/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.HashSet;

public class OrderedSet
extends Set {
    private static final long serialVersionUID = 1L;
    private ISet cjs;
    private TupleValue[] orderedTupleValues;
    private boolean sortedAscending;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public OrderedSet(ISet c, TupleValue[] orderedTupleVals, boolean ascending) throws InterpreterException {
        super(new Tuple[0]);
        this.cjs = c;
        this.sortedAscending = ascending;
        this.orderedTupleValues = orderedTupleVals;
    }

    public boolean contains(Dimension dimension) {
        return this.cjs.contains(dimension);
    }

    @Override
    public IDimension[] getDimensions() {
        return this.cjs.getDimensions();
    }

    @Override
    public long size() {
        return this.cjs.size();
    }

    @Override
    public ISet removeDimension(IDimension d, boolean retainDuplicates) {
        if (!this.cjs.contains(d)) {
            return this;
        }
        return this.cjs.removeDimension(d, retainDuplicates);
    }

    @Override
    public ITuple getTuple(long index) {
        Object o = null;
        IIterator it = this.iterator();
        if (it.hasNext() && index >= 0L && index < this.size()) {
            while (index-- >= 0L) {
                o = it.next();
            }
        } else {
            throw new RuntimeException("Tuple index out of bounds.");
        }
        return (Tuple)o;
    }

    @Override
    public Set subset(long start, long count) throws InterpreterException {
        XQEDebugLog.out.println("OrderedSet subset, start: " + start + " count:" + count);
        if (start < 0L || count <= 0L) {
            return new Set(new Tuple[0]);
        }
        if (start + count > this.size()) {
            count = this.size() - start;
        }
        return super.subset(start, count);
    }

    @Override
    public ITupleList getTupleList() {
        if (this.tupleList == null || this.tupleList.width() == 0) {
            ArrayList<ITuple> tups = new ArrayList<ITuple>();
            IIterator it = this.iterator();
            while (it.hasNext()) {
                tups.add((ITuple)((ITuple)it.next()).copy());
            }
            ITuple[] atups = tups.toArray(new Tuple[tups.size()]);
            this.initializeTupleList(SimpleTupleList.construct(atups));
        }
        return this.tupleList;
    }

    @Override
    public Set hierarchize(boolean post) {
        return super.hierarchize(post);
    }

    @Override
    public IIterator iterator() {
        return new OrderedSetIterator(this);
    }

    @Override
    public IIterator iterator(long start, long count) {
        return new OrderedSetIterator(this, start, count);
    }

    private final class OrderedSetIterator
    implements IIterator {
        private Set s;
        private long index;
        private long startIndex;
        private long count;
        private HashSet<ITuple> nonNullTuples;
        private long nullCounter;

        private OrderedSetIterator(Set set) {
            this(set, 0L, set.size());
        }

        private OrderedSetIterator(Set set, long st, long ct) {
            this.s = set;
            this.index = st;
            this.count = ct;
            this.startIndex = this.index;
            this.nonNullTuples = new HashSet();
            this.nullCounter = 0L;
            if (this.startIndex + this.count > OrderedSet.this.cjs.size()) {
                this.count = OrderedSet.this.cjs.size() - this.startIndex;
            }
            for (int i = 0; i < OrderedSet.this.orderedTupleValues.length; ++i) {
                this.nonNullTuples.add(OrderedSet.this.orderedTupleValues[i].getTuple());
            }
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.startIndex + this.count;
        }

        @Override
        public Object next() {
            ITuple result;
            if (OrderedSet.this.sortedAscending) {
                if (this.index < OrderedSet.this.cjs.size() - (long)OrderedSet.this.orderedTupleValues.length) {
                    ITuple currentNullCandidate = OrderedSet.this.cjs.getTuple(this.nullCounter);
                    while (this.nullCounter < OrderedSet.this.cjs.size() && this.nonNullTuples.contains(currentNullCandidate)) {
                        ++this.nullCounter;
                        if (this.nullCounter >= OrderedSet.this.cjs.size()) continue;
                        currentNullCandidate = OrderedSet.this.cjs.getTuple(this.nullCounter);
                    }
                    if (this.nullCounter >= OrderedSet.this.cjs.size()) {
                        return null;
                    }
                    result = currentNullCandidate;
                } else {
                    int idx = (int)(this.index - (this.s.size() - (long)OrderedSet.this.orderedTupleValues.length));
                    if (idx >= OrderedSet.this.orderedTupleValues.length) {
                        return null;
                    }
                    result = OrderedSet.this.orderedTupleValues[idx].getTuple();
                }
            } else if (this.index < (long)OrderedSet.this.orderedTupleValues.length) {
                result = OrderedSet.this.orderedTupleValues[(int)this.index].getTuple();
            } else {
                if (this.nullCounter >= OrderedSet.this.cjs.size()) {
                    return null;
                }
                ITuple currentNullCandidate = OrderedSet.this.cjs.getTuple(this.nullCounter);
                while (this.nullCounter < OrderedSet.this.cjs.size() && this.nonNullTuples.contains(currentNullCandidate)) {
                    ++this.nullCounter;
                    if (this.nullCounter >= OrderedSet.this.cjs.size()) continue;
                    currentNullCandidate = OrderedSet.this.cjs.getTuple(this.nullCounter);
                }
                if (this.nullCounter >= OrderedSet.this.cjs.size()) {
                    return null;
                }
                result = currentNullCandidate;
            }
            ++this.index;
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void release() {
        }
    }
}

