/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.DefaultPushdownAdapter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.IPushdown;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.IPushdownAdapter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.HashSet;
import java.util.Map;

public abstract class QueryStrategy
implements IPushdown {
    private ICube cube;
    private QueryContext infoData;
    protected boolean[] nonEmptyAxes;
    protected static final String FORMAT = "format";
    protected PushdownManager mPushdownManager = null;

    public ICube getCube() {
        return this.cube;
    }

    public void setCube(ICube c) {
        this.cube = c;
    }

    public QueryContext getInfoData() {
        return this.infoData;
    }

    public void setInfoData(QueryContext id) {
        this.infoData = id;
    }

    public abstract void execute(CrossJoinedSet var1, IResultSet var2) throws InterpreterException;

    public void setAttributeDimensionInfo(Map<String, String> attributeDimensionInfo) {
    }

    public void setCubeletHint(String hint) {
    }

    public String getCubeletHint() {
        return null;
    }

    protected long getCombinationsSize(HashSet<IMember>[] selections) {
        long size = 0L;
        for (int i = 0; i < selections.length; ++i) {
            HashSet<IMember> set = selections[i];
            if (i == 0) {
                size = set.size();
                continue;
            }
            size *= (long)set.size();
        }
        return size;
    }

    protected boolean hasUnknownMbrs(HashSet<IMember>[] selections) {
        for (int i = 0; i < selections.length; ++i) {
            HashSet<IMember> set = selections[i];
            if (set.size() <= 0) continue;
            return true;
        }
        return false;
    }

    protected CrossJoinedSet createCjsFromMemberSelections(java.util.Set<IMember>[] selections) throws InterpreterException {
        ISet[] sets = new Set[selections.length];
        for (int j = 0; j < selections.length; ++j) {
            IMember[] mbrs = selections[j].toArray(new IMember[selections[j].size()]);
            sets[j] = new Set(Tuple.createTupleList(mbrs));
        }
        return new CrossJoinedSet(sets);
    }

    @Override
    public PushdownManager getPushdownManager() {
        return this.mPushdownManager;
    }

    @Override
    public void setPushdownManager(PushdownManager pushdownManager) {
        this.mPushdownManager = pushdownManager;
    }

    @Override
    public void resetPushdownManager() {
        this.mPushdownManager = null;
    }

    @Override
    public boolean getPushDownMode() {
        return this.mPushdownManager != null && this.mPushdownManager.isEnabled();
    }

    @Override
    public IPushdownAdapter getPushdownAdapter() {
        return new DefaultPushdownAdapter();
    }

    public void setNonEmptyAxes(boolean[] axesHaveNonEmpty) {
        int index = 0;
        this.nonEmptyAxes = new boolean[axesHaveNonEmpty.length];
        for (boolean flag : axesHaveNonEmpty) {
            this.nonEmptyAxes[index++] = flag;
        }
    }

    public boolean isNonEmptyAxes(int index) {
        if (this.nonEmptyAxes == null) {
            return false;
        }
        return this.nonEmptyAxes[index];
    }

    public void rebuildCalculatedMembersSets(CalculationEngine calculationEngine, IResultSet resultSet) throws InterpreterException {
    }

    public static String getSessionId() {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        String sessionId = ((RequestEnvironment)execEnv.getRequestEnvironment()).getSessionContextID();
        return sessionId;
    }

    public static String getRequestId() {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        String sessionId = ((RequestEnvironment)execEnv.getRequestEnvironment()).getRequestID();
        return sessionId;
    }

    public static String getReportName() {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        String reportName = ((RequestEnvironment)execEnv.getRequestEnvironment()).getReportName();
        return reportName;
    }

    private class SelectionsIterator {
        int[] tupleSlice;
        int[] maxOrdinals;
        int total = 0;
        int count = 0;

        SelectionsIterator(IMember[][] selectionsArray) {
            this.tupleSlice = new int[selectionsArray.length];
            this.maxOrdinals = new int[selectionsArray.length];
            for (int i = 0; i < selectionsArray.length; ++i) {
                if (selectionsArray[i].length == 0) {
                    this.total = 0;
                    break;
                }
                this.maxOrdinals[i] = selectionsArray[i].length - 1;
                this.tupleSlice[i] = selectionsArray[i].length - 1;
                if (this.total == 0 && selectionsArray[i].length > 0) {
                    this.total = selectionsArray[i].length;
                    continue;
                }
                this.total *= selectionsArray[i].length;
            }
        }

        public boolean hasNext() {
            return this.count < this.total;
        }

        public int[] getNext() {
            if (this.count == 0) {
                ++this.count;
                return this.tupleSlice;
            }
            for (int i = 0; i < this.tupleSlice.length; ++i) {
                if (this.maxOrdinals[i] <= 0) continue;
                if (this.tupleSlice[i] > 0) {
                    this.tupleSlice[i] = this.tupleSlice[i] - 1;
                    break;
                }
                this.tupleSlice[i] = this.maxOrdinals[i];
            }
            ++this.count;
            return this.tupleSlice;
        }
    }
}

