/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterRuntimeException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetGenericDelegate;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.CrossJoinTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.UnionTupleList;
import com.cognos.xqe.runtree.olap.mdx.util.CompareNumbers;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class ResultSetDownsizeDelegate
extends ResultSetGenericDelegate {
    private boolean[] axesForNonEmpty;
    private static XQELogger statsLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryStrategyStatistics", LogLevel.TRACE);
    private static final String NEWLINE = System.getProperty("line.separator");

    public ResultSetDownsizeDelegate(AbstractResultSet rs, boolean[] downsizeAxes) {
        super(rs);
        this.axesForNonEmpty = downsizeAxes;
    }

    @Override
    public void rebuildCellList() {
    }

    @Override
    public void rebuildAxesList() throws InterpreterException {
        int size = this.tupleValues.size();
        ITuple[] tuples = new Tuple[size];
        for (int i = 0; i < size; ++i) {
            tuples[i] = ((TupleValue)this.tupleValues.get(i)).getTuple();
        }
        if (statsLogger.isOn(LogLevel.TRACE)) {
            StringBuilder strBuffer = new StringBuilder(NEWLINE);
            strBuffer.append("Number of NON EMPTY tuples: ").append(this.tupleValues.size()).append(NEWLINE);
            statsLogger.log(strBuffer.toString());
        }
        ISet[] axes = this.resultSet.getAxes();
        Set nonEmptySet = new Set(tuples);
        try {
            for (int i = 0; i < axes.length; ++i) {
                if (!this.axesForNonEmpty[i]) continue;
                if (size == 0) {
                    axes[i] = new Set();
                    continue;
                }
                if (statsLogger.isOn(LogLevel.TRACE)) {
                    StringBuilder strBuffer = new StringBuilder(NEWLINE);
                    strBuffer.append("Reducing the ResultSet size by removing empty tuples: true").append(NEWLINE);
                    strBuffer.append("..  ResultSet axis [").append(i).append("] size: ").append(((Set)axes[i]).noOverflowSize().toString());
                    statsLogger.log(strBuffer.toString());
                }
                axes[i] = new Set(this.rebuildAxis(nonEmptySet, (Set)axes[i]));
                long currentSize = axes[i].size();
                if (!statsLogger.isOn(LogLevel.TRACE)) continue;
                StringBuilder strBuffer = new StringBuilder(NEWLINE);
                strBuffer.append("... ResultSet axis [").append(i).append("] new size: ").append(currentSize).append(NEWLINE);
                statsLogger.log(strBuffer.toString());
            }
            this.resultSet.resetQuerySet();
        }
        catch (InterpreterRuntimeException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Runtime exception while removing empty tuples in the result set.");
        }
        catch (InterpreterException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Exception while removing empty tuples in the result set.");
        }
        finally {
            if (size == 0) {
                StringBuilder strBuffer = new StringBuilder(NEWLINE);
                strBuffer.append("Resultset(tupleValues) is empty. ").append(NEWLINE);
                statsLogger.log(strBuffer.toString());
            }
        }
        if (statsLogger.isOn(LogLevel.TRACE)) {
            StringBuilder strBuffer = new StringBuilder(NEWLINE);
            strBuffer.append("New ResultSet size: ").append(this.resultSet.size()).append(NEWLINE);
            statsLogger.log(strBuffer.toString());
        }
    }

    private ITupleList rebuildAxis(Set nonEmptySet, Set set) throws InterpreterException {
        ITupleList tupleList = set.getTupleList();
        if (tupleList instanceof UnionTupleList) {
            ITupleList[] childTupleLists = ((UnionTupleList)tupleList).getChildTupleLists();
            ArrayList<ITupleList> unionList = new ArrayList<ITupleList>();
            for (int i = 0; i < childTupleLists.length; ++i) {
                ITupleList tl = this.rebuildAxis(nonEmptySet, new Set(childTupleLists[i]));
                if (tl == null) continue;
                unionList.add(tl);
            }
            if (!unionList.isEmpty()) {
                return UnionTupleList.construct(unionList);
            }
            return SimpleTupleList.construct(new Tuple[0]);
        }
        if (tupleList instanceof CrossJoinTupleList) {
            ITupleList[] childTupleLists = ((CrossJoinTupleList)tupleList).getChildTupleLists();
            ArrayList<ITupleList> cjTupleLists = new ArrayList<ITupleList>();
            ArrayList<ITupleList> subCjTupleLists = new ArrayList<ITupleList>();
            for (int i = 0; i < childTupleLists.length; ++i) {
                ITupleList nonEmptyTl = this.rebuildAxis(nonEmptySet, new Set(childTupleLists[i]));
                if (nonEmptyTl != null) {
                    childTupleLists[i] = nonEmptyTl;
                }
                if (childTupleLists[i].containsCalculatedMembers() || childTupleLists[i].containsMeasures()) {
                    if (subCjTupleLists.size() > 0) {
                        Set nonEmptyTuples = this.retainNonEmptyTuplesInTupleLists(nonEmptySet, subCjTupleLists);
                        if (nonEmptyTuples != null) {
                            cjTupleLists.add(nonEmptyTuples.tupleList);
                        } else {
                            cjTupleLists.addAll(subCjTupleLists);
                        }
                    }
                    cjTupleLists.add(childTupleLists[i]);
                    subCjTupleLists.clear();
                    continue;
                }
                subCjTupleLists.add(childTupleLists[i]);
            }
            if (subCjTupleLists.size() > 0) {
                Set nonEmptyTuples = this.retainNonEmptyTuplesInTupleLists(nonEmptySet, subCjTupleLists);
                if (nonEmptyTuples != null) {
                    cjTupleLists.add(nonEmptyTuples.tupleList);
                } else {
                    cjTupleLists.addAll(subCjTupleLists);
                }
            }
            return CrossJoinTupleList.construct(cjTupleLists);
        }
        return tupleList;
    }

    private Set retainNonEmptyTuplesInTupleLists(Set nonEmptySet, List<ITupleList> tupleLists) {
        ArrayList<IHierarchy> tlHierarchies = new ArrayList<IHierarchy>();
        for (int x = 0; x < tupleLists.size(); ++x) {
            IHierarchy[] hiers = new Set(tupleLists.get(x)).getHierarchies();
            for (int i = 0; i < hiers.length; ++i) {
                if (hiers[i].getDimension().isMeasuresDimension()) {
                    return null;
                }
                if (tlHierarchies.contains(hiers[i])) continue;
                tlHierarchies.add(hiers[i]);
            }
        }
        ITupleList tupleList = null;
        tupleList = tupleLists.size() > 1 ? CrossJoinTupleList.construct(tupleLists) : tupleLists.get(0);
        if (tupleList.size() > 0L && nonEmptySet.size() == tupleList.size()) {
            return null;
        }
        TreeMap<Number, Tuple> indexTupleMap = new TreeMap<Number, Tuple>(new CompareNumbers());
        ArrayList nonEmptyTuples = new ArrayList();
        ITupleIterator iti = nonEmptySet.tupleList.iterator();
        int hierarchiesSize = tlHierarchies.size();
        int[] hierarchyIndexes = new int[hierarchiesSize];
        for (int i = 0; i < hierarchiesSize; ++i) {
            hierarchyIndexes[i] = nonEmptySet.getHierarchyIndex((IHierarchy)tlHierarchies.get(i));
        }
        while (iti.hasNext()) {
            ITuple tuple = iti.next();
            IMember[] members = new IMember[hierarchiesSize];
            for (int j = 0; j < hierarchiesSize; ++j) {
                members[j] = tuple.getMember(hierarchyIndexes[j]);
            }
            List<Number> indexes = tupleList.find(members, false);
            Tuple t = new Tuple(members);
            for (Number index : indexes) {
                indexTupleMap.put(index, t);
            }
        }
        if (!indexTupleMap.isEmpty()) {
            nonEmptyTuples.addAll(indexTupleMap.values());
        }
        if (tupleList.size() > 0L && (long)nonEmptyTuples.size() >= tupleList.size()) {
            return null;
        }
        return new Set(nonEmptyTuples.toArray(new Tuple[nonEmptyTuples.size()]));
    }
}

