/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.util.NumberOp;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.pool.XQELongPool;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public class ResultSetMetadata {
    private ISet[] axes;
    private ISet slicer;
    private CrossJoinedSet querySet = null;
    private long cachedSize = -1L;

    public ResultSetMetadata(ISet[] theAxes, ISet aSlicer) {
        this.axes = theAxes;
        this.slicer = aSlicer;
        this.buildQuerySetFromAxes();
    }

    public ResultSetMetadata(CrossJoinedSet cjs) {
        this.querySet = cjs;
        this.buildAxesFromQuerySet();
    }

    public final ISet[] getAxes() {
        return this.axes;
    }

    public final void setAxes(ISet[] theAxes) {
        this.axes = theAxes;
        this.invalidateCachedSize();
    }

    public final ISet getSlicer() {
        return this.slicer;
    }

    public final void setSlicer(ISet aSlicer) {
        this.slicer = aSlicer;
        this.invalidateCachedSize();
    }

    public void setSlicerEmpty() {
        this.slicer = new Set(new Tuple[0]);
        this.invalidateCachedSize();
    }

    public final CrossJoinedSet getQuerySet() {
        return this.querySet;
    }

    public long size() {
        if (this.cachedSize == -1L) {
            this.cachedSize = this.calcSize();
        }
        return this.cachedSize;
    }

    private void invalidateCachedSize() {
        this.cachedSize = -1L;
    }

    private long calcSize() {
        if (this.slicer == null || this.axes == null) {
            return 0L;
        }
        long result = this.slicer.size();
        if (result == 0L) {
            result = 1L;
        }
        for (int i = this.axes.length - 1; i >= 0; --i) {
            if (this.axes[i].size() > 0L) {
                result = NumberOp.multiplyQuantities(result, this.axes[i].size());
            } else if (this.axes[i].size() < 0L) {
                return this.axes[i].size();
            }
            if (result >= 0L) continue;
            return result;
        }
        return result;
    }

    public BigInteger noOverflowSize() {
        if (this.slicer == null || this.axes == null) {
            return BigInteger.ZERO;
        }
        BigInteger result = ((Set)this.slicer).noOverflowSize();
        if (this.slicer.size() == 0L) {
            result = BigInteger.ONE;
        }
        for (int i = this.axes.length - 1; i >= 0; --i) {
            result = result.multiply(((Set)this.axes[i]).noOverflowSize());
        }
        return result;
    }

    public CrossJoinedSet getAxisCrossJoinedSet() throws InterpreterException {
        ISet[] sets;
        if (this.slicer != null && !this.slicer.isEmpty()) {
            sets = new Set[this.axes.length + 1];
            sets[this.axes.length] = this.slicer;
            for (int i = this.axes.length - 1; i >= 0; --i) {
                sets[this.axes.length - 1 - i] = this.axes[i];
            }
        } else {
            sets = new Set[this.axes.length];
            for (int i = this.axes.length - 1; i >= 0; --i) {
                sets[this.axes.length - 1 - i] = this.axes[i];
            }
        }
        return new CrossJoinedSet(sets);
    }

    public void moveContextSingleSelectionsToSlicer(Set contextSet) throws InterpreterException {
        ISet singleTupleSet = contextSet.getSingleTupleSet();
        if (singleTupleSet.size() > 0L && singleTupleSet.getTuple(0L).size() > 0) {
            IHierarchy[] hiers = singleTupleSet.getHierarchies();
            for (int i = 0; i < hiers.length; ++i) {
                if (this.slicer.contains(hiers[i])) {
                    this.slicer = (Set)this.slicer.removeHierarchy(hiers[i], true);
                }
                for (int j = 0; j < this.axes.length; ++j) {
                    if (!this.axes[j].contains(hiers[i])) continue;
                    this.axes[j] = (Set)this.axes[j].removeHierarchy(hiers[i], true);
                }
            }
            this.slicer = ((Set)this.slicer).crossjoin(singleTupleSet);
        }
        this.invalidateCachedSize();
    }

    public void moveAxesSingleSelectionsToSlicer(IDimension[] remove) throws InterpreterException {
        ArrayList<ISet> newAxes = new ArrayList<ISet>();
        for (int i = 0; i < this.axes.length; ++i) {
            ISet axis = this.axes[i];
            ISet singleTupleSet = axis.getSingleTupleSet();
            singleTupleSet = singleTupleSet.removeDimensions(remove);
            this.slicer = ((Set)this.slicer).crossjoin(singleTupleSet);
            IDimension[] dims = singleTupleSet.getDimensions();
            if ((axis = (Set)axis.removeDimensions(dims)).isEmpty()) continue;
            newAxes.add(axis);
        }
        this.axes = newAxes.toArray(new Set[0]);
        this.invalidateCachedSize();
    }

    public void printVerbose() {
        XQEDebugLog.out.println("Slicer " + this.getSlicer().toString());
        for (int i = 0; i < this.axes.length; ++i) {
            ISet axis = this.axes[i];
            XQEDebugLog.out.println("Axis " + i + " " + axis.toString());
        }
    }

    public Tuple getTupleByCellOrdinal(long cellOrdinal) {
        boolean bEmptyAxis = false;
        long[] axesSizes = new long[this.axes.length];
        for (int i = 0; i < this.axes.length; ++i) {
            axesSizes[i] = this.axes[i].size();
            if (axesSizes[i] != 0L) continue;
            bEmptyAxis = true;
        }
        long[] tupleOrdinals = null;
        if (bEmptyAxis) {
            tupleOrdinals = new long[this.axes.length];
            Arrays.fill(tupleOrdinals, 0L);
        } else {
            tupleOrdinals = ResultSetMetadata.computeTupleOrdinals(cellOrdinal, axesSizes);
        }
        ArrayList<IMember> tupleMembers = new ArrayList<IMember>();
        if (!this.getSlicer().isEmpty()) {
            tupleMembers.addAll(Arrays.asList(this.getSlicer().getTuple(0L).getMembers()));
        }
        for (int i = tupleOrdinals.length - 1; i >= 0; --i) {
            ISet anAxes = this.axes[i];
            if (anAxes.size() == 0L) continue;
            IMember[] members = anAxes.getTuple(tupleOrdinals[i]).getMembers();
            tupleMembers.addAll(Arrays.asList(members));
        }
        IMember[] tupleMemberArray = new IMember[tupleMembers.size()];
        Tuple tuple = new Tuple(tupleMembers.toArray(tupleMemberArray));
        return tuple;
    }

    public IMember[] getMembersOnAxis(long cellOrdinal, int axisIndex, long[] axesSizes) {
        long[] tupleOrdinals = ResultSetMetadata.computeTupleOrdinals(cellOrdinal, axesSizes);
        ISet anAxes = this.axes[axisIndex];
        IMember[] members = anAxes.getTuple(tupleOrdinals[axisIndex]).getMembers();
        return members;
    }

    public Tuple getTupleByCellOrdinal(BigInteger cellOrdinal) {
        BigInteger[] axesSizes = new BigInteger[this.axes.length];
        for (int i = 0; i < this.axes.length; ++i) {
            axesSizes[i] = ((Set)this.axes[i]).noOverflowSize();
        }
        BigInteger[] tupleOrdinals = ResultSetMetadata.computeTupleOrdinals(cellOrdinal, axesSizes);
        ArrayList<IMember> tupleMembers = new ArrayList<IMember>();
        if (!this.getSlicer().isEmpty()) {
            tupleMembers.addAll(Arrays.asList(this.getSlicer().getTuple(0L).getMembers()));
        }
        for (int i = tupleOrdinals.length - 1; i >= 0; --i) {
            Set anAxes = (Set)this.axes[i];
            IMember[] members = anAxes.getTuple(tupleOrdinals[i]).getMembers();
            tupleMembers.addAll(Arrays.asList(members));
        }
        IMember[] tupleMemberArray = new IMember[tupleMembers.size()];
        Tuple tuple = new Tuple(tupleMembers.toArray(tupleMemberArray));
        return tuple;
    }

    public static long computeCellOrdinal(long[] tupleOrdinals, long[] axesSizes) {
        long cellOrdinal = tupleOrdinals[0];
        long multiplier = 1L;
        for (int i = 1; i < tupleOrdinals.length; ++i) {
            if ((multiplier = NumberOp.multiplyQuantities(multiplier, axesSizes[i - 1])) < 0L) {
                boolean allRemainingTupleOrdinalsZero = true;
                for (int j = i; j < tupleOrdinals.length && allRemainingTupleOrdinalsZero; ++j) {
                    allRemainingTupleOrdinalsZero = tupleOrdinals[j] == 0L;
                }
                if (allRemainingTupleOrdinalsZero) {
                    return cellOrdinal;
                }
                return Long.MIN_VALUE;
            }
            long val = NumberOp.multiplyQuantities(multiplier, tupleOrdinals[i]);
            if (val < 0L) {
                return Long.MIN_VALUE;
            }
            if ((cellOrdinal = NumberOp.addQuantities(cellOrdinal, val)) >= 0L) continue;
            return Long.MIN_VALUE;
        }
        return cellOrdinal;
    }

    public static Number computeCellOrdinal(Number[] tupleOrdinals, Number[] axesSizes) {
        Number cellOrdinal = tupleOrdinals[0];
        Number multiplier = XQELongPool.ONE;
        for (int i = 1; i < tupleOrdinals.length; ++i) {
            multiplier = NumberOp.multiply(axesSizes[i - 1], multiplier);
            cellOrdinal = NumberOp.add(cellOrdinal, NumberOp.multiply(tupleOrdinals[i], multiplier));
        }
        return cellOrdinal;
    }

    public static long[] computeTupleOrdinals(long cellOrdinal, long[] axesSizes) {
        int axesCount = axesSizes.length;
        long[] tupleOrdinalsOnAxes = new long[axesCount];
        for (int axesInx = 0; axesInx < axesCount; ++axesInx) {
            long index = cellOrdinal % axesSizes[axesInx];
            cellOrdinal /= axesSizes[axesInx];
            tupleOrdinalsOnAxes[axesInx] = index;
        }
        return tupleOrdinalsOnAxes;
    }

    public static BigInteger[] computeTupleOrdinals(BigInteger cellOrdinal, BigInteger[] axesSizes) {
        int axesCount = axesSizes.length;
        BigInteger[] tupleOrdinalsOnAxes = new BigInteger[axesCount];
        for (int axesInx = 0; axesInx < axesCount; ++axesInx) {
            BigInteger index = cellOrdinal.mod(axesSizes[axesInx]);
            cellOrdinal = cellOrdinal.divide(axesSizes[axesInx]);
            tupleOrdinalsOnAxes[axesInx] = index;
        }
        return tupleOrdinalsOnAxes;
    }

    public static Number[] computeTupleOrdinals(Number cellOrdinal, Number[] axesSizes) {
        int axesCount = axesSizes.length;
        Number[] tupleOrdinalsOnAxes = new Number[axesCount];
        for (int axesInx = 0; axesInx < axesCount; ++axesInx) {
            Number index = NumberOp.mod(cellOrdinal, axesSizes[axesInx]);
            cellOrdinal = NumberOp.divide(cellOrdinal, axesSizes[axesInx]);
            tupleOrdinalsOnAxes[axesInx] = index;
        }
        return tupleOrdinalsOnAxes;
    }

    public Number[] convertCrossJoinedSetTupleOrdinalToResultSetTupleOrdinal(Number[] tupleOrdinal, Number[] sizes) {
        ArrayList<ISet> sets = new ArrayList<ISet>();
        Number[] cjsTupleOrdinal = null;
        Number[] cjsSetSizes = null;
        sets.add(this.getSlicer());
        for (int i = 0; i < this.axes.length; ++i) {
            if (this.axes[i] instanceof CrossJoinedSet) {
                sets.addAll(Arrays.asList(((CrossJoinedSet)this.axes[i]).getSets()));
                continue;
            }
            sets.add(this.axes[i]);
        }
        int totalSetNumbers = sets.size();
        if (tupleOrdinal.length != totalSetNumbers) {
            cjsTupleOrdinal = new Number[totalSetNumbers];
            cjsSetSizes = new Number[totalSetNumbers];
            int numberOfEmptySet = 0;
            for (int i = 0; i < totalSetNumbers; ++i) {
                if (((ISet)sets.get(i)).isEmpty()) {
                    ++numberOfEmptySet;
                    cjsTupleOrdinal[i] = 0;
                    cjsSetSizes[i] = 0;
                    continue;
                }
                cjsTupleOrdinal[i] = tupleOrdinal[i - numberOfEmptySet];
                cjsSetSizes[i] = sizes[i - numberOfEmptySet];
            }
        } else {
            cjsTupleOrdinal = tupleOrdinal;
            cjsSetSizes = sizes;
        }
        Number[] aResultSetTupleOrdinal = new Number[this.axes.length];
        int posStart = 1;
        for (int i = 0; i < this.axes.length; ++i) {
            Number tupleOrdinalOfCurrentAxis;
            if (this.axes[i] instanceof CrossJoinedSet) {
                Number tupleOrdinalOnAnAxis;
                int subsetLength = ((CrossJoinedSet)this.axes[i]).getSets().length;
                Number[] subsetTupleOrdinal = new Number[subsetLength];
                Number[] subsetSizes = new Number[subsetLength];
                for (int j = 0; j < subsetLength; ++j) {
                    subsetTupleOrdinal[j] = cjsTupleOrdinal[i + j + posStart];
                    subsetSizes[j] = cjsSetSizes[i + j + posStart];
                }
                posStart = posStart + subsetLength - 1;
                tupleOrdinalOfCurrentAxis = tupleOrdinalOnAnAxis = ResultSetMetadata.computeCellOrdinal(subsetTupleOrdinal, subsetSizes);
            } else {
                tupleOrdinalOfCurrentAxis = cjsTupleOrdinal[i + posStart];
            }
            aResultSetTupleOrdinal[i] = tupleOrdinalOfCurrentAxis;
        }
        return aResultSetTupleOrdinal;
    }

    public long[] convertCrossJoinedSetTupleOrdinalToResultSetTupleOrdinal(long[] tupleOrdinal, long[] sizes) {
        ArrayList<ISet> sets = new ArrayList<ISet>();
        long[] cjsTupleOrdinal = null;
        long[] cjsSetSizes = null;
        sets.add(this.getSlicer());
        for (int i = 0; i < this.axes.length; ++i) {
            if (this.axes[i] instanceof CrossJoinedSet) {
                sets.addAll(Arrays.asList(((CrossJoinedSet)this.axes[i]).getSets()));
                continue;
            }
            sets.add(this.axes[i]);
        }
        int totalSetNumbers = sets.size();
        if (tupleOrdinal.length != totalSetNumbers) {
            cjsTupleOrdinal = new long[totalSetNumbers];
            cjsSetSizes = new long[totalSetNumbers];
            int numberOfEmptySet = 0;
            for (int i = 0; i < totalSetNumbers; ++i) {
                if (((ISet)sets.get(i)).isEmpty()) {
                    ++numberOfEmptySet;
                    cjsTupleOrdinal[i] = 0L;
                    cjsSetSizes[i] = 0L;
                    continue;
                }
                cjsTupleOrdinal[i] = tupleOrdinal[i - numberOfEmptySet];
                cjsSetSizes[i] = sizes[i - numberOfEmptySet];
            }
        } else {
            cjsTupleOrdinal = tupleOrdinal;
            cjsSetSizes = sizes;
        }
        long[] aResultSetTupleOrdinal = new long[this.axes.length];
        int posStart = 1;
        for (int i = 0; i < this.axes.length; ++i) {
            long tupleOrdinalOfCurrentAxis;
            if (this.axes[i] instanceof CrossJoinedSet) {
                long tupleOrdinalOnAnAxis;
                int subsetLength = ((CrossJoinedSet)this.axes[i]).getSets().length;
                long[] subsetTupleOrdinal = new long[subsetLength];
                long[] subsetSizes = new long[subsetLength];
                for (int j = 0; j < subsetLength; ++j) {
                    subsetTupleOrdinal[j] = cjsTupleOrdinal[i + j + posStart];
                    subsetSizes[j] = cjsSetSizes[i + j + posStart];
                }
                posStart = posStart + subsetLength - 1;
                tupleOrdinalOfCurrentAxis = tupleOrdinalOnAnAxis = ResultSetMetadata.computeCellOrdinal(subsetTupleOrdinal, subsetSizes);
            } else {
                tupleOrdinalOfCurrentAxis = cjsTupleOrdinal[i + posStart];
            }
            aResultSetTupleOrdinal[i] = tupleOrdinalOfCurrentAxis;
        }
        return aResultSetTupleOrdinal;
    }

    private void buildQuerySetFromAxes() {
        if (this.slicer == null) {
            this.querySet = new CrossJoinedSet(new Set[0]);
        } else {
            int numAxes = this.axes.length;
            ISet[] sets = new Set[numAxes + 1];
            sets[numAxes] = this.slicer;
            for (int i = numAxes - 1; i >= 0; --i) {
                sets[numAxes - 1 - i] = this.axes[i];
            }
            this.querySet = new CrossJoinedSet(sets);
        }
    }

    private void buildAxesFromQuerySet() {
        Set[] sets = this.querySet.getSets();
        if (sets[sets.length - 1].size() == 1L) {
            this.axes = new Set[sets.length - 1];
            for (int i = 0; i < this.axes.length; ++i) {
                this.axes[i] = sets[this.axes.length - 1 - i];
            }
            this.slicer = sets[sets.length - 1];
        } else {
            this.axes = new Set[sets.length];
            for (int i = 0; i < this.axes.length; ++i) {
                this.axes[i] = sets[this.axes.length - 1 - i];
            }
            this.slicer = new Set(new Tuple[0]);
        }
    }
}

