/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.functions.IMDXFunctionProcessor;
import com.cognos.xqe.runtree.olap.mdx.functions.MDXFunctionProcessorFactory;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ErrorCell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IsEmptySet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Operator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TypeCoercion;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.FilterPushdownUtility;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.Pair;
import com.ibm.icu.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public class ResultSetProcessor {
    private static final String TRUE = "true";
    private static final String ENABLE_ARITHMETIC_OPERATIONS_SPARSE_PROCESSING = "enableArithmeticOperationsSparseProcessing";
    private static final String ENABLE_ARITMETIC_OPERATIONS_SPARSE_PROCESSING_DEFAULT = "true";
    private static final String COMMA_SPACE_STR = ", ";
    private static final String COMMA_SPACE_DOTDOTDOT_STR = ", ...";
    private static final String PERFORM_SIMPLE_OP_STR = "performSimpleOp";
    public static final int INVALID_OPERATOR = Integer.MAX_VALUE;
    public static final int AND_OPERATOR = 1;
    public static final int OR_OPERATOR = 3;
    public static final int XOR_OPERATOR = 5;
    public static final int NOT_OPERATOR = 7;
    public static final int EQUAL_OPERATOR = 9;
    public static final int NOT_EQUAL_OPERATOR = 11;
    public static final int GREATER_THAN_OPERATOR = 13;
    public static final int LESS_THAN_OPERATOR = 15;
    public static final int GREATER_THAN_OR_EQUAL_OPERATOR = 17;
    public static final int LESS_THAN_OR_EQUAL_OPERATOR = 19;
    public static final int IS_OPERATOR = 21;
    public static final int ISANCESTOR_OPERATOR = 23;
    public static final int PLUS_OPERATOR = 20;
    public static final int MINUS_OPERATOR = 22;
    public static final int DIVIDE_OPERATOR = 24;
    public static final int MULTIPLY_OPERATOR = 26;
    public static final int MODULO_OPERATOR = 28;
    public static final int IS_EMPTY_OPERATOR = 29;
    public static final int CONCAT_OPERATOR = 30;
    public static final int CUSTOM_OPERATOR = 32;
    public static final int NOT_IS_EMPTY_OPERATOR = 33;
    private static final int NINE = 9;
    public static final int COMPARISON_NULL_BEHAVIOR_IDX = 0;
    public static final int BOOLEAN_NULL_BEHAVIOR_IDX = 1;
    public static final int PLUS_NULL_BEHAVIOR_IDX = 2;
    public static final int MINUS_NULL_BEHAVIOR_IDX = 3;
    public static final int MULTIPLY_NULL_BEHAVIOR_IDX = 4;
    public static final int DIVIDENUMERATOR_NULL_BEHAVIOR_IDX = 5;
    public static final int DIVIDEDENOMINATOR_NULL_BEHAVIOR_IDX = 6;
    public static final int MODULODIVIDEND_NULL_BEHAVIOR_IDX = 7;
    public static final int MODULODIVISOR_NULL_BEHAVIOR_IDX = 8;

    public ResultSetProcessor(ICube cube) {
    }

    public Object performSimpleOp(InterpreterContext interpreterContext, Object operand, int operation) throws InterpreterException {
        Object opResult = null;
        if (operation == 29) {
            opResult = this.performIsEmptyOp(interpreterContext, operand, false);
        } else if (operation == 7) {
            opResult = this.performNotOp(interpreterContext, operand);
        } else if (operation == 33) {
            NullBehavior[] nullHandling = this.getNullHandlingBehavior(interpreterContext);
            TreeSet<Cell> nullCell = new TreeSet<Cell>();
            nullCell.add(new Cell(NullValue.NULLVALUE));
            Block o2 = new Block(interpreterContext, nullCell);
            FilterPushdownUtility.configurePushdown(interpreterContext, (Block)operand, o2, 11, nullHandling, this);
            Object pushdownResultDefaultValue = null;
            PushdownManager pushdownManager = PushdownManager.getPushdownManager(interpreterContext);
            if (pushdownManager != null) {
                if (pushdownManager.isConfigureOnly()) {
                    return null;
                }
                pushdownResultDefaultValue = pushdownManager.getParameter("Filter", "defaultValue");
            }
            opResult = this.performIsEmptyOp(interpreterContext, operand, true);
            if (PushdownManager.isPushdownExecutionFinished(interpreterContext)) {
                ((Block)opResult).setDefaultValue(pushdownResultDefaultValue);
                return opResult;
            }
            opResult = this.performNotOp(interpreterContext, opResult);
        } else {
            throw new InterpreterException("X01434", new String[]{operation + "", "29, 7"});
        }
        return opResult;
    }

    private Object performNotOp(InterpreterContext interpreterContext, Object operand) throws InterpreterException {
        Block b1 = (Block)operand;
        b1.getValues(interpreterContext);
        Block[] wrkBlocks = new Block[]{b1};
        Block retBlock = new Block(interpreterContext, wrkBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Value v;
            Object[] blockObj = (Object[])blockIter.next();
            if (blockObj[0] instanceof Double) {
                v = DataValueFactory.createDoubleValue();
                v.set(~((Double)blockObj[0]).intValue());
                v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                retBlock.add(blockIter, (Object)v);
                continue;
            }
            if (blockObj[0] instanceof IsEmptySet) {
                retBlock.add(blockIter, (Object)((IsEmptySet)blockObj[0]).notIsEmpty());
                continue;
            }
            if (blockObj[0] instanceof Value) {
                v = (Value)blockObj[0];
                if (v.isNumeric()) {
                    DoubleValue notValue = DataValueFactory.createDoubleValue();
                    ((Value)notValue).set(~Double.valueOf(v.getDouble()).intValue());
                    notValue.setFormatId(v.getFormatId());
                    retBlock.add(blockIter, (Object)notValue);
                    continue;
                }
                if (v.isError()) {
                    retBlock.add(blockIter, (Object)TextValue.ERROR_VALUE);
                    continue;
                }
                boolean b = v.getBoolean();
                if (b) {
                    retBlock.add(blockIter, (Object)BooleanValue.FALSE);
                    continue;
                }
                retBlock.add(blockIter, (Object)BooleanValue.TRUE);
                continue;
            }
            Boolean b = TypeCoercion.getBooleanOperand(blockObj[0]);
            if (b.booleanValue()) {
                retBlock.add(blockIter, (Object)BooleanValue.FALSE);
                continue;
            }
            retBlock.add(blockIter, (Object)BooleanValue.TRUE);
        }
        if (retBlock.getDefaultValue() == null) {
            int cellCount = retBlock.cellSetSize();
            long tupleCount = retBlock.tupleSetSize();
            if (cellCount == 0 || tupleCount < 0L || tupleCount > (long)cellCount) {
                DoubleValue v = DataValueFactory.createDoubleValue();
                ((Value)v).set(-1);
                v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                retBlock.setDefaultValue(v);
            }
        }
        Block opResult = retBlock;
        return opResult;
    }

    private Object performIsEmptyOp(InterpreterContext interpreterContext, Object operand, boolean isPartOfNOTIsEmptyPushdown) throws InterpreterException {
        Block b1 = (Block)operand;
        b1.getValues(interpreterContext);
        Block[] wrkBlocks = new Block[]{b1};
        Block retBlock = new Block(interpreterContext, wrkBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
        if (b1.isPipelining()) {
            blockIter.hasNext();
        }
        BooleanValue positiveValue = BooleanValue.TRUE;
        BooleanValue negativeValue = BooleanValue.FALSE;
        if (isPartOfNOTIsEmptyPushdown && PushdownManager.isPushdownExecutionFinished(interpreterContext)) {
            positiveValue = BooleanValue.FALSE;
            negativeValue = BooleanValue.TRUE;
        }
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            if (blockObj[0] instanceof NullMember) {
                retBlock.add(blockIter, (Object)positiveValue);
                continue;
            }
            retBlock.add(blockIter, (Object)negativeValue);
        }
        if (retBlock.getDefaultValue() == null) {
            int cellCount = retBlock.cellSetSize();
            long tupleCount = retBlock.tupleSetSize();
            if (cellCount == 0 || tupleCount < 0L || tupleCount > (long)cellCount) {
                retBlock.setDefaultValue(positiveValue);
            }
        }
        Block opResult = retBlock;
        return opResult;
    }

    public Object performSimpleOp(InterpreterContext interpreterContext, Object o1, Object o2, int operation) throws InterpreterException {
        Object defaultValue;
        Object blockObj;
        Object blockObj2;
        NullBehavior[] nullHandling = this.getNullHandlingBehavior(interpreterContext);
        Object pushdownResultDefaultValue = null;
        Block b1 = (Block)o1;
        if (operation == 23) {
            b1.cast(IMember.class);
        } else if (operation == 21) {
            blockObj2 = b1.first();
            if (blockObj2 instanceof IDimension || blockObj2 instanceof IHierarchy) {
                b1.getCurrentMembers();
            }
        } else {
            blockObj2 = b1.first();
            if (!(blockObj2 instanceof Set) || operation != 1 && operation != 26) {
                FilterPushdownUtility.configurePushdown(interpreterContext, b1, (Block)o2, operation, nullHandling, this);
                PushdownManager pushdownManager = PushdownManager.getPushdownManager(interpreterContext);
                if (pushdownManager != null) {
                    if (pushdownManager.isConfigureOnly()) {
                        return null;
                    }
                    pushdownResultDefaultValue = pushdownManager.getParameter("Filter", "defaultValue");
                }
                b1.getValues(interpreterContext);
                blockObj2 = b1.first();
                if (!(blockObj2 == null || blockObj2 instanceof NullObject || blockObj2 instanceof Double || blockObj2 instanceof Integer || blockObj2 instanceof String || blockObj2 instanceof Boolean || blockObj2 instanceof Date || blockObj2 instanceof Value)) {
                    throw new InterpreterException("X01490", new String[]{blockObj2.getClass().toString(), PERFORM_SIMPLE_OP_STR, "Integer, String, Boolean, Double, NullObject"});
                }
            }
        }
        Block b2 = (Block)o2;
        if (operation == 23) {
            b2.cast(IMember.class);
        } else if (operation == 21) {
            blockObj = b2.first();
            if (blockObj instanceof IDimension || blockObj instanceof IHierarchy) {
                b2.getCurrentMembers();
            }
        } else {
            blockObj = b2.first();
            if (!(blockObj instanceof Set) || operation != 1 && operation != 26) {
                b2.getValues(interpreterContext);
                blockObj = b2.first();
                if (!(blockObj == null || blockObj instanceof NullObject || blockObj instanceof Double || blockObj instanceof Integer || blockObj instanceof String || blockObj instanceof Boolean || blockObj instanceof Date || blockObj instanceof Value)) {
                    throw new InterpreterException("X01490", new String[]{blockObj.getClass().toString(), PERFORM_SIMPLE_OP_STR, "Integer, String, Boolean, Double, NullObject"});
                }
            }
        }
        List comparisonExpressionList = null;
        if (PushdownManager.isPushdownExecutionFinished(interpreterContext)) {
            PushdownManager pushdownManager = PushdownManager.getPushdownManager(interpreterContext);
            comparisonExpressionList = (List)pushdownManager.getParameter("Filter", "originalComparisonExpression");
        }
        Operator customOp = null;
        boolean b1IsConst = false;
        boolean b2IsConst = false;
        Object b1CosntOp = null;
        Object b2CosntOp = null;
        Block[] wrkBlocks = null;
        if (b1.isConstant() && !b1.isEmpty()) {
            b1IsConst = true;
            b1CosntOp = b1.first();
            wrkBlocks = new Block[]{b2};
        } else if (b2.isConstant() && !b2.isEmpty()) {
            b2IsConst = true;
            b2CosntOp = b2.first();
            wrkBlocks = new Block[]{b1};
        } else {
            wrkBlocks = new Block[]{b1, b2};
        }
        Block block = new Block(interpreterContext, wrkBlocks);
        Long suppressedOrdinal = null;
        boolean trackSuppressedOrdinals = false;
        if (!b1IsConst || !b2IsConst) {
            if (PushdownManager.isPushdownExecutionFinished(interpreterContext)) {
                block.setDefaultValue(pushdownResultDefaultValue);
            } else if (b1IsConst && (b2.isPipelining() || b2.hasEmptyCells())) {
                defaultValue = this.performOp(interpreterContext, b1CosntOp, null, customOp, operation, nullHandling);
                block.setDefaultValue(defaultValue);
                if (this.isOrdinalTrackingRequired(b2)) {
                    trackSuppressedOrdinals = true;
                }
            } else if (b2IsConst && (b1.isPipelining() || b1.hasEmptyCells())) {
                defaultValue = this.performOp(interpreterContext, null, b2CosntOp, customOp, operation, nullHandling);
                block.setDefaultValue(defaultValue);
                if (this.isOrdinalTrackingRequired(b1)) {
                    trackSuppressedOrdinals = true;
                }
            }
        }
        defaultValue = block.getDefaultValue();
        int numSuppressedValues = 0;
        boolean useSparseIter = this.useSparseIterator(interpreterContext, wrkBlocks, operation, nullHandling);
        XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine", LogLevel.INFO);
        long iterSize = 0L;
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks, useSparseIter);
        while (blockIter.hasNext()) {
            ++iterSize;
            Object[] blockObj3 = (Object[])blockIter.next();
            Object operand1 = null;
            Object operand2 = null;
            if (b1IsConst) {
                operand1 = b1CosntOp;
                operand2 = blockObj3[0];
            } else if (b2IsConst) {
                operand1 = blockObj3[0];
                operand2 = b2CosntOp;
            } else {
                operand1 = blockObj3[0];
                operand2 = blockObj3[1];
            }
            Object valueResult = this.performOp(interpreterContext, operand1, operand2, customOp, operation, nullHandling);
            if (comparisonExpressionList != null && comparisonExpressionList.size() > 1) {
                Pair aFilterCondition = (Pair)comparisonExpressionList.get(0);
                Object tmpValueResult = null;
                Object constandOperand = aFilterCondition.getSecond();
                int filterOperator = (Integer)aFilterCondition.getFirst();
                tmpValueResult = filterOperator == 11 && constandOperand instanceof NullValue ? (!((Value)operand1).isNull() ? BooleanValue.TRUE : BooleanValue.FALSE) : this.performOp(interpreterContext, operand1, constandOperand, customOp, filterOperator, nullHandling);
                valueResult = this.performOp(interpreterContext, valueResult, tmpValueResult, customOp, 1, nullHandling);
            }
            if (defaultValue == null || !defaultValue.equals(valueResult)) {
                block.add(blockIter, valueResult);
                continue;
            }
            ++numSuppressedValues;
            if (!trackSuppressedOrdinals) continue;
            if (suppressedOrdinal == null) {
                suppressedOrdinal = blockIter.pos();
                continue;
            }
            trackSuppressedOrdinals = false;
            suppressedOrdinal = null;
        }
        if (logger.isOn(LogLevel.INFO)) {
            logger.log(LogLevel.INFO, "Simple operation iteration size: " + iterSize);
        }
        if (suppressedOrdinal != null && (b1.isPipelining() && !b1.hasEmptyCells() || b2.isPipelining() && !b2.hasEmptyCells())) {
            block.add(suppressedOrdinal, defaultValue, null);
            block.setDefaultValue(null);
            --numSuppressedValues;
        }
        if (logger.isOn(LogLevel.INFO)) {
            NumberFormat nf = NumberFormat.getInstance();
            logger.log(LogLevel.INFO, "Block built from resultSet has " + nf.format((long)block.cellSetSize()) + " cells, and " + nf.format((long)numSuppressedValues) + " were suppressed since they matched the default value.");
        }
        if (block.getDefaultValue() == null) {
            if (operation == 1 || operation == 3 || operation == 5) {
                NullBehavior nullBooleanHandling = NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.boolean.operator", NullBehavior.ZERO);
                if (nullBooleanHandling != NullBehavior.SQL) {
                    this.performOpForNullCells(block, operation);
                }
            } else if (operation == 9 || operation == 17 || operation == 19 || operation == 11 || operation == 13 || operation == 15) {
                NullBehavior nullComparisonHandling = NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.comparison.operator", NullBehavior.ZERO);
                if (nullComparisonHandling != NullBehavior.SQL) {
                    this.performOpForNullCells(block, operation);
                }
            } else {
                this.performOpForNullCells(block, operation);
            }
        }
        return block;
    }

    private boolean useSparseIterator(InterpreterContext interpreterContext, Block[] blocks, int operation, NullBehavior[] nullBehavior) {
        if (!ResultSetProcessor.isSparseIterationEnabled(interpreterContext)) {
            return false;
        }
        for (Block block : blocks) {
            if (block.getDefaultValue() == null) continue;
            return false;
        }
        switch (operation) {
            case 20: {
                return nullBehavior[2] == NullBehavior.SQL;
            }
            case 22: {
                return nullBehavior[3] == NullBehavior.SQL;
            }
            case 26: {
                return nullBehavior[4] == NullBehavior.SQL;
            }
            case 24: {
                return nullBehavior[5] != NullBehavior.ZERO && nullBehavior[6] == NullBehavior.SQL;
            }
        }
        return false;
    }

    public static boolean isSparseIterationEnabled(InterpreterContext interpreterContext) {
        IDataSource dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        String key = null;
        String sparseIterationEnabled = Boolean.FALSE.toString();
        if (dataSource != null) {
            if (dataSource.isROLAP()) {
                key = "RO";
            } else if (dataSource.isRelational()) {
                key = "DMR";
            }
            IDataSourceCapabilities providerCapabilities = null;
            providerCapabilities = key != null ? ProviderCapabilites.getInstance().getOrAddProviderCapabilities(key) : dataSource.getCapabilities();
            sparseIterationEnabled = providerCapabilities.getStringValue(ENABLE_ARITHMETIC_OPERATIONS_SPARSE_PROCESSING, "true");
        }
        return sparseIterationEnabled.equalsIgnoreCase("true");
    }

    private boolean isOrdinalTrackingRequired(Block blk) {
        return blk.isPipelining() && blk.tupleSetSize() < Integer.MAX_VALUE;
    }

    private NullBehavior[] getNullHandlingBehavior(InterpreterContext interpreterContext) {
        NullBehavior[] nullHandling = new NullBehavior[]{NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.comparison.operator", NullBehavior.ZERO), NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.boolean.operator", NullBehavior.FALSE), NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.plus.operator", NullBehavior.ZERO), NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.minus.operator", NullBehavior.ZERO), NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.multiply.operator", NullBehavior.SQL), NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.divide.numerator", NullBehavior.SQL), NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.divide.denominator", NullBehavior.ZERO), NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.modulo.dividend", NullBehavior.SQL), NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.modulo.divisor", NullBehavior.ZERO)};
        return nullHandling;
    }

    private void performOpForNullCells(Block block, int operation) {
        int cellCount = block.cellSetSize();
        long tupleCount = block.tupleSetSize();
        if (cellCount == 0 || tupleCount < 0L || tupleCount > (long)cellCount) {
            if (operation == 9 || operation == 17 || operation == 19 || operation == 21) {
                block.setDefaultValue(BooleanValue.TRUE);
            } else if (operation == 11 || operation == 13 || operation == 15 || operation == 1 || operation == 3 || operation == 5) {
                block.setDefaultValue(BooleanValue.FALSE);
            }
        }
    }

    public Object performOp(InterpreterContext interpreterContext, Object o1, Object o2, Operator op, int operation, NullBehavior[] nullBevahior) throws InterpreterException {
        if (ErrorCell.isErrorCell(o1) || ErrorCell.isErrorCell(o2)) {
            return TextValue.ERROR_VALUE;
        }
        if (o1 instanceof Value || o2 instanceof Value) {
            Value v;
            if (o1 == null) {
                Value value2 = (Value)o2;
                v = (Value)value2.getDataType().createValue();
                v.setState(ValueState.NULL);
                v.setFormatId(value2.getFormatId());
                o1 = v;
            }
            if (o2 == null) {
                Value value1 = (Value)o1;
                v = (Value)value1.getDataType().createValue();
                v.setState(ValueState.NULL);
                v.setFormatId(value1.getFormatId());
                o2 = v;
            }
            return this.operateOnIValues(interpreterContext, (Value)o1, (Value)o2, op, operation, nullBevahior);
        }
        return this.operateOnObjectValues(o1, o2, op, operation);
    }

    private Object operateOnIValues(InterpreterContext interpreterContext, Value v1, Value v2, Operator op, int operation, NullBehavior[] nullBehavior) throws InterpreterException {
        boolean i = false;
        NullBehavior nullComparisonHandling = nullBehavior[0];
        NullBehavior nullBooleanHandling = nullBehavior[1];
        NullBehavior nullPlusHandling = nullBehavior[2];
        NullBehavior nullMinusHandling = nullBehavior[3];
        NullBehavior nullMultiplyHandling = nullBehavior[4];
        NullBehavior nullDivideNumeratorHandling = nullBehavior[5];
        NullBehavior nullDivideDenominatorHandling = nullBehavior[6];
        NullBehavior nullModuloDividendHandling = nullBehavior[7];
        NullBehavior nullModuloDivisorHandling = nullBehavior[8];
        switch (operation) {
            case 1: {
                Value v;
                if (nullBooleanHandling == NullBehavior.SQL && (v1.isNull() || v2.isNull())) {
                    if (!v1.isNull() && v1.getBoolean() == Boolean.FALSE.booleanValue() || !v2.isNull() && v2.getBoolean() == Boolean.FALSE.booleanValue()) {
                        BooleanValue v3 = DataValueFactory.createBooleanValue();
                        ((Value)v3).set(Boolean.FALSE);
                        return v3;
                    }
                    if (v1.isNull()) {
                        return v1.copy();
                    }
                    return v2.copy();
                }
                if (!v1.isNull() && v1.isNumeric() || !v2.isNull() && v2.isNumeric()) {
                    v = DataValueFactory.createDoubleValue();
                    v.set(v1.getInteger() & v2.getInteger());
                    v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                } else {
                    v = DataValueFactory.createBooleanValue();
                    boolean b1 = v1.getBoolean();
                    boolean b2 = v2.getBoolean();
                    v.set(b1 && b2);
                }
                return v;
            }
            case 3: {
                Value v;
                if (nullBooleanHandling == NullBehavior.SQL && (v1.isNull() || v2.isNull())) {
                    if (!v1.isNull() && v1.getBoolean() == Boolean.TRUE.booleanValue() || !v2.isNull() && v2.getBoolean() == Boolean.TRUE.booleanValue()) {
                        BooleanValue v4 = DataValueFactory.createBooleanValue();
                        ((Value)v4).set(Boolean.TRUE);
                        return v4;
                    }
                    if (v1.isNull()) {
                        return v1.copy();
                    }
                    return v2.copy();
                }
                if (!v1.isNull() && v1.isNumeric() || !v2.isNull() && v2.isNumeric()) {
                    v = DataValueFactory.createDoubleValue();
                    v.set(v1.getInteger() | v2.getInteger());
                    v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                } else {
                    v = DataValueFactory.createBooleanValue();
                    boolean b1 = v1.getBoolean();
                    boolean b2 = v2.getBoolean();
                    v.set(b1 || b2);
                }
                return v;
            }
            case 5: {
                Value v;
                if (nullBooleanHandling == NullBehavior.SQL && (v1.isNull() || v2.isNull())) {
                    if (v1.isNull()) {
                        return v1.copy();
                    }
                    return v2.copy();
                }
                if (!v1.isNull() && v1.isNumeric() || !v2.isNull() && v2.isNumeric()) {
                    v = DataValueFactory.createDoubleValue();
                    v.set(v1.getInteger() ^ v2.getInteger());
                    v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                } else {
                    v = DataValueFactory.createBooleanValue();
                    boolean b1 = v1.getBoolean();
                    boolean b2 = v2.getBoolean();
                    v.set(b1 ^ b2);
                }
                return v;
            }
            case 9: {
                if (nullComparisonHandling == NullBehavior.SQL && (v1.isNull() || v2.isNull())) {
                    if (v1.isNull()) {
                        return v1.copy();
                    }
                    return v2.copy();
                }
                int compare = this.compareIValues(v1, v2, nullComparisonHandling);
                if (compare == 0) {
                    return BooleanValue.TRUE;
                }
                return BooleanValue.FALSE;
            }
            case 11: {
                if (nullComparisonHandling == NullBehavior.SQL && (v1.isNull() || v2.isNull())) {
                    if (v1.isNull()) {
                        return v1.copy();
                    }
                    return v2.copy();
                }
                int compare = this.compareIValues(v1, v2, nullComparisonHandling);
                if (compare != 0) {
                    return BooleanValue.TRUE;
                }
                return BooleanValue.FALSE;
            }
            case 13: {
                if (nullComparisonHandling == NullBehavior.SQL && (v1.isNull() || v2.isNull())) {
                    if (v1.isNull()) {
                        return v1.copy();
                    }
                    return v2.copy();
                }
                if (v1.isNull() && v2.isNull()) {
                    return BooleanValue.FALSE;
                }
                int compare = this.compareIValues(v1, v2, nullComparisonHandling);
                if (compare == 1) {
                    return BooleanValue.TRUE;
                }
                return BooleanValue.FALSE;
            }
            case 15: {
                if (nullComparisonHandling == NullBehavior.SQL && (v1.isNull() || v2.isNull())) {
                    if (v1.isNull()) {
                        return v1.copy();
                    }
                    return v2.copy();
                }
                if (v1.isNull() && v2.isNull()) {
                    return BooleanValue.FALSE;
                }
                int compare = this.compareIValues(v1, v2, nullComparisonHandling);
                if (compare == -1) {
                    return BooleanValue.TRUE;
                }
                return BooleanValue.FALSE;
            }
            case 17: {
                if (nullComparisonHandling == NullBehavior.SQL && (v1.isNull() || v2.isNull())) {
                    if (v1.isNull()) {
                        return v1.copy();
                    }
                    return v2.copy();
                }
                if (v1.isNull() && v2.isNull()) {
                    return BooleanValue.TRUE;
                }
                int compare = this.compareIValues(v1, v2, nullComparisonHandling);
                if (compare == 1 || compare == 0) {
                    return BooleanValue.TRUE;
                }
                return BooleanValue.FALSE;
            }
            case 19: {
                if (nullComparisonHandling == NullBehavior.SQL && (v1.isNull() || v2.isNull())) {
                    if (v1.isNull()) {
                        return v1.copy();
                    }
                    return v2.copy();
                }
                if (v1.isNull() && v2.isNull()) {
                    return BooleanValue.TRUE;
                }
                int compare = this.compareIValues(v1, v2, nullComparisonHandling);
                if (compare == -1 || compare == 0) {
                    return BooleanValue.TRUE;
                }
                return BooleanValue.FALSE;
            }
            case 20: {
                if (v1.isNull()) {
                    if (nullPlusHandling == NullBehavior.SQL) {
                        return v1.copy();
                    }
                    return v2.copy();
                }
                if (v2.isNull()) {
                    if (nullPlusHandling == NullBehavior.SQL) {
                        return v2.copy();
                    }
                    return v1.copy();
                }
                if (v1 instanceof TextValue && v2 instanceof TextValue) {
                    StringValue v = DataValueFactory.createStringValue();
                    ((Value)v).set(v1.getString() + v2.getString());
                    return v;
                }
                IMDXFunctionProcessor processor = MDXFunctionProcessorFactory.getMathOperatorProcessor(interpreterContext.getCube());
                processor.setFunctionCode(20, 2);
                processor.addParameter(interpreterContext, v1);
                processor.addParameter(interpreterContext, v2);
                return processor.getResult(interpreterContext);
            }
            case 22: {
                if (v1.isNull()) {
                    if (nullMinusHandling == NullBehavior.SQL) {
                        return v1.copy();
                    }
                    if (v2.isNull()) {
                        return v2.copy();
                    }
                    DoubleValue v = DataValueFactory.createDoubleValue();
                    ((Value)v).set(0.0 - v2.getDouble());
                    ArrayList<FormatId> idList = new ArrayList<FormatId>();
                    idList.add(v1.getFormatId());
                    idList.add(v2.getFormatId());
                    v.setFormatId(FormatService.getInstance().formatResult("Subtract", idList));
                    return v;
                }
                if (v2.isNull()) {
                    if (nullMinusHandling == NullBehavior.SQL) {
                        return v2.copy();
                    }
                    return v1.copy();
                }
                IMDXFunctionProcessor processor = MDXFunctionProcessorFactory.getMathOperatorProcessor(interpreterContext.getCube());
                processor.setFunctionCode(22, 2);
                processor.addParameter(interpreterContext, v1);
                processor.addParameter(interpreterContext, v2);
                return processor.getResult(interpreterContext);
            }
            case 26: {
                if (v1.isNull()) {
                    if (nullMultiplyHandling == NullBehavior.SQL) {
                        return v1.copy();
                    }
                    DoubleValue v = DataValueFactory.createDoubleValue();
                    ((Value)v).set(0);
                    v.setFormatId(v2.getFormatId());
                    return v;
                }
                if (v2.isNull()) {
                    if (nullMultiplyHandling == NullBehavior.SQL) {
                        return v2.copy();
                    }
                    DoubleValue v = DataValueFactory.createDoubleValue();
                    ((Value)v).set(0);
                    v.setFormatId(v1.getFormatId());
                    return v;
                }
                IMDXFunctionProcessor processor = MDXFunctionProcessorFactory.getMathOperatorProcessor(interpreterContext.getCube());
                processor.setFunctionCode(26, 2);
                processor.addParameter(interpreterContext, v1);
                processor.addParameter(interpreterContext, v2);
                return processor.getResult(interpreterContext);
            }
            case 24: {
                DoubleValue v = DataValueFactory.createDoubleValue();
                v.setFormatId(v1.getFormatId());
                if (v1.isNull() && nullDivideNumeratorHandling == NullBehavior.ZERO) {
                    v1.set(0);
                }
                if (v1.isNull()) {
                    return v1.copy();
                }
                if (v2.isNull()) {
                    if (nullDivideDenominatorHandling == NullBehavior.SQL && v2.isNull()) {
                        return v2.copy();
                    }
                    if (v1.getDouble() == 0.0) {
                        ((Value)v).set(Double.NaN);
                        v.setState(ValueState.DIV_BY_ZERO);
                        return v;
                    }
                    ((Value)v).set(Double.POSITIVE_INFINITY);
                    v.setState(ValueState.DIV_BY_ZERO);
                    return v;
                }
                IMDXFunctionProcessor processor = MDXFunctionProcessorFactory.getMathOperatorProcessor(interpreterContext.getCube());
                processor.setFunctionCode(24, 2);
                processor.addParameter(interpreterContext, v1);
                processor.addParameter(interpreterContext, v2);
                return processor.getResult(interpreterContext);
            }
            case 28: {
                if (v1.isNull() && nullModuloDividendHandling == NullBehavior.SQL) {
                    return v1.copy();
                }
                if (v2.isNull() && nullModuloDivisorHandling == NullBehavior.SQL) {
                    return v2.copy();
                }
                DoubleValue v = DataValueFactory.createDoubleValue();
                double d2 = v2.getDouble();
                if (v2.isNull() || d2 == 0.0) {
                    ((Value)v).set(Double.NaN);
                } else {
                    ((Value)v).set(v1.getDouble() % d2);
                }
                v.setFormatId(v1.getFormatId());
                return v;
            }
            case 30: {
                StringValue v = DataValueFactory.createStringValue();
                ((Value)v).set(v1.getString() + v2.getString());
                return v;
            }
            case 21: {
                Value b1 = this.isNullObject(v1);
                Value b2 = this.isNullObject(v2);
                if (b1.isNull()) {
                    return b2;
                }
                if (b2.isNull()) {
                    return b1;
                }
                throw new InterpreterException("X01434", new String[]{v2.getClass().toString() + COMMA_SPACE_STR + v1.getClass().toString(), "CMP_TYPEMEMBER, CMP_TYPETUPLE, CMP_TYPESET, CMP_TYPELEVEL, ..."});
            }
            case 32: {
                return op.performOperation(v1, v2);
            }
        }
        throw new InterpreterException("X01434", new String[]{operation + "", "9, 20, 22, 26, 24, ..."});
    }

    private int compareIValues(Value v1, Value v2, NullBehavior nullHandling) throws InterpreterException {
        if (v1.isNull() && v2.isNull()) {
            return 0;
        }
        if (v1 instanceof TextValue && v2.isNull()) {
            return 1;
        }
        if (v2 instanceof TextValue && v1.isNull()) {
            return -1;
        }
        if (v1 instanceof TextValue && v2 instanceof TextValue) {
            return v1.compareTo(v2);
        }
        if (!v1.isNull() && v1.isNumeric() && !v2.isNull() && v2.isNumeric()) {
            return v1.compareTo(v2, nullHandling);
        }
        try {
            return v1.compareTo(v2, nullHandling);
        }
        catch (ValueConversionException v3) {
            return v2.compareTo(v1, nullHandling) * -1;
        }
    }

    private Object operateOnObjectValues(Object o1, Object o2, Operator op, int operation) throws InterpreterException {
        switch (operation) {
            case 1: {
                if (o1 instanceof Set && o2 instanceof Set) {
                    return this.performIntersect((Set)o1, (Set)o2);
                }
                throw new InterpreterException("X01434", new String[]{o1.toString() + COMMA_SPACE_STR + o2.toString(), ""});
            }
            case 3: {
                if (o1 instanceof Set && o2 instanceof Set) {
                    return Set.union(new Set[]{(Set)o1, (Set)o2}, false);
                }
                throw new InterpreterException("X01434", new String[]{o1.toString() + COMMA_SPACE_STR + o2.toString(), ""});
            }
            case 5: {
                if (o1 instanceof Set && o2 instanceof Set) {
                    return Set.union(new Set[]{(Set)o1, (Set)o2}, false).except(((Set)o1).intersect((Set)o2, false));
                }
                throw new InterpreterException("X01434", new String[]{o1.toString() + COMMA_SPACE_STR + o2.toString(), ""});
            }
            case 9: {
                if (o1 == null && o2 == null) {
                    return BooleanValue.TRUE;
                }
                if (o1 != null && o2 != null) {
                    if (o1.getClass() != o2.getClass()) {
                        return BooleanValue.FALSE;
                    }
                    if (o1.equals(o2)) {
                        return BooleanValue.TRUE;
                    }
                    return BooleanValue.FALSE;
                }
                return BooleanValue.FALSE;
            }
            case 11: {
                if (o1 == null && o2 == null) {
                    return BooleanValue.FALSE;
                }
                if (o1 != null && o2 != null) {
                    if (o1.getClass() != o2.getClass()) {
                        return BooleanValue.TRUE;
                    }
                    if (o1.equals(o2)) {
                        return BooleanValue.FALSE;
                    }
                    return BooleanValue.TRUE;
                }
                return BooleanValue.TRUE;
            }
            case 13: 
            case 15: {
                if (o1 == null && o2 == null) {
                    return BooleanValue.FALSE;
                }
                throw new InterpreterException("X01434", new String[]{o1.toString() + COMMA_SPACE_STR + o2.toString(), ""});
            }
            case 17: 
            case 19: {
                if (o1 == null && o2 == null) {
                    return BooleanValue.TRUE;
                }
                throw new InterpreterException("X01434", new String[]{o1.toString() + COMMA_SPACE_STR + o2.toString(), ""});
            }
            case 26: {
                if (o1 instanceof Set && o2 instanceof Set) {
                    Set s1 = (Set)o1;
                    Set s2 = (Set)o2;
                    return s1.crossjoin(s2);
                }
                throw new InterpreterException("X01434", new String[]{o1.toString() + COMMA_SPACE_STR + o2.toString(), ""});
            }
            case 23: {
                if ((this.isNullObject(o1).getBoolean() || o1 instanceof Tuple) && (this.isNullObject(o2).getBoolean() || o2 instanceof Tuple)) {
                    if (this.isNullObject(o1).getBoolean() || this.isNullObject(o2).getBoolean()) {
                        return BooleanValue.FALSE;
                    }
                    if (((Tuple)o1).size() != 1 && ((Tuple)o2).size() != 1) {
                        throw new InterpreterException("X01490", new String[]{"TUPLE1.size() == " + ((Tuple)o1).size() + ", TUPLE2.size() == " + ((Tuple)o2).size(), "performMemberOperation", "TUPLE1.size() == 1 || TUPLE2.size() == 1"});
                    }
                    IMember member1 = ((Tuple)o1).getMember(0);
                    IMember member2 = ((Tuple)o2).getMember(0);
                    return this.isAncestor(member1, member2);
                }
                if ((this.isNullObject(o1).getBoolean() || o1 instanceof IMember) && (this.isNullObject(o2).getBoolean() || o2 instanceof IMember)) {
                    IMember member1 = (IMember)o1;
                    IMember member2 = (IMember)o2;
                    return this.isAncestor(member1, member2);
                }
                throw new InterpreterException("X01434", new String[]{o1.toString() + COMMA_SPACE_STR + o2.toString(), "Member, Tuple"});
            }
            case 21: {
                if (this.isNullObject(o1).getBoolean()) {
                    return this.isNullObject(o2);
                }
                if (this.isNullObject(o2).getBoolean()) {
                    return this.isNullObject(o1);
                }
                if (o1 instanceof Tuple && o2 instanceof Tuple) {
                    Tuple tuple1 = (Tuple)o1;
                    Tuple tuple2 = (Tuple)o2;
                    if (tuple1.compareTo(tuple2) == 0) {
                        return BooleanValue.TRUE;
                    }
                    return BooleanValue.FALSE;
                }
                if (o1 instanceof ILevel && o2 instanceof ILevel) {
                    ILevel level1 = (ILevel)o1;
                    ILevel level2 = (ILevel)o2;
                    if (level1.compareTo(level2) == 0) {
                        return BooleanValue.TRUE;
                    }
                    return BooleanValue.FALSE;
                }
                if (o1 instanceof IMember && o2 instanceof IMember) {
                    IMember m1 = (IMember)o1;
                    IMember m2 = (IMember)o2;
                    if (m1.getUniqueName().compareTo(m2.getUniqueName()) == 0) {
                        return BooleanValue.TRUE;
                    }
                    return BooleanValue.FALSE;
                }
                if (Caster.isCastable(o1, Tuple.class) && Caster.isCastable(o2, Tuple.class)) {
                    Tuple tuple2;
                    Tuple tuple1 = (Tuple)Caster.cast(o1, Tuple.class);
                    if (tuple1.compareTo(tuple2 = (Tuple)Caster.cast(o2, Tuple.class)) == 0) {
                        return BooleanValue.TRUE;
                    }
                    return BooleanValue.FALSE;
                }
                throw new InterpreterException("X01434", new String[]{o2.getClass().toString() + COMMA_SPACE_STR + o1.getClass().toString(), "CMP_TYPEMEMBER, CMP_TYPETUPLE, CMP_TYPESET, CMP_TYPELEVEL, ..."});
            }
            case 32: {
                return op.performOperation(o1, o2);
            }
        }
        throw new InterpreterException("X01434", new String[]{operation + "", "9, 20, 22, 26, 24, ..."});
    }

    private Set performIntersect(Set s1, Set s2) throws InterpreterException {
        int i;
        HashSet<IHierarchy> hiersToRetain = new HashSet<IHierarchy>(Arrays.asList(s1.getHierarchies()));
        hiersToRetain.retainAll(Arrays.asList(s2.getHierarchies()));
        IHierarchy[] hiers = s2.getHierarchies();
        for (i = 0; i < hiers.length; ++i) {
            if (hiersToRetain.contains(hiers[i])) continue;
            s2 = (Set)s2.removeHierarchy(hiers[i], true);
        }
        hiers = s1.getHierarchies();
        for (i = 0; i < hiers.length; ++i) {
            if (hiersToRetain.contains(hiers[i])) continue;
            s1 = (Set)s1.removeHierarchy(hiers[i], true);
        }
        return s1.intersect(s2, false);
    }

    private BooleanValue isAncestor(IMember ancestorMember, IMember startingMember) throws InterpreterException {
        boolean isAncestorResult = false;
        if (ancestorMember instanceof NullMember || startingMember instanceof NullMember) {
            return BooleanValue.FALSE;
        }
        if (ancestorMember == null || startingMember == null) {
            return BooleanValue.FALSE;
        }
        int ancestorMemberLevelNdx = ancestorMember.getLevel().getIndex();
        if (ancestorMember.getHierarchy() == startingMember.getHierarchy() && startingMember.getLevel().getIndex() > ancestorMemberLevelNdx) {
            IMember ancestor = startingMember;
            while (ancestor != null && ancestor.getLevel().getIndex() > ancestorMemberLevelNdx && !isAncestorResult) {
                if ((ancestor = ancestor.getParent()) != ancestorMember) continue;
                isAncestorResult = true;
            }
        }
        if (isAncestorResult) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    private BooleanValue isNullObject(Object obj) {
        if (obj == null) {
            return BooleanValue.TRUE;
        }
        if (obj instanceof Value && ((Value)obj).isNull()) {
            return BooleanValue.TRUE;
        }
        if (obj instanceof NullObject) {
            return BooleanValue.TRUE;
        }
        if (obj instanceof ITuple && ((Tuple)obj).containsNullMember()) {
            return BooleanValue.TRUE;
        }
        if (obj instanceof NullMember) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    private Value isNullObject(Value obj) {
        if (obj == null) {
            return BooleanValue.TRUE;
        }
        if (obj instanceof Value && obj.isNull()) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }
}

