/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SecuredResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.SecuredPipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.SecuredSynchronousPipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPUserSecurityContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecManager;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.trace.LogLevel;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;

public class SecuredResultSetHelper {
    private static final String USE_SYNCHRONOUS_PIPELINE_RESULT_SET = "useSynchronousPipelineResultSet";
    private final SecurityManagerInterface securityManager;
    private boolean settingTuplesToError = false;
    private final HashSet<Number> errorTuples = new HashSet();
    private ROLAPUserSecurityContext securityContext = null;

    private static boolean useSynchronousPipelineResultSet() {
        String value = System.getProperty(USE_SYNCHRONOUS_PIPELINE_RESULT_SET);
        return "true".equalsIgnoreCase(value);
    }

    public static IResultSet createSecuredResultSet(ISet[] axis, ISet slicer, InterpreterContext ic, boolean cellResultsExpected) {
        boolean hasCalculatedMembers = SecuredResultSetHelper.hasCalculatedMembers(axis, slicer);
        boolean supportCalculatedMembersWithPipelining = PipelineResultSet.supportCalculatedMembersWithPipelining();
        if (cellResultsExpected && (!hasCalculatedMembers || supportCalculatedMembersWithPipelining) && PipelineResultSet.usePipelining(ic)) {
            if (SecuredResultSetHelper.useSynchronousPipelineResultSet()) {
                return new SecuredSynchronousPipelineResultSet(axis, slicer, ic);
            }
            return new SecuredPipelineResultSet(axis, slicer, ic);
        }
        return new SecuredResultSet(axis, slicer, ic);
    }

    private static boolean hasCalculatedMembers(ISet[] axis, ISet slicer) {
        boolean hasCalculatedMembers = false;
        if (slicer != null && !slicer.isEmpty()) {
            hasCalculatedMembers = ((Set)slicer).getTupleList().containsCalculatedMembers();
        }
        for (ISet ax : axis) {
            if (!ax.isEmpty() && (hasCalculatedMembers |= ((Set)ax).getTupleList().containsCalculatedMembers())) break;
        }
        return hasCalculatedMembers;
    }

    public static IResultSet createSecuredResultSet(CrossJoinedSet qs, InterpreterContext ic, boolean allowPipeline) {
        if (allowPipeline && PipelineResultSet.usePipelining(ic)) {
            if (SecuredResultSetHelper.useSynchronousPipelineResultSet()) {
                return new SecuredSynchronousPipelineResultSet(qs, ic);
            }
            return new SecuredPipelineResultSet(qs, ic);
        }
        return new SecuredResultSet(qs, ic);
    }

    public static IResultSet createSecuredResultSet(CrossJoinedSet qs, SecurityManagerInterface theSecManager) {
        return new SecuredResultSet(qs, theSecManager);
    }

    public SecuredResultSetHelper(InterpreterContext ic) {
        this.securityManager = SecuredResultSetHelper.getSecurityManager(ic);
        if (this.securityManager != null && this.securityManager instanceof SecManager) {
            this.securityContext = ((SecManager)this.securityManager).getUserSecurityContext();
        }
    }

    public SecuredResultSetHelper(SecurityManagerInterface secManager) {
        this.securityManager = SecuredResultSetHelper.getCheckTupleValueVisbility(secManager);
        if (this.securityManager != null && this.securityManager instanceof SecManager) {
            this.securityContext = ((SecManager)this.securityManager).getUserSecurityContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTuplesToError(AbstractResultSet resultSet) {
        try {
            if (this.securityManager == null) {
                return;
            }
            CrossJoinedSet querySet = resultSet.getQuerySet();
            this.settingTuplesToError = true;
            Cell c = new Cell(TextValue.ERROR_VALUE);
            ITupleList tupleList = resultSet.getQuerySet().getTupleList();
            if (tupleList == null) {
                return;
            }
            long querySize = resultSet.getQuerySet().size();
            ArrayList<IMember> slicerMembers = new ArrayList<IMember>();
            Set setToCheck = querySet;
            if (this.securityManager instanceof SecManager) {
                setToCheck = ((SecManager)this.securityManager).getMultiTupleSetWithRestrictedHierarchies(querySet, slicerMembers);
            }
            if ((tupleList = setToCheck.getTupleList()) == null) {
                return;
            }
            if (this.securityManager instanceof SecManager && ((SecManager)this.securityManager).areAllTuplesValuesVisible(this.securityContext, tupleList)) {
                return;
            }
            ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPCubes.Security", "Need to check which " + tupleList.size() + " tuples need to be set to error.");
            boolean allCalcTuples = false;
            if (slicerMembers.size() > 0) {
                Tuple slicerTuple = new Tuple(slicerMembers.toArray(new IMember[slicerMembers.size()]), this.securityManager.getCube());
                allCalcTuples = slicerTuple.containsCalculation();
            }
            ITupleIterator iterator = tupleList.iterator();
            long errorCount = 0L;
            while (iterator.hasNext()) {
                long currSetOrd = iterator.getIndex();
                ITuple tuple = iterator.next();
                if (this.securityManager.isTupleValueVisible(this.securityContext, tuple)) continue;
                boolean isCalc = allCalcTuples ? allCalcTuples : ((Tuple)tuple).containsCalculation();
                if (querySize < 0L) {
                    resultSet.addCell(tuple, c, isCalc);
                } else {
                    Cell newCell = new Cell(c);
                    newCell.setOrdinal(currSetOrd);
                    newCell.setIsCalculation(isCalc);
                    resultSet.addCell(newCell);
                }
                ++errorCount;
            }
            ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPCubes.Security", "Finished checking with " + errorCount + " tuples out of a total of " + tupleList.size() + " tuples set to error.");
        }
        finally {
            this.settingTuplesToError = false;
        }
    }

    public boolean getSettingTuplesToError() {
        return this.settingTuplesToError;
    }

    public HashSet<Number> getErrorTuples() {
        return this.errorTuples;
    }

    public SecurityManagerInterface getSecurityManager() {
        return this.securityManager;
    }

    public boolean isTupleValueVisible(Number cellOrdinal, AbstractResultSet resultSet) {
        if (this.securityManager == null || this.settingTuplesToError) {
            return true;
        }
        boolean isTupleValueVisible = true;
        Tuple tuple = null;
        if (cellOrdinal instanceof BigInteger) {
            tuple = resultSet.getTupleByCellOrdinal((BigInteger)cellOrdinal);
        } else if (cellOrdinal instanceof Long) {
            tuple = resultSet.getTupleByCellOrdinal((Long)cellOrdinal);
        }
        isTupleValueVisible = tuple == null ? false : this.getSecurityManager().isTupleValueVisible(this.securityContext, tuple);
        return isTupleValueVisible;
    }

    public boolean isTupleValueVisible(ITuple tuple) {
        if (this.getSecurityManager() == null) {
            return true;
        }
        return this.getSecurityManager().isTupleValueVisible(this.securityContext, tuple);
    }

    public void captureSecuredOrdinal(Number cellOrdinal) {
        if (this.getSettingTuplesToError()) {
            this.getErrorTuples().add(cellOrdinal);
        }
    }

    public boolean isSecuredOrdinal(Number ordinal) {
        boolean isSecuredOrdinal = this.getErrorTuples().contains(ordinal);
        return isSecuredOrdinal;
    }

    public boolean isSecurityEnabled() {
        return this.securityManager != null;
    }

    private static SecurityManagerInterface getSecurityManager(InterpreterContext interpreterContext) {
        ICube c;
        SecurityManagerInterface secManager = null;
        if (interpreterContext != null && (c = interpreterContext.getCube()) != null) {
            Provider provider = interpreterContext.getProvider();
            secManager = ((Cube)c).getSecurityManager(provider);
            secManager = SecuredResultSetHelper.getCheckTupleValueVisbility(secManager);
        }
        return secManager;
    }

    private static SecurityManagerInterface getCheckTupleValueVisbility(SecurityManagerInterface secManager) {
        if (secManager != null && !secManager.getCheckTupleValueVisbility()) {
            secManager = null;
        }
        return secManager;
    }
}

