/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Query;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SecuredResultSetHelper;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.IPipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelineCallable;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMediator;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.platform.Environment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCallable;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.util.concurrent.UnboundedThreadPool;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class SelectQuery
extends Query {
    private static final String ERROR_MESSAGE_PARM = "axisNumber > axes.length - 1";
    private static final String ERR_MSG_PARAM = "axes[";
    private ISet[] axes;
    private ITuple whereTuple;
    private Hashtable<IHierarchy, Integer> hierarchiesToAxes;
    private IResultSet resultSet;
    private boolean[] nonEmptyAxes;
    private ArrayList<IProperty>[] axisToProperties;
    private final ICalculationEngine calculationEngine;
    private boolean isSubQuery;
    private boolean isMemberSearchQuery;
    private boolean isCalculationPrime;
    private final ArrayList<String> cellProperties;
    private boolean nonEmptyQuery;
    private boolean applySecurity = true;
    private Boolean containsNullTag = false;

    public SelectQuery(ICalculationEngine ce) {
        this.calculationEngine = ce;
        this.isSubQuery = true;
        this.isMemberSearchQuery = false;
        this.nonEmptyQuery = false;
        this.cellProperties = new ArrayList();
        this.isCalculationPrime = false;
    }

    public SelectQuery(SelectQuery toClone, ICalculationEngine ce) {
        this.setCube(toClone.getCube());
        this.calculationEngine = ce;
        this.axes = new ISet[toClone.axes.length];
        int i = 0;
        for (i = 0; i < toClone.axes.length; ++i) {
            this.axes[i] = (ISet)toClone.axes[i].copy();
        }
        this.whereTuple = (ITuple)toClone.whereTuple.copy();
        this.hierarchiesToAxes = new Hashtable<IHierarchy, Integer>(toClone.hierarchiesToAxes);
        this.nonEmptyAxes = Arrays.copyOf(toClone.nonEmptyAxes, toClone.nonEmptyAxes.length);
        this.axisToProperties = new ArrayList[toClone.axisToProperties.length];
        for (i = 0; i < toClone.axisToProperties.length; ++i) {
            if (toClone.axisToProperties[i] == null) continue;
            this.axisToProperties[i] = new ArrayList<IProperty>(toClone.axisToProperties[i]);
        }
        this.isSubQuery = toClone.isSubQuery;
        this.isMemberSearchQuery = toClone.isMemberSearchQuery;
        this.isCalculationPrime = toClone.isCalculationPrime;
        this.cellProperties = new ArrayList<String>(toClone.cellProperties);
        this.nonEmptyQuery = toClone.nonEmptyQuery;
        this.applySecurity = toClone.applySecurity;
        this.containsNullTag = toClone.containsNullTag;
    }

    public void addCellProperty(String propertyName) {
        this.cellProperties.add(propertyName);
    }

    public boolean isMemberSearchQuery() {
        return this.isMemberSearchQuery;
    }

    public boolean hasPrimed() {
        return this.isCalculationPrime;
    }

    public boolean canPrimed() {
        return !this.hasPrimed() && !this.isMemberSearchQuery() && !this.isSubQuery();
    }

    public void setPrimed(boolean isPrimed) {
        this.isCalculationPrime = isPrimed;
    }

    public void setMemberSearchQuery(boolean memberSearchQuery) {
        this.isMemberSearchQuery = memberSearchQuery;
    }

    public boolean isSubQuery() {
        return this.isSubQuery;
    }

    public void setSubQuery(boolean subQuery) {
        this.isSubQuery = subQuery;
    }

    public boolean hasMeasureDimensions() {
        for (ISet set : this.getAxes()) {
            for (IDimension dim : set.getDimensions()) {
                if (!dim.isMeasuresDimension()) continue;
                return true;
            }
        }
        return false;
    }

    public void setNumberOfAxes(int num) {
        this.axes = new Set[num];
        this.axisToProperties = new ArrayList[num];
        this.nonEmptyAxes = new boolean[num];
        for (int i = 0; i < this.nonEmptyAxes.length; ++i) {
            this.nonEmptyAxes[i] = false;
        }
    }

    public void setNonEmptyAxis(int i) {
        this.nonEmptyAxes[i] = true;
        this.nonEmptyQuery = true;
    }

    public boolean isNonEmptyQuery() {
        return this.nonEmptyQuery;
    }

    public void setApplySecurity(boolean theApplySecurity) {
        this.applySecurity = theApplySecurity;
    }

    public void setPropertiesOnAxis(int axisNumber, ArrayList<IProperty> properties) throws InterpreterException {
        if (axisNumber > this.axes.length - 1) {
            throw new InterpreterException("X60002", new String[]{axisNumber + "", ERROR_MESSAGE_PARM});
        }
        this.axisToProperties[axisNumber] = properties;
    }

    ArrayList<IProperty> getPropertiesOnAxis(int axisNumber) throws InterpreterException {
        if (axisNumber > this.axes.length - 1) {
            throw new InterpreterException("X60002", new String[]{axisNumber + "", ERROR_MESSAGE_PARM});
        }
        return this.axisToProperties[axisNumber];
    }

    public IResultSet getResultSet() {
        return this.resultSet;
    }

    public ISet[] getAxes() {
        return this.axes;
    }

    public void removeNullMembers() {
        for (int j = 0; j < this.axes.length; ++j) {
            ISet axisSet = this.axes[j];
            if (axisSet instanceof CrossJoinedSet) {
                axisSet = ((CrossJoinedSet)axisSet).removeNullMembersFromCrossJoinedSet();
            } else if (axisSet instanceof Set) {
                axisSet = ((Set)axisSet).removeNullMembers();
            }
            this.axes[j] = axisSet;
        }
    }

    @Override
    public void setCube(ICube c) {
        super.setCube(c);
        List<IHierarchy> hierList = ((Cube)c).getHierarchies(true);
        this.hierarchiesToAxes = new Hashtable();
        for (int i = 0; i < hierList.size(); ++i) {
            this.hierarchiesToAxes.put(hierList.get(i), new Integer(-1));
        }
    }

    public void setAxis(int axisNumber, ISet s) throws InterpreterException {
        if (axisNumber > this.axes.length - 1) {
            throw new InterpreterException("X60002", new String[]{axisNumber + "", ERROR_MESSAGE_PARM});
        }
        if (this.axes[axisNumber] != null) {
            throw new InterpreterException("X60002", new String[]{this.axes[axisNumber].toString(), ERR_MSG_PARAM + axisNumber + "] != NULL"});
        }
        if (s.size() != 0L) {
            IHierarchy[] hiers = s.getHierarchies();
            for (int i = 0; i < hiers.length; ++i) {
                IHierarchy hierarchy = hiers[i];
                if (!this.hierarchiesToAxes.get(hierarchy).equals(new Integer(-1))) continue;
                if (this.whereTuple != null && !this.whereTuple.contains(hierarchy)) {
                    this.hierarchiesToAxes.put(hierarchy, new Integer(axisNumber));
                    continue;
                }
                String axisInfo = null;
                axisInfo = this.axes[axisNumber] != null ? this.axes[axisNumber].toString() : ERR_MSG_PARAM + axisNumber + "]";
                throw new InterpreterException("X01441", new String[]{hierarchy.getName(), axisInfo});
            }
        }
        this.axes[axisNumber] = s;
    }

    public void setWhereTuple(ITuple t) {
        this.whereTuple = t;
    }

    public ITuple getWhereTuple() {
        return this.whereTuple;
    }

    private Set createSlicer(Provider provider, InterpreterContext interpreterContext) throws InterpreterException {
        ArrayList<IMember> members = new ArrayList<IMember>();
        Cube cube = (Cube)this.getCube();
        boolean isTMR = cube instanceof LOLAPTM1Cube && cube.multipleHierarchySupport();
        ArrayList<IHierarchy> queryHierarchies = new ArrayList<IHierarchy>();
        ArrayList<IDimension> projDimensions = new ArrayList<IDimension>();
        if (isTMR) {
            MDXHierInfo hierInfo = this.calculationEngine.getMDXLocalHierarchyInfo();
            for (IHierarchy hier : hierInfo.getProjectedHierarchies()) {
                projDimensions.add(hier.getDimension());
            }
        }
        for (ISet axis : this.axes) {
            for (IHierarchy hier : axis.getHierarchies()) {
                queryHierarchies.add(hier);
                if (!isTMR || projDimensions.contains(hier.getDimension())) continue;
                projDimensions.add(hier.getDimension());
            }
        }
        for (IHierarchy hier : this.whereTuple.getHierarchies()) {
            queryHierarchies.add(hier);
        }
        List<IHierarchy> hiersList = cube.getHierarchies(queryHierarchies);
        LOLAPMediator<Boolean> mediator = new LOLAPMediator<Boolean>(() -> isTMR, () -> ((LOLAPTM1Cube)cube).getTM1ServerVersion());
        for (int i = 0; i < hiersList.size(); ++i) {
            int axisNumber;
            IHierarchy h = hiersList.get(i);
            if (mediator.execute(LOLAPMediator.Condition.LESS_THAN, "11.8.00600.6", () -> {
                IDimension d = h.getDimension();
                if (d.getHierarchyCount() > 1 && !this.whereTuple.contains(h) && (projDimensions.contains(d) || !queryHierarchies.contains(h) && !d.getDefaultHierarchy().equals(h) || this.whereTuple.contains(d) && d.getDefaultHierarchy().equals(h))) {
                    return true;
                }
                return false;
            }) && Boolean.TRUE.equals(mediator.getResult()) || (axisNumber = this.hierarchiesToAxes.get(h).intValue()) != -1) continue;
            if (this.whereTuple != null && this.whereTuple.contains(h)) {
                IMember slicerMember = this.whereTuple.getMember(h);
                SecurityManagerInterface sec = ((Cube)this.getCube()).getSecurityManager(provider);
                if (sec != null) {
                    IMember[] memOut;
                    IMember[] memIn = new IMember[]{slicerMember};
                    IHierarchy hier = null;
                    if (slicerMember != null) {
                        hier = slicerMember.getHierarchy();
                    }
                    if ((memOut = sec.applySecurity(memIn, hier)).length == 0) {
                        slicerMember = NullMember.getNullMember(h);
                    }
                }
                members.add(slicerMember);
                continue;
            }
            Dimension dim = (Dimension)h.getDimension();
            try {
                IMember defaultMember;
                if (dim.isAttributeDimension()) {
                    members.add(dim.getDummyMember(h));
                    continue;
                }
                boolean bProjDimension = true;
                if (mediator.applicable(LOLAPMediator.Condition.LESS_THAN, "11.8.00600.6")) {
                    bProjDimension = projDimensions.contains(dim);
                }
                if (isTMR && !dim.isMeasuresDimension() && bProjDimension) {
                    defaultMember = ((Hierarchy)h).getProviderDefaultMember();
                } else {
                    defaultMember = ((Hierarchy)h).getDefaultMemberWithSecurity(cube);
                    if (defaultMember instanceof CalculatedMember) {
                        defaultMember = this.resolveCalculatedDefaultMemberFromContext((CalculatedMember)defaultMember, interpreterContext);
                    }
                }
                members.add(defaultMember);
                continue;
            }
            catch (MetadataException e) {
                throw new InterpreterException("X01408", new String[]{"DIMENSION: " + dim.getUniqueName()}, e);
            }
        }
        if (members.size() == 0) {
            return new Set(new Tuple[0]);
        }
        ArrayList<IMember> removeNulls = new ArrayList<IMember>();
        for (IMember mem : members) {
            if (mem == null) continue;
            removeNulls.add(mem);
        }
        IMember[] tuplemMembers = removeNulls.toArray(new IMember[0]);
        return new Set(new Tuple[]{new Tuple(tuplemMembers, interpreterContext.getCube())});
    }

    private IMember resolveCalculatedDefaultMemberFromContext(CalculatedMember providerDefaultMember, InterpreterContext interpreterContext) {
        Member[] calcList;
        CrossJoinedSet s = interpreterContext.getRootContextSet();
        for (Member member : calcList = s.getCalculations()) {
            if (!(member instanceof CalculatedMember) || ((CalculatedMember)member).getOriginalCalculatedMember() != providerDefaultMember) continue;
            return member;
        }
        return providerDefaultMember;
    }

    @Override
    public boolean execute(InterpreterContext interpreterContext) throws InterpreterException {
        int i;
        Provider provider = interpreterContext.getProvider();
        Set slicer = this.createSlicer(provider, interpreterContext);
        boolean emptyAxis = false;
        SecurityManagerInterface sec = ((Cube)this.getCube()).getSecurityManager(provider);
        if (sec != null) {
            if (this.applySecurity) {
                this.axes = sec.applySecurity(this.axes, interpreterContext);
            }
            ISet[] s = new Set[]{slicer};
            if (slicer.size() > 0L && (slicer = (Set)(s = sec.applySecurity(s, interpreterContext))[0]).size() == 0L) {
                emptyAxis = true;
            }
        }
        if (slicer.containsNullMembers()) {
            emptyAxis = true;
        }
        ISet[] copiedAxes = new ISet[this.axes.length];
        for (i = 0; i < copiedAxes.length; ++i) {
            copiedAxes[i] = this.axes[i];
        }
        for (i = 0; i < this.axes.length; ++i) {
            ISet axis = this.axes[i];
            if (axis instanceof CrossJoinedSet) {
                this.axes[i] = ((CrossJoinedSet)axis).removeNullMembersFromCrossJoinedSet();
                continue;
            }
            if (!(axis instanceof Set)) continue;
            this.axes[i] = ((Set)axis).removeNullMembers();
        }
        for (i = 0; i < this.axes.length; ++i) {
            if (!this.axes[i].isEmpty()) continue;
            emptyAxis = true;
        }
        this.resultSet = SecuredResultSetHelper.createSecuredResultSet(copiedAxes, slicer, interpreterContext, !emptyAxis);
        HashSet<IHierarchy> hs = new HashSet<IHierarchy>();
        if (this.axes.length > 0 && !this.axes[0].isEmpty()) {
            hs.addAll(Arrays.asList(this.axes[0].getHierarchies()));
        }
        for (int i2 = 1; i2 < this.axes.length; ++i2) {
            IHierarchy[] axisDims = this.axes[i2].getHierarchies();
            for (int j = 0; j < axisDims.length; ++j) {
                if (hs.contains(axisDims[j])) {
                    throw new InterpreterException("X01448", new String[]{Integer.toString(i2), axisDims[j].toString()});
                }
                hs.add(axisDims[j]);
            }
        }
        boolean isPipelineResultSet = this.resultSet.isPipelining();
        if (!emptyAxis) {
            long ticks = System.currentTimeMillis();
            this.calculationEngine.slicerInitalized(!slicer.isEmpty());
            ticks = System.currentTimeMillis() - ticks;
            if (isPipelineResultSet) {
                ticks = System.currentTimeMillis();
                ExecutorService executorService = UnboundedThreadPool.getThreadPool();
                InterpreterContext clonedContext = new InterpreterContext(interpreterContext);
                Callable<Void> thread = new CallExecute(this, (IPipelineResultSet)this.resultSet, clonedContext);
                thread = ROLAPCallable.decorateCallable(thread);
                if (this.resultSet.supportsParallelAccess()) {
                    executorService.submit(thread);
                } else {
                    try {
                        thread.call();
                    }
                    catch (InterpreterException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        RuntimeException re = XQERuntimeException.wrap(e);
                        throw re;
                    }
                }
            } else {
                ticks = System.currentTimeMillis();
                this.resultSet = this.calculationEngine.execute(this.resultSet, this);
            }
            this.resultSet.setPropertiesOnAxes(this.axisToProperties);
            this.resultSet.setCellProperties(this.cellProperties);
            this.resultSet.addLocalScopedCalculatedMembers(this.calculationEngine.getAllCalcedMembers());
            ticks = System.currentTimeMillis() - ticks;
            boolean processNonEmpty = this.hasNonEmptyAxes();
            ticks = System.currentTimeMillis();
            if (!isPipelineResultSet) {
                if (processNonEmpty) {
                    this.resultSet.finalizeResultSet(this.nonEmptyAxes);
                    ticks = System.currentTimeMillis() - ticks;
                } else {
                    this.resultSet.finalizeResultSet(null);
                }
            }
        } else {
            if (!isPipelineResultSet) {
                this.resultSet.finalizeResultSet(this.nonEmptyAxes);
            }
            this.resultSet.setPropertiesOnAxes(this.axisToProperties);
            if (slicer.containsNullMembers()) {
                this.resultSet.setSlicerEmpty();
            }
        }
        return true;
    }

    private void suppressNullsInCognos8ResultSet() throws InterpreterException {
        IMember m;
        int i;
        ITuple t;
        if (this.resultSet.isPipelining()) {
            throw new UnsupportedOperationException("Suppress nulls not supported on a pipelined result set.");
        }
        HashMap<IMember, Boolean> memsToNotNull = new HashMap<IMember, Boolean>();
        CrossJoinedSet cjs = this.resultSet.getAxisCrossJoinedSet();
        for (Cell c : this.resultSet) {
            t = cjs.getTuple(c.getOrdinal());
            boolean foundMarker = false;
            for (i = 0; i < t.size() && !foundMarker; ++i) {
                if (!this.isC8Marker(t.getMember(i))) continue;
                foundMarker = true;
            }
            if (foundMarker) continue;
            for (i = 0; i < t.size() && !foundMarker; ++i) {
                m = t.getMember(i);
                if (memsToNotNull.containsKey(m)) continue;
                memsToNotNull.put(m, Boolean.TRUE);
            }
        }
        IResultSetIterator it = this.resultSet.iterator();
        while (it.hasNext()) {
            Cell c;
            c = (Cell)it.next();
            t = cjs.getTuple(c.getOrdinal());
            boolean removed = false;
            for (i = 0; i < t.size() && !removed; ++i) {
                m = t.getMember(i);
                if (memsToNotNull.containsKey(m) || this.isC8Marker(m)) continue;
                it.remove();
                removed = true;
            }
        }
        for (int i2 = 0; i2 < this.nonEmptyAxes.length; ++i2) {
            this.nonEmptyAxes[i2] = true;
        }
    }

    private boolean isC8Marker(IMember m) {
        String markerString = "COG_OQP_INT_";
        return m.isCalculatedMember() && m.getName().startsWith(markerString) && ((CalculatedMember)m).getCalculationString().equalsIgnoreCase("1");
    }

    public void setContainsNullTag(Boolean b) {
        this.containsNullTag = b;
    }

    public boolean containsNullTag() {
        return this.containsNullTag;
    }

    public boolean hasNonEmptyAxes() throws InterpreterException {
        boolean hasNonEmpty = false;
        boolean explicitNonEmptyOnSingleAxis = false;
        if (this.nonEmptyAxes.length == 1 && this.nonEmptyAxes[0]) {
            explicitNonEmptyOnSingleAxis = true;
        }
        String alwaysSuppressNulls = Environment.getEnvironmentVariable("alwaysSuppressNulls");
        if (!this.isSubQuery && alwaysSuppressNulls != null && alwaysSuppressNulls.equalsIgnoreCase("true")) {
            this.suppressNullsInCognos8ResultSet();
        }
        if (this.nonEmptyAxes.length > 1 || this.nonEmptyAxes.length == 1 && explicitNonEmptyOnSingleAxis) {
            for (int i = 0; i < this.nonEmptyAxes.length; ++i) {
                if (!this.nonEmptyAxes[i]) continue;
                hasNonEmpty = true;
            }
        }
        return hasNonEmpty;
    }

    public boolean[] axesHaveNonEmpty() {
        return this.nonEmptyAxes;
    }

    private class CallExecute
    extends PipelineCallable<Void> {
        private final SelectQuery selectQuery;
        private final InterpreterContext ourContext;

        CallExecute(SelectQuery sQuery, IPipelineResultSet pipelineResultSet, InterpreterContext clonedContext) {
            super(pipelineResultSet);
            this.selectQuery = sQuery;
            this.ourContext = clonedContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void callImpl() throws Exception {
            ICalculationEngine ourEngine = this.ourContext.getCalculationEngine();
            IExecutionEnvironment env = ExecutionEnvironmentContext.getExecutionEnvironment();
            XDataContext dc = env.getDataContext();
            if (dc == null) {
                dc = env.pushDataContext();
            }
            this.ourContext.setXDataContext(dc);
            dc.setInterpreterContext(this.ourContext);
            try {
                ourEngine.execute(this.getPipelineRS(), this.selectQuery);
                Void void_ = null;
                return void_;
            }
            finally {
                env.popDataContext(dc);
            }
        }
    }
}

