/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NamedSet;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.SequencedHashMap;

public class Session {
    private static final String OPEN_BRACKET_STR = "[";
    private static final String CLOSE_BRACKET_DOT_STR = "].";
    private String sessionId;
    private SequencedHashMap sessionObjects;
    private long lastAccessTime;

    public Session(String theSessionId) {
        this.sessionId = theSessionId;
        this.sessionObjects = new SequencedHashMap();
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void setLastAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void addSessionMember(CalculatedMember calc) {
        String id = OPEN_BRACKET_STR + calc.getDimension().getCube() + CLOSE_BRACKET_DOT_STR + calc.getUniqueName();
        this.sessionObjects.put((Object)id, (Object)calc);
    }

    public Map<String, CalculatedMember> getSessionObjects() {
        return this.sessionObjects;
    }

    public void addSessionSet(NamedSet set) {
        String id = set.getUniqueName();
        if (set.getCubeName() != null) {
            id = OPEN_BRACKET_STR + set.getCubeName() + CLOSE_BRACKET_DOT_STR + id;
        }
        this.sessionObjects.put((Object)id, (Object)set);
    }

    public void dropSessionMember(String name) {
        this.sessionObjects.remove((Object)name);
    }

    public void dropSessionSet(String name) {
        this.sessionObjects.remove((Object)name);
    }

    public CalculatedMember getCalculation(String memberUniqueName, Cube cube) {
        Object sessionObject;
        String uniqueSessionId;
        CalculatedMember result = null;
        if (this.sessionObjects != null && this.sessionObjects.containsKey((Object)(uniqueSessionId = OPEN_BRACKET_STR + cube.getName() + CLOSE_BRACKET_DOT_STR + memberUniqueName)) && (sessionObject = this.sessionObjects.get((Object)uniqueSessionId)) instanceof CalculatedMember) {
            result = (CalculatedMember)sessionObject;
        }
        return result;
    }

    public boolean isNamedSetSessionObject(String memberUniqueName, Cube cube) {
        String uniqueSessionId;
        boolean result = false;
        if (this.sessionObjects != null && this.sessionObjects.containsKey((Object)(uniqueSessionId = OPEN_BRACKET_STR + cube.getName() + CLOSE_BRACKET_DOT_STR + memberUniqueName))) {
            return true;
        }
        return result;
    }

    public ArrayList<CalculatedMember> getCalculatedMembers(IMetadata parentObj) {
        ArrayList<CalculatedMember> result = new ArrayList<CalculatedMember>();
        if (this.sessionObjects == null) {
            return result;
        }
        Set objs = this.sessionObjects.entrySet();
        for (Map.Entry mapEntry : objs) {
            Object obj = mapEntry.getValue();
            if (!(obj instanceof CalculatedMember)) continue;
            CalculatedMember calcMember = (CalculatedMember)obj;
            if (parentObj == null) {
                result.add(calcMember);
                continue;
            }
            IMetadata calcMemberParentObj = null;
            switch (parentObj.getObjectType()) {
                case DIMENSION: {
                    calcMemberParentObj = calcMember.getDimension();
                    break;
                }
                case HIERARCHY: {
                    calcMemberParentObj = calcMember.getHierarchy();
                    break;
                }
                case LEVEL: {
                    calcMemberParentObj = calcMember.getLevel();
                    break;
                }
                case MEMBER: {
                    calcMemberParentObj = calcMember.getParent();
                    break;
                }
            }
            if (calcMemberParentObj != parentObj) continue;
            result.add(calcMember);
        }
        return result;
    }
}

