/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.RequestMetrics;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.resultset.interfaces.IDataItemInfo;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ILevelInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.data.IXmlSerializable;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterRuntimeException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.CrossJoinTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ExtractTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.FilteredTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleListFilter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SortedTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SubsetTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleIndex;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleListFilter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleListQSort;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleListSparseFilter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.UnionTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.IROLAPSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.runtree.olap.mdx.util.NumberOp;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import com.cognos.xqe.util.xml.XMLWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Set
implements ISet,
IXmlSerializable {
    private static final int NUM_PTRS_IN_SET = 10;
    private static final String DRILLDOWNMEMBER_STR = "DRILLDOWNMEMBER";
    private static final String DEBUG_HIER_FAILED_PREFIX_STR = "Hierarchize failed ";
    private static final String LA4018_STR = "la4018";
    private static final long serialVersionUID = 1L;
    private static final int MAX_TUPLES_TO_DISPLAY = 100;
    protected ITupleList tupleList;
    protected ITupleIterator tupleListIterator;
    protected int[] dimensionCardinality;
    protected boolean[] singleMemberHierarchyFlags;
    private HashSet<IDimension> currentMemberDimensions;
    private HashSet<IHierarchy> currentMemberHierarchies;
    private IDimension[] currentDimensions;
    private IHierarchy[] currentHierarchies;
    private Boolean multHierSupport = null;
    private IMember ptdLastChild;
    private IMember mEmptyChildrenSetParentMember;
    private IMetadata mRelativeTimeAncestorObject;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    protected final CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
    boolean isMultiLevel = false;

    public Set() throws InterpreterRuntimeException {
    }

    public Set(ITuple t) throws InterpreterRuntimeException {
        this(new ITuple[]{t});
    }

    public Set(ITuple t, boolean check) throws InterpreterRuntimeException {
        this(new ITuple[]{t}, check);
    }

    public Set(ITuple[] tups) throws InterpreterRuntimeException {
        this(tups, false);
    }

    @Deprecated
    public Set(ITuple[] tups, boolean check) throws InterpreterRuntimeException {
        if (tups.length > 0) {
            this.addCurrentMemberDimensions(((Tuple)tups[0]).getCurrentMemberDimensions());
        }
        if (check && tups.length > 0) {
            int[] tupleDimensionality = ((Tuple)tups[0]).getDimensionality();
            for (int i = 1; i < tups.length; ++i) {
                if (Arrays.equals(((Tuple)tups[i]).getDimensionality(), tupleDimensionality)) continue;
                throw new InterpreterRuntimeException(LA4018_STR);
            }
        }
        this.initializeTupleList(SimpleTupleList.construct(tups));
        this.recordSetSizeRequestMetric();
    }

    protected void initializeTupleList(ITupleList tupList) {
        this.tupleListIterator = null;
        this.tupleList = tupList;
        if (this.tupleList != null) {
            this.tupleListIterator = this.tupleList.iterator();
        }
    }

    public Set(ITupleList tl) throws InterpreterRuntimeException {
        this(tl, false);
    }

    public Set(ITupleList tl, boolean check) throws InterpreterRuntimeException {
        if (check && tl != null && tl.size() > 0L) {
            ITupleIterator iter = tl.iterator();
            int[] tupleDimensionality = ((Tuple)iter.next()).getDimensionality();
            while (iter.hasNext()) {
                if (Arrays.equals(((Tuple)iter.next()).getDimensionality(), tupleDimensionality)) continue;
                throw new InterpreterRuntimeException(LA4018_STR);
            }
        }
        this.initializeTupleList(tl);
        if (this.tupleList != null && this.tupleList.size() != 0L) {
            ITupleIterator iter = this.tupleList.iterator();
            Tuple tuple = (Tuple)iter.next();
            this.addCurrentMemberDimensions(tuple.getCurrentMemberDimensions());
        }
        this.recordSetSizeRequestMetric();
    }

    public Set(Set srcSet) throws InterpreterRuntimeException {
        this.initializeTupleList(srcSet.getTupleList());
        this.addCurrentMemberDimensions(srcSet.getCurrentMemberDimensions());
        this.addCurrentMemberHierarchies(srcSet.getCurrentMemberHierarchies());
        this.recordSetSizeRequestMetric();
    }

    public ITupleList getTupleList() {
        return this.tupleList;
    }

    @Override
    public ILevelInfo[] getLevelInfo(int index) {
        return null;
    }

    @Override
    public IDataItemInfo[] getDataItemInfo(IDimension d) {
        return null;
    }

    public void setIsMultiLevel(boolean value) {
        this.isMultiLevel = value;
    }

    public boolean getIsMultiLevel() {
        return this.isMultiLevel;
    }

    @Override
    public void resetDimensionCardinality() {
        this.dimensionCardinality = null;
        this.singleMemberHierarchyFlags = null;
        this.currentDimensions = null;
        this.currentHierarchies = null;
    }

    @Override
    public Object copy() {
        Set clone = null;
        if (this.getTupleList() == null) {
            return new Set(new Tuple[0]);
        }
        clone = new Set(this.getTupleList().copy());
        clone.addCurrentMemberDimensions(this.getCurrentMemberDimensions());
        clone.addCurrentMemberHierarchies(this.getCurrentMemberHierarchies());
        if (this.dimensionCardinality != null) {
            clone.dimensionCardinality = (int[])this.dimensionCardinality.clone();
        }
        return clone;
    }

    public Set removeInvalidTuples(ICube cube, ITuple contextTuple) {
        HashMap<ILevel, Map<IMember, int[]>> memToConvLevelMap = new HashMap<ILevel, Map<IMember, int[]>>();
        ITupleList filteredTupleList = this.removeInvalidTuples(cube, this.tupleList, memToConvLevelMap, null);
        if (filteredTupleList == null || filteredTupleList != this.getTupleList()) {
            return new Set(filteredTupleList);
        }
        return this;
    }

    public Set removeInvalidTuples(ICube cube, Map<ILevel, Map<IMember, int[]>> convLevelMap, ITuple contextTuple) {
        ITupleList filteredTupleList = this.removeInvalidTuples(cube, this.tupleList, convLevelMap, contextTuple);
        if (filteredTupleList == null || filteredTupleList != this.getTupleList()) {
            return new Set(filteredTupleList);
        }
        return this;
    }

    private ITupleList removeInvalidTuples(ICube cube, ITupleList tl, Map<ILevel, Map<IMember, int[]>> convLevelMap, ITuple contextTuple) {
        if (tl == null || tl.size() == 0L) {
            return tl;
        }
        ITuple sampleTuple = tl.iterator().getTuple(0L);
        if (sampleTuple == null || sampleTuple.size() == 0) {
            return tl;
        }
        if (cube != null) {
            sampleTuple.setCube(cube);
        } else {
            cube = sampleTuple.getMember(0).getDimension().getCube();
        }
        if (cube == null || !((Cube)cube).isRemoveNonExistentTuplesEnabled()) {
            return tl;
        }
        if (tl.getInvalidTuplesRemoved()) {
            return tl;
        }
        if (tl instanceof CrossJoinTupleList) {
            ArrayList<Map<IHierarchy, ILevel>> hierToConvLevelMaps = new ArrayList<Map<IHierarchy, ILevel>>();
            this.buildHierarchyGroups(sampleTuple, hierToConvLevelMaps);
            if (hierToConvLevelMaps.size() == 0) {
                tl.setInvalidTuplesRemoved(true);
                return tl;
            }
            HashMap<ITupleList, List<IDimension>> tlDims = new HashMap<ITupleList, List<IDimension>>();
            HashMap<ITupleList, Integer> tlToChildTLPos = new HashMap<ITupleList, Integer>();
            ArrayList<ITupleList> tlList = new ArrayList<ITupleList>();
            ArrayList<ITupleList> tlWithNoConvLevel = new ArrayList<ITupleList>();
            ITupleList[] childTupleLists = ((CrossJoinTupleList)tl).getChildTupleLists();
            for (int tlIdx = 0; tlIdx < childTupleLists.length; ++tlIdx) {
                boolean tlHasConvLevel = false;
                IMember[] tlFirstMems = childTupleLists[tlIdx].iterator().getTuple(0L).getMembers();
                for (int membIdx = 0; membIdx < tlFirstMems.length; ++membIdx) {
                    IHierarchy tlHierarchy = tlFirstMems[membIdx].getHierarchy();
                    for (int convLevelIdx = 0; convLevelIdx < hierToConvLevelMaps.size(); ++convLevelIdx) {
                        if (!hierToConvLevelMaps.get(convLevelIdx).containsKey(tlHierarchy)) continue;
                        tlHasConvLevel = true;
                        break;
                    }
                    if (tlHasConvLevel) break;
                }
                if (tlHasConvLevel) {
                    ArrayList<IDimension> dimList = new ArrayList<IDimension>();
                    dimList.addAll(Arrays.asList(childTupleLists[tlIdx].iterator().getTuple(0L).getDimensions()));
                    tlDims.put(childTupleLists[tlIdx], dimList);
                    tlList.add(childTupleLists[tlIdx]);
                } else {
                    tlWithNoConvLevel.add(childTupleLists[tlIdx]);
                }
                tlToChildTLPos.put(childTupleLists[tlIdx], tlIdx);
            }
            ArrayList tlGroups = new ArrayList();
            while (!tlList.isEmpty()) {
                ArrayList tlGroup = new ArrayList();
                tlGroup.add(tlList.remove(0));
                for (int tlGroupIdx = 0; tlGroupIdx < tlGroup.size(); ++tlGroupIdx) {
                    ITupleList groupCurrentTL = (ITupleList)tlGroup.get(tlGroupIdx);
                    int tlListIdx = 0;
                    while (tlListIdx < tlList.size()) {
                        ITupleList tlCurrentTL = (ITupleList)tlList.get(tlListIdx);
                        boolean tlMoved = false;
                        if (this.haveCommonDimensions(groupCurrentTL, tlCurrentTL, tlDims)) {
                            tlGroup.add(tlCurrentTL);
                            tlList.remove(tlListIdx);
                            tlMoved = true;
                        }
                        if (tlMoved) continue;
                        ++tlListIdx;
                    }
                }
                tlGroups.add(tlGroup);
            }
            for (int tlIdx = 0; tlIdx < tlWithNoConvLevel.size(); ++tlIdx) {
                ArrayList tlGroup = new ArrayList();
                tlGroup.add(tlWithNoConvLevel.get(tlIdx));
                tlGroups.add(tlGroup);
            }
            boolean filterApplied = false;
            TupleListFilter[] tlFilter = new TupleListFilter[tlGroups.size()];
            for (int tlGroupIdx = 0; tlGroupIdx < tlGroups.size(); ++tlGroupIdx) {
                List tlGroup = (List)tlGroups.get(tlGroupIdx);
                TupleListFilter filter = this.removeInvalidTuples(cube, tlGroup, convLevelMap, contextTuple);
                if (filter == null) continue;
                tlFilter[tlGroupIdx] = filter;
                if (filterApplied) continue;
                filterApplied = true;
            }
            if (!filterApplied) {
                tl.setInvalidTuplesRemoved(true);
                return tl;
            }
            TupleListFilter filter = new TupleListFilter(tl.size());
            long[] nextOrds = new long[childTupleLists.length];
            Arrays.fill(nextOrds, -1L);
            long[] groupOrds = new long[tlGroups.size()];
            Arrays.fill(groupOrds, -1L);
            int groupIdx = 0;
            while (true) {
                if (groupIdx < tlGroups.size()) {
                    if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                        throw new OperationCanceledException();
                    }
                    List tlGroup = (List)tlGroups.get(groupIdx);
                    groupOrds[groupIdx] = this.calcNextOrds(tlGroup, tlFilter[groupIdx], tlToChildTLPos, groupOrds[groupIdx] + 1L, nextOrds);
                    if (groupOrds[groupIdx] != -1L) {
                        ++groupIdx;
                        continue;
                    }
                    if (groupIdx == 0) {
                        ITupleList filteredTupleList = FilteredTupleList.construct(tl, filter);
                        if (filteredTupleList != null) {
                            filteredTupleList.setInvalidTuplesRemoved(true);
                        }
                        return filteredTupleList;
                    }
                    --groupIdx;
                    continue;
                }
                long nextOrd = 0L;
                int weight = 1;
                for (int i = childTupleLists.length - 1; i >= 0; --i) {
                    nextOrd += nextOrds[i] * (long)weight;
                    weight = (int)((long)weight * childTupleLists[i].size());
                }
                filter.set(nextOrd, true);
                --groupIdx;
            }
        }
        ArrayList<ITupleList> tlGroup = new ArrayList<ITupleList>();
        tlGroup.add(tl);
        TupleListFilter filter = this.removeInvalidTuples(cube, tlGroup, convLevelMap, contextTuple);
        if (filter == null) {
            tl.setInvalidTuplesRemoved(true);
            return tl;
        }
        ITupleList filteredTupleList = FilteredTupleList.construct(tl, filter);
        if (filteredTupleList != null) {
            filteredTupleList.setInvalidTuplesRemoved(true);
        }
        return filteredTupleList;
    }

    private List<IDimension> getTupleListDims(ITupleList tl, Map<ITupleList, List<IDimension>> tlDimMap) {
        ArrayList<IDimension> tlDims = new ArrayList<IDimension>();
        if (tl.size() == 1L) {
            ArrayList<IMember> membersToCheck = new ArrayList<IMember>();
            IMember[] members = tl.iterator().getTuple(0L).getMembers();
            for (int memIdx = 0; memIdx < members.length; ++memIdx) {
                if (((Level)members[memIdx].getLevel()).isAllLevel() || members[memIdx].isCalculatedMember()) continue;
                membersToCheck.add(members[memIdx]);
            }
            if (!membersToCheck.isEmpty()) {
                for (IMember mem : membersToCheck) {
                    tlDims.add(mem.getDimension());
                }
            }
            return tlDims;
        }
        return tlDimMap.get(tl);
    }

    private boolean haveCommonDimensions(ITupleList tl1, ITupleList tl2, Map<ITupleList, List<IDimension>> tlDimMap) {
        List<IDimension> tl1Dims = this.getTupleListDims(tl1, tlDimMap);
        List<IDimension> tl2Dims = this.getTupleListDims(tl2, tlDimMap);
        for (IDimension tl1Dim : tl1Dims) {
            for (IDimension tl2Dim : tl2Dims) {
                if (tl1Dim != tl2Dim) continue;
                return true;
            }
        }
        return false;
    }

    private TupleListFilter removeInvalidTuples(ICube cube, List<ITupleList> tlGroup, Map<ILevel, Map<IMember, int[]>> convLevelMap, ITuple contextTuple) {
        ITupleList tl = null;
        if (tlGroup.size() > 1) {
            tl = CrossJoinTupleList.construct(tlGroup);
        } else {
            tl = tlGroup.get(0);
            if (tl.getInvalidTuplesRemoved()) {
                return null;
            }
        }
        if (tl == null || tl.size() == 0L) {
            return null;
        }
        ITuple sampleTuple = tl.iterator().getTuple(0L);
        if (sampleTuple == null || sampleTuple.size() == 0) {
            return null;
        }
        sampleTuple.setCube(cube);
        if (contextTuple != null && contextTuple.size() > 0) {
            IHierarchy[] tlHierarchies;
            IDimension[] tlDimensions = sampleTuple.getDimensions();
            contextTuple = ((Tuple)contextTuple).retain((Dimension[])tlDimensions);
            for (IHierarchy tlHier : tlHierarchies = sampleTuple.getHierarchies()) {
                contextTuple = contextTuple.remove(tlHier);
            }
            ArrayList<IMember> fullSampleTuple = new ArrayList<IMember>();
            fullSampleTuple.addAll(Arrays.asList(sampleTuple.getMembers()));
            fullSampleTuple.addAll(Arrays.asList(contextTuple.getMembers()));
            sampleTuple = new Tuple(fullSampleTuple.toArray(new IMember[fullSampleTuple.size()]), contextTuple.getCube());
        }
        if (sampleTuple.size() <= 1) {
            return null;
        }
        ArrayList<Map<IHierarchy, ILevel>> hierToConvLevelMaps = new ArrayList<Map<IHierarchy, ILevel>>();
        ArrayList<Integer[]> hierarchyGroups = this.buildHierarchyGroups(sampleTuple, hierToConvLevelMaps);
        if (hierarchyGroups == null || hierarchyGroups.size() == 0 || hierToConvLevelMaps.size() == 0) {
            return null;
        }
        TupleListFilter filter = new TupleListFilter(tl.size());
        boolean someTuplesFiltered = false;
        long tupleOrd = 0L;
        IMember[][] mhSubTuples = new IMember[hierarchyGroups.size()][];
        for (int i = 0; i < mhSubTuples.length; ++i) {
            mhSubTuples[i] = new IMember[hierarchyGroups.get(i).length];
        }
        IMember[] fullTuple = new IMember[sampleTuple.size()];
        if (contextTuple != null) {
            IMember[] contextMembers = contextTuple.getMembers();
            for (int memIdx = 0; memIdx < contextMembers.length; ++memIdx) {
                int ctxtMemIdx = fullTuple.length - contextMembers.length + memIdx;
                fullTuple[ctxtMemIdx] = contextMembers[memIdx];
            }
        }
        for (ITuple tuple : tl) {
            for (int memIdx = 0; memIdx < tuple.size(); ++memIdx) {
                fullTuple[memIdx] = tuple.getMember(memIdx);
            }
            this.getMultipleHierarchiesSubTuples(fullTuple, hierarchyGroups, mhSubTuples);
            if (mhSubTuples.length == 0) {
                return null;
            }
            boolean validTuple = true;
            for (int i = 0; i < mhSubTuples.length; ++i) {
                if (this.isValidTuple(mhSubTuples[i], convLevelMap, hierToConvLevelMaps.get(i))) continue;
                validTuple = false;
                break;
            }
            filter.set(tupleOrd, validTuple);
            ++tupleOrd;
            if (someTuplesFiltered || validTuple) continue;
            someTuplesFiltered = true;
        }
        TupleListFilter retFilter = null;
        if (someTuplesFiltered) {
            retFilter = filter;
        }
        return retFilter;
    }

    private ArrayList<Integer[]> buildHierarchyGroups(ITuple sampleTuple, ArrayList<Map<IHierarchy, ILevel>> hierToConvLevelMaps) {
        Cube cube = (Cube)sampleTuple.getCube();
        SecurityManagerInterface secManager = cube.getSecurityManager();
        if (secManager != null && !(secManager instanceof IROLAPSecurityManager)) {
            secManager = null;
        }
        HashMap<IHierarchy, Integer> hierToTuplePos = new HashMap<IHierarchy, Integer>();
        HashMap<IDimension, ArrayList<IHierarchy>> dimHierInTuple = new HashMap<IDimension, ArrayList<IHierarchy>>();
        for (int memIdx = 0; memIdx < sampleTuple.size(); ++memIdx) {
            IMember member = sampleTuple.getMember(memIdx);
            IDimension memDim = member.getDimension();
            IHierarchy memHier = member.getHierarchy();
            if (secManager != null && ((IROLAPSecurityManager)secManager).hasRestrictions(memHier)) continue;
            hierToTuplePos.put(memHier, memIdx);
            ArrayList<IHierarchy> hierList = (ArrayList<IHierarchy>)dimHierInTuple.get(memDim);
            if (hierList == null) {
                hierList = new ArrayList<IHierarchy>();
            }
            hierList.add(memHier);
            dimHierInTuple.put(memDim, hierList);
        }
        ArrayList<Integer[]> hierarchyMap = new ArrayList<Integer[]>();
        for (IDimension dim : dimHierInTuple.keySet()) {
            ArrayList dimHiers = (ArrayList)dimHierInTuple.get(dim);
            int hierCount = dimHiers.size();
            if (hierCount <= 1) continue;
            if (!(dim instanceof ROLAPDimension)) {
                return null;
            }
            ArrayList<Map<IHierarchy, ILevel>> hierConvLevels = ((ROLAPDimension)dim).findConvergenceHierarchyGroups(dimHiers.toArray(new IHierarchy[hierCount]));
            if (hierConvLevels == null || hierConvLevels.size() == 0) continue;
            for (int hierGroupIdx = 0; hierGroupIdx < hierConvLevels.size(); ++hierGroupIdx) {
                Map<IHierarchy, ILevel> convLevels = hierConvLevels.get(hierGroupIdx);
                hierToConvLevelMaps.add(convLevels);
                int[] hierMap = new int[dim.getHierarchyCount()];
                for (int i = 0; i < hierMap.length; ++i) {
                    hierMap[i] = -1;
                }
                for (int memIdx = 0; memIdx < sampleTuple.size(); ++memIdx) {
                    IMember member = sampleTuple.getMember(memIdx);
                    IHierarchy memHier = member.getHierarchy();
                    if (!convLevels.containsKey(memHier)) continue;
                    hierMap[((Hierarchy)memHier).getIndex()] = (Integer)hierToTuplePos.get(memHier);
                }
                ArrayList<Integer> compactHierMap = new ArrayList<Integer>();
                for (int i = 0; i < hierMap.length; ++i) {
                    if (hierMap[i] == -1) continue;
                    compactHierMap.add(hierMap[i]);
                }
                hierarchyMap.add(compactHierMap.toArray(new Integer[compactHierMap.size()]));
            }
        }
        return hierarchyMap;
    }

    private void getMultipleHierarchiesSubTuples(IMember[] tuple, ArrayList<Integer[]> hierarchyMGroups, IMember[][] subTuples) {
        for (int i = 0; i < hierarchyMGroups.size(); ++i) {
            Integer[] memPosInTuple = hierarchyMGroups.get(i);
            for (int j = 0; j < memPosInTuple.length; ++j) {
                subTuples[i][j] = tuple[memPosInTuple[j]];
            }
        }
    }

    private boolean isValidTuple(IMember[] tuple, Map<ILevel, Map<IMember, int[]>> convLevelMap, Map<IHierarchy, ILevel> hierToConvLevelMap) {
        int hierCount = 0;
        ArrayList<IMember> tupMembers = new ArrayList<IMember>();
        for (int memIdx = 0; memIdx < tuple.length; ++memIdx) {
            IHierarchy memHier;
            ILevel convergenceLevel;
            Level memLevel;
            IMember member = tuple[memIdx];
            if (member.isCalculatedMember() || member instanceof NullMember || (memLevel = (Level)member.getLevel()).isAllLevel() || (convergenceLevel = hierToConvLevelMap.get(memHier = member.getHierarchy())) == null) continue;
            ++hierCount;
            tupMembers.add(member);
        }
        if (hierCount < 2) {
            return true;
        }
        int[][] convergenceMemIdx = new int[hierCount][];
        for (int memIdx = 0; memIdx < tupMembers.size(); ++memIdx) {
            IMember member = (IMember)tupMembers.get(memIdx);
            ILevel memLevel = member.getLevel();
            IHierarchy memHier = member.getHierarchy();
            ILevel convergenceLevel = hierToConvLevelMap.get(memHier);
            if (convergenceLevel == null) continue;
            Map<IMember, int[]> memConvLevelMap = convLevelMap.get(convergenceLevel);
            if (memConvLevelMap == null) {
                memConvLevelMap = new HashMap<IMember, int[]>();
                convLevelMap.put(convergenceLevel, memConvLevelMap);
            } else {
                convergenceMemIdx[memIdx] = memConvLevelMap.get(member);
                if (convergenceMemIdx[memIdx] != null) continue;
            }
            if (memLevel.getIndex() == convergenceLevel.getIndex()) {
                convergenceMemIdx[memIdx] = new int[]{((ROLAPMemberProxy)member).getLevelKeys().hashCode()};
                continue;
            }
            if (memLevel.getIndex() < convergenceLevel.getIndex()) {
                ArrayList<IMember> descList = MemberOperations.getDescendantsOp((IMemberCubics)member, convergenceLevel, 0, true, null);
                convergenceMemIdx[memIdx] = new int[descList.size()];
                for (int descIdx = 0; descIdx < descList.size(); ++descIdx) {
                    convergenceMemIdx[memIdx][descIdx] = ((ROLAPMemberProxy)descList.get(descIdx)).getLevelKeys().hashCode();
                }
                Arrays.sort(convergenceMemIdx[memIdx]);
                memConvLevelMap.put(member, convergenceMemIdx[memIdx]);
                continue;
            }
            IMember ancestor = member;
            int convLevelIndex = convergenceLevel.getIndex();
            while (ancestor != null && !(ancestor instanceof NullMember) && ancestor.getLevel().getIndex() > convLevelIndex) {
                if ((ancestor = MemberOperations.getParentOp(ancestor.getParent(), false, null)).getLevel().getIndex() >= convLevelIndex) continue;
                ancestor = null;
            }
            if (ancestor == null || ((ROLAPMemberProxy)ancestor).getLevelKeys() == null) {
                return false;
            }
            convergenceMemIdx[memIdx] = new int[]{((ROLAPMemberProxy)ancestor).getLevelKeys().hashCode()};
            memConvLevelMap.put(member, convergenceMemIdx[memIdx]);
        }
        int[] convMemberPos = new int[hierCount];
        block4: while (true) {
            int i;
            boolean match = true;
            int max = Integer.MIN_VALUE;
            for (i = 0; i < convMemberPos.length - 1; ++i) {
                if (match && convergenceMemIdx[i][convMemberPos[i]] != convergenceMemIdx[i + 1][convMemberPos[i + 1]]) {
                    match = false;
                }
                max = Math.max(max, convergenceMemIdx[i][convMemberPos[i]]);
            }
            max = Math.max(max, convergenceMemIdx[convMemberPos.length - 1][convMemberPos[convMemberPos.length - 1]]);
            if (match) {
                return true;
            }
            i = 0;
            while (true) {
                if (i >= convMemberPos.length) continue block4;
                while (convergenceMemIdx[i][convMemberPos[i]] < max) {
                    int n = i;
                    convMemberPos[n] = convMemberPos[n] + 1;
                    if (convMemberPos[i] < convergenceMemIdx[i].length) continue;
                    return false;
                }
                ++i;
            }
            break;
        }
    }

    private long calcNextOrds(List<ITupleList> tlGroup, TupleListFilter tlFilter, Map<ITupleList, Integer> tlToChildTLPos, long groupOrd, long[] nextOrds) {
        int i;
        long nextGroupOrd = 0L;
        if (tlFilter != null) {
            nextGroupOrd = tlFilter.nextEnabledTuple(groupOrd);
            if (nextGroupOrd == -1L) {
                return -1L;
            }
        } else {
            nextGroupOrd = groupOrd;
            long groupSize = 1L;
            for (i = 0; i < tlGroup.size(); ++i) {
                groupSize *= tlGroup.get(i).size();
            }
            if (nextGroupOrd >= groupSize) {
                return -1L;
            }
        }
        long weight = 1L;
        for (i = tlGroup.size() - 1; i >= 0; --i) {
            nextOrds[tlToChildTLPos.get((Object)tlGroup.get((int)i)).intValue()] = nextGroupOrd / weight % tlGroup.get(i).size();
            weight *= tlGroup.get(i).size();
        }
        return nextGroupOrd;
    }

    public void addCurrentMemberDimension(IDimension d) {
        if (this.currentMemberDimensions == null) {
            this.currentMemberDimensions = new HashSet();
        }
        this.currentMemberDimensions.add(d);
    }

    public void addCurrentMemberHierarchy(IHierarchy h) {
        if (this.currentMemberHierarchies == null) {
            this.currentMemberHierarchies = new HashSet();
        }
        this.currentMemberHierarchies.add(h);
    }

    public void addCurrentMemberDimensions(IDimension[] ds) {
        if (ds.length > 0) {
            if (this.currentMemberDimensions == null) {
                this.currentMemberDimensions = new HashSet();
            }
            this.currentMemberDimensions.addAll(Arrays.asList(ds));
        }
    }

    public void addCurrentMemberHierarchies(IHierarchy[] hs) {
        if (hs.length > 0) {
            if (this.currentMemberHierarchies == null) {
                this.currentMemberHierarchies = new HashSet();
            }
            this.currentMemberHierarchies.addAll(Arrays.asList(hs));
        }
    }

    public Dimension[] getCurrentMemberDimensions() {
        if (this.currentMemberDimensions == null) {
            return new Dimension[0];
        }
        return this.currentMemberDimensions.toArray(new Dimension[0]);
    }

    public Hierarchy[] getCurrentMemberHierarchies() {
        if (this.currentMemberHierarchies == null) {
            return new Hierarchy[0];
        }
        return this.currentMemberHierarchies.toArray(new Hierarchy[0]);
    }

    public Dimension[] getCurrentMemberDimensions(ISet contextSet) {
        if (this.currentMemberDimensions == null) {
            return new Dimension[0];
        }
        ArrayList<IDimension> currMemberDims = new ArrayList<IDimension>();
        IDimension[] contextDims = contextSet.getDimensions();
        for (int i = 0; i < contextDims.length; ++i) {
            if (!this.currentMemberDimensions.contains(contextDims[i])) continue;
            currMemberDims.add(contextDims[i]);
        }
        return currMemberDims.toArray(new Dimension[0]);
    }

    public Hierarchy[] getCurrentMemberHierarchies(ISet contextSet) {
        if (this.currentMemberHierarchies == null) {
            return new Hierarchy[0];
        }
        ArrayList<IHierarchy> currMemberHiers = new ArrayList<IHierarchy>();
        IHierarchy[] contextHiers = contextSet.getHierarchies();
        for (int i = 0; i < contextHiers.length; ++i) {
            if (!this.currentMemberHierarchies.contains(contextHiers[i])) continue;
            currMemberHiers.add(contextHiers[i]);
        }
        return currMemberHiers.toArray(new Hierarchy[0]);
    }

    public boolean isCurrentMemberSet() {
        int setTupleSize = this.getHierarchyCount();
        Dimension[] currMemberDims = this.getCurrentMemberDimensions();
        return setTupleSize == 1 && currMemberDims.length > 0;
    }

    public void replaceMember(IMember m) throws InterpreterException {
        int index = this.multipleHierarchySupport() ? this.getHierarchyIndex(m.getHierarchy()) : this.getDimensionIndex(m.getDimension());
        if (this.getTupleList() != null) {
            this.getTupleList().replaceMember(index, m);
        }
        this.resetDimensionCardinality();
    }

    @Override
    public ISet getSingleTupleSet() {
        if (this.size() == 1L) {
            return this;
        }
        this.getSingleMemberHierarchyFlags();
        ArrayList<IMember> al = new ArrayList<IMember>();
        if (this.size() > 0L) {
            ITuple t = this.getTuple(0L);
            for (int i = 0; i < this.singleMemberHierarchyFlags.length; ++i) {
                if (!this.singleMemberHierarchyFlags[i]) continue;
                al.add(t.getMember(i));
            }
        }
        return new Set(new Tuple(al.toArray(new IMember[al.size()])));
    }

    @Override
    public ISet getMultipleTupleSets() {
        ISet singleTupleSet = this.getSingleTupleSet();
        return this.removeHierarchies(singleTupleSet.getHierarchies(), false);
    }

    public CrossJoinedSet mergeSet(ISet s) throws InterpreterException {
        if (this.multipleHierarchySupport()) {
            IHierarchy[] hiers = s.getHierarchies();
            ISet cjs = this;
            cjs = cjs.removeHierarchies(hiers, true);
            cjs = ((Set)cjs).crossjoin(s);
            return (CrossJoinedSet)cjs;
        }
        IDimension[] dims = s.getDimensions();
        ISet cjs = this;
        cjs = cjs.removeDimensions(dims, true);
        cjs = ((Set)cjs).crossjoin(s);
        return (CrossJoinedSet)cjs;
    }

    public boolean multipleHierarchySupport() {
        return this.multipleHierarchySupport(null);
    }

    public boolean multipleHierarchySupport(ICube cube) {
        if (this.multHierSupport != null) {
            return this.multHierSupport;
        }
        IDimension[] dims = this.getDimensions();
        if (dims.length == 0) {
            this.multHierSupport = new Boolean(false);
            return this.multHierSupport;
        }
        if (cube == null) {
            cube = dims[0].getCube();
        }
        this.multHierSupport = new Boolean(((Cube)cube).multipleHierarchySupport());
        return this.multHierSupport;
    }

    @Deprecated
    public HashSet<IMember>[] selectionsInDimensions(IDimension[] dims) {
        HashSet[] result = new HashSet[dims.length];
        IMember[][] mems = this.getMembers(dims);
        for (int i = 0; i < dims.length; ++i) {
            result[i] = new HashSet();
            result[i].addAll(Arrays.asList(mems[i]));
        }
        return result;
    }

    public HashSet<IMember>[] selectionsInHierarchies(IHierarchy[] hiers) {
        HashSet[] result = new HashSet[hiers.length];
        IMember[][] mems = this.getMembers(hiers);
        for (int i = 0; i < hiers.length; ++i) {
            result[i] = new HashSet();
            result[i].addAll(Arrays.asList(mems[i]));
        }
        return result;
    }

    public boolean[] getSingleMemberHierarchyFlags() {
        block7: {
            if (this.singleMemberHierarchyFlags != null) break block7;
            IHierarchy[] hiers = this.getHierarchies();
            this.singleMemberHierarchyFlags = new boolean[hiers.length];
            if (this.dimensionCardinality == null) {
                ArrayList[] hierUniqueMems = new ArrayList[hiers.length];
                for (int i = 0; i < hiers.length; ++i) {
                    this.singleMemberHierarchyFlags[i] = true;
                    hierUniqueMems[i] = new ArrayList(2);
                }
                if (this.size() == 1L) {
                    return this.singleMemberHierarchyFlags;
                }
                int numSingleMemHiers = hiers.length;
                IIterator it = this.iterator();
                while (it.hasNext()) {
                    Tuple t = (Tuple)it.next();
                    for (int i = 0; i < t.size(); ++i) {
                        if (!this.singleMemberHierarchyFlags[i] || hierUniqueMems[i].contains(t.getMember(i))) continue;
                        hierUniqueMems[i].add(t.getMember(i));
                        if (hierUniqueMems[i].size() <= 1) continue;
                        this.singleMemberHierarchyFlags[i] = false;
                        --numSingleMemHiers;
                    }
                    if (numSingleMemHiers != 0) continue;
                    break;
                }
            } else {
                for (int i = 0; i < hiers.length; ++i) {
                    this.singleMemberHierarchyFlags[i] = this.dimensionCardinality[i] == 1;
                }
            }
        }
        return this.singleMemberHierarchyFlags;
    }

    @Override
    public int[] getDimensionCardinality() {
        if (this.dimensionCardinality == null) {
            int tupleSize = this.getHierarchyCount();
            HashSet[] hs = new HashSet[tupleSize];
            for (int i = 0; i < hs.length; ++i) {
                hs[i] = new HashSet();
            }
            IIterator it = this.iterator();
            while (it.hasNext()) {
                Tuple t = (Tuple)it.next();
                for (int i = 0; i < t.size(); ++i) {
                    hs[i].add(t.getMember(i));
                }
            }
            this.dimensionCardinality = new int[hs.length];
            for (int i = 0; i < hs.length; ++i) {
                this.dimensionCardinality[i] = hs[i].size();
            }
        }
        return this.dimensionCardinality;
    }

    @Override
    public IMember[] getMembers(IDimension d) {
        if (this.tupleList != null) {
            return this.tupleList.getMembers(d);
        }
        return new IMember[0];
    }

    @Override
    public IMember[][] getMembers(IDimension[] d) {
        if (this.tupleList != null) {
            return this.tupleList.getMembers(d);
        }
        return new IMember[0][0];
    }

    public IMember[] getMembersRetainDuplicates(IDimension d) {
        ArrayList<IMember> result = new ArrayList<IMember>();
        int dimIndex = this.getDimensionIndex(d);
        for (long i = 0L; i < this.size(); ++i) {
            ITuple tuple = this.getTuple(i);
            IMember m = tuple.getMember(dimIndex);
            if (m == null) continue;
            result.add(m);
        }
        return result.toArray(new IMember[0]);
    }

    public IMember[] getMembersRetainDuplicates(IHierarchy h) {
        ArrayList<IMember> result = new ArrayList<IMember>();
        int hierIndex = this.getHierarchyIndex(h);
        for (long i = 0L; i < this.size(); ++i) {
            ITuple tuple = this.getTuple(i);
            IMember m = tuple.getMember(hierIndex);
            if (m == null) continue;
            result.add(m);
        }
        return result.toArray(new IMember[0]);
    }

    @Override
    public IMember[] getMembers(IHierarchy h) {
        if (this.tupleList != null) {
            return this.tupleList.getMembers(h);
        }
        return new IMember[0];
    }

    @Override
    public IMember[][] getMembers(IHierarchy[] h) {
        if (this.tupleList != null) {
            return this.tupleList.getMembers(h);
        }
        return new IMember[0][0];
    }

    @Override
    public IDimension[] getDimensions() {
        if (this.currentDimensions == null) {
            this.currentDimensions = this.size() != 0L ? this.getTuple(0L).getDimensions() : new Dimension[0];
        }
        return this.currentDimensions;
    }

    @Override
    public IHierarchy[] getHierarchies() {
        if (this.currentHierarchies == null) {
            this.currentHierarchies = this.size() != 0L ? this.getTuple(0L).getHierarchies() : new Hierarchy[0];
        }
        return this.currentHierarchies;
    }

    public int getHierarchyCount() {
        if (this.currentHierarchies != null) {
            return this.currentHierarchies.length;
        }
        if (this.size() != 0L) {
            return this.getTuple(0L).size();
        }
        return 0;
    }

    @Override
    public boolean contains(IDimension dimension) {
        boolean result = false;
        if (this.currentDimensions != null) {
            for (IDimension dim : this.currentDimensions) {
                if (!dim.equals(dimension)) continue;
                result = true;
                break;
            }
        } else if (this.size() != 0L) {
            result = this.getTuple(0L).contains(dimension);
        }
        return result;
    }

    @Override
    public boolean contains(IHierarchy hierarchy) {
        boolean result = false;
        if (this.currentHierarchies != null) {
            for (IHierarchy hier : this.currentHierarchies) {
                if (!hier.equals(hierarchy)) continue;
                result = true;
                break;
            }
        } else if (this.size() != 0L) {
            result = this.getTuple(0L).contains(hierarchy);
        }
        return result;
    }

    public int getDimensionIndex(IDimension dimension) {
        int result = 0;
        boolean gotDimension = false;
        IDimension[] dims = this.getDimensions();
        while (result < dims.length && !gotDimension) {
            if (dims[result].equals(dimension)) {
                gotDimension = true;
                continue;
            }
            ++result;
        }
        if (!gotDimension) {
            return -1;
        }
        return result;
    }

    public int getHierarchyIndex(IHierarchy hierarchy) {
        int result = 0;
        boolean gotHierarchy = false;
        IHierarchy[] hiers = this.getHierarchies();
        while (result < hiers.length && !gotHierarchy) {
            if (hiers[result].equals(hierarchy)) {
                gotHierarchy = true;
                continue;
            }
            ++result;
        }
        if (!gotHierarchy) {
            return -1;
        }
        return result;
    }

    public ISet crossjoin(ISet s) throws InterpreterRuntimeException {
        return this.crossjoin(s, true);
    }

    public ISet crossjoin(ISet s, boolean check) throws InterpreterRuntimeException {
        return new CrossJoinedSet(new ISet[]{this, s});
    }

    @Override
    public ITuple getTuple(long index) {
        if (index >= this.size() && this.size() >= 0L) {
            throw new RuntimeException("Index out of range in tuple access. " + this + " index " + index);
        }
        return this.tupleListIterator.getTuple(index);
    }

    public ITuple getTuple(BigInteger index) {
        if (index.compareTo(this.noOverflowSize()) >= 0) {
            throw new RuntimeException("Index out of set range in tuple access. " + this + " index: " + index.toString());
        }
        return this.tupleListIterator.getTuple(index);
    }

    @Override
    public long[] getOrdinals(ITuple tuple) {
        return this.getOrdinals(tuple, true);
    }

    public long[] getOrdinals(ITuple tuple, boolean exactMatch) {
        IMember[] mems = tuple.getMembers();
        if (!exactMatch) {
            mems = new IMember[this.getTupleList().width()];
            IHierarchy[] hiers = this.getHierarchies();
            for (int inx = 0; inx < tuple.size(); ++inx) {
                int hierIndex;
                IMember mem = tuple.getMember(inx);
                for (hierIndex = 0; hierIndex < hiers.length && !hiers[hierIndex].equals(mem.getHierarchy()); ++hierIndex) {
                }
                if (hierIndex >= hiers.length) {
                    return new long[0];
                }
                mems[hierIndex] = mem;
            }
        }
        List<Number> indices = this.getTupleList().find(mems, false);
        long[] result = new long[indices.size()];
        Iterator<Number> it = indices.iterator();
        int inx = 0;
        while (it.hasNext()) {
            result[inx++] = (Long)it.next();
        }
        return result;
    }

    public HashMap<Tuple, long[]> getOrdinalsMap(IDimension[] mapDims) throws InterpreterException {
        HashMap<Tuple, long[]> tupleToIndexes = new HashMap<Tuple, long[]>();
        long tupleOrdinal = 0L;
        IIterator setIter = this.iterator();
        while (setIter.hasNext()) {
            Tuple tuple = null;
            tuple = (Tuple)((ITuple)setIter.next()).copy();
            long[] indexes = tupleToIndexes.get(tuple = tuple.retain((Dimension[])mapDims));
            if (indexes == null) {
                indexes = new long[]{tupleOrdinal++};
            } else {
                long[] newIndexes = new long[indexes.length + 1];
                System.arraycopy(indexes, 0, newIndexes, 0, indexes.length);
                newIndexes[indexes.length] = tupleOrdinal++;
                indexes = newIndexes;
            }
            tupleToIndexes.put(tuple, indexes);
        }
        return tupleToIndexes;
    }

    public HashMap<Tuple, long[]> getOrdinalsMap(IHierarchy[] mapHiers) throws InterpreterException {
        HashMap<Tuple, long[]> tupleToIndexes = new HashMap<Tuple, long[]>();
        long tupleOrdinal = 0L;
        IIterator setIter = this.iterator();
        while (setIter.hasNext()) {
            Tuple tuple = null;
            tuple = (Tuple)((ITuple)setIter.next()).copy();
            long[] indexes = tupleToIndexes.get(tuple = tuple.retain(mapHiers));
            if (indexes == null) {
                indexes = new long[]{tupleOrdinal++};
            } else {
                long[] newIndexes = new long[indexes.length + 1];
                System.arraycopy(indexes, 0, newIndexes, 0, indexes.length);
                newIndexes[indexes.length] = tupleOrdinal++;
                indexes = newIndexes;
            }
            tupleToIndexes.put(tuple, indexes);
        }
        return tupleToIndexes;
    }

    @Override
    public long size() {
        if (this.getTupleList() != null) {
            return this.getTupleList().size();
        }
        return 0L;
    }

    public boolean hasMultipleTuples() {
        return this.size() > 1L || this.size() < 0L;
    }

    public BigInteger noOverflowSize() {
        if (this.getTupleList() != null) {
            return this.getTupleList().noOverflowSize();
        }
        return BigInteger.ZERO;
    }

    public String toString() {
        long setSize = this.size();
        StringBuilder setStr = new StringBuilder();
        setStr = setStr.append("{");
        if (setSize < 0L) {
            ITuple tuple = this.getTuple(0L);
            setStr = setStr.append(" \r\n").append(tuple.toString());
            setStr = setStr.append("...Huge Set ( ").append(this.noOverflowSize()).append(" tuples )");
        } else {
            int tupleIdx = 0;
            while ((long)tupleIdx < setSize) {
                ITuple tuple = this.getTuple(tupleIdx);
                setStr = setStr.append("\r\n").append(tuple.toString());
                if ((long)tupleIdx < setSize - 1L) {
                    setStr = setStr.append(",");
                }
                if (tupleIdx > 100) {
                    setStr = setStr.append("...Large Set (").append(this.size()).append(" tuples)");
                    break;
                }
                ++tupleIdx;
            }
        }
        setStr = setStr.append("\r\n}");
        return setStr.toString();
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Set", -1);
        if (this.size() > 100L) {
            xmlWriter.attribute("largeSet", true);
        } else {
            IIterator it = this.iterator();
            while (it.hasNext()) {
                Tuple tuple = (Tuple)it.next();
                tuple.toXML(xmlWriter);
            }
        }
        xmlWriter.endElement();
    }

    public String toHTMLString() {
        String s;
        if (this.size() > 100L) {
            s = this.toString();
        } else if (this.size() > 0L) {
            s = "<ul>{ " + this.getTuple(0L).toString();
            int i = 1;
            while ((long)i < this.size()) {
                s = s + ",<li>" + this.getTuple(i).toString();
                ++i;
            }
            s = s + "}</ul>";
        } else {
            s = "{}";
        }
        return s;
    }

    public Set intersect(Set s, boolean allowDuplicates) throws InterpreterException {
        int largeSet;
        int smallSet;
        boolean firstSetSmaller;
        if (this.isEmpty() || s.isEmpty()) {
            return new Set(new Tuple[0]);
        }
        Set result = null;
        Set[] sets = new Set[]{this, s};
        int firstSet = 0;
        int secondSet = 1;
        boolean bl = firstSetSmaller = sets[firstSet].size() < sets[secondSet].size();
        if (firstSetSmaller) {
            smallSet = firstSet;
            largeSet = secondSet;
        } else {
            smallSet = secondSet;
            largeSet = firstSet;
        }
        boolean filterSmallSet = firstSetSmaller;
        ITupleListFilter filter = null;
        filter = !filterSmallSet && sets[smallSet].size() * 128L < sets[largeSet].size() ? new TupleListSparseFilter() : new TupleListFilter(this.size());
        TupleIndex matchCandidates = new TupleIndex(sets[smallSet], "stintr", true);
        ITupleIterator iterLg = sets[largeSet].getTupleList().iterator();
        long ord = 0L;
        while (iterLg.hasNext()) {
            Tuple tuple = (Tuple)iterLg.next();
            if (matchCandidates.contains(tuple)) {
                if (filterSmallSet) {
                    matchCandidates.remove(tuple);
                } else {
                    filter.enable(ord);
                    if (!allowDuplicates) {
                        matchCandidates.remove(tuple);
                    }
                }
                if (matchCandidates.isEmpty()) break;
            }
            ++ord;
        }
        if (filterSmallSet) {
            ITupleIterator iterSm = sets[smallSet].getTupleList().iterator();
            ord = 0L;
            while (iterSm.hasNext()) {
                Tuple tuple = (Tuple)iterSm.next();
                if (!matchCandidates.contains(tuple) && !tuple.containsNullMember()) {
                    filter.enable(ord);
                    if (!allowDuplicates) {
                        matchCandidates.add(tuple);
                    }
                }
                ++ord;
            }
        }
        matchCandidates.close();
        ITupleList tl = FilteredTupleList.construct(sets[firstSet].getTupleList(), filter);
        if (!allowDuplicates && tl != null) {
            tl.setDistinctFlag(true);
        }
        if (tl != null && tl.size() > 0L) {
            result = new Set(tl);
        } else {
            IHierarchy[] setHiers = this.getHierarchies();
            IMember[] tupleMembers = new NullMember[setHiers.length];
            for (int i = 0; i < setHiers.length; ++i) {
                tupleMembers[i] = NullMember.getNullMember(setHiers[i]);
            }
            result = new Set(new Tuple(tupleMembers));
        }
        result.addCurrentMemberDimensions(s.getCurrentMemberDimensions());
        result.addCurrentMemberDimensions(this.getCurrentMemberDimensions());
        result.addCurrentMemberHierarchies(s.getCurrentMemberHierarchies());
        result.addCurrentMemberHierarchies(this.getCurrentMemberHierarchies());
        return result;
    }

    public static Set union(Set[] setsToUnion, boolean retainDuplicates) throws InterpreterException {
        int i;
        if (setsToUnion.length == 0) {
            return new Set(new Tuple[0]);
        }
        if (setsToUnion.length == 1) {
            return setsToUnion[0];
        }
        IHierarchy[] usetHiers = null;
        IHierarchy[] usetCmHiers = null;
        Set[] commonSets = null;
        for (i = 0; i < setsToUnion.length; ++i) {
            if (setsToUnion[i] == null || setsToUnion[i].isEmpty()) continue;
            usetHiers = setsToUnion[i].getHierarchies();
            usetCmHiers = setsToUnion[i].getCurrentMemberHierarchies();
            if (!(setsToUnion[i] instanceof CrossJoinedSet)) break;
            commonSets = ((CrossJoinedSet)setsToUnion[i]).getSets();
            break;
        }
        if (usetHiers == null) {
            return new Set(new Tuple[0]);
        }
        for (i = 1; i < setsToUnion.length; ++i) {
            if (setsToUnion[i] == null) continue;
            IHierarchy[] sHiers = setsToUnion[i].getHierarchies();
            int usetHierCount = usetHiers.length;
            int sHierCount = sHiers.length;
            if (usetHierCount > 0 && sHierCount > 0) {
                if (usetHierCount != sHierCount) {
                    throw new InterpreterException("X01444", new String[0], 1L);
                }
                for (int j = 0; j < usetHierCount; ++j) {
                    if (usetHiers[j].equals(sHiers[j])) continue;
                    throw new InterpreterException("X01444", new String[0], 1L);
                }
            }
            if (commonSets == null) continue;
            if (setsToUnion[i] instanceof CrossJoinedSet) {
                Set[] cjSets = ((CrossJoinedSet)setsToUnion[i]).getSets();
                if (cjSets.length == commonSets.length) {
                    for (int setIdx = 0; setIdx < cjSets.length; ++setIdx) {
                        if (cjSets[setIdx] == commonSets[setIdx]) continue;
                        commonSets[setIdx] = null;
                    }
                    continue;
                }
                commonSets = null;
                continue;
            }
            commonSets = null;
        }
        Set result = null;
        if (commonSets != null) {
            boolean allCommonAtTheEnd = false;
            int commonSetCount = 0;
            for (int i2 = 0; i2 < commonSets.length; ++i2) {
                if (commonSets[i2] != null) {
                    allCommonAtTheEnd = true;
                    ++commonSetCount;
                    continue;
                }
                if (!allCommonAtTheEnd) continue;
                allCommonAtTheEnd = false;
                break;
            }
            if (!allCommonAtTheEnd || commonSetCount == commonSets.length) {
                commonSets = null;
            }
        }
        ArrayList<ITupleList> childTupleLists = new ArrayList<ITupleList>();
        for (int inx = 0; inx < setsToUnion.length; ++inx) {
            if (setsToUnion[inx] == null || setsToUnion[inx].isEmpty()) continue;
            if (commonSets == null) {
                childTupleLists.add(setsToUnion[inx].getTupleList());
                continue;
            }
            Set[] cjSets = ((CrossJoinedSet)setsToUnion[inx]).getSets();
            int setIdx = 0;
            ArrayList<ITupleList> cjTupleLists = new ArrayList<ITupleList>();
            while (commonSets[setIdx] == null) {
                cjTupleLists.add(cjSets[setIdx].getTupleList());
                ++setIdx;
            }
            childTupleLists.add(CrossJoinTupleList.construct(cjTupleLists));
        }
        ITupleList tl = UnionTupleList.construct(childTupleLists);
        result = new Set(tl);
        if (!retainDuplicates) {
            result = result.distinct();
        }
        if (commonSets != null) {
            ArrayList<Set> cjResultSets = new ArrayList<Set>();
            cjResultSets.add(result);
            for (int i3 = 0; i3 < commonSets.length; ++i3) {
                if (commonSets[i3] == null) continue;
                cjResultSets.add(commonSets[i3]);
            }
            return new CrossJoinedSet(cjResultSets.toArray(new Set[0]));
        }
        result.addCurrentMemberHierarchies(usetCmHiers);
        return result;
    }

    public ISet head(long count) throws InterpreterException {
        return this.subset(0L, count);
    }

    public Set tail(int count) throws InterpreterException {
        long startIndex = this.size() - (long)count;
        if (startIndex < 0L) {
            startIndex = 0L;
        }
        return this.subset(startIndex, count);
    }

    private ISet reverse(InterpreterContext interpreterContext) throws InterpreterException {
        ResourceMonitor.checkMaxSetSize(this.size(), interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
        long[] order = new long[(int)this.size()];
        int inx = 0;
        while ((long)inx < this.size()) {
            order[inx] = this.size() - 1L - (long)inx;
            ++inx;
        }
        ITupleList tl = SortedTupleList.construct(this.getTupleList(), order);
        return new Set(tl);
    }

    public Set subset(long start, long count) throws InterpreterException {
        if (count > Integer.MAX_VALUE) {
            throw new InterpreterException("X01491");
        }
        if (start < 0L || count <= 0L) {
            return new Set(new Tuple[0]);
        }
        ITupleList tl = SubsetTupleList.construct(this.getTupleList(), start, count);
        return new Set(tl);
    }

    public Set getFilteredSet(ITupleListFilter filter) {
        ITupleList tl = FilteredTupleList.construct(this.getTupleList(), filter);
        return new Set(tl);
    }

    public Set distinct() {
        if (this.size() <= 1L) {
            return this;
        }
        if (this.getTupleList().getDistinctFlag()) {
            return this;
        }
        TupleListFilter filter = new TupleListFilter(this.size());
        TupleIndex uniqueTuples = new TupleIndex(this, "stdstr", false);
        ITupleIterator iter1 = this.getTupleList().iterator();
        while (iter1.hasNext()) {
            long index = iter1.getIndex();
            Tuple tuple = (Tuple)iter1.next();
            if (uniqueTuples.contains(tuple)) continue;
            filter.enable(index);
            uniqueTuples.add(tuple);
        }
        uniqueTuples.close();
        ITupleList tl = FilteredTupleList.construct(this.getTupleList(), filter);
        if (tl != null) {
            tl.setDistinctFlag(true);
        }
        return new Set(tl);
    }

    public Set extract(IDimension[] dimensions, boolean retainDuplicates) throws InterpreterException {
        int[] indexes;
        if (dimensions == null || dimensions.length == 0) {
            return new Set((ITupleList)null);
        }
        boolean[] indexSeen = new boolean[this.getHierarchyCount()];
        if (this.multipleHierarchySupport()) {
            IDimension[] setDimensions = this.getDimensions();
            int[] tempIndexes = new int[setDimensions.length];
            int j = 0;
            for (IDimension dim : dimensions) {
                boolean foundDim = false;
                for (int idx = 0; idx < setDimensions.length; ++idx) {
                    if (!setDimensions[idx].equals(dim)) continue;
                    tempIndexes[j++] = idx;
                    foundDim = true;
                    if (!indexSeen[idx]) {
                        indexSeen[idx] = true;
                        continue;
                    }
                    throw new MetadataException("X01442", new String[]{this.getHierarchies()[idx].getName()});
                }
                if (foundDim) continue;
                return new Set(new Tuple[0]);
            }
            indexes = new int[j];
            System.arraycopy(tempIndexes, 0, indexes, 0, j);
        } else {
            indexes = new int[dimensions.length];
            for (int i = 0; i < dimensions.length; ++i) {
                if (!this.contains(dimensions[i])) {
                    return new Set(new Tuple[0]);
                }
                indexes[i] = this.getDimensionIndex(dimensions[i]);
                if (indexSeen[i]) {
                    throw new MetadataException("X01442", new String[]{dimensions[i].getName()});
                }
                indexSeen[i] = true;
            }
        }
        ITupleList extractTupleList = ExtractTupleList.construct(this.getTupleList(), indexes);
        Set retSet = new Set(extractTupleList);
        if (!retainDuplicates) {
            retSet = retSet.distinct();
        }
        return retSet;
    }

    public Set extract(IHierarchy[] hierarchies, boolean retainDuplicates) throws InterpreterException {
        if (hierarchies == null || hierarchies.length == 0) {
            return new Set((ITupleList)null);
        }
        ArrayList<IHierarchy> hierarchyList = new ArrayList<IHierarchy>();
        int[] hierarchyIndexes = new int[hierarchies.length];
        for (int i = 0; i < hierarchies.length; ++i) {
            if (!this.contains(hierarchies[i])) {
                return new Set(new Tuple[0]);
            }
            hierarchyIndexes[i] = this.getHierarchyIndex(hierarchies[i]);
            if (hierarchyIndexes[i] < 0) {
                return new Set(new Tuple[0]);
            }
            if (hierarchyList.contains(hierarchies[i])) {
                throw new MetadataException("X01442", new String[]{hierarchies[i].getName()});
            }
            hierarchyList.add(hierarchies[i]);
        }
        ITupleList eTl = ExtractTupleList.construct(this.getTupleList(), hierarchyIndexes);
        Set retSet = new Set(eTl);
        if (!retainDuplicates) {
            retSet = retSet.distinct();
        }
        return retSet;
    }

    public Set except(Set notThese) throws InterpreterException {
        return this.except(notThese, false);
    }

    public Set except(Set notThese, boolean includeAll) throws InterpreterException {
        int largeSet;
        int smallSet;
        boolean firstSetSmaller;
        if (this.isEmpty() || notThese.isEmpty()) {
            return this;
        }
        Set[] sets = new Set[]{this, notThese};
        int firstSet = 0;
        int secondSet = 1;
        boolean bl = firstSetSmaller = sets[firstSet].size() < sets[secondSet].size();
        if (firstSetSmaller) {
            smallSet = firstSet;
            largeSet = secondSet;
        } else {
            smallSet = secondSet;
            largeSet = firstSet;
        }
        boolean filterSmallSet = firstSetSmaller;
        TupleListFilter filter = new TupleListFilter(this.size());
        TupleIndex matchCandidates = new TupleIndex(sets[smallSet], "stextr", true);
        ITupleIterator iterLg = sets[largeSet].getTupleList().iterator();
        long ordinal = 0L;
        while (iterLg.hasNext()) {
            Tuple tuple = (Tuple)iterLg.next();
            if (filterSmallSet) {
                if (matchCandidates.contains(tuple)) {
                    matchCandidates.remove(tuple);
                    if (matchCandidates.isEmpty()) {
                        break;
                    }
                }
            } else if (!matchCandidates.contains(tuple)) {
                filter.enable(ordinal);
                if (!includeAll) {
                    matchCandidates.add(tuple);
                }
            }
            ++ordinal;
        }
        if (filterSmallSet) {
            ITupleIterator iterSm = sets[smallSet].getTupleList().iterator();
            ordinal = 0L;
            while (iterSm.hasNext()) {
                Tuple tuple = (Tuple)iterSm.next();
                if (matchCandidates.contains(tuple)) {
                    filter.enable(ordinal);
                    if (!includeAll) {
                        matchCandidates.remove(tuple);
                    }
                }
                ++ordinal;
            }
        }
        matchCandidates.close();
        ITupleList tl = FilteredTupleList.construct(sets[firstSet].getTupleList(), filter);
        if (!includeAll && tl != null) {
            tl.setDistinctFlag(true);
        }
        return new Set(tl);
    }

    public boolean containsNullMembers() {
        if (this.tupleList == null) {
            return false;
        }
        return this.tupleList.containsNullMembers();
    }

    public Set removeNullMembers() {
        if (this.size() == 0L) {
            return this;
        }
        if (!this.containsNullMembers()) {
            return this;
        }
        ResourceMonitor.checkMaxSetSize(this.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        TupleListFilter filter = new TupleListFilter(this.size());
        for (long i = 0L; i < this.size(); ++i) {
            if (((Tuple)this.getTuple(i)).containsNullMember()) continue;
            filter.enable(i);
        }
        ITupleList outputList = FilteredTupleList.construct(this.getTupleList(), filter);
        Set retSet = new Set(outputList);
        retSet.setPtdLastChild(this.getPtdLastChild());
        retSet.setEmptyChildrenSetParentMember(this.getEmptyChildrenSetParentMember());
        retSet.setRelativeTimeAncestorObject(this.getRelativeTimeAncestorObject());
        retSet.addCurrentMemberDimensions(this.getCurrentMemberDimensions());
        retSet.addCurrentMemberHierarchies(this.getCurrentMemberHierarchies());
        return retSet;
    }

    public Set hierarchize() {
        return this.hierarchize(false);
    }

    public Set hierarchize(boolean post) {
        if (this.size() == 0L) {
            return new Set(this);
        }
        TupleListQSort sorter = new TupleListQSort();
        sorter.setSubject(this.getTupleList());
        sorter.setPostOrder(post);
        ITupleList tl = null;
        try {
            tl = sorter.sort();
        }
        catch (Exception ex) {
            XQEDebugLog.out.println(DEBUG_HIER_FAILED_PREFIX_STR + ex.toString());
        }
        return new Set(tl);
    }

    @Override
    public ISet removeDimensions(IDimension[] d) {
        return this.removeDimensions(d, true);
    }

    @Override
    public ISet removeDimensions(IDimension[] d, boolean retainDuplicates) {
        Set result;
        if (this.multipleHierarchySupport()) {
            ArrayList<IHierarchy> hierarchies = new ArrayList<IHierarchy>();
            for (IDimension dim : d) {
                hierarchies.addAll(dim.getHierarchies());
            }
            return this.removeHierarchies(hierarchies.toArray(new IHierarchy[hierarchies.size()]), retainDuplicates);
        }
        this.resetDimensionCardinality();
        ListOrderedSet removableDims = ListOrderedSet.decorate(new HashSet());
        ListOrderedSet dimsToRemove = ListOrderedSet.decorate(new HashSet());
        removableDims.addAll(Arrays.asList(this.getDimensions()));
        dimsToRemove.addAll(Arrays.asList(d));
        removableDims.retainAll((Collection)dimsToRemove);
        d = (Dimension[])removableDims.toArray((Object[])new Dimension[removableDims.size()]);
        if (d.length > 0) {
            if (this.getTuple(0L).size() > 1) {
                IDimension[] allDims = this.getDimensions();
                int[] dimMap = new int[allDims.length - removableDims.size()];
                int j = 0;
                for (int i = 0; i < allDims.length; ++i) {
                    if (removableDims.contains((Object)allDims[i])) continue;
                    dimMap[j] = i;
                    ++j;
                }
                ITupleList tl = ExtractTupleList.construct(this.getTupleList(), dimMap);
                result = new Set(tl);
                if (!retainDuplicates) {
                    result = result.distinct();
                }
            } else {
                result = new Set(new Tuple[0]);
            }
        } else {
            result = (Set)this.copy();
        }
        return result;
    }

    @Override
    public ISet removeHierarchies(IHierarchy[] h, boolean retainDuplicates) {
        Set result;
        this.resetDimensionCardinality();
        ListOrderedSet removableHiers = ListOrderedSet.decorate(new HashSet());
        ListOrderedSet hiersToRemove = ListOrderedSet.decorate(new HashSet());
        removableHiers.addAll(Arrays.asList(this.getHierarchies()));
        hiersToRemove.addAll(Arrays.asList(h));
        removableHiers.retainAll((Collection)hiersToRemove);
        h = (Hierarchy[])removableHiers.toArray((Object[])new Hierarchy[removableHiers.size()]);
        if (h.length > 0) {
            if (this.getTuple(0L).size() > 1) {
                ITupleList tl = ExtractTupleList.construct(this.getTupleList(), removableHiers, retainDuplicates);
                result = new Set(tl);
                if (!retainDuplicates) {
                    result = result.distinct();
                }
            } else {
                result = new Set(new Tuple[0]);
            }
        } else {
            result = (Set)this.copy();
        }
        return result;
    }

    @Override
    public ISet removeHierarchy(IHierarchy h, boolean retainDuplicates) {
        return this.removeHierarchies(new IHierarchy[]{h}, retainDuplicates);
    }

    @Override
    public boolean isEmpty() {
        long size = this.size();
        if (size < 0L) {
            BigInteger bigSize = this.noOverflowSize();
            return bigSize.bitLength() <= 0 || this.getTuple(0L).size() <= 0;
        }
        return size <= 0L || this.getTuple(0L).size() <= 0;
    }

    public void removeCurrentMemberDimensions() {
        this.currentMemberDimensions = new HashSet();
    }

    @Override
    public ISet removeDimension(IDimension d) {
        return this.removeDimension(d, true);
    }

    @Override
    public ISet removeDimension(IDimension d, boolean retainDuplicates) {
        Set result;
        if (this.multipleHierarchySupport() && d.getHierarchyCount() > 1) {
            IHierarchy[] hierarchies = d.getHierarchies().toArray(new IHierarchy[0]);
            return this.removeHierarchies(hierarchies, retainDuplicates);
        }
        if (this.contains(d)) {
            this.resetDimensionCardinality();
            if (this.getTuple(0L).size() > 1) {
                IDimension[] allDims = this.getDimensions();
                int[] dimMap = new int[allDims.length - 1];
                int j = 0;
                for (int i = 0; i < allDims.length; ++i) {
                    if (allDims[i].equals(d)) continue;
                    dimMap[j] = i;
                    ++j;
                }
                ITupleList tl = ExtractTupleList.construct(this.getTupleList(), dimMap);
                result = new Set(tl);
                if (!retainDuplicates) {
                    result = result.distinct();
                }
            } else {
                result = new Set(new Tuple[0]);
            }
        } else {
            result = (Set)this.copy();
        }
        return result;
    }

    private Set collapseToRollupMembers(IHierarchy hierarchy, int hierIndex) {
        ArrayList<Tuple> resultTuples = new ArrayList<Tuple>();
        HashSet<IMember> members = new HashSet<IMember>(Arrays.asList(this.getMembers(hierarchy)));
        if (members.size() == 1) {
            return this;
        }
        HashSet<IMember> membersWithParent = new HashSet<IMember>();
        ArrayList<IMember> pathToAncestor = new ArrayList<IMember>();
        Iterator<IMember> membersIt = members.iterator();
        block0: while (membersIt.hasNext()) {
            pathToAncestor.clear();
            IMember child = membersIt.next();
            IMember parent = child.getParent();
            if (members.contains(parent)) {
                membersWithParent.add(child);
                continue;
            }
            if (parent == null) continue;
            pathToAncestor.add(child);
            child = parent;
            parent = child.getParent();
            while (parent != null) {
                pathToAncestor.add(child);
                if (members.contains(parent)) {
                    membersWithParent.addAll(pathToAncestor);
                    continue block0;
                }
                child = parent;
                parent = child.getParent();
            }
        }
        if (membersWithParent.isEmpty()) {
            return this;
        }
        IIterator setIter = this.iterator();
        while (setIter.hasNext()) {
            Tuple tuple = (Tuple)((ITuple)setIter.next()).copy();
            IMember m = tuple.getMember(hierarchy);
            IMember parent = null;
            if (membersWithParent.contains(m)) {
                parent = m.getParent();
                while (membersWithParent.contains(parent)) {
                    parent = parent.getParent();
                }
            }
            if (parent != null) {
                tuple.replaceMember(hierIndex, parent);
            }
            if (resultTuples.contains(tuple)) continue;
            resultTuples.add(tuple);
        }
        if (resultTuples.isEmpty()) {
            return this;
        }
        return new Set(resultTuples.toArray(new ITuple[0]));
    }

    public Set collapseToRollupMembers() {
        IHierarchy[] hierarchies;
        if (this.size() == 1L) {
            return this;
        }
        for (IHierarchy h : hierarchies = this.getHierarchies()) {
            if (h.getDimension().getMembersRollup()) continue;
            return null;
        }
        Set resultSet = this;
        for (int i = 0; i < hierarchies.length; ++i) {
            resultSet = resultSet.collapseToRollupMembers(hierarchies[i], i);
        }
        return resultSet;
    }

    public Set drillDownMember(Set s2) throws InterpreterException {
        return this.drillDownMember(s2, false);
    }

    public Set drillDownMember(Set s2, boolean recurse) throws InterpreterException {
        Set result = null;
        if (this.isEmpty() || s2.isEmpty()) {
            result = this;
        } else {
            long i;
            boolean addedMemberInSet2 = true;
            Set s1 = this;
            ResourceMonitor.checkMaxSetSize(s2.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
            HashSet<IMember> s2MemsAlreadyDrilledUpon = new HashSet<IMember>();
            HashSet<IMember> s2Mems = new HashSet<IMember>();
            for (i = 0L; i < s2.size(); ++i) {
                s2Mems.add(s2.getTuple(i).getMember(0));
            }
            while (addedMemberInSet2) {
                addedMemberInSet2 = false;
                if (s2.getTuple(0L).size() > 1) {
                    throw new InterpreterException("X01482", new String[]{"drillDownMember"});
                }
                IMember m = s2.getTuple(0L).getMember(0);
                Hierarchy h = (Hierarchy)m.getHierarchy();
                ArrayList<ITuple> al = new ArrayList<ITuple>();
                if (!s1.contains(h)) {
                    throw new InterpreterException("X01456", new String[]{h.getName()});
                }
                int hierIndex = s1.getHierarchyIndex(h);
                if (hierIndex < 0) {
                    throw new InterpreterException("X01456", new String[]{h.getName()});
                }
                ResourceMonitor.checkMaxSetSize(s1.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
                for (i = 0L; i < s1.size(); ++i) {
                    ITuple t = s1.getTuple(i);
                    al.add(t);
                    m = t.getMember(hierIndex);
                    ITuple nextTuple = null;
                    if (i + 1L < s1.size()) {
                        nextTuple = s1.getTuple(i + 1L);
                        IMember nextMember = null;
                        nextMember = nextTuple.getMember(hierIndex);
                        List<IMember> mChildren = m.getChildren();
                        if (mChildren.contains(nextMember)) continue;
                    }
                    if (!s2Mems.contains(m) || s2MemsAlreadyDrilledUpon.contains(m)) continue;
                    try {
                        s2MemsAlreadyDrilledUpon.add(m);
                        IMember[] children = m.getChildMembers();
                        for (int k = 0; k < children.length; ++k) {
                            IMember[] newTupMems = new IMember[t.size()];
                            for (int j = 0; j < t.size(); ++j) {
                                if (j == hierIndex) {
                                    IMember addingMember = children[k];
                                    if (s2Mems.contains(addingMember)) {
                                        addedMemberInSet2 = true;
                                    }
                                    newTupMems[j] = addingMember;
                                    continue;
                                }
                                newTupMems[j] = t.getMember(j);
                            }
                            Tuple t2 = new Tuple(newTupMems);
                            al.add(t2);
                        }
                        continue;
                    }
                    catch (MetadataException e) {
                        throw new InterpreterException("X01516", new String[]{m.getName()}, e);
                    }
                }
                result = s1 = new Set(al.toArray(new Tuple[0]));
                if (!(addedMemberInSet2 = addedMemberInSet2 && recurse)) continue;
                XQEDebugLog.out.println("Recursing in DrillDownMember...");
            }
        }
        return result;
    }

    public Set drillUpMember(Set s2) throws InterpreterException {
        Set s = null;
        if (this.size() == 0L) {
            return new Set(new Tuple[0]);
        }
        if (s2.getHierarchyCount() == 0) {
            return this;
        }
        if (s2.getHierarchyCount() != 1) {
            throw new InterpreterException("X01482", new String[]{"DrillUpMember"});
        }
        HashSet<IMember> drillUpMembers = new HashSet<IMember>();
        ResourceMonitor.checkMaxSetSize(s2.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        for (long i = 0L; i < s2.size(); ++i) {
            drillUpMembers.add(s2.getTuple(i).getMember(0));
        }
        HashSet<IMember> descendantsToRemove = new HashSet<IMember>();
        ArrayList<ITuple> newSet = new ArrayList<ITuple>();
        IHierarchy hier = s2.getTuple(0L).getMember(0).getHierarchy();
        int hierIndex = this.getHierarchyIndex(hier);
        if (hierIndex < 0) {
            throw new InterpreterException("X01456", new String[]{hier.getName()});
        }
        ResourceMonitor.checkMaxSetSize(this.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        for (long i = 0L; i < this.size(); ++i) {
            ITuple tuple = this.getTuple(i);
            IMember m = tuple.getMember(hierIndex);
            if (descendantsToRemove.contains(m)) continue;
            if (drillUpMembers.contains(m)) {
                try {
                    XQEDebugLog.out.println("Remove descendants of " + m.getUniqueName());
                    descendantsToRemove = new HashSet();
                    descendantsToRemove.addAll(((IMemberCubics)m).getDescendants());
                    descendantsToRemove.remove(m);
                }
                catch (MetadataException e) {
                    mErrorLogger.log(e);
                }
            } else {
                descendantsToRemove = new HashSet();
            }
            newSet.add(tuple);
        }
        s = new Set(newSet.toArray(new Tuple[0]));
        return s;
    }

    private Set drillSort(ParameterFetcher paramFetcher, int paramIdx, boolean drillTop) throws InterpreterException {
        ArrayList<TupleValue> sortedTupleValues;
        InterpreterContext interpreterContext = paramFetcher.getInterpreterContext();
        int paramCount = paramFetcher.getParameterCount();
        if (paramIdx >= paramCount) {
            if (drillTop) {
                return this;
            }
            return (Set)this.reverse(interpreterContext);
        }
        Block thisSetB = new Block(interpreterContext, this);
        Block numExpParamB = new Block(interpreterContext, thisSetB, paramFetcher, paramIdx, true, false);
        TreeSet setValues = (TreeSet)numExpParamB.first();
        if (setValues == null) {
            if (drillTop) {
                return this;
            }
            return (Set)this.reverse(interpreterContext);
        }
        ArrayList<TupleValue> positiveTuples = new ArrayList<TupleValue>();
        ArrayList<TupleValue> negativeTuples = new ArrayList<TupleValue>();
        ArrayList<TupleValue> nullTuples = new ArrayList<TupleValue>();
        long emptyTupleIdx = 0L;
        for (Cell cell : setValues) {
            long tupleOrd = cell.getOrdinal();
            boolean isPositive = true;
            if (cell.isNumeric() || cell.isBoolean()) {
                if (cell.getNumericValue() < 0.0) {
                    isPositive = false;
                }
            } else if (!cell.isString()) {
                throw new InterpreterException("X01490", new String[]{cell.getObjectValue().toString(), DRILLDOWNMEMBER_STR, "CMP_TYPENUMERIC"});
            }
            ITuple tup = this.getTuple(tupleOrd);
            TupleValue tupVal = new TupleValue(tup, cell);
            tupVal.setTiesComp(Long.valueOf(this.size() - tupleOrd - 1L));
            if (isPositive) {
                positiveTuples.add(tupVal);
            } else {
                negativeTuples.add(tupVal);
            }
            for (long i = emptyTupleIdx; i < tupleOrd; ++i) {
                ITuple emptyTuple = this.getTuple(i);
                Cell emptyCell = new Cell(i, NullValue.NULLVALUE);
                nullTuples.add(new TupleValue(emptyTuple, emptyCell));
            }
            emptyTupleIdx = tupleOrd + 1L;
        }
        Collections.sort(positiveTuples);
        Collections.sort(negativeTuples);
        if (drillTop) {
            Collections.reverse(positiveTuples);
            Collections.reverse(negativeTuples);
            positiveTuples.addAll(nullTuples);
            positiveTuples.addAll(negativeTuples);
            sortedTupleValues = positiveTuples;
        } else {
            Collections.reverse(nullTuples);
            negativeTuples.addAll(nullTuples);
            negativeTuples.addAll(positiveTuples);
            sortedTupleValues = negativeTuples;
        }
        ITuple[] sortedTuples = new ITuple[sortedTupleValues.size()];
        for (int i = 0; i < sortedTupleValues.size(); ++i) {
            sortedTuples[i] = ((TupleValue)sortedTupleValues.get(i)).getTuple();
        }
        return new Set(sortedTuples);
    }

    public Set drillDownMemberTopOrBottom(Set drillDownSet, int count, ParameterFetcher paramFetcher, int paramIdx, boolean drillTop, boolean recurse) throws InterpreterException {
        ArrayList<ITuple> retTuples = new ArrayList<ITuple>();
        if (count == 0 || drillDownSet.isEmpty() || this.isEmpty()) {
            return this;
        }
        Hierarchy drillDownHier = (Hierarchy)drillDownSet.getTuple(0L).getMember(0).getHierarchy();
        int drillDownHierIdx = this.getHierarchyIndex(drillDownHier);
        if (drillDownHierIdx < 0) {
            throw new InterpreterException("X01456", new String[]{drillDownHier.getName()});
        }
        ResourceMonitor.checkMaxSetSize(drillDownSet.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        HashSet<IMember> drillDownMembers = new HashSet<IMember>();
        for (long i = 0L; i < drillDownSet.size(); ++i) {
            drillDownMembers.add(drillDownSet.getTuple(i).getMember(0));
        }
        ResourceMonitor.checkMaxSetSize(this.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        for (long s1TupleIdx = 0L; s1TupleIdx < this.size(); ++s1TupleIdx) {
            ITuple s1NextTuple;
            IMember s1NextTupleMem;
            ITuple s1Tuple = this.getTuple(s1TupleIdx);
            IMember s1TupleMem = s1Tuple.getMember(drillDownHier);
            retTuples.add(s1Tuple);
            if (!drillDownMembers.contains(s1TupleMem) || s1TupleIdx < this.size() - 1L && s1TupleMem.equals((s1NextTupleMem = (s1NextTuple = this.getTuple(s1TupleIdx + 1L)).getMember(drillDownHierIdx)).getParent())) continue;
            Set s1TupleMemDesc = new Set(Tuple.createTupleList(s1TupleMem.getChildMembers()));
            s1TupleMemDesc = s1TupleMemDesc.drillSort(paramFetcher, paramIdx, drillTop);
            s1TupleMemDesc = s1TupleMemDesc.subset(0L, count);
            if (recurse) {
                s1TupleMemDesc = s1TupleMemDesc.drillDownMemberTopOrBottom(drillDownSet, count, paramFetcher, paramIdx, drillTop, recurse);
            }
            ResourceMonitor.checkMaxSetSize(s1TupleMemDesc.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
            for (long i = 0L; i < s1TupleMemDesc.size(); ++i) {
                IMember[] s1TupleMems = (IMember[])s1Tuple.getMembers().clone();
                s1TupleMems[drillDownHierIdx] = s1TupleMemDesc.getTuple(i).getMember(0);
                retTuples.add(new Tuple(s1TupleMems));
            }
        }
        return new Set(retTuples.toArray(new Tuple[0]));
    }

    public Set toggleDrillState(Set s2) throws InterpreterException {
        Set s = null;
        if (s2.getHierarchyCount() != 1) {
            throw new InterpreterException("X01482", new String[]{"ToggleDrillState"});
        }
        HashSet<IMember> drillMembers = new HashSet<IMember>();
        ResourceMonitor.checkMaxSetSize(s2.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        for (long i = 0L; i < s2.size(); ++i) {
            drillMembers.add(s2.getTuple(i).getMember(0));
        }
        IHierarchy hier = s2.getTuple(0L).getMember(0).getHierarchy();
        int hierIndex = this.getHierarchyIndex(hier);
        if (hierIndex < 0) {
            throw new InterpreterException("X01456", new String[]{hier.getName()});
        }
        ResourceMonitor.checkMaxSetSize(this.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        s = this;
        for (long i = 0L; i < this.size(); ++i) {
            ITuple tuple = this.getTuple(i);
            IMember m = tuple.getMember(hierIndex);
            if (!drillMembers.contains(m)) continue;
            try {
                if (i < this.size() - 1L) {
                    ITuple nextTuple = this.getTuple(i + 1L);
                    HashSet<IMember> descendants = new HashSet<IMember>();
                    descendants.addAll(((IMemberCubics)m).getDescendants());
                    if (descendants.contains(nextTuple.getMember(hierIndex))) {
                        s = s.drillUpMember(new Set(new Tuple(m)));
                        continue;
                    }
                    s = s.drillDownMember(new Set(new Tuple(m)));
                    continue;
                }
                s = s.drillDownMember(new Set(new Tuple(m)));
                continue;
            }
            catch (MetadataException e) {
                mErrorLogger.log(e);
            }
        }
        return s;
    }

    public Level getLowestLevel(int hierarchyIndex) {
        ResourceMonitor.checkMaxSetSize(this.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        ITuple tuple = this.getTuple(0L);
        Level result = (Level)tuple.getMember(hierarchyIndex).getLevel();
        for (long i = 0L; i < this.size(); ++i) {
            tuple = this.getTuple(i);
            IMember m = tuple.getMember(hierarchyIndex);
            if (m.getLevel().getIndex() <= result.getIndex()) continue;
            result = (Level)m.getLevel();
        }
        return result;
    }

    public Set drillDownLevel() throws InterpreterException {
        Set result;
        int hierarchyIndex = 0;
        if (this.size() == 0L) {
            result = this;
        } else {
            Level l = this.getLowestLevel(hierarchyIndex);
            result = this.drillDownLevel(l, hierarchyIndex);
        }
        return result;
    }

    public Set drillDownLevelByLevelIndex(int levelIndex) throws InterpreterException {
        Set result;
        int hierarchyIndex = 0;
        if (this.size() == 0L) {
            result = this;
        } else {
            ITuple tuple = this.getTuple(0L);
            ILevel l = ((Hierarchy)tuple.getMember(hierarchyIndex).getHierarchy()).getLevel(levelIndex);
            result = this.drillDownLevel(l, hierarchyIndex);
        }
        return result;
    }

    public Set drillDownLevelByHierarchyIndex(int hierarchyIndex) throws InterpreterException {
        Set result;
        if (this.size() == 0L) {
            result = this;
        } else {
            Level l = this.getLowestLevel(hierarchyIndex);
            result = this.drillDownLevel(l, hierarchyIndex);
        }
        return result;
    }

    public Set drillDownLevel(ILevel drillLevel, int hierarchyIndex) throws InterpreterException {
        Set result;
        ILevel drillLevelNext = drillLevel.getNextLevel();
        if (drillLevelNext == null) {
            return this;
        }
        if (this.size() == 0L) {
            result = this;
        } else {
            ResourceMonitor.checkMaxSetSize(this.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
            ArrayList<ITuple> al = new ArrayList<ITuple>();
            for (long i = 0L; i < this.size(); ++i) {
                ITuple tuple = this.getTuple(i);
                al.add(tuple);
                IMember m = tuple.getMember(hierarchyIndex);
                try {
                    if (m.getLevel().getIndex() != drillLevel.getIndex()) continue;
                    HashSet<IMember> descendants = new HashSet<IMember>();
                    descendants.addAll(((IMemberCubics)m).getDescendants());
                    if (i < this.size() - 1L && descendants.contains(this.getTuple(i + 1L).getMember(hierarchyIndex))) continue;
                    XQEDebugLog.out.println("Drill Down on " + m.getUniqueName());
                    try {
                        IMember[] children = m.getChildMembers();
                        for (int k = 0; k < children.length; ++k) {
                            if (!children[k].getLevel().equals(drillLevelNext)) continue;
                            IMember[] newTupMems = new IMember[tuple.size()];
                            for (int j = 0; j < tuple.size(); ++j) {
                                newTupMems[j] = j == hierarchyIndex ? children[k] : tuple.getMember(j);
                            }
                            Tuple t2 = new Tuple(newTupMems);
                            al.add(t2);
                        }
                        continue;
                    }
                    catch (MetadataException e) {
                        throw new InterpreterException("X01516", new String[]{m.getName()}, e);
                    }
                }
                catch (MetadataException e) {
                    mErrorLogger.log(e);
                }
            }
            result = new Set(al.toArray(new Tuple[al.size()]));
        }
        return result;
    }

    public Set drillUpLevel() throws InterpreterException {
        Set result;
        int dimensionIndex = 0;
        if (this.size() == 0L) {
            result = this;
        } else {
            Level l = this.getLowestLevel(dimensionIndex);
            ILevel upperLevel = null;
            IHierarchy hier = l.getHierarchy();
            int index = l.getIndex();
            if (index != 0) {
                upperLevel = hier.getLevel(index - 1);
            }
            result = this.drillUpLevel((Level)upperLevel);
        }
        return result;
    }

    public Set drillUpLevel(Level level) throws InterpreterException {
        Set result;
        if (level == null) {
            return this;
        }
        IDimension levelDim = level.getDimension();
        if (this.size() == 0L) {
            result = this;
        } else {
            ResourceMonitor.checkMaxSetSize(this.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
            ArrayList<ITuple> al = new ArrayList<ITuple>();
            for (long i = 0L; i < this.size(); ++i) {
                ITuple tuple = this.getTuple(i);
                IMember m = tuple.getMember(levelDim);
                if (m == null) {
                    throw new InterpreterException("X01482", new String[]{"drillUpLevel"});
                }
                if (m.getLevel().getIndex() > level.getIndex()) continue;
                al.add(tuple);
            }
            result = new Set(al.toArray(new Tuple[0]));
        }
        return result;
    }

    @Override
    public IIterator iterator() {
        return new SetIterator(this);
    }

    @Override
    public IIterator iterator(long start, long count) {
        return new SetIterator(this, start, count);
    }

    public IScrollableIterator getScrollableIterator() {
        return new SetScrollableIterator(this);
    }

    public IIterator dimensionOrderedIterator(IDimension[] dimensionOrder) {
        return new DimensionOrderedSetIterator(this, dimensionOrder);
    }

    @Override
    public int compareTo(Object other) {
        if (null == other || !(other instanceof ISet)) {
            return -1;
        }
        ISet otherSet = (ISet)other;
        if (this.size() < otherSet.size()) {
            return -1;
        }
        if (this.size() > otherSet.size()) {
            return 1;
        }
        ResourceMonitor.checkMaxSetSize(this.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        CompareToBuilder ctb = new CompareToBuilder();
        for (long i = 0L; i < this.size(); ++i) {
            ctb.append((Object)this.getTuple(i), (Object)otherSet.getTuple(i));
        }
        return ctb.toComparison();
    }

    public boolean equals(Object o) {
        if (null == o || !(o instanceof ISet)) {
            return false;
        }
        ISet otherSet = (ISet)o;
        if (this.size() != otherSet.size()) {
            return false;
        }
        ResourceMonitor.checkMaxSetSize(this.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        for (long i = 0L; i < this.size(); ++i) {
            if (this.getTuple(i).equals(otherSet.getTuple(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        ResourceMonitor.checkMaxSetSize(this.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        for (long i = 0L; i < this.size(); ++i) {
            hcb.append((Object)this.getTuple(i));
        }
        return hcb.toHashCode();
    }

    public IMember getPtdLastChild() {
        return this.ptdLastChild;
    }

    public void setPtdLastChild(IMember lastChild) {
        this.ptdLastChild = lastChild;
    }

    public IMember getEmptyChildrenSetParentMember() {
        return this.mEmptyChildrenSetParentMember;
    }

    public void setEmptyChildrenSetParentMember(IMember emptyChildrenSetParentMember) {
        this.mEmptyChildrenSetParentMember = emptyChildrenSetParentMember;
    }

    public IMetadata getRelativeTimeAncestorObject() {
        return this.mRelativeTimeAncestorObject;
    }

    public void setRelativeTimeAncestorObject(IMetadata relativeTimeAncestorObject) {
        this.mRelativeTimeAncestorObject = relativeTimeAncestorObject;
    }

    public long sizeOf() {
        long size = JavaObjectMemorySize.getJavaObjectSize(1L, 10L);
        if (this.tupleList != null) {
            long sizePerTuple = JavaObjectMemorySize.getJavaObjectSize(2L, 2L + (long)this.tupleList.width());
            size += this.tupleList.listSize() * sizePerTuple;
        }
        return size;
    }

    public static long crossjoinSize(ISet[] sets) {
        if (sets.length == 0) {
            return 0L;
        }
        long size = 1L;
        for (int i = 0; i < sets.length; ++i) {
            long setSize = sets[i].size();
            if (setSize < 0L) {
                return setSize;
            }
            if ((size = NumberOp.multiplyQuantities(size, setSize)) >= 0L) continue;
            return size;
        }
        return size;
    }

    @Override
    public boolean isLargeSet() {
        long size = this.size();
        return size < 0L;
    }

    public boolean isAsymmetricSet() {
        if (this.isEmpty()) {
            return false;
        }
        long requiredTuples = this.size();
        double symmetricTuples = 1.0;
        IMember[][] members = this.getMembers(this.getHierarchies());
        for (int j = 0; j < members.length; ++j) {
            symmetricTuples *= (double)members[j].length;
        }
        return (double)requiredTuples < symmetricTuples;
    }

    public void recordSetSizeRequestMetric() {
        RequestEnvironment reqEnv = (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
        RequestMetrics reqMetrics = reqEnv.getRequestMetrics();
        reqMetrics.setBiggestSetSize(this.noOverflowSize());
    }

    public final class DimensionOrderedSetIterator
    extends SetIterator {
        private final HashMap<IDimension, Integer> dimensionToIndex;

        private DimensionOrderedSetIterator(Set cjs, IDimension[] dimensionOrder) {
            super(cjs);
            this.dimensionToIndex = new HashMap();
            for (int i = 0; i < dimensionOrder.length; ++i) {
                this.dimensionToIndex.put(dimensionOrder[i], new Integer(i));
            }
        }

        @Override
        public Object next() {
            Tuple t = (Tuple)super.next();
            IMember[] members = new IMember[t.size()];
            for (int i = 0; i < members.length; ++i) {
                IMember m = t.getMember(i);
                Integer index = this.dimensionToIndex.get(m.getDimension());
                members[index.intValue()] = m;
            }
            t = new Tuple(members, false);
            return t;
        }
    }

    public final class SetScrollableIterator
    implements IScrollableIterator {
        private final Set set;
        private long iteratorPosition = -1L;

        private SetScrollableIterator(Set s) {
            this.set = s;
        }

        @Override
        public boolean absolute(long index) {
            if (index < 0L) {
                return false;
            }
            if (index < this.set.size()) {
                this.iteratorPosition = index;
                return true;
            }
            return false;
        }

        @Override
        public Object current() {
            if (this.iteratorPosition < 0L) {
                return null;
            }
            return this.set.getTuple(this.iteratorPosition);
        }

        @Override
        public boolean hasPrevious() {
            return this.iteratorPosition > 0L;
        }

        @Override
        public Object previous() {
            if (!this.hasPrevious()) {
                return null;
            }
            --this.iteratorPosition;
            return this.current();
        }

        @Override
        public void reset() {
            this.iteratorPosition = -1L;
        }

        @Override
        public long getIndex() {
            return this.iteratorPosition;
        }

        public Object nextImpl() {
            if (this.iteratorPosition + 1L >= this.set.size()) {
                return null;
            }
            if (Set.this.cancelManager != null && Set.this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            return this.set.getTuple(++this.iteratorPosition);
        }

        public long size() {
            return this.set.size();
        }

        @Override
        public void release() {
        }

        @Override
        public boolean hasNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object next() {
            return this.nextImpl();
        }
    }

    private class SetIterator
    implements IIterator {
        private final Set set;
        private long index = 0L;
        private long lastTupleOrdinal;
        private final Dimension[] currentMemberDims;

        SetIterator(Set s) {
            this.set = s;
            this.lastTupleOrdinal = s.size();
            this.currentMemberDims = s.getCurrentMemberDimensions();
        }

        SetIterator(Set s, long start, long count) {
            this.set = s;
            this.index = start;
            this.lastTupleOrdinal = start + count > s.size() ? s.size() : start + count;
            this.currentMemberDims = s.getCurrentMemberDimensions();
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.lastTupleOrdinal;
        }

        @Override
        public Object next() {
            Tuple t = null;
            if (this.hasNext()) {
                if (Set.this.cancelManager != null && Set.this.cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                t = (Tuple)this.set.getTuple(this.index++);
                if (this.currentMemberDims.length > 0) {
                    t.addCurrentMemberDimensions(this.currentMemberDims);
                }
                Tuple tupleToReturn = new Tuple(new IMember[t.getMembers().length], false);
                tupleToReturn.addCurrentMemberDimensions(this.currentMemberDims);
                IMember[] sourceMembers = t.getMembers();
                tupleToReturn.setMembers(sourceMembers);
                t = tupleToReturn;
            }
            return t;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void release() {
        }
    }
}

