/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.util.ArrayCast;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class SetSelections {
    private Set set;
    private Collection<IMember>[] selections;

    public SetSelections(ISet theSet) {
        this.set = (Set)theSet;
    }

    public SetSelections(Collection<IMember>[] theSelections) {
        this.selections = theSelections;
    }

    public SetSelections(ISet theSet, Collection<IMember>[] theSelections) {
        this.set = (Set)theSet;
        this.selections = theSelections;
    }

    public Set getSet() {
        if (this.set == null) {
            this.set = BlockTupleStorageUtil.createCjsFromMemberSelections(this.selections);
        }
        return this.set;
    }

    public Set getSet(IHierarchy[] hiers) {
        IHierarchy[] setHiers;
        if (this.set != null && (setHiers = this.set.getHierarchies()).length == hiers.length) {
            boolean allHiersSame = true;
            for (int i = 0; i < hiers.length && allHiersSame; ++i) {
                allHiersSame = setHiers[i] == hiers[i];
            }
            if (allHiersSame) {
                return this.set;
            }
        }
        Collection<IMember>[] members = this.getSelections(hiers, false);
        return BlockTupleStorageUtil.createCjsFromMemberSelections(members);
    }

    public Collection<IMember>[] getSelections(Hierarchy[] hiers) {
        return this.getSelections(hiers, false);
    }

    public Collection<IMember>[] getSelections(IHierarchy[] hiers, boolean recalculate) {
        if (this.selections == null || hiers != null && this.selections.length != hiers.length || recalculate) {
            if (hiers == null) {
                hiers = this.getSet().getHierarchies();
            }
            this.selections = this.getSet().selectionsInHierarchies(hiers);
        } else if (hiers != null) {
            for (int i = 0; i < this.selections.length; ++i) {
                IMember sel;
                Iterator<IMember> it = this.selections[i].iterator();
                if (!it.hasNext() || (sel = it.next()).getHierarchy().equals(hiers[i])) continue;
                return this.getSelections(hiers, true);
            }
        }
        return this.selections;
    }

    public IMember[][] getSelectionsArrays(IHierarchy[] hiers, boolean recalculate) {
        Collection<IMember>[] selColls = this.getSelections(hiers, recalculate);
        IMember[][] selArrays = new IMember[selColls.length][];
        for (int i = 0; i < selColls.length; ++i) {
            selArrays[i] = selColls[i].toArray(new IMember[selColls[i].size()]);
        }
        return selArrays;
    }

    public static Collection<IMember>[] copySelections(Collection<IMember>[] theSelections) {
        Collection[] copiedSelections = (Collection[])ArrayCast.uncheckedCast(new Collection[theSelections.length]);
        for (int j = 0; j < theSelections.length; ++j) {
            copiedSelections[j] = new HashSet<IMember>(theSelections[j]);
        }
        return copiedSelections;
    }

    public static SetSelections createSetSelections(Collection<IMember>[] originalSelections, Collection<IMember> measures, int measuresIndex) {
        Collection<IMember>[] newSelections = Arrays.copyOf(originalSelections, originalSelections.length);
        newSelections[measuresIndex] = new HashSet<IMember>(measures);
        return new SetSelections(newSelections);
    }

    public long size() {
        if (this.set != null) {
            return this.set.size();
        }
        long size = this.selections[0].size();
        for (int i = 1; i < this.selections.length; ++i) {
            size *= (long)this.selections[i].size();
        }
        return size;
    }

    public SetSelections selectionExcept(SetSelections exceptSet, Hierarchy[] hierarchies) {
        Collection<IMember>[] coveredSelections = exceptSet.getSelections(hierarchies);
        Collection<IMember>[] remainderSelections = SetSelections.copySelections(this.getSelections(hierarchies));
        int numReducedHierarchies = 0;
        int reducedHierIdx = -1;
        for (int k = 0; k < coveredSelections.length && numReducedHierarchies < 2; ++k) {
            if (coveredSelections[k].size() == remainderSelections[k].size()) continue;
            ++numReducedHierarchies;
            reducedHierIdx = k;
        }
        if (numReducedHierarchies == 1) {
            remainderSelections[reducedHierIdx].removeAll(coveredSelections[reducedHierIdx]);
        }
        return new SetSelections(remainderSelections);
    }

    public int numHierarchiesReduced(SetSelections coveredSet, Hierarchy[] hierarchies) {
        Collection<IMember>[] coveredSelections = coveredSet.getSelections(hierarchies);
        Collection<IMember>[] thisSelections = this.getSelections(hierarchies);
        int numReducedHierarchies = 0;
        for (int k = 0; k < coveredSelections.length; ++k) {
            if (coveredSelections[k].size() == thisSelections[k].size()) continue;
            ++numReducedHierarchies;
        }
        return numReducedHierarchies;
    }
}

