/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.data.values.NullContextFlagValue;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import java.util.Iterator;
import java.util.TreeSet;

public class TreeSetExpandingBlockIterator
implements IBlockIterator {
    private final IBlockIterator blockIter;
    private Iterator<Cell> cellIter = null;
    private long currentContextOrdinal = -1L;
    private Object[] blockIterReturnArray;
    private final Cell[] cellArray = new Cell[1];
    private TreeSet<Cell> treeSetForEmptyContexts = null;
    private final int streamingPosition;

    public TreeSetExpandingBlockIterator(IBlockIterator aBlockIter, int streamingBlockPosition) {
        this.blockIter = aBlockIter;
        this.streamingPosition = streamingBlockPosition;
        this.treeSetForEmptyContexts = new TreeSet();
        NullContextFlagValue nullContextFlagValue = NullContextFlagValue.NULLCONTEXTFLAGVALUE;
        this.treeSetForEmptyContexts.add(new Cell(0L, nullContextFlagValue));
        this.advanceBlockIter();
    }

    private void advanceBlockIter() {
        if (this.blockIter.hasNext()) {
            this.blockIterReturnArray = (Object[])this.blockIter.next();
            this.currentContextOrdinal = this.blockIter.pos();
            if (this.blockIterReturnArray[this.streamingPosition] == null) {
                this.cellIter = this.treeSetForEmptyContexts.iterator();
            } else {
                TreeSet cellSet = (TreeSet)this.blockIterReturnArray[this.streamingPosition];
                this.cellIter = cellSet.iterator();
                if (!this.cellIter.hasNext()) {
                    this.cellIter = this.treeSetForEmptyContexts.iterator();
                }
            }
        } else {
            this.blockIterReturnArray = null;
            this.cellIter = null;
        }
    }

    @Override
    public boolean hasNext() {
        while (this.cellIter != null) {
            boolean currentCellIterHasNext = this.cellIter.hasNext();
            if (currentCellIterHasNext) {
                return true;
            }
            this.advanceBlockIter();
        }
        return false;
    }

    @Override
    public Object next() {
        if (this.hasNext()) {
            Cell c = this.cellIter.next();
            this.cellArray[0] = c.getValue() == NullContextFlagValue.NULLCONTEXTFLAGVALUE ? new Cell(this.currentContextOrdinal, NullContextFlagValue.NULLCONTEXTFLAGVALUE) : new Cell(this.currentContextOrdinal, c);
            this.blockIterReturnArray[this.streamingPosition] = this.cellArray;
            return this.blockIterReturnArray;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long pos() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAtDefaultValuePos() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITuple getCurrentTuple() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMember getMeasuresForAllTuples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getBlockOrdSurrogateId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlockOrdSurrogateId(long surrogateId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean returnsCellArray() {
        return true;
    }
}

