/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.data.IXmlSerializable;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterRuntimeException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SingleHierarchySimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.AggregateMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPSecurityPaddingMemberProxy;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class Tuple
implements ITuple,
Comparable<Object>,
IXmlSerializable {
    private static final long serialVersionUID = 1L;
    private static final int LONG_BIT_COUNT = 64;
    private static final int MAX_LONGS_FOR_DIMENSIONALITY = 20;
    private static final int HASHCODE_PRIME_1 = 17;
    private static final int HASHCODE_PRIME_2 = 37;
    private IMember[] members;
    private boolean containsCalculation;
    private boolean checkedForCalc;
    private int hashCode;
    private HashSet<IDimension> currentMemberDimensions;
    public static final int TUPLE_CONTAINS_ALLREGULAR_MEMBERS = 0;
    public static final int TUPLE_CONTAINS_NULL_MEMBER = 1;
    public static final int TUPLE_CONTAINS_PADDING_MEMBER = 2;
    public static final int TUPLE_CONTAINS_CALCULATED_MEMBER = 4;
    private ICube cube;

    public static ITupleList createTupleList(IMember[] members) {
        return SingleHierarchySimpleTupleList.construct(members);
    }

    public static Tuple[] createTuplePerMember(IMember[] members) {
        Tuple[] tuples = new Tuple[members.length];
        for (int i = 0; i < members.length; ++i) {
            tuples[i] = new Tuple(members[i]);
        }
        return tuples;
    }

    public Tuple() {
        this(new IMember[0], false);
    }

    public Tuple(IMember mem) {
        this(new IMember[]{mem}, false);
    }

    public Tuple(IMember mem, ICube c) {
        this(new IMember[]{mem}, false, c);
    }

    public Tuple(Tuple clone) {
        this.members = new IMember[clone.members.length];
        System.arraycopy(clone.members, 0, this.members, 0, this.members.length);
        this.containsCalculation = clone.containsCalculation;
        this.checkedForCalc = clone.checkedForCalc;
        this.hashCode = clone.hashCode;
    }

    public Tuple(IMember[] mems) {
        this(mems, true, null);
    }

    public Tuple(IMember[] mems, ICube c) {
        this(mems, true, c);
    }

    public Tuple(IMember[] mems, boolean checkTuple) {
        this(mems, checkTuple, null);
    }

    public Tuple(IMember[] mems, boolean checkTuple, ICube c) {
        this.cube = c;
        this.hashCode = -1;
        this.members = mems;
        if (checkTuple) {
            this.checkDimensionality();
        }
    }

    public void addCurrentMemberDimension(IDimension d) {
        if (this.currentMemberDimensions == null) {
            this.currentMemberDimensions = new HashSet();
        }
        this.currentMemberDimensions.add(d);
    }

    public void addCurrentMemberDimensions(IDimension[] ds) {
        if (this.currentMemberDimensions == null) {
            this.currentMemberDimensions = new HashSet();
        }
        this.currentMemberDimensions.addAll(Arrays.asList(ds));
    }

    public Dimension[] getCurrentMemberDimensions() {
        if (this.currentMemberDimensions == null) {
            return new Dimension[0];
        }
        return this.currentMemberDimensions.toArray(new Dimension[0]);
    }

    public boolean containsNullMember() {
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i] == null || !(this.members[i] instanceof NullMember)) continue;
            return true;
        }
        return false;
    }

    public int getTupleType() {
        int tupleType = 0;
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i] instanceof NullMember) {
                tupleType |= 1;
                continue;
            }
            if (this.members[i] instanceof ROLAPSecurityPaddingMemberProxy) {
                tupleType |= 2;
                continue;
            }
            if (this.checkedForCalc || this.containsCalculation || !this.members[i].isCalculatedMember()) continue;
            this.containsCalculation = true;
        }
        if (this.containsCalculation) {
            tupleType |= 4;
        }
        this.checkedForCalc = true;
        return tupleType;
    }

    public static boolean containsNullMember(int tupleType) {
        return (tupleType & 1) != 0;
    }

    public static boolean containsPaddingMember(int tupleType) {
        return (tupleType & 2) != 0;
    }

    public static boolean containsCalculatedMember(int tupleType) {
        return (tupleType & 4) != 0;
    }

    public static boolean containsAllRegularMember(int tupleType) {
        return tupleType == 0;
    }

    public boolean containsNullTag() {
        for (int i = 0; i < this.members.length; ++i) {
            CalculatedMember cm;
            Boolean isNullTag;
            if (this.members[i] == null || !this.members[i].isCalculatedMember() || (isNullTag = (Boolean)(cm = (CalculatedMember)this.members[i]).getProperty("nullTag")) == null || !isNullTag.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ITuple)) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return Arrays.equals(this.members, tuple.members);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = 17;
            for (int i = 0; i < this.members.length; ++i) {
                this.hashCode = 37 * this.hashCode + this.members[i].hashCode();
            }
        }
        return this.hashCode;
    }

    public void recalcHashcode() {
        this.hashCode = -1;
    }

    public void removeCurrentMemberDimensions() {
        this.currentMemberDimensions = new HashSet();
    }

    @Override
    public ITuple remove(IDimension d) {
        this.recalcHashcode();
        ArrayList<IMember> mems = new ArrayList<IMember>();
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i].getDimension().equals(d)) continue;
            mems.add(this.members[i]);
        }
        return new Tuple(mems.toArray(new IMember[mems.size()]), false, this.cube);
    }

    @Override
    public ITuple remove(IHierarchy h) {
        this.recalcHashcode();
        ArrayList<IMember> mems = new ArrayList<IMember>();
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i] == null || this.members[i].getHierarchy().equals(h)) continue;
            mems.add(this.members[i]);
        }
        return new Tuple(mems.toArray(new IMember[mems.size()]), false, this.cube);
    }

    public boolean containsCalculation() {
        if (!this.checkedForCalc) {
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i] == null || !this.members[i].isCalculatedMember()) continue;
                this.containsCalculation = true;
                break;
            }
            this.checkedForCalc = true;
        }
        return this.containsCalculation;
    }

    public boolean containsMeasure() {
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i] == null || !this.members[i].isMeasure()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<AggregateMember> getAggregateMembers() {
        ArrayList<AggregateMember> aggregateMembers = new ArrayList<AggregateMember>();
        for (int i = 0; i < this.members.length; ++i) {
            if (!(this.members[i] instanceof CalculatedMember) || !((CalculatedMember)this.members[i]).isAggregateMember()) continue;
            aggregateMembers.add((AggregateMember)this.members[i]);
        }
        return aggregateMembers;
    }

    public int getHierarchyIndex(IHierarchy h) {
        for (int i = 0; i < this.members.length; ++i) {
            IMember member = this.members[i];
            if (member == null || !member.getHierarchy().equals(h)) continue;
            return i;
        }
        return -1;
    }

    public int getDimensionIndex(IDimension d) {
        for (int i = 0; i < this.members.length; ++i) {
            IMember member = this.members[i];
            if (member == null || !member.getDimension().equals(d)) continue;
            return i;
        }
        return -1;
    }

    public void addMember(IMember m) {
        this.recalcHashcode();
        int idx = 0;
        idx = this.multipleHierarchySupport() ? this.getHierarchyIndex(m.getHierarchy()) : this.getDimensionIndex(m.getDimension());
        if (idx >= 0) {
            this.replaceMember(idx, m);
        } else {
            IMember[] temp = new IMember[this.members.length + 1];
            for (int i = 0; i < this.members.length; ++i) {
                temp[i] = this.members[i];
            }
            temp[this.members.length] = m;
            this.members = temp;
        }
    }

    public void replaceMember(int index, IMember m) {
        this.recalcHashcode();
        this.members[index] = m;
    }

    public Tuple removeNullMembers() {
        Tuple whereTuple = this;
        if (whereTuple.containsNullMember()) {
            ArrayList<IMember> whereMembers = new ArrayList<IMember>();
            int sz = whereTuple.size();
            for (int k = 0; k < sz; ++k) {
                IMember m = whereTuple.getMember(k);
                if (m instanceof NullMember) continue;
                whereMembers.add(m);
            }
            IMember[] newWhereTuple = whereMembers.toArray(new IMember[0]);
            whereTuple = new Tuple(newWhereTuple, this.cube);
        }
        return whereTuple;
    }

    private void checkDimensionality() {
        long[] seen = new long[20];
        if (this.members.length > 0) {
            int hierCubeIndex = 0;
            if (this.multipleHierarchySupport()) {
                Hierarchy h = (Hierarchy)this.members[0].getHierarchy();
                hierCubeIndex = this.cube != null ? h.getOrdinal(this.cube.getName()) : h.getOrdinal();
            } else {
                Dimension d = (Dimension)this.members[0].getDimension();
                hierCubeIndex = this.cube != null ? d.getIndex(this.cube.getName()) : d.getIndex();
            }
            seen[hierCubeIndex / 64] = 1L << hierCubeIndex % 64;
        }
        for (int i = 1; i < this.members.length; ++i) {
            IMember mem = this.members[i];
            if (mem == null) continue;
            int hierCubeIndex = 0;
            if (this.multipleHierarchySupport()) {
                Hierarchy h = (Hierarchy)mem.getHierarchy();
                hierCubeIndex = this.cube != null && h instanceof IROLAPHierarchy && ((IROLAPHierarchy)((Object)h)).isShared() ? ((IROLAPHierarchy)((Object)h)).getOrdinal(this.cube.getName()) : h.getOrdinal();
            } else {
                Dimension d = (Dimension)mem.getDimension();
                hierCubeIndex = this.cube != null ? d.getIndex(this.cube.getName()) : d.getIndex();
            }
            if ((seen[hierCubeIndex / 64] & 1L << hierCubeIndex % 64) > 0L) {
                throw new InterpreterRuntimeException("X01442", new String[]{((Hierarchy)mem.getHierarchy()).getName()});
            }
            seen[hierCubeIndex / 64] = seen[hierCubeIndex / 64] | 1L << hierCubeIndex % 64;
        }
    }

    public boolean multipleHierarchySupport() {
        if (this.members.length == 0) {
            return false;
        }
        Cube dimCube = this.cube != null ? (Cube)this.cube : (Cube)this.members[0].getDimension().getCube();
        return dimCube.multipleHierarchySupport();
    }

    public int[] getDimensionality() throws InterpreterRuntimeException {
        Dimension d;
        int index;
        Hierarchy h;
        long[] seen = new long[20];
        int[] dimensionality = new int[this.members.length];
        if (this.members.length > 0) {
            if (this.multipleHierarchySupport()) {
                h = (Hierarchy)this.members[0].getHierarchy();
                index = this.cube != null ? h.getOrdinal(this.cube.getName()) : h.getOrdinal();
            } else {
                d = (Dimension)this.members[0].getDimension();
                index = this.cube != null ? d.getIndex(this.cube.getName()) : d.getIndex();
            }
            seen[index / 64] = 1L << index % 64;
            dimensionality[0] = (byte)index;
        }
        for (int i = 1; i < this.members.length; ++i) {
            if (this.multipleHierarchySupport()) {
                h = (Hierarchy)this.members[i].getHierarchy();
                index = h instanceof IROLAPHierarchy && ((IROLAPHierarchy)((Object)h)).isShared() && this.cube != null ? ((IROLAPHierarchy)((Object)h)).getOrdinal(this.cube.getName()) : h.getOrdinal();
            } else {
                d = (Dimension)this.members[i].getDimension();
                index = this.cube != null ? d.getIndex(this.cube.getName()) : d.getIndex();
            }
            if ((seen[index / 64] & 1L << index % 64) > 0L) {
                if (this.multipleHierarchySupport()) {
                    throw new InterpreterRuntimeException("X01442", new String[]{((Hierarchy)this.members[i].getHierarchy()).getName()});
                }
                throw new InterpreterRuntimeException("X01442", new String[]{((Dimension)this.members[i].getDimension()).getName()});
            }
            seen[index / 64] = seen[index / 64] | 1L << index % 64;
            dimensionality[i] = (byte)index;
        }
        return dimensionality;
    }

    @Override
    public IDimension[] getDimensions() {
        IDimension[] result = new Dimension[this.members.length];
        for (int i = 0; i < result.length; ++i) {
            if (this.members[i] == null) continue;
            result[i] = (Dimension)this.members[i].getDimension();
        }
        return result;
    }

    @Override
    public int size() {
        return this.members.length;
    }

    @Override
    public IMember getMember(int index) {
        return this.members[index];
    }

    @Override
    public boolean contains(IMember m) {
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i] == null || !this.members[i].equals(m)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(ITuple t) {
        IMember[] tupleMembers = t.getMembers();
        for (int i = 0; i < tupleMembers.length; ++i) {
            boolean found = false;
            IMember m = tupleMembers[i];
            for (int j = 0; j < this.members.length; ++j) {
                if (this.members[j] == null || !this.members[j].equals(m)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public Tuple retain(Dimension[] dims) {
        ArrayList<IMember> mems = new ArrayList<IMember>();
        if (this.multipleHierarchySupport()) {
            block0: for (IMember mem : this.members) {
                for (Dimension dim : dims) {
                    if (!mem.getDimension().equals(dim)) continue;
                    mems.add(mem);
                    continue block0;
                }
            }
            return new Tuple(mems.toArray(new IMember[mems.size()]), this.cube);
        }
        for (int i = 0; i < dims.length; ++i) {
            IMember member = this.getMember(dims[i]);
            if (member == null) continue;
            mems.add(member);
        }
        return new Tuple(mems.toArray(new IMember[mems.size()]), this.cube);
    }

    public Tuple retain(IHierarchy[] hiers) throws InterpreterException {
        ArrayList<IMember> mems = new ArrayList<IMember>();
        for (int i = 0; i < hiers.length; ++i) {
            IMember member = this.getMember(hiers[i]);
            if (member == null) continue;
            if (mems.contains(member)) {
                throw new InterpreterRuntimeException("X01442", new String[]{hiers[i].getName()});
            }
            mems.add(member);
        }
        return new Tuple(mems.toArray(new IMember[mems.size()]), false, this.cube);
    }

    @Override
    public IMember getMember(IDimension d) {
        IMember result = null;
        boolean found = false;
        int i = 0;
        while (i < this.members.length && !found) {
            if (this.members[i] != null && this.members[i].getDimension().equals(d)) {
                found = true;
                continue;
            }
            ++i;
        }
        if (found) {
            result = this.members[i];
        }
        return result;
    }

    @Override
    public IMember getMember(IHierarchy h) {
        IMember result = null;
        boolean found = false;
        int i = 0;
        while (i < this.members.length && !found) {
            if (this.members[i] != null && this.members[i].getHierarchy().equals(h)) {
                found = true;
                continue;
            }
            ++i;
        }
        if (found) {
            result = this.members[i];
        }
        return result;
    }

    @Override
    public boolean contains(IDimension d) {
        return this.getMember(d) != null;
    }

    @Override
    public boolean contains(IHierarchy h) {
        return this.getMember(h) != null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        if (this.members.length > 0) {
            buffer.append(this.members[0].toString());
        }
        for (int i = 1; i < this.members.length; ++i) {
            buffer.append(", ");
            buffer.append(this.members[i].toString());
        }
        buffer.append(")");
        String s = buffer.toString();
        return s;
    }

    @Override
    public int compareTo(Object o) {
        Tuple t1 = this;
        Tuple t2 = (Tuple)o;
        IMember[] mems1 = t1.getMembers();
        IMember[] mems2 = t2.getMembers();
        int compare = 0;
        for (int i = 0; compare == 0 && i < mems1.length && i < mems2.length; ++i) {
            IMember m1 = mems1[i];
            IMember m2 = t2.getMember(m1.getHierarchy());
            if (m1 == null || m2 == null) continue;
            compare = m1.getUniqueName().compareTo(m2.getUniqueName());
        }
        if (compare == 0) {
            if (mems1.length > mems2.length) {
                compare = 1;
            } else if (mems1.length < mems2.length) {
                compare = -1;
            }
        }
        return compare;
    }

    @Override
    public IMember[] getMembers() {
        return this.members;
    }

    @Override
    public IHierarchy[] getHierarchies() {
        IHierarchy[] result = new IHierarchy[this.members.length];
        for (int i = 0; i < result.length; ++i) {
            if (this.members[i] == null) continue;
            result[i] = this.members[i].getHierarchy();
        }
        return result;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Tuple", -1);
        for (int idx = 0; idx < this.size(); ++idx) {
            IMember member = this.getMember(idx);
            member.toXML(xmlWriter);
        }
        xmlWriter.endElement();
    }

    @Override
    public Object copy() {
        IMember[] memberArray = new IMember[this.members.length];
        for (int i = 0; i < this.members.length; ++i) {
            memberArray[i] = null == this.members[i] ? null : (IMember)this.members[i].copy();
        }
        return new Tuple(memberArray, false, this.cube);
    }

    public void setMembers(IMember[] sourceMembers) {
        System.arraycopy(sourceMembers, 0, this.members, 0, sourceMembers.length);
        this.recalcHashcode();
    }

    public static boolean containsCalculation(IMember[] members) {
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].isCalculatedMember()) continue;
            return true;
        }
        return false;
    }

    public static int getMeasureIndex(ITuple tuple, boolean throwIfNotFound) {
        int measureIndex = -1;
        IMember[] mbrs = tuple.getMembers();
        for (int i = 0; i < mbrs.length; ++i) {
            if (!mbrs[i].isMeasure()) continue;
            measureIndex = i;
            break;
        }
        if (measureIndex == -1 && throwIfNotFound) {
            throw new XQERuntimeException();
        }
        return measureIndex;
    }

    @Override
    public ICube getCube() {
        if (this.cube != null) {
            return this.cube;
        }
        if (this.members != null) {
            for (IMember member : this.members) {
                if (member == null || !member.isMeasure() && member.getDimension().isShareable()) continue;
                this.cube = member.getDimension().getCube();
                break;
            }
        }
        if (this.cube == null) {
            throw new UnsupportedOperationException("Could not determine cube for Tuple.");
        }
        return this.cube;
    }

    @Override
    public void setCube(ICube c) {
        this.cube = c;
    }
}

