/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TupleOrdinalCalculationCache {
    private IMember[][] cachedMemberArrays = null;
    private List<long[]> cachedTupleIndexesInSetList = null;
    private final IHierarchy[] lookupTupleHierarchies;
    private final Map<ITupleList, int[]> tupleListSubTupleMap;

    public TupleOrdinalCalculationCache(CrossJoinedSet cjs) {
        this.cachedMemberArrays = new IMember[cjs.getSets().length][];
        this.lookupTupleHierarchies = null;
        this.tupleListSubTupleMap = null;
    }

    public TupleOrdinalCalculationCache(CrossJoinedSet cjs, IHierarchy[] lookupTupleHiers) {
        this.cachedMemberArrays = new IMember[cjs.getSets().length][];
        this.lookupTupleHierarchies = lookupTupleHiers;
        this.tupleListSubTupleMap = new HashMap<ITupleList, int[]>();
    }

    public IMember[] getMemberArray(int setIndex, int arraySize) {
        IMember[] array = this.cachedMemberArrays[setIndex];
        if (array == null || array.length != arraySize) {
            array = new IMember[arraySize];
            this.cachedMemberArrays[setIndex] = array;
        }
        return array;
    }

    public List<long[]> getCachedTupleIndexesInSetList() {
        if (this.cachedTupleIndexesInSetList == null) {
            this.cachedTupleIndexesInSetList = new ArrayList<long[]>();
        } else {
            this.cachedTupleIndexesInSetList.clear();
        }
        return this.cachedTupleIndexesInSetList;
    }

    public int[] getTupleListSubTupleMap(ITupleList tupleList) {
        if (this.tupleListSubTupleMap == null) {
            return null;
        }
        int[] subTupleMap = this.tupleListSubTupleMap.get(tupleList);
        if (subTupleMap != null) {
            return subTupleMap;
        }
        IHierarchy[] tlHiers = tupleList.iterator().next().getHierarchies();
        subTupleMap = new int[tlHiers.length];
        block0: for (int tlHierIdx = 0; tlHierIdx < tlHiers.length; ++tlHierIdx) {
            for (int ltHierIdx = 0; ltHierIdx < this.lookupTupleHierarchies.length; ++ltHierIdx) {
                if (tlHiers[tlHierIdx] != this.lookupTupleHierarchies[ltHierIdx]) continue;
                subTupleMap[tlHierIdx] = ltHierIdx;
                continue block0;
            }
        }
        this.tupleListSubTupleMap.put(tupleList, subTupleMap);
        return subTupleMap;
    }
}

