/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.TestEnvironmentOptions;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.ConsumerEndedException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.IPipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.OtherProducerHadError;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import java.util.concurrent.Callable;

public abstract class PipelineCallable<V>
implements Callable<V> {
    private final IPipelineResultSet pipelineRS;
    private static final String TASK_DESCRIPTION = "PipelineResultSet producer thread: ";

    public PipelineCallable(IPipelineResultSet pipelineResultSet) {
        this.pipelineRS = pipelineResultSet;
        this.iStreamAsynchronouslyThereforeIam();
    }

    @Override
    public V call() throws Exception {
        V returnObject = null;
        try {
            this.pipelineRS.executeDeferredProducerAdditions();
            returnObject = this.callImpl();
        }
        catch (Throwable t) {
            if (XQERuntimeException.isACause(t, OtherProducerHadError.class)) {
                ROLAPLog.log("ROLAPPipeline", "Thread stopped because other producer had an error.");
            } else if (XQERuntimeException.isACause(t, ConsumerEndedException.class)) {
                ROLAPLog.log("ROLAPPipeline", "Thread stopped because the pipeline consumer ended.");
                this.pipelineRS.setProducerError(t);
            } else {
                this.pipelineRS.setProducerError(t);
            }
        }
        finally {
            this.pipelineRS.producersComplete();
        }
        return returnObject;
    }

    public abstract V callImpl() throws Exception;

    protected IPipelineResultSet getPipelineRS() {
        return this.pipelineRS;
    }

    private void iStreamAsynchronouslyThereforeIam() {
        TestEnvironmentOptions.TestHitCountTracker thct = TestEnvironmentOptions.TestHitCountTracker.current();
        if (thct != null) {
            thct.incrementNumberOfPipelineCallables();
        }
    }

    public String toString() {
        return TASK_DESCRIPTION + super.toString();
    }
}

