/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelinePacket;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PipelineIterator
implements IResultSetIterator {
    PipelineResultSet pResultSet;
    PipelinePacket nextPipelinePacket;
    private Iterator<ICell> packetCellIterator = null;
    private int positionInPacket = 0;
    private boolean loggedEndOfStreamMsg = false;
    private CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();

    public PipelineIterator(PipelineResultSet pipelineResultSet) {
        this.pResultSet = pipelineResultSet;
    }

    @Override
    public boolean hasNext() {
        if (this.nextPipelinePacket == null || !this.packetCellIterator.hasNext()) {
            this.nextPacket();
        }
        if (this.nextPipelinePacket.isEndOfStreamPacket()) {
            if (!this.loggedEndOfStreamMsg && ROLAPLog.isOn("ROLAPPipeline", LogLevel.INFO)) {
                this.logEndOfStream();
            }
            return false;
        }
        return true;
    }

    private void nextPacket() {
        this.nextPipelinePacket = this.pResultSet.getNextPipelinePacket();
        this.packetCellIterator = this.nextPipelinePacket.getCells().iterator();
        this.positionInPacket = 0;
    }

    @Override
    public ICell next() {
        if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
            throw new OperationCanceledException();
        }
        XQERuntimeException producerError = this.pResultSet.getProducerError();
        if (producerError != null) {
            throw producerError;
        }
        if (this.packetCellIterator == null || !this.packetCellIterator.hasNext()) {
            this.nextPacket();
        }
        if (this.nextPipelinePacket.isEndOfStreamPacket()) {
            if (!this.loggedEndOfStreamMsg && ROLAPLog.isOn("ROLAPPipeline", LogLevel.INFO)) {
                this.logEndOfStream();
            }
            throw new NoSuchElementException();
        }
        if (this.nextPipelinePacket.isErrorPacket()) {
            throw this.pResultSet.getProducerError();
        }
        ++this.positionInPacket;
        return this.packetCellIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot call remove on PipelineIterator.");
    }

    @Override
    public ICell peek() {
        ICell nextCell = null;
        if (this.hasNext()) {
            if (this.nextPipelinePacket.isErrorPacket()) {
                throw this.pResultSet.getProducerError();
            }
            nextCell = this.nextPipelinePacket.getCells().get(this.positionInPacket);
        }
        return nextCell;
    }

    private void logEndOfStream() {
        this.loggedEndOfStreamMsg = true;
        ROLAPLog.log("ROLAPPipeline", String.format("Pipeline iterator ended, total of %,d cells were pipelined, %,d duplicate cells were discarded, %,dms spent waiting to enqueue cells.", this.pResultSet.cellCount(), this.pResultSet.getDuplicateCellCount(), this.pResultSet.getTotalCellEnqueueWaitTime()));
    }
}

