/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.SessionContext;
import com.cognos.xqe.query.engine.TestEnvironmentOptions;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetConfiguration;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.ConsumerEndedException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.IPipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.OtherProducerHadError;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelineIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelinePacket;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.storage.ICellStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQESoftLongPool;
import com.cognos.xqe.util.primitive.HashSetLong;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class PipelineResultSet
extends AbstractResultSet
implements IPipelineResultSet {
    private static final String TRUE = "true";
    public static final String DISABLEPIPELINE_REPORTS_JVM_PARAM = "disablePipelineReports";
    public static final String PIPELINECALCULATEDMEMBERS = "pipelineCalculatedMembers";
    public static final boolean PIPELINENONROLAP = System.getProperty("pipelineNonROLAP") != null;
    public static final int DEFAULT_MAX_PIPELINE_SIZE = 50;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 100;
    public static final int DEFAULT_EQUEUE_CELL_WAIT_TIME = 120000;
    public static final Cell EOSCELL = new Cell(-1L, "End of the stream", false, false);
    public static final ICell ERRORCELL = new Cell(-1L, "Producer error", false, false);
    private static int maxQueueSize = 50;
    private static int queueChunkSize = 100;
    private static int cellEnqueueWaitTime = 120000;
    private PipelineIterator pipelineIterator = null;
    private BlockingQueue<List<ICell>> cellQueue = null;
    private volatile boolean producersCompleted = false;
    private final HashSetLong possibleDuplicateOrdinals = new HashSetLong();
    private final HashSetLong addedOrdinalsWhenNoDupsShouldOccur;
    private final AtomicInteger numProducersAddingCells = new AtomicInteger(0);
    private final AtomicInteger cellCount = new AtomicInteger(0);
    private final AtomicInteger duplicateCellCount = new AtomicInteger(0);
    private volatile XQERuntimeException producerError = null;
    private SessionContext consumerContext;
    private String consumerRequestIdAndContext;
    private final Object lockObject = new Object();
    private volatile boolean waitingOnCell = false;
    private final Map<Long, ProducerThreadData> pendingDataByProducer = new ConcurrentHashMap<Long, ProducerThreadData>();
    private volatile boolean trackAddedCellsAsPossibleFutureDuplicates = true;
    private final long consumerThreadId = Thread.currentThread().getId();
    private final boolean traceLoggingOn;
    private AtomicLong lastEnqueueEndWaitTime = new AtomicLong();
    private AtomicLong totalWaitTime = new AtomicLong();
    private static final String UNSUPPORTED_OP = "Operation not supported at this time.";

    @Override
    public boolean isPipelining() {
        return true;
    }

    @Override
    public boolean supportsParallelAccess() {
        return true;
    }

    public static boolean supportCalculatedMembersWithPipelining() {
        String value = System.getProperty(PIPELINECALCULATEDMEMBERS, TRUE);
        return TRUE.equalsIgnoreCase(value);
    }

    private static boolean usePipelining(ICube cube) {
        String disablePipelineReportStr;
        boolean usePipeline;
        boolean bl = usePipeline = cube instanceof IROLAPCube || PIPELINENONROLAP;
        if (cube instanceof IROLAPCube && (disablePipelineReportStr = System.getProperty(DISABLEPIPELINE_REPORTS_JVM_PARAM)) != null) {
            if (disablePipelineReportStr.equals("*")) {
                usePipeline = false;
            } else {
                String[] reportNames;
                ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
                String reportName = ((RequestEnvironment)execEnv.getRequestEnvironment()).getReportName();
                for (String name : reportNames = disablePipelineReportStr.split(",")) {
                    if (!name.equals(reportName)) continue;
                    usePipeline = false;
                    break;
                }
            }
        }
        if (ROLAPLog.isOn("ROLAPPipeline", LogLevel.INFO)) {
            ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            String reportName = ((RequestEnvironment)execEnv.getRequestEnvironment()).getReportName();
            String reportStr = "Report ";
            if (usePipeline) {
                ROLAPLog.log("ROLAPPipeline", reportStr + reportName + " is using pipelining.");
            } else {
                ROLAPLog.log("ROLAPPipeline", reportStr + reportName + " is not using pipelining.");
            }
        }
        return usePipeline;
    }

    public static boolean usePipelining(InterpreterContext iContext) {
        ResultSetConfiguration config = iContext.getResultSetConfiguration();
        if (iContext.inPrimingPhase()) {
            return false;
        }
        return config.isSupportPipelineProcessing() && PipelineResultSet.usePipelining(iContext.getCube());
    }

    public static void setBlockingQueryMaxSize(int queueSize, int chunkSize) {
        maxQueueSize = queueSize;
        queueChunkSize = chunkSize;
    }

    public static void setCellEnqueueWaitTime(int waitTime) {
        cellEnqueueWaitTime = waitTime;
    }

    public PipelineResultSet() {
        this.init();
        this.traceLoggingOn = ROLAPLog.isOn("ROLAPPipeline", LogLevel.TRACE);
        this.addedOrdinalsWhenNoDupsShouldOccur = this.initAddedOrdinalsMap();
    }

    public PipelineResultSet(InterpreterContext interpreterContext) {
        super(interpreterContext);
        this.init();
        this.traceLoggingOn = ROLAPLog.isOn("ROLAPPipeline", LogLevel.TRACE);
        this.addedOrdinalsWhenNoDupsShouldOccur = this.initAddedOrdinalsMap();
    }

    public PipelineResultSet(ISet[] a, ISet s) {
        super(a, s);
        this.init();
        this.traceLoggingOn = ROLAPLog.isOn("ROLAPPipeline", LogLevel.TRACE);
        this.addedOrdinalsWhenNoDupsShouldOccur = this.initAddedOrdinalsMap();
    }

    public PipelineResultSet(CrossJoinedSet qs) {
        super(qs);
        this.init();
        this.traceLoggingOn = ROLAPLog.isOn("ROLAPPipeline", LogLevel.TRACE);
        this.addedOrdinalsWhenNoDupsShouldOccur = this.initAddedOrdinalsMap();
    }

    private HashSetLong initAddedOrdinalsMap() {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (execEnv != null && execEnv.getTestEnvironmentOptions() != null && execEnv.getTestEnvironmentOptions().searchForUnexpectedDuplicateOrdinalsWhenPipelining()) {
            return new HashSetLong();
        }
        return null;
    }

    private void init() {
        this.iStreamThereforeIam();
        this.createCellQueue();
        this.consumerRequestIdAndContext = null;
        MultiRequestContext mrc = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContextNoThrow();
        if (mrc != null) {
            this.consumerContext = mrc.getSessionContext();
            if (this.consumerContext != null) {
                this.consumerRequestIdAndContext = this.consumerContext.getIDSString();
            }
        } else {
            this.consumerContext = null;
        }
    }

    @Override
    public void executeDeferredProducerAdditions() {
    }

    private void iStreamThereforeIam() {
        TestEnvironmentOptions.TestHitCountTracker thct = TestEnvironmentOptions.TestHitCountTracker.current();
        if (thct != null) {
            thct.incrementNumberOfPipelineResultSets();
        }
    }

    private void createCellQueue() {
        if (maxQueueSize < 2) {
            throw new IllegalArgumentException("The queue needs to hold at least two elements, one for the EOSCELL and one (possibly) for the ERRORCELL.");
        }
        this.cellQueue = new ArrayBlockingQueue<List<ICell>>(maxQueueSize, true);
    }

    public PipelineIterator getPipelineIterator() {
        if (this.pipelineIterator != null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_CanOnlyCallGetPipelineIteratorOnce);
        }
        this.pipelineIterator = new PipelineIterator(this);
        return this.pipelineIterator;
    }

    @Override
    public void producersComplete() {
        this.producersCompleted = true;
        this.addMarkerCellToQueue(EOSCELL);
        ROLAPLog.logTrace("ROLAPPipeline", "Added EndOfStream cell since producers finished.");
    }

    @Override
    public synchronized void setProducerError(Throwable t) {
        if (this.producerError == null) {
            this.producerError = t instanceof InterpreterException ? new MDXEngineException((InterpreterException)t) : (XQERuntimeException)XQERuntimeException.wrap(t);
            ROLAPLog.logTrace("ROLAPPipeline", "Producer had an " + t.toString() + " error that will be returned to the consumer.");
            this.freeAllProducers();
            this.cellQueue.clear();
            this.addMarkerCellToQueue(ERRORCELL);
        }
    }

    private void freeAllProducers() {
        while (this.numProducersAddingCells.get() > 0) {
            this.cellQueue.clear();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public XQERuntimeException getProducerError() {
        return this.producerError;
    }

    @Override
    public void addCell(ITuple tuple, Cell c) {
        this.addCellHelper(tuple, c, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProducerCellToQueue(Cell c) {
        block13: {
            if (this.producerError != null) {
                throw new OtherProducerHadError();
            }
            if (this.producersCompleted) {
                Exception e = new Exception("Producers have been marked as completed, but another cell was added.");
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)e);
            }
            try {
                ProducerThreadData producerThreadData = this.getProducerThreadData();
                List<ICell> pendingCellsForThisProducer = producerThreadData.getPendingCells();
                pendingCellsForThisProducer.add(c);
                this.cellCount.incrementAndGet();
                if (pendingCellsForThisProducer.size() == queueChunkSize) {
                    try {
                        this.numProducersAddingCells.incrementAndGet();
                        if (this.producerError != null) {
                            throw new OtherProducerHadError();
                        }
                        this.enqueCells(pendingCellsForThisProducer, true);
                        producerThreadData.resetPendingCells();
                    }
                    finally {
                        this.numProducersAddingCells.decrementAndGet();
                    }
                }
                if (!this.waitingOnCell) break block13;
                Object object = this.lockObject;
                synchronized (object) {
                    this.waitingOnCell = false;
                    this.lockObject.notifyAll();
                }
            }
            catch (InterruptedException ie) {
                throw new XQERuntimeException(ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int filterOutDupCells(List<ICell> cells) {
        int numDups = 0;
        if (this.trackAddedCellsAsPossibleFutureDuplicates) {
            HashSetLong hashSetLong = this.possibleDuplicateOrdinals;
            synchronized (hashSetLong) {
                for (int i = cells.size() - 1; i >= 0; --i) {
                    boolean ordinalNew = this.possibleDuplicateOrdinals.add(cells.get(i).getOrdinal());
                    if (ordinalNew) continue;
                    cells.remove(i);
                    ++numDups;
                }
            }
        }
        if (this.addedOrdinalsWhenNoDupsShouldOccur != null) {
            HashSetLong hashSetLong = this.addedOrdinalsWhenNoDupsShouldOccur;
            synchronized (hashSetLong) {
                for (ICell c : cells) {
                    boolean ordinalNew = this.addedOrdinalsWhenNoDupsShouldOccur.add(c.getOrdinal());
                    if (ordinalNew) continue;
                    throw new IllegalStateException("Found duplicate ordinal " + c.getOrdinal() + " after trackAddedCelssAsPossibleFutureDuplicates was set to false.");
                }
            }
        }
        if (this.possibleDuplicateOrdinals.size() > 0) {
            for (int i = cells.size() - 1; i >= 0; --i) {
                if (!this.possibleDuplicateOrdinals.contains(cells.get(i).getOrdinal())) continue;
                cells.remove(i);
                ++numDups;
            }
        }
        return numDups;
    }

    private void flushPendingCellsOntoQueue() throws InterruptedException {
        for (ProducerThreadData producerThreadData : this.pendingDataByProducer.values()) {
            List<ICell> pendingCellsFromProducer = producerThreadData.getPendingCells();
            if (pendingCellsFromProducer.size() <= 0) continue;
            this.enqueCells(pendingCellsFromProducer, true);
            producerThreadData.resetPendingCells();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMarkerCellToQueue(ICell markerCell) {
        try {
            if (markerCell == EOSCELL) {
                this.flushPendingCellsOntoQueue();
            }
            ArrayList<ICell> tempList = new ArrayList<ICell>();
            tempList.add(markerCell);
            this.enqueCells(tempList, false);
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            Object object = this.lockObject;
            synchronized (object) {
                this.lockObject.notifyAll();
            }
        }
    }

    private void enqueCells(List<ICell> cells, boolean filterDups) throws InterruptedException {
        int numDups;
        if (filterDups && (numDups = this.filterOutDupCells(cells)) > 0) {
            this.cellCount.addAndGet(numDups * -1);
            this.duplicateCellCount.addAndGet(numDups);
        }
        if (cells.size() == 0) {
            return;
        }
        long enqueueStartTime = 0L;
        if (this.cellQueue.remainingCapacity() == 0) {
            enqueueStartTime = System.currentTimeMillis();
        }
        while (!this.cellQueue.offer(cells, cellEnqueueWaitTime, TimeUnit.MILLISECONDS)) {
            if (this.consumerContext == null || this.consumerContext.isInUse() && this.consumerRequestIdAndContext.equals(this.consumerContext.getIDSString())) continue;
            throw new ConsumerEndedException(XQEMessageKeys.EXE_PipelineConsumerEnded, (Object)this.consumerRequestIdAndContext, (Object)this.consumerContext.getIDSString(), (Object)this.consumerContext.isInUse());
        }
        if (enqueueStartTime > 0L) {
            this.accumlateEnqueueWaitTime(enqueueStartTime, System.currentTimeMillis());
        }
    }

    private ProducerThreadData getProducerThreadData() {
        Long threadId = XQESoftLongPool.getLong(Thread.currentThread().getId());
        ProducerThreadData producerThreadData = this.pendingDataByProducer.get(threadId);
        if (producerThreadData == null) {
            producerThreadData = new ProducerThreadData();
            this.pendingDataByProducer.put(threadId, producerThreadData);
            if (threadId == this.consumerThreadId) {
                this.enforceProducerAndConsumerNotSameThread();
            }
        }
        return producerThreadData;
    }

    protected void enforceProducerAndConsumerNotSameThread() {
        throw new IllegalStateException("The pipeline consumer thread cannot also be a producer (deadlock risk).");
    }

    public PipelinePacket getNextPipelinePacket() {
        try {
            List<ICell> cells = this.cellQueue.take();
            return new PipelinePacket(cells);
        }
        catch (InterruptedException ie) {
            throw new XQERuntimeException(ie);
        }
    }

    public boolean isProducerComplete() {
        return this.producersCompleted;
    }

    public boolean isPipelineEmpty() {
        return this.cellQueue.isEmpty();
    }

    public boolean isPipelineFull() {
        return this.cellQueue.remainingCapacity() == 0;
    }

    @Override
    public void doNotTrackAddedCellsAsPossibleFutureDuplicates() throws InterruptedException {
        if (this.trackAddedCellsAsPossibleFutureDuplicates) {
            this.flushPendingCellsOntoQueue();
        }
        this.trackAddedCellsAsPossibleFutureDuplicates = false;
    }

    @Override
    public IResultSetIterator iterator() {
        return this.getPipelineIterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isEmpty() {
        if (this.cellCount.get() > 0) {
            return false;
        }
        if (this.producerError != null || this.producersCompleted) {
            return true;
        }
        Object object = this.lockObject;
        synchronized (object) {
            this.waitingOnCell = true;
            while (this.cellCount.get() <= 0) {
                if (this.producerError != null || this.producersCompleted) {
                    return true;
                }
                try {
                    this.lockObject.wait();
                }
                catch (InterruptedException e) {
                    throw new XQERuntimeException(e);
                }
            }
            return false;
        }
    }

    @Override
    public int cellCount() {
        return this.cellCount.get();
    }

    @Override
    public void add(IResultSet other, boolean combineExistingCells) {
        if (combineExistingCells) {
            throw new UnsupportedOperationException("PipelineResultSets cannot combine existing cells because nowhere do we have the entire set of cells.");
        }
        this.validateSameMetadataStructure(other);
        Map<String, CalculatedMember> calcedMembers = this.getCalcMembers();
        for (Map.Entry<String, CalculatedMember> otherEntry : other.getCalcMembers().entrySet()) {
            CalculatedMember myCalcMember = calcedMembers.get(otherEntry.getKey());
            if (myCalcMember == null) {
                calcedMembers.put(otherEntry.getKey(), otherEntry.getValue());
                continue;
            }
            if (myCalcMember.equals(otherEntry.getValue())) continue;
            throw new UnsupportedOperationException("Cannot add resultSets if calcedMember values are different.");
        }
        this.getCellProperties().addAll(other.getCellProperties());
        this.getTagTupleOrdinalsList().addAll(other.getTagTupleOrdinalsList());
        for (Cell otherCell : other) {
            this.addCell(new Cell(otherCell));
        }
    }

    @Override
    public ICellStorage getCellMap() {
        return null;
    }

    @Override
    public boolean getResultSetDelegateMode() {
        return false;
    }

    @Override
    public void finalizeResultSet(boolean[] nonEmptyAxes) {
    }

    @Override
    public Cell getCellAtOrdinal(long ordinal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putCell(Number ordinal, Cell cell) {
        if (this.traceLoggingOn) {
            ROLAPLog.logTrace("ROLAPPipeline", Integer.toHexString(this.hashCode()) + " PipelineRS putCell: " + cell);
        }
        this.addProducerCellToQueue(cell);
    }

    @Override
    public void setCachedCell(long index, Cell cell) {
    }

    public String toString() {
        return "PipelineResultSet: (" + this.cellCount() + " cells) " + this.cellQueue;
    }

    public int getDuplicateCellCount() {
        return this.duplicateCellCount.get();
    }

    @Override
    public boolean supportsRandomAccess() {
        return false;
    }

    @Override
    public void delegate(boolean[] nonEmptyAxes) {
        throw new UnsupportedOperationException(UNSUPPORTED_OP);
    }

    @Override
    public void undelegate() throws InterpreterException {
        throw new UnsupportedOperationException(UNSUPPORTED_OP);
    }

    @Override
    public void resetQuerySet() {
        throw new UnsupportedOperationException(UNSUPPORTED_OP);
    }

    private void accumlateEnqueueWaitTime(long myEnqueueStartTime, long myEnqueueEndTime) {
        long previousEnqueueEndTime = this.lastEnqueueEndWaitTime.get();
        boolean myEndtimeWasNewLatestTime = false;
        while (myEnqueueEndTime > previousEnqueueEndTime && !myEndtimeWasNewLatestTime) {
            myEndtimeWasNewLatestTime = this.lastEnqueueEndWaitTime.compareAndSet(previousEnqueueEndTime, myEnqueueEndTime);
            if (myEndtimeWasNewLatestTime) continue;
            previousEnqueueEndTime = this.lastEnqueueEndWaitTime.get();
        }
        if (myEndtimeWasNewLatestTime) {
            long waitStartTime = Math.max(myEnqueueStartTime, previousEnqueueEndTime);
            this.totalWaitTime.addAndGet(myEnqueueEndTime - waitStartTime);
        }
    }

    public long getTotalCellEnqueueWaitTime() {
        return this.totalWaitTime.get();
    }

    private static class ProducerThreadData {
        private List<ICell> pendingCells = new ArrayList<ICell>(PipelineResultSet.access$100());

        private ProducerThreadData() {
        }

        public List<ICell> getPendingCells() {
            return this.pendingCells;
        }

        public void resetPendingCells() {
            this.pendingCells = new ArrayList<ICell>(queueChunkSize);
        }
    }
}

