/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.TestEnvironmentOptions;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetCellIteratorDecorator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.IPipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.storage.ICellStorage;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class SynchronousPipelineResultSet
extends AbstractResultSet
implements IPipelineResultSet {
    private TreeSet<ICell> cells = null;
    private static final String UNSUPPORTED_OP = "Operation not supported at this time.";

    @Override
    public boolean isPipelining() {
        return true;
    }

    @Override
    public boolean supportsParallelAccess() {
        return false;
    }

    public SynchronousPipelineResultSet() {
        this.init();
    }

    public SynchronousPipelineResultSet(InterpreterContext interpreterContext) {
        super(interpreterContext);
        this.init();
    }

    public SynchronousPipelineResultSet(ISet[] a, ISet s) {
        super(a, s);
        this.init();
    }

    public SynchronousPipelineResultSet(CrossJoinedSet qs) {
        super(qs);
        this.init();
    }

    private void init() {
        this.iStreamThereforeIam();
        this.cells = new TreeSet();
        ROLAPLog.log("ROLAPPipeline", "Created a SynchronousPipelineResultSet");
    }

    @Override
    public void executeDeferredProducerAdditions() {
    }

    private void iStreamThereforeIam() {
        TestEnvironmentOptions.TestHitCountTracker thct = TestEnvironmentOptions.TestHitCountTracker.current();
        if (thct != null) {
            thct.incrementNumberOfPipelineResultSets();
        }
    }

    @Override
    public void producersComplete() {
    }

    @Override
    public void setProducerError(Throwable t) {
        throw XQERuntimeException.wrap(t);
    }

    @Override
    public void addCell(ITuple tuple, Cell c) {
        this.addCellHelper(tuple, c, null);
    }

    @Override
    public void doNotTrackAddedCellsAsPossibleFutureDuplicates() throws InterruptedException {
    }

    @Override
    public IResultSetIterator iterator() {
        Iterator<ICell> iter = this.cells.iterator();
        return new ResultSetCellIteratorDecorator(iter);
    }

    @Override
    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    @Override
    public int cellCount() {
        return this.cells.size();
    }

    @Override
    public void add(IResultSet other, boolean combineExistingCells) {
        if (combineExistingCells) {
            throw new UnsupportedOperationException("PipelineResultSets cannot combine existing cells because nowhere do we have the entire set of cells.");
        }
        this.validateSameMetadataStructure(other);
        Map<String, CalculatedMember> calcedMembers = this.getCalcMembers();
        for (Map.Entry<String, CalculatedMember> otherEntry : other.getCalcMembers().entrySet()) {
            CalculatedMember myCalcMember = calcedMembers.get(otherEntry.getKey());
            if (myCalcMember == null) {
                calcedMembers.put(otherEntry.getKey(), otherEntry.getValue());
                continue;
            }
            if (myCalcMember.equals(otherEntry.getValue())) continue;
            throw new UnsupportedOperationException("Cannot add resultSets if calcedMember values are different.");
        }
        this.getCellProperties().addAll(other.getCellProperties());
        this.getTagTupleOrdinalsList().addAll(other.getTagTupleOrdinalsList());
        for (Cell otherCell : other) {
            this.addCell(new Cell(otherCell));
        }
    }

    @Override
    public ICellStorage getCellMap() {
        return null;
    }

    @Override
    public boolean getResultSetDelegateMode() {
        return false;
    }

    @Override
    public void finalizeResultSet(boolean[] nonEmptyAxes) {
    }

    @Override
    public Cell getCellAtOrdinal(long ordinal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putCell(Number ordinal, Cell cell) {
        this.cells.add(cell);
    }

    @Override
    public void setCachedCell(long index, Cell cell) {
    }

    public String toString() {
        return "SynchronizedPipelineResultSet: (" + this.cellCount() + " cells)";
    }

    @Override
    public boolean supportsRandomAccess() {
        return false;
    }

    @Override
    public void delegate(boolean[] nonEmptyAxes) {
        throw new UnsupportedOperationException(UNSUPPORTED_OP);
    }

    @Override
    public void undelegate() throws InterpreterException {
        throw new UnsupportedOperationException(UNSUPPORTED_OP);
    }

    @Override
    public void resetQuerySet() {
        throw new UnsupportedOperationException(UNSUPPORTED_OP);
    }
}

