/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleList;
import com.cognos.xqe.runtree.olap.mdx.util.SymmetricSubqueryIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.pool.XQESoftLongPool;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public final class SimpleTupleList
extends TupleList {
    private ITuple[] tuples;
    private SoftReference<HashMap<ITuple, List<Number>>> tupleToOrdinalsMapRef = new SoftReference<Object>(null);

    private SimpleTupleList(ITuple[] tups) {
        this.tuples = tups;
    }

    public List<ITuple> getTupleList() {
        return Collections.unmodifiableList(Arrays.asList(this.tuples));
    }

    public static ITupleList construct(ITuple[] tups) {
        if (tups == null || tups.length == 0) {
            return null;
        }
        return new SimpleTupleList(tups);
    }

    public static ITupleList rebuildAsSimpleTupleList(ITupleList tl) {
        if (tl.size() == 0L) {
            return null;
        }
        if (tl.size() > Integer.MAX_VALUE) {
            return tl;
        }
        ITuple[] tups = new ITuple[(int)tl.size()];
        ITupleIterator it = tl.iterator();
        int idx = 0;
        while ((long)idx < tl.size()) {
            tups[idx] = it.getTuple(idx);
            ++idx;
        }
        SimpleTupleList newTl = new SimpleTupleList(tups);
        newTl.setDistinctFlag(tl.getDistinctFlag());
        return newTl;
    }

    public static ITupleList cloneAsSimpleTupleList(ITupleList originalTL) {
        if (originalTL.size() == 0L || originalTL.size() > Integer.MAX_VALUE || originalTL.size() < 0L) {
            return null;
        }
        SimpleTupleList newTl = null;
        if (originalTL.size() <= originalTL.listSize()) {
            ITuple[] tups = new ITuple[(int)originalTL.size()];
            int idx = 0;
            for (ITuple t : originalTL) {
                tups[idx++] = (ITuple)t.copy();
            }
            newTl = new SimpleTupleList(tups);
            newTl.setDistinctFlag(originalTL.getDistinctFlag());
        }
        return newTl;
    }

    @Override
    public long size() {
        return this.tuples.length;
    }

    @Override
    public BigInteger noOverflowSize() {
        return BigInteger.valueOf(this.tuples.length);
    }

    @Override
    public int width() {
        return this.tuples[0].size();
    }

    @Override
    public long listSize() {
        return this.size();
    }

    @Override
    public List<Number> find(IMember[] findMems, boolean first) {
        ArrayList<Number> indices = new ArrayList<Number>();
        ITupleIterator iter = this.iterator();
        while (iter.hasNext()) {
            long index = iter.getIndex();
            ITuple currTuple = iter.next();
            Object[] tupMems = currTuple.getMembers();
            if (!Arrays.equals(findMems, tupMems)) continue;
            indices.add(index);
            if (!first) continue;
            return indices;
        }
        return indices;
    }

    private HashMap<ITuple, List<Number>> buildTupleToOrdinalsMap() {
        HashMap<ITuple, List<Number>> tupleToOrdinalMap = new HashMap<ITuple, List<Number>>();
        for (int i = 0; i < this.tuples.length; ++i) {
            List<Number> ordinalList = tupleToOrdinalMap.get(this.tuples[i]);
            if (ordinalList == null) {
                ordinalList = new ArrayList<Number>(1);
                tupleToOrdinalMap.put(this.tuples[i], ordinalList);
            }
            ordinalList.add(XQESoftLongPool.getLong(i));
        }
        return tupleToOrdinalMap;
    }

    @Override
    public List<Number> find(ITuple tuple, TupleOrdinalCalculationCache cache) {
        List<Number> result;
        HashMap<ITuple, List<Number>> tupleToOrdinalsMap = this.tupleToOrdinalsMapRef.get();
        if (tupleToOrdinalsMap == null) {
            tupleToOrdinalsMap = this.buildTupleToOrdinalsMap();
            this.tupleToOrdinalsMapRef = new SoftReference<HashMap<ITuple, List<Number>>>(tupleToOrdinalsMap);
        }
        if ((result = tupleToOrdinalsMap.get(this.getSubTuple(tuple, cache))) == null) {
            result = new ArrayList<Number>(0);
        }
        return result;
    }

    @Override
    public ITupleIterator iterator() {
        return new SimpleTupleIterator(this);
    }

    @Override
    public ITupleList copy() {
        ITuple[] cloneTuples = new Tuple[(int)this.size()];
        int i = 0;
        for (ITuple tuple : this) {
            cloneTuples[i++] = (ITuple)tuple.copy();
        }
        SimpleTupleList tl = new SimpleTupleList(cloneTuples);
        tl.setDistinctFlag(this.getDistinctFlag());
        return tl;
    }

    @Override
    public List<Set> getSymmetricSets(boolean splitAsymmetricSets) {
        Set set = new Set(this);
        if (SymmetricSubqueryIterator.isAsymmetric(set)) {
            if (!splitAsymmetricSets) {
                return null;
            }
            return SymmetricSubqueryIterator.getSymmetricSubsets(set, new HashSet<IHierarchy>());
        }
        ArrayList<Set> sets = new ArrayList<Set>();
        sets.add(set);
        return sets;
    }

    private final class SimpleTupleIterator
    extends TupleIterator {
        private SimpleTupleIterator(TupleList tl) {
            super(tl);
        }

        @Override
        protected IMember[] fetchMembers(long index) {
            return SimpleTupleList.this.tuples[(int)index].getMembers();
        }

        @Override
        protected IMember[] fetchMembers(BigInteger index) {
            return SimpleTupleList.this.tuples[index.intValue()].getMembers();
        }

        @Override
        protected int fetchMembers(long index, IMember[] membersArray, int indexToStart) {
            IMember[] membersToAdd = SimpleTupleList.this.tuples[(int)index].getMembers();
            System.arraycopy(membersToAdd, 0, membersArray, indexToStart, membersToAdd.length);
            return membersToAdd.length;
        }

        @Override
        protected int fetchMembers(BigInteger index, IMember[] membersArray, int indexToStart) {
            IMember[] membersToAdd = SimpleTupleList.this.tuples[index.intValue()].getMembers();
            System.arraycopy(membersToAdd, 0, membersArray, indexToStart, membersToAdd.length);
            return membersToAdd.length;
        }

        @Override
        public ITuple getTuple(long index) {
            this.checkForCancelRequest();
            if ((int)index >= SimpleTupleList.this.tuples.length || index < 0L) {
                this.logWrongSizeWarning(index);
            }
            return SimpleTupleList.this.tuples[(int)index];
        }

        @Override
        public ITuple getTuple(BigInteger index) {
            this.checkForCancelRequest();
            return SimpleTupleList.this.tuples[index.intValue()];
        }

        private void logWrongSizeWarning(long index) {
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine", LogLevel.WARN).log("Getting tuple at index: " + (int)index + " but tuple.length is " + SimpleTupleList.this.tuples.length);
        }
    }
}

