/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleList;
import com.cognos.xqe.runtree.olap.mdx.util.SymmetricSubqueryIterator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class SubsetTupleList
extends TupleList {
    TupleList childTupleList;
    long startInd;
    long endInd;
    long size;
    private static final double CARD_LENGTH_REBUILD_RATIO = 0.5;
    private static final long REBUILD_THRESHOLD = 10L;

    private SubsetTupleList(ITupleList child, long start, long count) {
        this.childTupleList = (TupleList)child;
        this.startInd = start;
        this.endInd = start + count - 1L;
        this.size = count;
        this.setDistinctFlag(child.getDistinctFlag());
    }

    public static ITupleList construct(ITupleList child, long start, long count) {
        if (child == null) {
            return null;
        }
        if (start < 0L || count <= 0L) {
            return null;
        }
        if (start + count > child.size()) {
            count = child.size() - start;
        }
        if (count == child.size()) {
            return child;
        }
        ITupleList tl = new SubsetTupleList(child, start, count);
        if ((count < 10L || (double)count / (double)child.listSize() < 0.5) && (tl = SimpleTupleList.rebuildAsSimpleTupleList(tl)) != null) {
            tl.setDistinctFlag(child.getDistinctFlag());
        }
        tl.setInvalidTuplesRemoved(child.getInvalidTuplesRemoved());
        return tl;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public BigInteger noOverflowSize() {
        return BigInteger.valueOf(this.size);
    }

    @Override
    public int width() {
        return this.childTupleList.width();
    }

    @Override
    public long listSize() {
        return this.childTupleList.listSize();
    }

    @Override
    public ITupleIterator iterator() {
        return new SubsetTupleIterator(this);
    }

    @Override
    public ITupleList copy() {
        ITupleList tl = SimpleTupleList.cloneAsSimpleTupleList(this);
        if (tl == null) {
            tl = new SubsetTupleList(this.childTupleList.copy(), this.startInd, this.size);
            tl.setDistinctFlag(this.getDistinctFlag());
        }
        return tl;
    }

    @Override
    public List<Set> getSymmetricSets(boolean splitAsymmetricSets) {
        Set set = new Set(this);
        if (SymmetricSubqueryIterator.isAsymmetric(set)) {
            if (!splitAsymmetricSets) {
                return null;
            }
            return SymmetricSubqueryIterator.getSymmetricSubsets(set, new HashSet<IHierarchy>());
        }
        ArrayList<Set> sets = new ArrayList<Set>();
        sets.add(set);
        return sets;
    }

    private final class SubsetTupleIterator
    extends TupleIterator {
        TupleIterator childTupleListIterator;

        private SubsetTupleIterator(TupleList tl) {
            super(tl);
            this.childTupleListIterator = (TupleIterator)SubsetTupleList.this.childTupleList.iterator();
        }

        @Override
        protected IMember[] fetchMembers(long index) {
            long childOrdinal = SubsetTupleList.this.startInd + index;
            return this.childTupleListIterator.fetchMembers(childOrdinal);
        }

        @Override
        protected IMember[] fetchMembers(BigInteger index) {
            BigInteger childOrdinal = BigInteger.valueOf(SubsetTupleList.this.startInd).add(index);
            return this.childTupleListIterator.fetchMembers(childOrdinal);
        }

        @Override
        protected int fetchMembers(long index, IMember[] membersArray, int indexToStart) {
            long childOrdinal = SubsetTupleList.this.startInd + index;
            return this.childTupleListIterator.fetchMembers(childOrdinal, membersArray, indexToStart);
        }

        @Override
        protected int fetchMembers(BigInteger index, IMember[] membersArray, int indexToStart) {
            BigInteger childOrdinal = BigInteger.valueOf(SubsetTupleList.this.startInd).add(index);
            return this.childTupleListIterator.fetchMembers(childOrdinal, membersArray, indexToStart);
        }

        @Override
        public ITuple getTuple(long index) {
            this.checkForCancelRequest();
            long childOrdinal = SubsetTupleList.this.startInd + index;
            return this.childTupleListIterator.getTuple(childOrdinal);
        }

        @Override
        public ITuple getTuple(BigInteger index) {
            this.checkForCancelRequest();
            BigInteger childOrdinal = BigInteger.valueOf(SubsetTupleList.this.startInd).add(index);
            return this.childTupleListIterator.getTuple(childOrdinal);
        }
    }
}

