/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleListFilter;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import java.util.BitSet;

public class TupleListFilter
implements ITupleListFilter {
    private static final int EIGHT = 8;
    private BitSet[] units;
    private int unitCount;
    private long highestSetBit = -1L;

    public TupleListFilter(long nbits) {
        this.allocateBits(nbits);
    }

    private void allocateBits(long theSize) {
        if (theSize <= 0L) {
            this.unitCount = 0;
            return;
        }
        long neededBytes = theSize / 8L;
        ResourceMonitor.checkAvailableMemory(neededBytes);
        int[] unitIdx = TupleListFilter.resolveUnitIndex(theSize - 1L);
        this.unitCount = unitIdx[0] + 1;
        if (unitIdx[0] == 0) {
            this.units = new BitSet[]{new BitSet(unitIdx[1] + 1)};
        } else {
            this.units = new BitSet[this.unitCount];
            for (int i = 0; i < this.unitCount - 1; ++i) {
                this.units[i] = new BitSet(Integer.MAX_VALUE);
            }
            this.units[this.unitCount - 1] = new BitSet(unitIdx[1] + 1);
        }
    }

    private static int[] resolveUnitIndex(long index) {
        int unitIdx = 0;
        int indexWithinUnit = (int)index;
        if (index >= Integer.MAX_VALUE) {
            unitIdx = (int)(index / Integer.MAX_VALUE);
            indexWithinUnit = (int)(index % Integer.MAX_VALUE);
        }
        return new int[]{unitIdx, indexWithinUnit};
    }

    private void set(long bitIndex) {
        int[] u = TupleListFilter.resolveUnitIndex(bitIndex);
        this.units[u[0]].set(u[1]);
        if (bitIndex > this.highestSetBit) {
            this.highestSetBit = bitIndex;
        }
    }

    @Override
    public void set(long bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    private void clear(long bitIndex) {
        int[] u = TupleListFilter.resolveUnitIndex(bitIndex);
        this.units[u[0]].clear(u[1]);
        if (bitIndex > this.highestSetBit) {
            this.highestSetBit = -1L;
        }
    }

    private boolean get(long bitIndex) {
        int[] u = TupleListFilter.resolveUnitIndex(bitIndex);
        return this.units[u[0]].get(u[1]);
    }

    @Override
    public long cardinality() {
        long sum = 0L;
        for (int i = 0; i < this.unitCount; ++i) {
            sum += (long)this.units[i].cardinality();
        }
        return sum;
    }

    @Override
    public long length() {
        if (this.highestSetBit > -1L) {
            return this.highestSetBit + 1L;
        }
        for (int i = this.unitCount - 1; i >= 0; --i) {
            int unitLen = this.units[i].length();
            if (unitLen <= 0) continue;
            this.highestSetBit = i * Integer.MAX_VALUE + unitLen;
            return this.highestSetBit;
        }
        return 0L;
    }

    private long nextSetBit(long fromIndex) {
        int[] u = TupleListFilter.resolveUnitIndex(fromIndex);
        int nsb = this.units[u[0]].nextSetBit(u[1]);
        if (nsb > -1) {
            return nsb;
        }
        for (int i = u[0] + 1; i < this.unitCount; ++i) {
            nsb = this.units[i].nextSetBit(0);
            if (nsb <= -1) continue;
            return i * Integer.MAX_VALUE + nsb;
        }
        return nsb;
    }

    @Override
    public void disable(long tupleOrd) {
        this.clear(tupleOrd);
    }

    @Override
    public void enable(long tupleOrd) {
        this.set(tupleOrd);
    }

    @Override
    public boolean isEnabled(long tupleOrd) {
        return this.get(tupleOrd);
    }

    @Override
    public long nextEnabledTuple(long tupleOrd) {
        return this.nextSetBit(tupleOrd);
    }
}

