/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleListFilter;
import com.cognos.xqe.util.pool.XQELongPool;
import java.util.SortedSet;
import java.util.TreeSet;

public class TupleListSparseFilter
implements ITupleListFilter {
    public static final long BITS_PER_ORDINAL = 128L;
    TreeSet<Long> enabledTuples = new TreeSet();

    @Override
    public long cardinality() {
        return this.enabledTuples.size();
    }

    @Override
    public void disable(long tupleOrd) {
        this.enabledTuples.remove(tupleOrd);
    }

    @Override
    public void enable(long tupleOrd) {
        this.enabledTuples.add(XQELongPool.getLong(tupleOrd));
    }

    @Override
    public boolean isEnabled(long tupleOrd) {
        return this.enabledTuples.contains(tupleOrd);
    }

    @Override
    public long length() {
        if (this.enabledTuples.isEmpty()) {
            return 0L;
        }
        return this.enabledTuples.last() + 1L;
    }

    @Override
    public long nextEnabledTuple(long tupleOrd) {
        SortedSet<Long> temp = this.enabledTuples.tailSet(tupleOrd);
        if (temp.isEmpty()) {
            return -1L;
        }
        return temp.first();
    }

    @Override
    public void set(long tupleOrd, boolean enabled) {
        if (enabled) {
            this.enable(tupleOrd);
        } else {
            this.disable(tupleOrd);
        }
    }
}

