/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SingleHierarchySimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleIndex;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.util.NumberOp;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.set.ListOrderedSet;

public final class UnionTupleList
extends TupleList {
    ITupleList[] childTupleLists;
    long size;
    BigInteger bigSize = null;
    long listSize;
    private final CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();

    private UnionTupleList(List<ITupleList> theChildTupleLists) {
        this.childTupleLists = new ITupleList[theChildTupleLists.size()];
        this.size = 0L;
        this.listSize = 0L;
        for (int inx = 0; inx < theChildTupleLists.size(); ++inx) {
            this.childTupleLists[inx] = theChildTupleLists.get(inx);
            if (this.childTupleLists[inx] == null) {
                XQEDebugLog.err.println("Oops");
            }
            this.listSize += theChildTupleLists.get(inx).listSize();
        }
        this.setSize();
        this.setDistinctFlag(false);
    }

    private void setSize() {
        for (int inx = 0; inx < this.childTupleLists.length; ++inx) {
            long childSize = this.childTupleLists[inx].size();
            if (childSize < 0L) {
                this.size = Long.MIN_VALUE;
                break;
            }
            this.size = NumberOp.addQuantities(this.size, childSize);
            if (this.size < 0L) break;
        }
        if (this.size < 0L) {
            this.setBigSize();
        }
    }

    public static ITupleList construct(List<ITupleList> childTupleLists) {
        if (childTupleLists.size() == 0) {
            return null;
        }
        if (childTupleLists.size() == 1) {
            return childTupleLists.get(0);
        }
        boolean validTupleOnlyFlag = true;
        ArrayList<ITupleList> expandedTupleLists = new ArrayList<ITupleList>();
        for (int inx = 0; inx < childTupleLists.size(); ++inx) {
            ITupleList tl = childTupleLists.get(inx);
            if (tl instanceof UnionTupleList) {
                UnionTupleList utl = (UnionTupleList)tl;
                for (int inx2 = 0; inx2 < utl.childTupleLists.length; ++inx2) {
                    expandedTupleLists.add(utl.childTupleLists[inx2]);
                    validTupleOnlyFlag = validTupleOnlyFlag && utl.getInvalidTuplesRemoved();
                }
                continue;
            }
            expandedTupleLists.add(tl);
            validTupleOnlyFlag = validTupleOnlyFlag && tl.getInvalidTuplesRemoved();
        }
        List<ITupleList> simplifiedChildTupleLists = UnionTupleList.simplifyTupleList(expandedTupleLists);
        if (simplifiedChildTupleLists.size() == 1) {
            return simplifiedChildTupleLists.get(0);
        }
        UnionTupleList unionTupleList = new UnionTupleList(simplifiedChildTupleLists);
        unionTupleList.setInvalidTuplesRemoved(validTupleOnlyFlag);
        return unionTupleList;
    }

    public static List<ITupleList> simplifyTupleList(List<ITupleList> listTupleList) {
        ArrayList<ITupleList> simplifiedChildTupleLists = new ArrayList<ITupleList>();
        ArrayList<ITupleList> merged = new ArrayList<ITupleList>();
        for (ITupleList aChild : listTupleList) {
            if (aChild.width() == 1) {
                merged.add(aChild);
                continue;
            }
            if (!merged.isEmpty()) {
                if (merged.size() == 1) {
                    simplifiedChildTupleLists.addAll(merged);
                } else {
                    ArrayList<IMember> mergedMembers = new ArrayList<IMember>();
                    for (ITupleList tl : merged) {
                        IMember[][] members = ((TupleList)tl).getMembersRetainDuplicates(new int[]{0});
                        mergedMembers.addAll(Arrays.asList(members[0]));
                    }
                    simplifiedChildTupleLists.add(SingleHierarchySimpleTupleList.construct(mergedMembers.toArray(new IMember[0])));
                }
                merged.clear();
            }
            simplifiedChildTupleLists.add(aChild);
        }
        if (!merged.isEmpty()) {
            if (merged.size() == 1) {
                simplifiedChildTupleLists.addAll(merged);
            } else {
                ArrayList<IMember> mergedMembers = new ArrayList<IMember>();
                for (ITupleList tl : merged) {
                    IMember[][] members = ((TupleList)tl).getMembersRetainDuplicates(new int[]{0});
                    mergedMembers.addAll(Arrays.asList(members[0]));
                }
                simplifiedChildTupleLists.add(SingleHierarchySimpleTupleList.construct(mergedMembers.toArray(new IMember[0])));
            }
            merged.clear();
        }
        return simplifiedChildTupleLists;
    }

    @Override
    public IMember[][] getMembers(int[] dimHierIdx) {
        ListOrderedSet[] allMembers = new ListOrderedSet[dimHierIdx.length];
        for (int i = 0; i < dimHierIdx.length; ++i) {
            allMembers[i] = ListOrderedSet.decorate(new HashSet());
        }
        for (ITupleList child : this.childTupleLists) {
            if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            IMember[][] memberArrays = ((TupleList)child).getMembers(dimHierIdx);
            for (int i = 0; i < dimHierIdx.length; ++i) {
                if (memberArrays[i] == null) continue;
                allMembers[i].addAll(Arrays.asList(memberArrays[i]));
            }
        }
        IMember[][] dimHierMembers = new IMember[dimHierIdx.length][];
        for (int i = 0; i < dimHierIdx.length; ++i) {
            dimHierMembers[i] = (IMember[])allMembers[i].toArray((Object[])new IMember[allMembers[i].size()]);
        }
        return dimHierMembers;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public BigInteger noOverflowSize() {
        if (this.bigSize == null) {
            this.setBigSize();
        }
        return this.bigSize;
    }

    private void setBigSize() {
        this.bigSize = BigInteger.ZERO;
        for (int inx = 0; inx < this.childTupleLists.length; ++inx) {
            if (this.childTupleLists[inx] == null) continue;
            this.bigSize = this.bigSize.add(this.childTupleLists[inx].noOverflowSize());
        }
    }

    @Override
    public int width() {
        return this.childTupleLists[0].width();
    }

    @Override
    public void replaceMember(int memIndex, IMember m) {
        this.setDistinctFlag(false);
        for (int i = 0; i < this.childTupleLists.length; ++i) {
            this.childTupleLists[i].replaceMember(memIndex, m);
        }
    }

    @Override
    public List<Number> find(IMember[] findMems, boolean first) {
        ArrayList<Number> indices = new ArrayList<Number>();
        long indexOffset = 0L;
        for (int inx = 0; inx < this.childTupleLists.length; ++inx) {
            List<Number> subIndices = this.childTupleLists[inx].find(findMems, first);
            for (int inx2 = 0; inx2 < subIndices.size(); ++inx2) {
                Number newIndex = NumberOp.add(subIndices.get(inx2), (Number)indexOffset);
                indices.add(newIndex);
                if (!first) continue;
                return indices;
            }
            indexOffset += this.childTupleLists[inx].size();
        }
        return indices;
    }

    @Override
    public List<Number> find(ITuple tuple, TupleOrdinalCalculationCache cache) {
        ArrayList<Number> result = new ArrayList<Number>(1);
        if (this.size >= 0L) {
            long offset = 0L;
            for (int inx = 0; inx < this.childTupleLists.length; ++inx) {
                TupleList aChildTupleList = (TupleList)this.childTupleLists[inx];
                List<Number> ordinals = aChildTupleList.find(tuple, cache);
                for (Number ordinal : ordinals) {
                    result.add((Long)ordinal + offset);
                }
                offset += aChildTupleList.size();
            }
        } else {
            BigInteger offset = BigInteger.ZERO;
            for (int inx = 0; inx < this.childTupleLists.length; ++inx) {
                TupleList aChildTupleList = (TupleList)this.childTupleLists[inx];
                List<Number> ordinals = aChildTupleList.find(tuple, cache);
                for (Number ordinal : ordinals) {
                    result.add(NumberOp.add(ordinal, offset));
                }
                offset = offset.add(aChildTupleList.noOverflowSize());
            }
        }
        return result;
    }

    @Override
    public boolean containsNullMembers() {
        for (int i = 0; i < this.childTupleLists.length; ++i) {
            if (!this.childTupleLists[i].containsNullMembers()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsCalculatedMembers() {
        for (int i = 0; i < this.childTupleLists.length; ++i) {
            if (!this.childTupleLists[i].containsCalculatedMembers()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsMeasures() {
        for (int i = 0; i < this.childTupleLists.length; ++i) {
            if (!this.childTupleLists[i].containsMeasures()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IMember[] getMembers(IDimension d) {
        ListOrderedSet members = ListOrderedSet.decorate(new HashSet());
        for (long idx = 0L; idx < (long)this.childTupleLists.length; ++idx) {
            IMember[] m = this.childTupleLists[(int)idx].getMembers(d);
            if (m.length <= 0) continue;
            members.addAll(Arrays.asList(m));
        }
        return (IMember[])members.toArray((Object[])new IMember[members.size()]);
    }

    @Override
    public HashSet<IMember> getCalculatedMembers() {
        HashSet<IMember> calculatedMembers = new HashSet<IMember>();
        for (long idx = 0L; idx < (long)this.childTupleLists.length; ++idx) {
            HashSet<IMember> calcMembers = this.childTupleLists[(int)idx].getCalculatedMembers();
            if (calcMembers.size() <= 0) continue;
            calculatedMembers.addAll(calcMembers);
        }
        return calculatedMembers;
    }

    @Override
    public void getCalculatedMemberSets(HashMap<CalculatedMember, Set> calculatedMemToSet, List<Set> baseSetList, ICube cube) {
        ArrayList<ITupleList> childBaseSetList = new ArrayList<ITupleList>();
        ArrayList<HashMap<CalculatedMember, Set>> calculatedMemToSetList = new ArrayList<HashMap<CalculatedMember, Set>>();
        HashSet<CalculatedMember> allCalculatedMem = new HashSet<CalculatedMember>();
        for (int i = 0; i < this.childTupleLists.length; ++i) {
            ITupleList tl;
            HashMap<CalculatedMember, Set> tmpCalculatedMemToSet = new HashMap<CalculatedMember, Set>();
            ArrayList<Set> tmpBaseSetList = new ArrayList<Set>();
            this.childTupleLists[i].getCalculatedMemberSets(tmpCalculatedMemToSet, tmpBaseSetList, cube);
            if (!tmpCalculatedMemToSet.isEmpty()) {
                calculatedMemToSetList.add(tmpCalculatedMemToSet);
                allCalculatedMem.addAll(tmpCalculatedMemToSet.keySet());
            }
            if (tmpBaseSetList.isEmpty() || (tl = ((Set)tmpBaseSetList.get(0)).getTupleList()) == null) continue;
            childBaseSetList.add(tl);
        }
        Set baseSet = null;
        if (childBaseSetList.size() > 1) {
            baseSet = new Set(UnionTupleList.construct(childBaseSetList));
        } else if (childBaseSetList.size() == 1) {
            baseSet = new Set(childBaseSetList.get(0));
        }
        if (baseSet != null) {
            if (baseSet.size() < TupleIndex.getMaxSizeForHash()) {
                baseSet = baseSet.distinct();
            }
            baseSetList.add(baseSet);
        }
        for (CalculatedMember calculatedMem : allCalculatedMem) {
            ArrayList<ITupleList> allSetTLs = new ArrayList<ITupleList>();
            for (HashMap hashMap : calculatedMemToSetList) {
                Set set = (Set)hashMap.get(calculatedMem);
                if (set == null) continue;
                allSetTLs.add(set.getTupleList());
            }
            calculatedMemToSet.put(calculatedMem, new Set(UnionTupleList.construct(allSetTLs)));
        }
    }

    @Override
    public ITupleIterator iterator() {
        return new UnionTupleIterator(this);
    }

    @Override
    public long listSize() {
        return this.listSize;
    }

    @Override
    public ITupleList copy() {
        ITupleList tl = SimpleTupleList.cloneAsSimpleTupleList(this);
        if (tl == null) {
            ArrayList<ITupleList> clonedChildTLs = new ArrayList<ITupleList>(this.childTupleLists.length);
            for (int inx = 0; inx < this.childTupleLists.length; ++inx) {
                clonedChildTLs.add(this.childTupleLists[inx].copy());
            }
            tl = new UnionTupleList(clonedChildTLs);
            tl.setDistinctFlag(this.getDistinctFlag());
        }
        return tl;
    }

    public ITupleList[] getChildTupleLists() {
        return this.childTupleLists;
    }

    @Override
    public List<Set> getSymmetricSets(boolean splitAsymmetricSets) {
        ArrayList<Set> sets = new ArrayList<Set>();
        for (ITupleList tl : this.childTupleLists) {
            List<Set> childList = tl.getSymmetricSets(splitAsymmetricSets);
            if (childList == null) {
                return null;
            }
            sets.addAll(childList);
        }
        return sets;
    }

    private final class UnionTupleIterator
    extends TupleIterator {
        TupleIterator[] childTupleListIterators;
        BigInteger[] bigChildTupleListCumulativeSizes;
        long[] longChildTupleListCumulativeSizes;
        BigInteger bigMRUAbsoluteIndex;
        long longMRUAbsoluteIndex;
        int mruChildIndex;

        private UnionTupleIterator(TupleList tl) {
            super(tl);
            this.bigMRUAbsoluteIndex = BigInteger.ZERO;
            this.longMRUAbsoluteIndex = 0L;
            this.mruChildIndex = 0;
            this.childTupleListIterators = new TupleIterator[UnionTupleList.this.childTupleLists.length];
            this.bigChildTupleListCumulativeSizes = null;
            this.longChildTupleListCumulativeSizes = new long[UnionTupleList.this.childTupleLists.length];
            for (int inx = 0; inx < UnionTupleList.this.childTupleLists.length; ++inx) {
                this.childTupleListIterators[inx] = (TupleIterator)UnionTupleList.this.childTupleLists[inx].iterator();
                if (inx == 0) {
                    long tempSize = UnionTupleList.this.childTupleLists[inx].size();
                    if (tempSize < 0L) {
                        this.bigChildTupleListCumulativeSizes = new BigInteger[UnionTupleList.this.childTupleLists.length];
                        this.bigChildTupleListCumulativeSizes[inx] = UnionTupleList.this.childTupleLists[inx].noOverflowSize();
                        continue;
                    }
                    this.longChildTupleListCumulativeSizes[inx] = tempSize;
                    continue;
                }
                if (this.bigChildTupleListCumulativeSizes != null) {
                    this.bigChildTupleListCumulativeSizes[inx] = this.bigChildTupleListCumulativeSizes[inx - 1].add(UnionTupleList.this.childTupleLists[inx].noOverflowSize());
                    continue;
                }
                long tempCumulativeSize = NumberOp.addQuantities(this.longChildTupleListCumulativeSizes[inx - 1], UnionTupleList.this.childTupleLists[inx].size());
                if (tempCumulativeSize < 0L) {
                    this.updateCumulativeSizesToBigIntegers(inx);
                    this.bigChildTupleListCumulativeSizes[inx] = this.bigChildTupleListCumulativeSizes[inx - 1].add(UnionTupleList.this.childTupleLists[inx].noOverflowSize());
                    continue;
                }
                this.longChildTupleListCumulativeSizes[inx] = tempCumulativeSize;
            }
        }

        private void updateCumulativeSizesToBigIntegers(int idx) {
            this.bigChildTupleListCumulativeSizes = new BigInteger[UnionTupleList.this.childTupleLists.length];
            for (int i = 0; i < idx; ++i) {
                this.bigChildTupleListCumulativeSizes[idx] = BigInteger.valueOf(this.longChildTupleListCumulativeSizes[idx]);
            }
            this.longChildTupleListCumulativeSizes = null;
        }

        @Override
        protected IMember[] fetchMembers(long index) {
            long childRelativeIndex = this.bigChildTupleListCumulativeSizes == null ? this.scanForChildTupleListRelativeIndexLongImpl(index) : this.scanForChildTupleListRelativeIndexBigImpl(BigInteger.valueOf(index)).longValue();
            return this.childTupleListIterators[this.mruChildIndex].fetchMembers(childRelativeIndex);
        }

        @Override
        protected IMember[] fetchMembers(BigInteger index) {
            if (this.bigChildTupleListCumulativeSizes == null) {
                return this.fetchMembers(index.longValue());
            }
            BigInteger childRelativeIndex = this.scanForChildTupleListRelativeIndexBigImpl(index);
            return this.childTupleListIterators[this.mruChildIndex].fetchMembers(childRelativeIndex);
        }

        @Override
        protected int fetchMembers(long index, IMember[] membersArray, int indexToStart) {
            long childRelativeIndex = this.bigChildTupleListCumulativeSizes == null ? this.scanForChildTupleListRelativeIndexLongImpl(index) : this.scanForChildTupleListRelativeIndexBigImpl(BigInteger.valueOf(index)).longValue();
            return this.childTupleListIterators[this.mruChildIndex].fetchMembers(childRelativeIndex, membersArray, indexToStart);
        }

        @Override
        protected int fetchMembers(BigInteger index, IMember[] membersArray, int indexToStart) {
            if (this.bigChildTupleListCumulativeSizes == null) {
                return this.fetchMembers(index.longValue(), membersArray, indexToStart);
            }
            BigInteger childRelativeIndex = this.scanForChildTupleListRelativeIndexBigImpl(index);
            return this.childTupleListIterators[this.mruChildIndex].fetchMembers(childRelativeIndex, membersArray, indexToStart);
        }

        @Override
        public ITuple getTuple(BigInteger index) {
            this.checkForCancelRequest();
            if (this.bigChildTupleListCumulativeSizes == null) {
                return this.getTuple(index.longValue());
            }
            BigInteger childRelativeIndex = this.scanForChildTupleListRelativeIndexBigImpl(index);
            return this.childTupleListIterators[this.mruChildIndex].getTuple(childRelativeIndex);
        }

        @Override
        public ITuple getTuple(long index) {
            this.checkForCancelRequest();
            if (this.bigChildTupleListCumulativeSizes != null) {
                return this.getTuple(BigInteger.valueOf(index));
            }
            long childRelativeIndex = this.scanForChildTupleListRelativeIndexLongImpl(index);
            return this.childTupleListIterators[this.mruChildIndex].getTuple(childRelativeIndex);
        }

        private BigInteger scanForChildTupleListRelativeIndexBigImpl(BigInteger absoluteIndex) {
            int inx;
            BigInteger childIndex = absoluteIndex;
            for (inx = this.getStartingChildIndexForScan(absoluteIndex); inx < UnionTupleList.this.childTupleLists.length && absoluteIndex.compareTo(this.bigChildTupleListCumulativeSizes[inx]) >= 0; ++inx) {
            }
            if (inx > 0) {
                childIndex = absoluteIndex.subtract(this.bigChildTupleListCumulativeSizes[inx - 1]);
            }
            this.updateIndicesForMRUTuple(absoluteIndex, inx);
            return childIndex;
        }

        private long scanForChildTupleListRelativeIndexLongImpl(long absoluteIndex) {
            int inx;
            long childIndex = absoluteIndex;
            for (inx = this.getStartingChildIndexForScan(absoluteIndex); inx < UnionTupleList.this.childTupleLists.length && absoluteIndex >= this.longChildTupleListCumulativeSizes[inx]; ++inx) {
            }
            if (inx > 0) {
                childIndex = absoluteIndex - this.longChildTupleListCumulativeSizes[inx - 1];
            }
            this.updateIndicesForMRUTuple(absoluteIndex, inx);
            return childIndex;
        }

        private int getStartingChildIndexForScan(BigInteger index) {
            if (index.compareTo(this.bigMRUAbsoluteIndex) >= 0) {
                return this.mruChildIndex;
            }
            return 0;
        }

        private int getStartingChildIndexForScan(long index) {
            if (index >= this.longMRUAbsoluteIndex) {
                return this.mruChildIndex;
            }
            return 0;
        }

        private void updateIndicesForMRUTuple(BigInteger absoluteIndex, int childIndex) {
            this.bigMRUAbsoluteIndex = absoluteIndex;
            this.longMRUAbsoluteIndex = 0L;
            this.mruChildIndex = childIndex;
        }

        private void updateIndicesForMRUTuple(long absoluteIndex, int childIndex) {
            this.bigMRUAbsoluteIndex = null;
            this.longMRUAbsoluteIndex = absoluteIndex;
            this.mruChildIndex = childIndex;
        }
    }
}

