/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.SecuredOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.SecurityAwareLayer;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IAliasEntry;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.data.cache.AbstractCubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.data.cache.IResultSetCacheKeyMaker;
import com.cognos.xqe.runtree.olap.mdx.data.cache.SimpleCubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SelectQuery;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleStorage;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPEssbaseCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPException;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMDXQuery;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IReusableCube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderDefaultMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.VirtualMember;
import com.cognos.xqe.runtree.olap.mdx.platform.Environment;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageFactory;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.concurrent.Gate;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class LOLAPCube
extends Cube
implements IReusableCube {
    private static final int M = 0x100000;
    protected static final String OPEN_BRACKET_STR = "[";
    protected static final String CLOSE_BRACKET_STR = "]";
    private static final String OPEN_CBRACKET_STR = "{";
    private static final String CLOSE_CBRACKET_STR = "}";
    private static final String COMMA_STR = ",";
    private static final String NEWLINE_STR = "\n";
    private static final String LOGIN_FAILURE_STR = "Login failure";
    private static final String XQE_RUNTIME_EXCEPTION_STR = "XQERuntimeException";
    private static final String PROPERTY_SELECTQUERY = "selectQuery";
    protected ICube modelCube;
    protected IDataSource runtreeDataSource;
    private ICatalog catalog = null;
    private String keyDate = null;
    private String contextId = null;
    private String datasourceType = null;
    private String sapVariables = null;
    private Boolean useMetadataCallOnly = null;
    private Boolean supressNulls = Boolean.TRUE;
    private IOLAPDataProvider dataProvider = null;
    private IHierarchy modelMeasureHierarchy;
    private AbstractCubeResultSetCache resultSetCache = null;
    protected ConcurrentMap<String, IMeasure> referencedMeasures = null;
    private IRestrictions cubeRestrictions = null;
    private boolean cachingCubeRestritionsIsAllowed = false;
    private HashMap<HashSet<IMember>[], ArrayList<TupleValue>> selectionsToResults = new HashMap();
    private ConcurrentMap<String, LocalizedString> replacementTextCaptions = new ConcurrentHashMap<String, LocalizedString>();
    private ConcurrentMap<String, String> replacementTextDescriptions = new ConcurrentHashMap<String, String>();
    private boolean locked = false;
    protected boolean dimsInitialised = false;
    private IModelDataSource datasource = null;
    private final MemberStorage memberStorage;
    private MemberStorage.MemberStorageIdentifier memberProviderMRCKey = null;
    private IBlockTupleStorage blockTupleStorage = null;
    private boolean resultSetCacheEnabled;
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MemberStorage", LogLevel.ERROR);
    protected static XQELogger mMSErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MemberStorage", LogLevel.ERROR);
    private final ConcurrentMap<String, Gate> mdxExecutionGate = new ConcurrentHashMap<String, Gate>();
    private static final String MEASURES_STR = "[Measures]";

    @Override
    public IModelDataSource getModelDataSource() {
        if (this.datasource != null) {
            return this.datasource;
        }
        if (super.getModelDataSource() != null) {
            this.datasource = super.getModelDataSource();
        } else if (this.modelCube != null) {
            this.datasource = this.modelCube.getModelDataSource();
        } else if (this.getConnection() != null) {
            this.datasource = this.getConnection().getModelDataSources().get(0);
        }
        return this.datasource;
    }

    public IDataSource getRuntreeDataSource() {
        return this.runtreeDataSource;
    }

    @Override
    public void lock() {
        if (!this.locked) {
            this.locked = true;
        }
    }

    public HashMap<HashSet<IMember>[], ArrayList<TupleValue>> getSelectionsToResults() {
        return this.selectionsToResults;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    public static String removeBrackets(String name) {
        if (name.charAt(0) == '[' && name.charAt(name.length() - 1) == ']') {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public LOLAPCube(ICatalog theCatalog, ICube theModelCube, IDataSource theRuntreeDataSource, String theKeyDate, MemberStorage memberStore) throws ProviderException {
        super(LOLAPCube.removeBrackets(theModelCube.getUniqueName()), theCatalog.getName(), new Date().getTime());
        XQELog.logConsole("Adding LOLAPCube " + theModelCube.getUniqueName());
        this.keyDate = theKeyDate;
        this.runtreeDataSource = theRuntreeDataSource;
        this.modelCube = theModelCube;
        this.setConnection(theModelCube.getConnection());
        this.catalog = theCatalog;
        this.datasourceType = theRuntreeDataSource.getType();
        this.dataProvider = ProviderManager.getInstance().getOLAPProvider(theRuntreeDataSource.getType());
        this.memberStorage = memberStore;
        if (!this.isCubeExistOnDataSource()) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_CubeNotExistOnServer, LOLAPCube.removeBrackets(theModelCube.getUniqueName()), this.runtreeDataSource.getName());
        }
        this.dimsInitialised = false;
        this.initialiseDimensions();
        this.modelMeasureHierarchy = this.modelCube.getMeasuresHierarchy();
        this.blockTupleStorage = this.createBlockTupleStorage();
        this.blockTupleStorage.initialize();
        int resultSetCacheSize = this.getResultSetCacheSize(this.runtreeDataSource);
        boolean bl = this.resultSetCacheEnabled = resultSetCacheSize > 0;
        if (this.resultSetCacheEnabled) {
            this.resultSetCache = new SimpleCubeResultSetCache(theModelCube.getUniqueName(), new IResultSetCacheKeyMaker(){

                @Override
                public Object makeKey(ICube cube, MDXQuery mdxQuery, XDataContext dataContext) {
                    return mdxQuery.getMDX();
                }
            });
            this.resultSetCache.setMaxCacheSize(0x100000 * resultSetCacheSize);
        }
    }

    public void initialiseDimensions() {
        if (!this.dimsInitialised) {
            List<IDimension> otherDims = this.modelCube.getDimensions();
            for (int i = 0; i < otherDims.size(); ++i) {
                IDimension dim = otherDims.get(i);
                String name = dim.getUniqueName();
                if (name.charAt(0) == '[') {
                    name = name.substring(1, name.length() - 1);
                }
                LOLAPDimension newDim = new LOLAPDimension(name, this, dim);
                newDim.initialiseHierarchies();
            }
            this.dimsInitialised = true;
        }
    }

    @Override
    public ICatalog getCatalog() {
        return this.catalog;
    }

    public void release() {
        XQELog.logConsole("LOLAPCube.release");
    }

    public Locale getLocale() {
        return ((RequestEnvironment)this.getExecutionEnvironment().getRequestEnvironment()).getRunLocale();
    }

    public MemberStorage.MemberStorageIdentifier getMemberProviderMRCKey() {
        if (this.memberProviderMRCKey == null) {
            MemberStorage.MemberStorageIdentifier msID;
            this.memberProviderMRCKey = msID = MemberStorage.buildMemberStorageIdentifier(this.memberStorage.getDataSourceType(), this.memberStorage.getDataSourceName(), this.memberStorage.getCatalogName(), this.memberStorage.getCubeName(), this.memberStorage.getModelName(), true, LocaleConverter.localeToStr(this.getLocale()));
        }
        return this.memberProviderMRCKey;
    }

    public SecuredOLAPMetadataProvider getSecuredMetadataProvider() {
        return this.getExecutionEnvironment().getMultiRequestContext().getSecuredOLAPMetadataProvider(this.getMemberProviderMRCKey());
    }

    @Override
    public long getCacheUpdateInterval() {
        long result = -1L;
        String cacheOn = Environment.getEnvironmentVariable("cachingEnabled");
        if (cacheOn != null && cacheOn.equals("false")) {
            result = 0L;
        }
        return result;
    }

    @Override
    public IDimension getDimension(String dimName) {
        IDimension dimension = super.getDimension(dimName);
        if (dimension != null) {
            return dimension;
        }
        int dimCnt = this.getDimensionCount();
        if (!dimName.startsWith(OPEN_BRACKET_STR)) {
            dimName = OPEN_BRACKET_STR + dimName + CLOSE_BRACKET_STR;
        }
        for (int i = 0; i < dimCnt; ++i) {
            dimension = this.getDimension(i);
            String extName = ((LOLAPDimension)dimension).getExternalName();
            if (extName.compareTo(dimName) != 0) continue;
            return dimension;
        }
        return null;
    }

    @Override
    public void addMeasuresDimension() throws ProviderException {
    }

    public abstract void addProviderSpecificRestrictions(IRestrictions var1);

    @Override
    public IMember getMeasure(String measureName) {
        IMember measure = this.modelMeasureHierarchy.getMember(measureName);
        return measure;
    }

    @Deprecated
    protected TupleStorage createTupleStorage() throws ProviderException {
        return null;
    }

    @Override
    protected IBlockTupleStorage createBlockTupleStorage() throws ProviderException {
        return BlockTupleStorageFactory.getBlockTupleStorage(this);
    }

    protected abstract boolean hasInconsistentMeasureValues();

    @Override
    public IBlockTupleStorage getBlockTupleStorage() {
        return this.blockTupleStorage;
    }

    @Override
    public QueryStrategy getQueryStrategy() {
        return new LOLAPQueryStrategy();
    }

    @Override
    public List<IVariable> getVariables() {
        return null;
    }

    public ICubeResultSet performExecuteRequest(MDXQuery mdxQuery, OrderedMap<String> propertiesMap, ICube cube) throws LOLAPException {
        if (DataSourceTypeEnum.isEssbase(this.datasourceType)) {
            LOLAPEssbaseCube eCube = (LOLAPEssbaseCube)cube;
            IAliasEntry aliasTableEntry = eCube.getAliasTableEntry();
            if (aliasTableEntry != null) {
                ArrayList<IAliasEntry> aliasTable = new ArrayList<IAliasEntry>();
                aliasTable.add(aliasTableEntry);
                mdxQuery.setAliasTable(aliasTable);
            }
        } else if (DataSourceTypeEnum.isTM(this.datasourceType)) {
            LOLAPTM1Cube tm1Cube = (LOLAPTM1Cube)cube;
            List<IAliasEntry> aliasTable = tm1Cube.getAliasTableEntries();
            mdxQuery.setAliasTable(aliasTable);
        }
        ExecutionEnvironment execEnv = this.getExecutionEnvironment();
        XDataContext dataContext = execEnv.pushDataContext();
        ICubeResultSet cubeResult = null;
        try {
            MDXQueryArguments mdxArguments = new MDXQueryArguments(this.runtreeDataSource, mdxQuery, ((RequestEnvironment)execEnv.getRequestEnvironment()).getRunLocale(), cube.getModelDataSource().getConnection().getContentLocale());
            cubeResult = this.dataProvider.query(dataContext, mdxArguments);
        }
        catch (LogonFailureException e) {
            throw new LOLAPException(e, LOGIN_FAILURE_STR);
        }
        catch (XQERuntimeException e) {
            throw new LOLAPException(e, XQE_RUNTIME_EXCEPTION_STR);
        }
        finally {
            execEnv.popDataContext(dataContext);
        }
        return cubeResult;
    }

    public void resetDefaultMember(LOLAPHierarchy hierarchy) {
    }

    public IDataSourceCapabilities getCapabilities() {
        return this.runtreeDataSource.getCapabilities();
    }

    public SecurityAwareLayer getSAL() {
        return this.getSecuredMetadataProvider().getSAL();
    }

    public MemberStorage getMemberStorage() {
        return this.memberStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMember findMember(String memberNamePart) throws MetadataException {
        if (memberNamePart == null || memberNamePart.isEmpty()) {
            return null;
        }
        IMember member = null;
        String trimmedName = memberNamePart.trim();
        String mdxName = null;
        if (trimmedName.startsWith(OPEN_BRACKET_STR)) {
            mdxName = trimmedName;
            member = this.handleDefaultMemberSyntax(mdxName);
        }
        if (member == null) {
            IHierarchy hier;
            ICacheKey memberKey = null;
            if (mdxName != null) {
                memberKey = this.getSingleMemberFromCache(null, null, mdxName);
            } else {
                Dimension[] dims = this.getDimensions().toArray(new Dimension[0]);
                for (int i = 0; i < dims.length && memberKey == null; ++i) {
                    Dimension dim = dims[i];
                    Hierarchy[] hiers = dim.getHierarchies().toArray(new Hierarchy[0]);
                    for (int j = 0; j < hiers.length && memberKey == null; ++j) {
                        hier = hiers[j];
                        mdxName = this.prepareMDXMemberName((LOLAPHierarchy)hier, memberNamePart);
                        memberKey = this.getSingleMemberFromCache((LOLAPDimension)dim, (LOLAPHierarchy)hier, mdxName);
                    }
                }
            }
            if (memberKey != null) {
                SecurityAwareLayer sal = this.getSAL();
                String name = this.getMemberName(memberKey);
                String dun = sal.getDimensionUniqueNameFromCache(memberKey);
                IDimension dim = this.getDimension(dun);
                String hun = sal.getHierarchyUniqueNameFromCache(memberKey);
                hier = dim.getHierarchy(hun);
                int memberLevelNumber = this.getCorrespondingLOLAPLevelIndex(hier, sal.getMemberLevelIndexFromCache(memberKey));
                Level level = (Level)hier.getLevel(memberLevelNumber);
                int memberId = sal.getMemberIdFromCache(memberKey);
                Level level2 = level;
                synchronized (level2) {
                    member = level.getMember(name, memberId);
                    if (member == null) {
                        member = LOLAPMemberProxy.initMemberProxy(memberKey, level);
                    }
                }
            }
        }
        return member;
    }

    public IMember handleDefaultMemberSyntax(String mdxName) {
        IMember result = null;
        UniqueNameParser parser = new UniqueNameParser();
        try {
            int idx;
            Dimension dim;
            String[] parts = parser.parse(mdxName);
            if (parts.length > 0 && (dim = (Dimension)this.getDimension(parts[idx = 0])) != null) {
                if (++idx == parts.length) {
                    result = dim.getDefaultMember();
                } else if (parts[idx].equalsIgnoreCase("HIERARCHY")) {
                    IHierarchy hier = dim.getDefaultHierarchy();
                    if (++idx == parts.length) {
                        result = hier.getDefaultMember();
                    }
                }
            }
        }
        catch (Exception e) {
            mErrorLogger.log(e);
        }
        return result;
    }

    public ICacheKey getSingleMemberFromCache(LOLAPDimension dim, LOLAPHierarchy hier, String mun) {
        IRestrictions restrictions = this.getCubeRestrictions();
        String dun = null;
        String hun = null;
        if (dim == null) {
            int dimNameEndNdx = mun.indexOf(CLOSE_BRACKET_STR);
            if (dimNameEndNdx <= 0) {
                return null;
            }
            dun = mun.substring(0, dimNameEndNdx + 1);
        } else {
            dun = dim.getExternalName();
        }
        if (hier == null) {
            int memberNameStartNdx = mun.lastIndexOf(".[");
            if (memberNameStartNdx <= 2) {
                return null;
            }
            hun = mun.substring(0, memberNameStartNdx);
        } else {
            hun = hier.getExternalName();
        }
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dun);
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hun);
        restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, mun);
        restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMSELFANCESTORS);
        return this.getSecuredMetadataProvider().collectSingleMemberInCache(restrictions);
    }

    public String prepareMDXMemberName(LOLAPHierarchy hier, String memberName) {
        if (memberName.length() == 0 || memberName.trim().length() == 0) {
            return null;
        }
        StringBuilder mdxMemberName = new StringBuilder();
        mdxMemberName.append(hier.getExternalName());
        mdxMemberName.append(".");
        mdxMemberName.append(OPEN_BRACKET_STR);
        mdxMemberName.append(memberName);
        mdxMemberName.append(CLOSE_BRACKET_STR);
        return mdxMemberName.toString();
    }

    public boolean cubeContainAttributeDimensions() {
        return false;
    }

    public void setCubeContainsAttributeDimensions(boolean isAttribDimension) {
    }

    public void cacheLOLAPMeasure(LOLAPMeasure lolapMeasure) {
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CATALOG, this.getCatalogName());
        restrictions.add(RestrictionType.CUBE, this.getName());
        restrictions.add(RestrictionType.CUBE_OBJECT, this.modelCube);
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, MEASURES_STR);
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, MEASURES_STR);
        ICacheKey measureCacheKey = LOLAPMemberProxy.cacheAlreadyRetrievedMember(lolapMeasure, this, restrictions, null);
        lolapMeasure.setCacheKey(measureCacheKey);
    }

    public IHierarchy pushSingleMemberDimensionOnToRow(IHierarchy hier) {
        return null;
    }

    protected boolean supportsPartialLoadingOfPropertiesForCachedMembers() {
        return false;
    }

    public abstract String getMDXMemberUniqueName(IMember var1);

    public abstract boolean addToWhereCondition(IDimension var1, IMember var2);

    public abstract String getMDXAxisAttributes(int var1);

    public abstract String getMDXFromClause();

    public abstract String getMDXQueryAttributes();

    public abstract boolean isCubeExistOnDataSource();

    public abstract void loadMemberProperties(LOLAPLevel var1);

    public abstract void updateMeasuresLevelInfo(LOLAPLevel var1);

    public abstract int getCorrespondingLOLAPLevelIndex(IHierarchy var1, int var2);

    public abstract String getMemberName(ICacheKey var1);

    public String getCachedMUNPropName() {
        return "MEMBER_UNIQUE_NAME";
    }

    public String getKeyDate() {
        return this.keyDate;
    }

    @Override
    public String getContextId() {
        return this.contextId;
    }

    @Override
    public void setContextId(String contextID) {
        this.contextId = contextID;
    }

    @Override
    public String getDatasourceType() {
        return this.datasourceType;
    }

    @Override
    public void setDatasourceType(String dsType) {
        this.datasourceType = dsType;
    }

    @Override
    public Object getAdditionalContext() {
        return this.sapVariables;
    }

    @Override
    public void setAdditionalContext(Object sapVars) {
        this.sapVariables = (String)sapVars;
    }

    public String getSAPVariables() {
        return this.sapVariables;
    }

    public Boolean getUseMetadataCallOnly() {
        return this.useMetadataCallOnly;
    }

    public void setUseMetadataCallOnly(Boolean metadataCallOnly) {
        this.useMetadataCallOnly = metadataCallOnly;
    }

    public Boolean getSupressNulls() {
        return this.supressNulls;
    }

    public void setSupressNulls(Boolean theSupressNull) {
        this.supressNulls = theSupressNull;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null == env) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        return env;
    }

    public void setCachingCubeRestrictionsIsAllowed() {
        this.cachingCubeRestritionsIsAllowed = true;
    }

    private synchronized void initCubeRestrictions() {
        if (this.cachingCubeRestritionsIsAllowed && this.cubeRestrictions == null) {
            this.cubeRestrictions = this.prepareCubeRestrictions();
        }
    }

    private IRestrictions prepareCubeRestrictions() {
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CATALOG, this.getCatalogName());
        restrictions.add(RestrictionType.CUBE, this.getName());
        this.addProviderSpecificRestrictions(restrictions);
        return restrictions;
    }

    public IRestrictions getCubeRestrictions() {
        return this.getCubeRestrictionsReference().duplicate();
    }

    protected IRestrictions getCubeRestrictionsReference() {
        IRestrictions restrictions;
        if (this.cachingCubeRestritionsIsAllowed) {
            if (this.cubeRestrictions == null) {
                this.initCubeRestrictions();
            }
            restrictions = this.cubeRestrictions;
        } else {
            restrictions = this.prepareCubeRestrictions();
        }
        return restrictions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITuple getCubicsTuple(ITuple atuple) {
        SecurityAwareLayer sal = this.getSAL();
        Tuple tuple = null;
        IMember[] amembers = atuple.getMembers();
        ArrayList<IMember> members = new ArrayList<IMember>();
        for (int i = 0; i < amembers.length; ++i) {
            LOLAPDimension dim = (LOLAPDimension)this.getDimension(amembers[i].getDimension().getUniqueName());
            if (dim == null) continue;
            LOLAPHierarchy hier = (LOLAPHierarchy)dim.getHierarchy(amembers[i].getHierarchy().getUniqueName());
            ICacheKey memberKey = LOLAPMemberProxy.cacheAlreadyRetrievedMember(amembers[i], this, null);
            if (memberKey == null) continue;
            String name = this.getMemberName(memberKey);
            String hun = sal.getHierarchyUniqueNameFromCache(memberKey);
            IHierarchy hier1 = dim.getHierarchy(hun);
            int memberLevelNumber = this.getCorrespondingLOLAPLevelIndex(hier, sal.getMemberLevelIndexFromCache(memberKey));
            Level level = (Level)hier1.getLevel(memberLevelNumber);
            int memberId = sal.getMemberIdFromCache(memberKey);
            Level level2 = level;
            synchronized (level2) {
                IMember member = level.getMember(name, memberId);
                if (member == null) {
                    member = LOLAPMemberProxy.initMemberProxy(memberKey, level);
                    members.add(member);
                } else {
                    members.add(member);
                }
                continue;
            }
        }
        IMember[] mems = members.toArray(new IMember[members.size()]);
        tuple = new Tuple(mems);
        return tuple;
    }

    public ICubeResultSet remoteMDXStatement(String mdx, XDataContext context) {
        ITuple tuple;
        IMember[] members;
        ExecutionEnvironment execEnv = (ExecutionEnvironment)context.getEnvironment();
        if (null == execEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        StringBuilder strMDX = new StringBuilder();
        IDimension dim = this.getDimension(DimensionTypeEnum.MEASURE);
        String name = "";
        if (dim != null) {
            name = dim.getUniqueName();
            strMDX.append("WITH MEMBER ");
            strMDX.append(name);
            strMDX.append(".[XQE_NULL_CM0] AS '(NULL)' SOLVE_ORDER = 65535 \n");
        }
        strMDX.append("SELECT \n");
        strMDX.append(OPEN_CBRACKET_STR);
        strMDX.append(mdx);
        strMDX.append(CLOSE_CBRACKET_STR);
        strMDX.append(NEWLINE_STR);
        strMDX.append("ON AXIS(0)");
        if (dim != null) {
            strMDX.append(COMMA_STR);
            strMDX.append(NEWLINE_STR);
            strMDX.append(OPEN_CBRACKET_STR);
            strMDX.append(name);
            strMDX.append(".[XQE_NULL_CM0]");
            strMDX.append(CLOSE_CBRACKET_STR);
            strMDX.append(NEWLINE_STR);
            strMDX.append("ON AXIS(1)");
        }
        strMDX.append(NEWLINE_STR);
        strMDX.append(this.getMDXFromClause());
        SelectQuery selectQuery = (SelectQuery)context.getProperty(PROPERTY_SELECTQUERY);
        if (selectQuery != null && (members = (tuple = selectQuery.getWhereTuple()).getMembers()).length > 0) {
            strMDX.append(NEWLINE_STR);
            strMDX.append("WHERE ");
            strMDX.append("(");
            for (int i = 0; i < members.length; ++i) {
                strMDX.append(members[i].getUniqueName());
                if (i >= members.length - 1) continue;
                strMDX.append(COMMA_STR);
            }
            strMDX.append(")");
        }
        ArrayList<IHierarchy> hierarchyList = new ArrayList<IHierarchy>();
        XQEDebugLog.out.println("Priming Query MDX: " + strMDX.toString());
        LOLAPMDXQuery mdxQuery = new LOLAPMDXQuery(strMDX.toString(), this, hierarchyList);
        MDXQueryArguments mdxArguments = new MDXQueryArguments(this.runtreeDataSource, mdxQuery, ((RequestEnvironment)execEnv.getRequestEnvironment()).getRunLocale(), this.getConnection().getContentLocale());
        ICubeResultSet cubeResult = null;
        XDataContext subContext = execEnv.pushDataContext();
        try {
            cubeResult = this.dataProvider.query(context, mdxArguments);
        }
        catch (LogonFailureException e) {
            throw new LOLAPException(e, LOGIN_FAILURE_STR);
        }
        catch (XQERuntimeException e) {
            throw new LOLAPException(e, XQE_RUNTIME_EXCEPTION_STR);
        }
        finally {
            execEnv.popDataContext(subContext);
        }
        return cubeResult;
    }

    @Override
    public int getMemberIndex(IMember member) {
        if (member.isMeasure()) {
            return ((LOLAPMeasure)member).getIndex();
        }
        if (member.isProviderDefaultMember()) {
            return ((ProviderDefaultMember)member).getIndex();
        }
        if (member.getDimension().getType() == DimensionTypeEnum.INTERNAL && member instanceof VirtualMember) {
            return ((VirtualMember)member).getIndex();
        }
        return ((LOLAPMemberProxy)member).getIndex();
    }

    @Override
    public IMember getExistingMemberFromId(IDimension dimension, int memberId) {
        if (dimension.isMeasuresDimension() || memberId == -1) {
            StringBuilder strBldr = new StringBuilder("Exception encountered - requesting member from SAL using invalid memberid ");
            mMSErrorLogger.log(strBldr.toString());
            throw new XQERuntimeException(XQEMessageKeys.MD_InvalidMemberID_INTERNAL);
        }
        IMember member = null;
        SecurityAwareLayer sal = this.getSAL();
        ICacheKey memberKey = sal.getMemberKeyFromId(memberId);
        String dun = sal.getDimensionUniqueNameFromCache(memberKey);
        IDimension dim = this.getDimension(dun);
        String hun = sal.getHierarchyUniqueNameFromCache(memberKey);
        IHierarchy hier = dim.getHierarchy(hun);
        member = ((LOLAPHierarchy)hier).findMember(sal.getMemberUniqueNameFromCache(memberKey));
        return member;
    }

    public ConcurrentMap<String, LocalizedString> getReplacementTextCaptions() {
        return this.replacementTextCaptions;
    }

    public ConcurrentMap<String, String> getReplacementTextDescrips() {
        return this.replacementTextDescriptions;
    }

    public void setMeasureInfo(List<IMeasure> measures) {
        if (this.referencedMeasures == null) {
            this.referencedMeasures = new ConcurrentHashMap<String, IMeasure>();
        }
        for (IMeasure measure : measures) {
            String measureUniqueName = measure.getUniqueName();
            if (this.referencedMeasures.containsKey(measureUniqueName)) continue;
            this.referencedMeasures.put(measureUniqueName, measure);
        }
    }

    public ConcurrentMap<String, IMeasure> getMeasureInfo() {
        return this.referencedMeasures;
    }

    protected abstract IHierarchy getDefaultHierarchy(IDimension var1);

    public ICubeResultSetCache getResultSetCache() {
        return this.resultSetCache;
    }

    public boolean isResultSetCacheEnabled() {
        return this.resultSetCacheEnabled;
    }

    private int getResultSetCacheSize(IDataSource dataSource) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        int lolapResultSetCacheSize = capabilities.getIntegerValue("lolapResultSetCacheSize", 0);
        return lolapResultSetCacheSize;
    }

    public boolean trustProviderCaption() {
        return false;
    }

    public ConcurrentMap<String, Gate> getMDXExecutionGate() {
        return this.mdxExecutionGate;
    }
}

