/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider;

import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.data.providers.olap.securecache.SecurityAwareLayer;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.util.IOrderedMap;
import java.util.List;

public class LOLAPHierarchy
extends Hierarchy {
    private static final String OPEN_BRACE_STR = "[";
    private static final String CLOSE_BRACE_STR = "]";
    protected IHierarchy modelHierarchy;

    @Override
    public boolean isUnbalanced() {
        if (this.modelHierarchy == null) {
            return false;
        }
        return this.modelHierarchy.isUnbalanced();
    }

    @Override
    public boolean isRagged() {
        if (this.modelHierarchy == null) {
            return false;
        }
        return this.modelHierarchy.isRagged();
    }

    @Override
    protected void setDefaultProperties() {
        this.setProperty("all level", "No");
        this.setProperty("all caption", "");
        this.setProperty("default member", "");
    }

    public LOLAPHierarchy(String name, LOLAPDimension dimension, IHierarchy theModelHierarchy, boolean setHierarchyWithDefaultHierarchy) {
        super(name, dimension, setHierarchyWithDefaultHierarchy);
    }

    public LOLAPHierarchy(String name, LOLAPDimension dimension, IHierarchy theModelHierarchy) {
        super(name, dimension);
    }

    public void initializeHierarchy(IHierarchy theModelHierarchy) {
        LOLAPDimension dim = (LOLAPDimension)this.getDimension();
        this.modelHierarchy = theModelHierarchy;
        this.setConnection(dim.getConnection());
        if (theModelHierarchy == null) {
            new LOLAPLevel("MeasuresLevel", this, null);
        } else {
            if (theModelHierarchy.isParentChild()) {
                this.setParentChild(true);
            }
            this.initializeLevels();
        }
        if (dim.isMeasuresDimension() || dim.isKeyFigureStructure() && dim.getType() == DimensionTypeEnum.REGULAR) {
            dim.resetDefaultMember(this);
        }
    }

    public void initializeLevels() {
        LOLAPDimension dim = (LOLAPDimension)this.getDimension();
        if (!dim.isDefaultHierarchyExistInModel()) {
            this.modelHierarchy.getLevels();
        }
        int levelCount = this.modelHierarchy.getLevelCount();
        for (int i = 0; i < levelCount; ++i) {
            ILevel level = this.modelHierarchy.getLevel(i);
            new LOLAPLevel(level.getName(), this, level);
        }
    }

    public String getExternalName() {
        if (this.modelHierarchy == null) {
            if (((LOLAPDimension)this.getDimension()).isMeasuresDimension()) {
                return OPEN_BRACE_STR + this.name + CLOSE_BRACE_STR;
            }
            return "";
        }
        return this.modelHierarchy.getUniqueName();
    }

    @Override
    public String getUniqueName() {
        return this.getExternalName();
    }

    @Override
    public String getV5UniqueName() {
        if (this.modelHierarchy == null) {
            return this.getDimension().getV5UniqueName();
        }
        return this.modelHierarchy.getV5UniqueName();
    }

    @Override
    public ILevel getLevel(String levName) {
        ILevel level = (Level)super.getLevel(levName);
        if (level != null) {
            return level;
        }
        String hierName = this.getExternalName();
        if (!levName.startsWith(OPEN_BRACE_STR)) {
            levName = OPEN_BRACE_STR + levName + CLOSE_BRACE_STR;
        }
        levName = hierName + "." + levName;
        int levelCnt = this.getLevelCount();
        for (int i = 0; i < levelCnt; ++i) {
            level = this.getLevel(i);
            String extName = ((LOLAPLevel)level).getExternalName();
            if (extName.compareTo(levName) != 0) continue;
            return level;
        }
        return null;
    }

    public IHierarchy getModelHierarchy() {
        return this.modelHierarchy;
    }

    @Override
    public IOrderedMap<IMember> fetchFirstLevelMembers() throws ProviderException {
        LOLAPLevel level = (LOLAPLevel)this.getLevel(0);
        List<IMember> firstLevelMembers = level.getMembers();
        return level.getMembersOrderedMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMember findMember(String memberNamePart) throws MetadataException {
        if (memberNamePart == null || memberNamePart.isEmpty()) {
            return null;
        }
        if (this.getDimension().isMeasuresDimension()) {
            return super.findMember(memberNamePart);
        }
        IMember member = null;
        LOLAPCube c = (LOLAPCube)this.getDimension().getCube();
        String trimmedName = memberNamePart.trim();
        String mdxName = null;
        int count = 0;
        int i = trimmedName.length() - 1;
        char brace = trimmedName.charAt(i);
        while (brace == ']') {
            ++count;
            brace = trimmedName.charAt(--i);
        }
        if (trimmedName.startsWith(OPEN_BRACE_STR) && count % 2 == 1) {
            mdxName = trimmedName;
            member = c.handleDefaultMemberSyntax(mdxName);
        }
        if (member == null) {
            ICacheKey memberKey = null;
            boolean validateDimAndHier = false;
            if (mdxName != null) {
                memberKey = c.getSingleMemberFromCache(null, null, mdxName);
                validateDimAndHier = true;
            } else {
                mdxName = c.prepareMDXMemberName(this, memberNamePart);
                memberKey = c.getSingleMemberFromCache((LOLAPDimension)this.getDimension(), this, mdxName);
            }
            if (memberKey != null) {
                SecurityAwareLayer sal = c.getSAL();
                String name = c.getMemberName(memberKey);
                if (validateDimAndHier) {
                    String dun = sal.getDimensionUniqueNameFromCache(memberKey);
                    IDimension dim = c.getDimension(dun);
                    if (dim != this.getDimension()) {
                        throw new XQERuntimeException(XQEMessageKeys.MD_UnexpectedDimForMemberFound, (Object)name, (Object)dim.getUniqueName(), (Object)this.getDimension().getUniqueName());
                    }
                    String hun = sal.getHierarchyUniqueNameFromCache(memberKey);
                    IHierarchy hier = dim.getHierarchy(hun);
                    if (hier != this) {
                        throw new XQERuntimeException(XQEMessageKeys.MD_UnexpectedHierForMemberFound, (Object)name, (Object)hier.getUniqueName(), (Object)this.getUniqueName());
                    }
                }
                int memberLevelNumber = c.getCorrespondingLOLAPLevelIndex(this, sal.getMemberLevelIndexFromCache(memberKey));
                Level level = (Level)this.getLevel(memberLevelNumber);
                int memberId = sal.getMemberIdFromCache(memberKey);
                Level level2 = level;
                synchronized (level2) {
                    member = level.getMember(name, memberId);
                    if (member == null) {
                        member = LOLAPMemberProxy.initMemberProxy(memberKey, level);
                    }
                }
            }
        }
        return member;
    }

    public List<IMember> getRootMembers() {
        return this.getVisibleRoots();
    }

    @Override
    public IMember[] getMembers() {
        if (this.allMembers != null) {
            for (ILevel lev : this.getLevels()) {
                LOLAPLevel level = (LOLAPLevel)lev;
                if (level.hasGotAllProperties()) continue;
                level.loadMissingProperties();
            }
        }
        return super.getMembers();
    }
}

