/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider;

import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorageKey;
import com.cognos.xqe.data.providers.olap.securecache.SecurityAwareLayer;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MemberProxy;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.OrderedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class LOLAPLevel
extends Level {
    ILevel modelLevel;
    private static XQELogger mMSErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MemberStorage", LogLevel.ERROR);
    private ArrayList<String> loadedProperties;
    private String msessionCntxt;

    public LOLAPLevel(String name, LOLAPHierarchy hierarchy, ILevel theModelLevel) {
        super(name, hierarchy);
        this.setConnection(hierarchy.getConnection());
        this.modelLevel = theModelLevel;
        if (hierarchy.getDimension().getType() != DimensionTypeEnum.INTERNAL) {
            this.loadMFWMemberProperties();
            ((LOLAPCube)this.getDimension().getCube()).updateMeasuresLevelInfo(this);
            ((LOLAPCube)this.getDimension().getCube()).loadMemberProperties(this);
        }
        this.loadedProperties = new ArrayList();
    }

    private void loadMFWMemberProperties() {
        if (this.modelLevel == null) {
            return;
        }
        List<IProperty> propertyList = this.modelLevel.getMemberProperties();
        for (IProperty property : propertyList) {
            this.addMemberProperty(property);
        }
    }

    @Override
    public int getCardinality() {
        if (this.modelLevel == null) {
            return -1;
        }
        return this.modelLevel.getCardinality();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLoadedProperties(Set<String> propertiesList) {
        if (propertiesList != null && ((LOLAPCube)this.getDimension().getCube()).supportsPartialLoadingOfPropertiesForCachedMembers()) {
            this.writeLock().lock();
            try {
                for (String prop : propertiesList) {
                    if (this.loadedProperties.contains(prop)) continue;
                    this.loadedProperties.add(prop);
                }
            }
            finally {
                this.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getMissingProperties() {
        Set<String> propertiesList;
        HashSet<String> missingProperties = new HashSet<String>();
        if (((LOLAPCube)this.getDimension().getCube()).supportsPartialLoadingOfPropertiesForCachedMembers() && (propertiesList = LOLAPMemberProxy.getDimenstionProperties(this.getDimension().getUniqueName())) != null) {
            this.readLock().lock();
            try {
                for (String prop : propertiesList) {
                    if (this.loadedProperties.contains(prop)) continue;
                    missingProperties.add(prop);
                }
            }
            finally {
                this.readLock().unlock();
            }
        }
        return missingProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGotAllProperties() {
        Set<String> propertiesList = LOLAPMemberProxy.getDimenstionProperties(this.getDimension().getUniqueName());
        if (propertiesList != null) {
            this.readLock().lock();
            try {
                for (String prop : propertiesList) {
                    if (this.loadedProperties.contains(prop)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.readLock().unlock();
            }
        }
        return true;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName != null) {
            return this.uniqueName;
        }
        if (this.modelLevel != null) {
            this.uniqueName = this.modelLevel.getUniqueName();
            return this.uniqueName;
        }
        return super.getUniqueName();
    }

    @Override
    public List<IMember> getMembersWithContext(InterpreterContext ic) {
        if (!this.hasGotAllMembers()) {
            this.initLevelMembersOrMeasures();
            if (!this.getDimension().isMeasuresDimension()) {
                String sessionContextID;
                this.msessionCntxt = sessionContextID = this.getSessionId(ic);
            }
        } else {
            this.loadMissingProperties();
            String session = this.getSessionId(ic);
            ICube cube = ic.getCube();
            if (session != this.msessionCntxt) {
                SecurityAwareLayer sal = ((LOLAPCube)cube).getSAL();
                sal.incrementSALRequestCount(((LOLAPCube)cube).getContextId(), this.getDimension().getUniqueName());
            }
        }
        return super.getMembers();
    }

    private String getSessionId(InterpreterContext ic) {
        String sessionContextID = null;
        try {
            sessionContextID = ic.getXDataContext().getEnvironment().getMultiRequestContext().getSessionContextID();
        }
        catch (NullPointerException e) {
            mMSErrorLogger.log("Unable to determine session id during caching metric collection for LUN " + this.getUniqueName());
        }
        return sessionContextID;
    }

    @Override
    public List<IMember> getMembers() {
        if (!this.hasGotAllMembers()) {
            this.initLevelMembersOrMeasures();
        } else {
            this.loadMissingProperties();
        }
        return super.getMembers();
    }

    private boolean initLevelMembersOrMeasures() {
        this.writeLock().lock();
        try {
            if (!this.hasGotAllMembers()) {
                if (this.getDimension().isMeasuresDimension()) {
                    if (this.loadMeasuresOnDemanding()) {
                        this.fetchReferencedMeasuresOnLevel();
                    } else {
                        this.fetchAllMeasuresOnLevel();
                    }
                } else {
                    this.initLevelMembers();
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private void initLevelMembers() {
        try {
            this.fetchAllMembersOnLevel();
        }
        catch (Exception e) {
            String msTsInfo = LOLAPMemberProxy.gatherMemberStorageTimestampInfo((LOLAPCube)this.getDimension().getCube());
            if (msTsInfo != null) {
                StringBuilder strBldr = new StringBuilder("SAL exception encountered when loading level members. ");
                strBldr.append(" LUN is: ");
                strBldr.append(this.getUniqueName());
                strBldr.append(msTsInfo);
                mMSErrorLogger.log(strBldr.toString());
            }
            throw XQERuntimeException.wrap(e);
        }
    }

    private OrderedMap<IMember> fetchAllMembersOnLevel() {
        IDimension d = this.getDimension();
        Cube c = (Cube)d.getCube();
        int numCachedMembersFoundInOrderedMap = 0;
        OrderedMap<IMember> result = new OrderedMap<IMember>();
        SecurityAwareLayer sal = ((LOLAPCube)this.getDimension().getCube()).getSAL();
        List<ICacheKey> memberKeys = LOLAPMemberProxy.getMembersFromCache(this, null, -1, null, -1);
        LOLAPMemberProxy singleRootParent = null;
        if (memberKeys != null) {
            HashMap<String, IMember> punToParent = null;
            if (memberKeys.size() > 0 && !this.isRootLevel()) {
                List<IMember> parents = this.getParentMembers();
                punToParent = new HashMap<String, IMember>();
                Iterator it = parents.iterator();
                while (it.hasNext()) {
                    IMember parent = (IMember)it.next();
                    String pun = parent.getUniqueName();
                    punToParent.put(pun, parent);
                }
                if (parents.size() == 1 && !this.getHierarchy().isRagged()) {
                    singleRootParent = (LOLAPMemberProxy)parents.get(0);
                }
            }
            for (ICacheKey memberKey : memberKeys) {
                int memberId;
                IMember existingMember = null;
                MemberProxy parent = null;
                String name = ((LOLAPCube)c).getMemberName(memberKey);
                existingMember = this.getMember(name, memberId = sal.getMemberIdFromCache(memberKey));
                if (existingMember == null) {
                    boolean memberHasFillerParent = false;
                    String pun = sal.getParentUniqueNameFromCache(memberKey);
                    if (!this.isRootLevel() && pun != null) {
                        int parentLevelNumber = ((LOLAPCube)this.getDimension().getCube()).getCorrespondingLOLAPLevelIndex(this.getHierarchy(), sal.getParentLevelIndexFromCache(memberKey));
                        int memberLevelNumber = ((LOLAPCube)this.getDimension().getCube()).getCorrespondingLOLAPLevelIndex(this.getHierarchy(), sal.getMemberLevelIndexFromCache(memberKey));
                        if (memberLevelNumber - parentLevelNumber > 1) {
                            memberHasFillerParent = true;
                            MemberStorageKey parentCacheKey = sal.getParentMemberRefKeyFromCache(memberKey);
                            String parentName = pun.substring(pun.lastIndexOf("[") + 1, pun.length() - 1);
                            if (sal.isParentMemberRefFullyCached(memberKey)) {
                                parent = (MemberProxy)((Level)this.getHierarchy().getLevel(parentLevelNumber)).getMember(parentName, sal.getMemberIdFromCache(parentCacheKey));
                            }
                            if (parent == null) {
                                parent = (MemberProxy)((Hierarchy)this.getHierarchy()).findMember(parentName);
                            }
                        } else {
                            parent = (MemberProxy)punToParent.get(pun);
                        }
                    }
                    if (parent != null && memberHasFillerParent) {
                        parent.getChildrenOrderedMap(this.getIndex());
                        existingMember = this.getMember(name, memberId);
                    }
                }
                if (existingMember != null) {
                    result.put(existingMember);
                    ++numCachedMembersFoundInOrderedMap;
                    continue;
                }
                LOLAPMemberProxy memberShell = new LOLAPMemberProxy((MemberStorageKey)memberKey, name, (ILevel)this);
                ((IMemberCubics)memberShell).setParentMember(parent);
                result.put(memberShell);
            }
        }
        IMember[] membersPresentInOrderedMap = (IMember[])this.getMembersOrderedMap().toArray(new IMember[0]);
        int numMembersToReinsert = membersPresentInOrderedMap.length - numCachedMembersFoundInOrderedMap;
        for (int i = 0; i < membersPresentInOrderedMap.length && numMembersToReinsert > 0; ++i) {
            IMember aMember = membersPresentInOrderedMap[i];
            if (result.get(aMember.getName()) != null) continue;
            result.put(aMember);
            --numMembersToReinsert;
        }
        if (singleRootParent != null) {
            singleRootParent.setChildren(result);
        }
        this.setMembers(result);
        this.setGotAllMembers();
        return result;
    }

    public List<IMember> getParentMembers() {
        return this.getPreviousLevel().getMembers();
    }

    private OrderedMap<IMember> fetchAllMeasuresOnLevel() {
        OrderedMap<IMember> result = new OrderedMap<IMember>();
        LOLAPDimension d = (LOLAPDimension)this.getDimension();
        IMeasure[] measures = null;
        measures = this.modelLevel == null ? (IMeasure[])d.getMembersFromHierarchyLessModeledDim() : this.modelLevel.getMembers().toArray(new IMeasure[0]);
        if (measures != null) {
            for (int i = 0; i < measures.length; ++i) {
                LOLAPMeasure lolapMeasure = new LOLAPMeasure(measures[i], (ILevel)this);
                ((LOLAPCube)d.getCube()).cacheLOLAPMeasure(lolapMeasure);
                result.add(lolapMeasure);
            }
        }
        this.setMembers(result);
        this.setGotAllMembers();
        return result;
    }

    public IOrderedMap<IMember> fetchReferencedMeasuresOnLevel() {
        OrderedMap<IMember> result = new OrderedMap<IMember>();
        ConcurrentMap<String, IMeasure> mdxQueryReferencedMeasures = ((LOLAPCube)this.getDimension().getCube()).getMeasureInfo();
        if (mdxQueryReferencedMeasures == null || mdxQueryReferencedMeasures.isEmpty()) {
            return result;
        }
        Collection measures = mdxQueryReferencedMeasures.values();
        LOLAPDimension d = (LOLAPDimension)this.getDimension();
        for (IMeasure measure : measures) {
            LOLAPMeasure lolapMeasure = new LOLAPMeasure(measure, (ILevel)this);
            ((LOLAPCube)d.getCube()).cacheLOLAPMeasure(lolapMeasure);
            result.add(lolapMeasure);
        }
        this.addMeasures(result);
        if (result.size() == this.getMemberCount()) {
            this.setGotAllMembers();
        }
        return result;
    }

    private void updateMembersInCache(Set<String> propertiesList) {
        LOLAPDimension dim = (LOLAPDimension)this.getDimension();
        LOLAPCube cube = (LOLAPCube)dim.getCube();
        IRestrictions restrictions = cube.getCubeRestrictions();
        String dimName = dim.getExternalName();
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimName);
        LOLAPHierarchy hier = (LOLAPHierarchy)this.getHierarchy();
        String hierName = hier.getExternalName();
        if (hierName.equals("") || hierName.equals("[Measures]")) {
            hierName = dimName;
        }
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hierName);
        String levelName = this.getExternalName();
        if (!levelName.equals("")) {
            restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, levelName);
        } else {
            restrictions.add(RestrictionType.LEVEL_NUMBER, this.getIndex());
        }
        StringBuilder properties = new StringBuilder();
        for (String prop : propertiesList) {
            if (properties.length() == 0) {
                properties.append(prop);
                continue;
            }
            properties.append(", ");
            properties.append(prop);
        }
        restrictions.add(RestrictionType.DIMENSION_PROPERTIES, properties.toString());
        try {
            cube.getSecuredMetadataProvider().getSAL().loadPropertiesForMembersOnLevel(cube.getSecuredMetadataProvider().getUserId(), restrictions);
        }
        catch (Exception e) {
            String msTsInfo = LOLAPMemberProxy.gatherMemberStorageTimestampInfo(cube);
            if (msTsInfo != null) {
                StringBuilder strBldr = new StringBuilder("SAL exception encountered. ");
                strBldr.append("LUN is " + levelName);
                strBldr.append(msTsInfo);
                mMSErrorLogger.log(strBldr.toString());
            }
            throw XQERuntimeException.wrap(e);
        }
        this.updateLoadedProperties(propertiesList);
    }

    public String getExternalName() {
        return this.getUniqueName();
    }

    @Override
    public String getV5UniqueName() {
        if (this.modelLevel == null) {
            return null;
        }
        if (this.v5UniqueName == null) {
            this.v5UniqueName = this.modelLevel.getV5UniqueName();
        }
        return this.v5UniqueName;
    }

    @Override
    public synchronized List<IMetadata> getChildMetadataObjects() {
        List<IMetadata> children = super.getChildMetadataObjects();
        if (children == null) {
            this.populateChildren();
            return super.getChildMetadataObjects();
        }
        return children;
    }

    @Override
    public void populateChildren() {
        List<IMember> members = this.getMembers();
        members.toArray();
    }

    @Override
    public boolean isAutoGenerated() {
        return this.modelLevel.isAutoGenerated();
    }

    public void loadMissingProperties() {
        Set<String> missingProperties = this.getMissingProperties();
        if (missingProperties.size() > 0) {
            this.writeLock().lock();
            try {
                this.updateMembersInCache(missingProperties);
            }
            finally {
                this.writeLock().unlock();
            }
        }
    }
}

