/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider;

import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.securecache.SecurityAwareLayer;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Measure;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.ImmutableOrderedMap;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameParser;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LOLAPMeasure
extends Measure {
    IMeasure modelMeasure;
    private boolean isDummyMember = false;
    private ICacheKey measureCacheKey;
    private static XQELogger mMSErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MemberStorage", LogLevel.ERROR);
    private Object textReplacementCaption = null;
    private String textReplacementDescription = null;

    public static String getNameFromMFWUniqueName(IMeasure mfwMeasure) {
        String name = null;
        String[] parts = UniqueNameParser.parseNoThrow(mfwMeasure.getUniqueName());
        name = parts != null && parts.length > 0 ? UniqueNameParser.escapeSquareBrackets(parts[parts.length - 1]) : mfwMeasure.getName();
        return name;
    }

    public LOLAPMeasure(IMeasure mfwMeasure, ILevel l) {
        super(LOLAPMeasure.getNameFromMFWUniqueName(mfwMeasure), l);
        IMember lolapParentMeasure;
        this.modelMeasure = mfwMeasure;
        this.measureCacheKey = null;
        this.setDataType(this.modelMeasure.getDataType());
        IMember parentMeasure = mfwMeasure.getParent();
        if (parentMeasure != null && (lolapParentMeasure = l.getPreviousLevel().getMember(parentMeasure.getUniqueName())) != null) {
            this.setParentMember(lolapParentMeasure);
        }
        this.setMemberId(0L);
    }

    public LOLAPMeasure(String name, ILevel l) {
        super(name, l);
        this.modelMeasure = null;
        this.measureCacheKey = null;
        if (!name.equals("DummyMeasure")) {
            throw new XQERuntimeException();
        }
        this.isDummyMember = true;
        this.setMemberId(0L);
    }

    @Override
    public IOrderedMap<IMember> fetchChildMembers() throws MetadataException, ProviderException {
        OrderedMap childMeasures;
        Level nextLevel = (Level)this.getLevel().getNextLevel();
        if (nextLevel == null) {
            childMeasures = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
        } else {
            childMeasures = new OrderedMap();
            List<IMember> measures = nextLevel.getMembers();
            for (IMember meas : measures) {
                if (!meas.getParent().equals(this)) continue;
                childMeasures.put(meas);
            }
            if (childMeasures.size() == 0) {
                childMeasures = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
            }
        }
        return childMeasures;
    }

    protected void setCacheKey(ICacheKey cacheKey) {
        this.measureCacheKey = cacheKey;
    }

    @Override
    public String getUniqueName() {
        if (this.getDimension().getCube() instanceof LOLAPTM1Cube) {
            String datasourceType = ((LOLAPTM1Cube)this.getDimension().getCube()).getDatasourceType();
            StringBuilder memUniqueName = new StringBuilder(this.getHierarchy().getUniqueName());
            if (DataSourceTypeEnum.isTM1(datasourceType)) {
                memUniqueName.append(".[@MEMBER]");
            }
            memUniqueName.append(".[");
            memUniqueName.append(this.getName());
            memUniqueName.append("]");
            return memUniqueName.toString();
        }
        return super.getUniqueName();
    }

    @Override
    public String getCaption() {
        Object value = null;
        if (this.isDummyMember() || this.measureCacheKey == null) {
            if (this.modelMeasure != null) {
                value = this.modelMeasure.getCaption();
                if (value == null) {
                    value = this.getName();
                }
            } else {
                value = this.getName();
            }
        } else {
            value = this.textReplacementCaption != null ? this.textReplacementCaption : this.retrievePropValueFromCache("CAPTION");
            if (value != null) {
                LOLAPCube cube = (LOLAPCube)this.getDimension().getCube();
                SecurityAwareLayer sal = cube.getSAL();
                LocalizedString localizedCaption = (LocalizedString)value;
                Locale locale = cube.getLocale();
                String caption = localizedCaption.toString(LocaleConverter.getLanguage(locale));
                if (caption == null) {
                    Map<String, String> supportedLocales = sal.getMemberStorage().getSupportedLocales();
                    caption = supportedLocales == null || supportedLocales.containsKey(LocaleConverter.getLanguage(locale)) || cube.trustProviderCaption() ? localizedCaption.toString(localizedCaption.getDefaultLocale()) : this.getName();
                }
                IRestrictions restrictions = ((LOLAPCube)this.getDimension().getCube()).getCubeRestrictionsReference();
                restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getDimension().getUniqueName());
                if (sal.isReplacementVariableUsedFor(restrictions)) {
                    this.textReplacementCaption = value;
                }
                value = caption;
            }
        }
        return value;
    }

    @Override
    public Value getCaptionValue() {
        StringValue v = DataValueFactory.createStringValue();
        ((Value)v).set(this.getCaption());
        return v;
    }

    @Override
    public String getDescription() {
        String description = null;
        if (this.isDummyMember() || this.measureCacheKey == null) {
            if (this.modelMeasure != null) {
                description = this.modelMeasure.getDescription();
                if (description == null) {
                    description = this.getCaption();
                }
            } else {
                description = this.getCaption();
            }
        } else if (this.textReplacementDescription != null) {
            description = this.textReplacementDescription;
        } else {
            description = (String)this.retrievePropValueFromCache("DESCRIPTION");
            SecurityAwareLayer sal = ((LOLAPCube)this.getDimension().getCube()).getSAL();
            IRestrictions restrictions = ((LOLAPCube)this.getDimension().getCube()).getCubeRestrictionsReference();
            restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getDimension().getUniqueName());
            if (sal.isReplacementVariableUsedFor(restrictions)) {
                this.textReplacementDescription = description;
            }
        }
        return description;
    }

    @Override
    public Value getDescriptionValue() {
        StringValue v = DataValueFactory.createStringValue();
        ((Value)v).set(this.getDescription());
        return v;
    }

    @Override
    public IAggregateRule[] getAggregateRules() {
        return this.modelMeasure.getAggregateRules();
    }

    @Override
    public String getV5UniqueName() {
        return this.modelMeasure.getV5UniqueName();
    }

    @Override
    public boolean isDummyMember() {
        return this.isDummyMember;
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        if (this.isDummyMember()) {
            return AggregateTypeEnum.UNKNOWN;
        }
        return this.modelMeasure.getRegularAggregate();
    }

    private Object retrievePropValueFromCache(String propName) {
        Object value = null;
        SecurityAwareLayer sal = ((LOLAPCube)this.getDimension().getCube()).getSAL();
        IRestrictions restrictions = ((LOLAPCube)this.getDimension().getCube()).getCubeRestrictionsReference();
        try {
            value = sal.getMemberPropValueFromCache(this.measureCacheKey, propName, restrictions);
        }
        catch (Exception e) {
            String msTsInfo = LOLAPMemberProxy.gatherMemberStorageTimestampInfo((LOLAPCube)this.getDimension().getCube());
            if (msTsInfo != null) {
                StringBuilder strBldr = new StringBuilder("SAL exception encountered while retrieving a measure property. ");
                strBldr.append(" Measure is: ");
                strBldr.append(this.getUniqueName());
                strBldr.append(msTsInfo);
                mMSErrorLogger.log(strBldr.toString());
            }
            throw XQERuntimeException.wrap(e);
        }
        return value;
    }
}

