/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorageKey;
import com.cognos.xqe.data.providers.olap.securecache.SecurityAwareLayer;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MemberProxy;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.ImmutableOrderedMap;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LOLAPMemberProxy
extends MemberProxy {
    private static final String DUMMY_MEMBER_NAME = "DummyMember";
    private static final String BRACE_STR = "[";
    private static final String MEMBER_CAPTION_STR = "MEMBER_CAPTION";
    private static final String MEMBERCAPTION_STR = "memberCaption";
    private static final String MEASURES_STR = "[Measures]";
    private long memberId;
    private boolean isDummyMember = false;
    private static final int DUMMY_MEMBER_ID = 0xFFFFFF;
    private Object replacementTextCaption = null;
    private Object replacementTextDescription = null;
    private boolean isFillerMember = false;
    private HashMap<Integer, IMember> fillerMembers = null;
    private String mCaption = null;
    private static XQELogger mMSErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MemberStorage", LogLevel.ERROR);
    private volatile int childrenRetrievedLevelIndex = -1;
    private final Lock parentLock = new ReentrantLock();
    private final Lock membersLock = new ReentrantLock();
    private final Lock childIndexLock = new ReentrantLock();
    private final Lock getChildrenLock = new ReentrantLock();
    private static String providerException = "ProviderException";
    private boolean isMultiHierarchySlicer = false;

    public LOLAPMemberProxy(MemberStorageKey memKey, String memName, ILevel memLevel) {
        super(memKey, memName, memLevel);
        if (memKey == null && memName != null && memName.equals("")) {
            this.isFillerMember = true;
            this.memberId = -1L;
        } else {
            SecurityAwareLayer sal = ((LOLAPCube)this.getDimension().getCube()).getSAL();
            this.memberId = sal.getMemberIdFromCache(memKey);
            this.memberUniqueName = sal.getMemberUniqueNameFromCache(memKey);
        }
    }

    public LOLAPMemberProxy(IMember defaultMember) {
        super((ICacheKey)null, DUMMY_MEMBER_NAME, defaultMember.getLevel());
        this.isDummyMember = true;
        this.isCached = false;
        this.memberId = 0xFFFFFFL;
    }

    public LOLAPMemberProxy(MemberRecord record, ILevel level) {
        super(record.getName(), record.getUniqueName(), level);
        this.mCaption = record.getCaption().toString();
        if (level.getIndex() > 0) {
            IHierarchy hierarchy = level.getHierarchy();
            ILevel parentLevel = hierarchy.getLevel(record.getParentLevelNumber());
            LOLAPMemberProxy parent = new LOLAPMemberProxy(record.getParentUniqueName(), record.getParentUniqueName(), parentLevel);
            this.setParentMember(parent);
        }
        this.isCached = false;
        this.memberId = 0xFFFFFFL;
    }

    private LOLAPMemberProxy(String memName, String memUniqueName, ILevel level) {
        super(memName, memUniqueName, level);
        this.isCached = false;
        this.memberId = 0xFFFFFFL;
    }

    @Override
    public String getCaption() {
        if ((this.isDummyMember || !this.isCached) && this.mCaption != null) {
            return this.mCaption;
        }
        return super.getCaption();
    }

    @Override
    public Object retrievePropValueFromCache(String propName) {
        Object value = null;
        if (this.isFillerMember() || this.isDummyMember()) {
            if (propName.equalsIgnoreCase(MEMBER_CAPTION_STR) || propName.equalsIgnoreCase(MEMBERCAPTION_STR) || propName.equalsIgnoreCase("MEMBER_UNIQUE_NAME")) {
                value = this.getName();
            } else if (propName.equalsIgnoreCase("MEMBER_TYPE")) {
                value = MemberTypeEnum.REGULAR;
            }
        } else {
            LOLAPCube cube = (LOLAPCube)this.getDimension().getCube();
            SecurityAwareLayer sal = cube.getSAL();
            IRestrictions restrictions = cube.getCubeRestrictionsReference();
            try {
                if (propName.equalsIgnoreCase(MEMBER_CAPTION_STR) || propName.equalsIgnoreCase(MEMBERCAPTION_STR)) {
                    if (this.replacementTextCaption != null) {
                        value = this.replacementTextCaption;
                    } else {
                        value = this.getReplacementTextValue("CAPTION", sal, restrictions);
                        this.replacementTextCaption = value;
                    }
                    if (this.replacementTextCaption == null) {
                        value = sal.getMemberPropValueFromCache(this.getCacheKey(), "CAPTION", restrictions);
                    }
                    if (value != null) {
                        LocalizedString localizedCaption = (LocalizedString)value;
                        Locale locale = cube.getLocale();
                        String caption = localizedCaption.toString(LocaleConverter.getLanguage(locale));
                        if (caption == null) {
                            Map<String, String> supportedLocales = sal.getMemberStorage().getSupportedLocales();
                            caption = supportedLocales == null || supportedLocales.containsKey(LocaleConverter.getLanguage(locale)) || cube.trustProviderCaption() ? localizedCaption.toString(localizedCaption.getDefaultLocale()) : this.getName();
                        }
                        this.replacementTextCaption = value;
                        value = caption;
                    }
                } else if (cube.isMemberNameSupported(propName)) {
                    value = sal.getMemberPropValueFromCache(this.getCacheKey(), "MEMBER_NAME", restrictions);
                } else if (cube.isMemberAnAttribute(propName, this.getLevel())) {
                    String propertyName = cube.getAttributeUniqueName(propName, this.getLevel());
                    value = sal.getAttributeValueFromCache(this.getCacheKey(), propertyName, restrictions);
                    if (value == null) {
                        ArrayList<LOLAPMemberProxy> memArrayList = new ArrayList<LOLAPMemberProxy>();
                        memArrayList.add(this);
                        IMember[] mems = memArrayList.toArray(new IMember[0]);
                        HashMap<String, Object> tupsMap = cube.getAttributeValuesForMembers(propertyName, mems);
                        value = tupsMap.get(this.getUniqueName());
                        sal.setDynamicProperty(this.getCacheKey(), propertyName, value);
                    }
                } else if (propName.equalsIgnoreCase("DESCRIPTION")) {
                    if (this.replacementTextDescription != null) {
                        value = this.replacementTextDescription;
                    } else {
                        value = this.getReplacementTextValue("DESCRIPTION", sal, restrictions);
                        this.replacementTextDescription = value;
                    }
                    if (this.replacementTextDescription == null) {
                        value = sal.getMemberPropValueFromCache(this.getCacheKey(), propName, restrictions);
                        this.replacementTextDescription = value;
                    }
                } else {
                    value = sal.getMemberPropValueFromCache(this.getCacheKey(), propName, restrictions);
                }
            }
            catch (Exception e) {
                String msTsInfo = LOLAPMemberProxy.gatherMemberStorageTimestampInfo(cube);
                if (msTsInfo != null) {
                    StringBuilder strBldr = new StringBuilder("SAL exception encountered while retrieving a property value from member cache. ");
                    strBldr.append(" Property is: ");
                    strBldr.append(propName);
                    strBldr.append(". Member is: ");
                    strBldr.append(this.getUniqueName());
                    strBldr.append(msTsInfo);
                    mMSErrorLogger.log(strBldr.toString());
                }
                throw XQERuntimeException.wrap(e);
            }
        }
        return value;
    }

    @Override
    public IOrderedMap<IMember> fetchChildren() {
        this.initChildrenOrderedMap(-1);
        return this.childrenOrderedMap;
    }

    private Object getReplacementTextValue(String replacementText, SecurityAwareLayer sal, IRestrictions restrictions) {
        Object value = null;
        IRestrictions newRestrictions = restrictions;
        newRestrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getDimension().getUniqueName());
        if (sal.isReplacementVariableUsedFor(newRestrictions)) {
            LOLAPCube cube = (LOLAPCube)this.getDimension().getCube();
            sal.setCube(cube);
            if (cube.getReplacementTextCaptions().containsKey(this.getUniqueName())) {
                if (replacementText.equals("CAPTION")) {
                    value = cube.getReplacementTextCaptions().get(this.getUniqueName());
                } else if (replacementText.equals("DESCRIPTION")) {
                    value = cube.getReplacementTextDescrips().get(this.getUniqueName());
                }
            }
        }
        return value;
    }

    private IOrderedMap<IMember> fetchChildren(int maxLevelIndex) {
        OrderedMap children = null;
        int parentLevelIndex = ((Level)this.getLevel()).getIndex();
        Level nextLevel = (Level)this.getLevel().getNextLevel();
        if (nextLevel == null) {
            children = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
        } else {
            children = new OrderedMap();
            try {
                List<ICacheKey> childKeys = null;
                SecurityAwareLayer sal = ((LOLAPCube)this.getDimension().getCube()).getSAL();
                childKeys = this.getMemberChildrenFromCache(maxLevelIndex);
                if (childKeys != null) {
                    CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
                    for (ICacheKey childKey : childKeys) {
                        int childMemberId;
                        if (cancelManager != null && cancelManager.isRequestCancelled()) {
                            throw new OperationCanceledException();
                        }
                        IMember memberShell = null;
                        int childLevelIndex = -1;
                        String childName = null;
                        Level childLevel = null;
                        boolean memberShellCreated = false;
                        childName = ((LOLAPCube)this.getDimension().getCube()).getMemberName(childKey);
                        childLevelIndex = ((LOLAPCube)this.getDimension().getCube()).getCorrespondingLOLAPLevelIndex(this.getHierarchy(), sal.getMemberLevelIndexFromCache(childKey));
                        childLevel = (Level)this.getHierarchy().getLevel(childLevelIndex);
                        memberShell = childLevel.getMember(childName, childMemberId = sal.getMemberIdFromCache(childKey));
                        if (memberShell == null) {
                            memberShell = new LOLAPMemberProxy((MemberStorageKey)childKey, childName, (ILevel)childLevel);
                            memberShellCreated = true;
                            sal.isDataMember(childKey);
                        }
                        IMember childMember = LOLAPMemberProxy.createFillerMemberChain(this, parentLevelIndex, (LOLAPMemberProxy)memberShell, childLevelIndex);
                        ((IMemberCubics)childMember).setIndexInParentsChildren(children.size());
                        children.put(childMember);
                        if (!memberShellCreated) continue;
                        childLevel.addMember(memberShell);
                    }
                }
            }
            catch (ProviderException e) {
                throw new MetadataException(providerException, e);
            }
            if (children.size() == 0) {
                children = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
            }
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IMember createFillerMemberChain(LOLAPMemberProxy upperMember, int upperLevelIndex, LOLAPMemberProxy lowerMember, int lowerLevelIndex) {
        LOLAPMemberProxy lOLAPMemberProxy;
        IMember result = null;
        int lowerMemberId = lowerMember.getIndex();
        int i = upperLevelIndex + 1;
        if (i < lowerLevelIndex) {
            lOLAPMemberProxy = upperMember;
            synchronized (lOLAPMemberProxy) {
                if (upperMember.fillerMembers != null) {
                    result = upperMember.fillerMembers.get(lowerMemberId);
                }
            }
        }
        result = lowerMember;
        lOLAPMemberProxy = lowerMember;
        synchronized (lOLAPMemberProxy) {
            if (lowerMember.getParent() == null) {
                lowerMember.setParentMember(upperMember);
            }
        }
        if (result == null) {
            lOLAPMemberProxy = upperMember;
            synchronized (lOLAPMemberProxy) {
                IMember result2 = null;
                if (upperMember.fillerMembers != null) {
                    result2 = upperMember.fillerMembers.get(lowerMemberId);
                }
                if (result2 == null) {
                    LOLAPMemberProxy parentMember = upperMember;
                    LOLAPMemberProxy fillerMember = null;
                    while (i < lowerLevelIndex) {
                        fillerMember = new LOLAPMemberProxy((MemberStorageKey)null, "", upperMember.getHierarchy().getLevel(i));
                        fillerMember.setParentMember(parentMember);
                        if (i == upperLevelIndex + 1) {
                            result = fillerMember;
                        } else {
                            OrderedMap<IMember> childFillers = new OrderedMap<IMember>();
                            childFillers.put(fillerMember);
                            parentMember.setChildren(childFillers);
                        }
                        if (parentMember.fillerMembers == null) {
                            parentMember.fillerMembers = new HashMap();
                        }
                        parentMember.fillerMembers.put(lowerMemberId, fillerMember);
                        parentMember = fillerMember;
                        ++i;
                    }
                    if (fillerMember != null) {
                        lowerMember.setParentMember(fillerMember);
                        OrderedMap<IMember> nonFillerChildren = new OrderedMap<IMember>();
                        nonFillerChildren.put(lowerMember);
                        fillerMember.setChildren(nonFillerChildren);
                    }
                } else {
                    result = result2;
                }
            }
        }
        return result;
    }

    private List<ICacheKey> getMemberChildrenFromCache(int maxLevelIndex) {
        return LOLAPMemberProxy.getMembersFromCache((LOLAPLevel)this.getLevel(), this.getUniqueName(), maxLevelIndex, TreeOperatorEnum.CHILDREN, 0);
    }

    @Override
    public IOrderedMap<IMember> getDescendantsOrderedMap(int depth, int descRangeFlag) {
        int maxHierarchyDepth;
        OrderedMap descendants = null;
        int maxFetchedDepth = maxHierarchyDepth = this.getLevel().getHierarchy().getLevelCount() - 1;
        if (descRangeFlag == 1) {
            maxFetchedDepth = this.getLevel().getIndex() + depth - 1;
        } else if (descRangeFlag == 0 || descRangeFlag == 5) {
            maxFetchedDepth = this.getLevel().getIndex() + depth;
        }
        SecurityAwareLayer sal = null;
        List<ICacheKey> descendantKeys = null;
        this.getChildrenLock.lock();
        try {
            sal = ((LOLAPCube)this.getDimension().getCube()).getSAL();
            descendantKeys = LOLAPMemberProxy.getMembersFromCache((LOLAPLevel)this.getLevel(), this.getUniqueName(), depth, TreeOperatorEnum.DESCENDANTS, descRangeFlag);
        }
        catch (ProviderException e) {
            throw new MetadataException(providerException, e);
        }
        finally {
            this.getChildrenLock.unlock();
        }
        if (descendantKeys == null) {
            descendants = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
        } else {
            descendants = new OrderedMap();
            HashMap<ICacheKey, IOrderedMap<IMember>> parentChildrenMap = new HashMap<ICacheKey, IOrderedMap<IMember>>();
            int storedParentLevelIndex = -1;
            ICacheKey storedParentKey = null;
            ICacheKey currentDescendantKey = null;
            ICacheKey nextDescendantKey = null;
            LOLAPMemberProxy storedParentMember = this;
            Stack<LOLAPMemberProxy> parents = new Stack<LOLAPMemberProxy>();
            parents.push(this);
            IOrderedMap<IMember> cachedChildrenOrderedMap = null;
            LOLAPCube cube = (LOLAPCube)this.getDimension().getCube();
            IHierarchy hierarchy = this.getHierarchy();
            int size = descendantKeys.size();
            for (int i = 0; i < size; ++i) {
                int currentDescMemberId;
                currentDescendantKey = descendantKeys.get(i);
                if (currentDescendantKey.equals(storedParentKey = storedParentMember.getCacheKey())) {
                    descendants.put(storedParentMember);
                    continue;
                }
                MemberStorageKey currentParentKey = sal.getParentMemberRefKeyFromCache(currentDescendantKey);
                while (currentParentKey != null && !storedParentKey.equals(currentParentKey) && !parents.empty()) {
                    boolean isLeaf;
                    storedParentMember = (LOLAPMemberProxy)parents.lastElement();
                    storedParentKey = storedParentMember.getCacheKey();
                    if (storedParentKey.equals(currentParentKey)) continue;
                    cachedChildrenOrderedMap = (ImmutableOrderedMap<IMember>)parentChildrenMap.get(storedParentKey);
                    int memberLevelIndex = storedParentMember.getLevel().getIndex();
                    boolean bl = isLeaf = cachedChildrenOrderedMap == null && (memberLevelIndex == maxHierarchyDepth || memberLevelIndex < maxFetchedDepth);
                    if (isLeaf) {
                        cachedChildrenOrderedMap = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
                    }
                    if (cachedChildrenOrderedMap != null) {
                        storedParentMember.setChildren(cachedChildrenOrderedMap);
                        storedParentMember.setGotAllChildren();
                    }
                    parents.pop();
                }
                storedParentLevelIndex = storedParentMember.getLevel().getIndex();
                int currentDescLevelIndex = cube.getCorrespondingLOLAPLevelIndex(hierarchy, sal.getMemberLevelIndexFromCache(currentDescendantKey));
                IMember memberShell = null;
                String currentDescName = null;
                Level currentDescLevel = null;
                currentDescName = cube.getMemberName(currentDescendantKey);
                currentDescLevel = (Level)hierarchy.getLevel(currentDescLevelIndex);
                memberShell = currentDescLevel.getMember(currentDescName, currentDescMemberId = sal.getMemberIdFromCache(currentDescendantKey));
                if (memberShell == null) {
                    memberShell = new LOLAPMemberProxy((MemberStorageKey)currentDescendantKey, currentDescName, (ILevel)currentDescLevel);
                    currentDescLevel.addMember(memberShell);
                    sal.isDataMember(currentDescendantKey);
                }
                IMember childOfCurrentStoredParent = LOLAPMemberProxy.createFillerMemberChain(storedParentMember, storedParentLevelIndex, (LOLAPMemberProxy)memberShell, currentDescLevelIndex);
                if (((LOLAPMemberProxy)childOfCurrentStoredParent).isFillerMember) {
                    childOfCurrentStoredParent = memberShell;
                }
                descendants.put(childOfCurrentStoredParent);
                cachedChildrenOrderedMap = (IOrderedMap)parentChildrenMap.get(storedParentKey);
                if (cachedChildrenOrderedMap == null) {
                    cachedChildrenOrderedMap = new OrderedMap();
                    parentChildrenMap.put(storedParentKey, cachedChildrenOrderedMap);
                }
                cachedChildrenOrderedMap.put(childOfCurrentStoredParent);
                int next = i + 1;
                if (next >= size || storedParentKey.equals(sal.getParentMemberRefKeyFromCache(nextDescendantKey = descendantKeys.get(next)))) continue;
                parents.push((LOLAPMemberProxy)memberShell);
            }
        }
        return descendants;
    }

    public static Set<String> getDimenstionProperties(String dum) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (execEnv == null) {
            return null;
        }
        XDataContext dataContext = execEnv.getDataContext();
        if (dataContext == null) {
            return null;
        }
        Map dimProperties = MapCast.uncheckedCast((Map)dataContext.getProperty("axesDimensionProperties"));
        Set propertyList = null;
        if (dimProperties != null) {
            propertyList = (Set)dimProperties.get(dum);
            if (!execEnv.getDataSource().getType().equals("EB")) {
                if (propertyList != null) {
                    propertyList.addAll((Collection)dimProperties.get("nativeProperties"));
                } else {
                    propertyList = (Set)dimProperties.get("nativeProperties");
                }
            }
        }
        return propertyList;
    }

    public static List<ICacheKey> getMembersFromCache(LOLAPLevel level, String mun, int maxLevelIndex, TreeOperatorEnum treeOp, int descRangeFlag) {
        Set<String> propertiesList;
        String hierName;
        LOLAPDimension dim = (LOLAPDimension)level.getDimension();
        LOLAPCube cube = (LOLAPCube)dim.getCube();
        IRestrictions restrictions = cube.getCubeRestrictions();
        String dimName = dim.getExternalName();
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimName);
        LOLAPHierarchy hier = (LOLAPHierarchy)level.getHierarchy();
        IHierarchy modelHier = hier.getModelHierarchy();
        if (restrictions.contains(RestrictionType.KEY_DATE) && modelHier != null && modelHier.getValidFrom() == null && modelHier.getValidTo() == null) {
            restrictions.remove(RestrictionType.KEY_DATE);
        }
        if ((hierName = hier.getExternalName()).equals("") || hierName.equals(MEASURES_STR)) {
            hierName = dimName;
        }
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hierName);
        String levelName = level.getExternalName();
        if (!levelName.equals("")) {
            restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, levelName);
        } else {
            restrictions.add(RestrictionType.LEVEL_NUMBER, level.getIndex());
        }
        if (mun != null) {
            restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, mun);
            if (treeOp == TreeOperatorEnum.CHILDREN) {
                restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMCHILDREN);
            } else if (treeOp == TreeOperatorEnum.DESCENDANTS) {
                restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMDESCENDANTS);
                restrictions.add(RestrictionType.DESCENDANTSOPT, descRangeFlag);
                restrictions.add(RestrictionType.DESCENDANTSLEVELDISTANCE, maxLevelIndex);
            }
        }
        if ((propertiesList = LOLAPMemberProxy.getDimenstionProperties(dim.getUniqueName())) != null) {
            StringBuilder properties = new StringBuilder();
            for (String prop : propertiesList) {
                if (properties.length() == 0) {
                    properties.append(prop);
                    continue;
                }
                properties.append(", ");
                properties.append(prop);
            }
            restrictions.add(RestrictionType.DIMENSION_PROPERTIES, properties.toString());
        }
        List<ICacheKey> cacheKeys = null;
        try {
            SecurityAwareLayer sal = cube.getSecuredMetadataProvider().getSAL();
            if (sal.isReplacementVariableUsedFor(restrictions)) {
                sal.setCube(cube);
            }
            if (maxLevelIndex == -1 && treeOp != TreeOperatorEnum.DESCENDANTS) {
                cacheKeys = cube.getSecuredMetadataProvider().collectMembersInCache(restrictions);
            } else {
                if (mun == null) {
                    throw new XQERuntimeException();
                }
                String userId = cube.getSecuredMetadataProvider().getUserId();
                if (treeOp == TreeOperatorEnum.CHILDREN) {
                    cacheKeys = sal.getMemberChildren(userId, restrictions, maxLevelIndex);
                } else if (treeOp == TreeOperatorEnum.DESCENDANTS) {
                    cacheKeys = sal.getMemberDescendants(userId, restrictions);
                }
            }
        }
        catch (Exception e) {
            String msTsInfo = LOLAPMemberProxy.gatherMemberStorageTimestampInfo(cube);
            if (msTsInfo != null) {
                StringBuilder strBldr = new StringBuilder("SAL exception encountered. ");
                strBldr.append("LUN is " + levelName);
                if (mun != null) {
                    strBldr.append(". MUN is " + mun);
                }
                strBldr.append(msTsInfo);
                mMSErrorLogger.log(strBldr.toString());
            }
            throw XQERuntimeException.wrap(e);
        }
        if (mun == null) {
            level.updateLoadedProperties(propertiesList);
        }
        return cacheKeys;
    }

    public static String gatherMemberStorageTimestampInfo(LOLAPCube cube) {
        long cubeMSTimestamp;
        String memberStorageTimestampInfo = null;
        long requestCtxMSTimestamp = cube.getSecuredMetadataProvider().getSAL().getMemberStorage().getTimestamp();
        if (requestCtxMSTimestamp != (cubeMSTimestamp = cube.getMemberStorage().getTimestamp())) {
            memberStorageTimestampInfo = new String(". Unexpected MemberStorage timestamp mismatch. Request context MS timestamp: " + requestCtxMSTimestamp + ". Cube MS timestamp: " + cubeMSTimestamp);
        }
        return memberStorageTimestampInfo;
    }

    public static ICacheKey cacheAlreadyRetrievedMember(IMember member, LOLAPCube cube, MemberRecord memberRecord) {
        IRestrictions restrictions = cube.getCubeRestrictions();
        return LOLAPMemberProxy.cacheAlreadyRetrievedMember(member, cube, restrictions, memberRecord);
    }

    public static ICacheKey cacheAlreadyRetrievedMember(IMember member, LOLAPCube cube, IRestrictions restrictions, MemberRecord memberRecord) {
        String dimName = member.getDimension().getUniqueName();
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimName);
        IHierarchy hier = member.getHierarchy();
        String hierName = hier.getUniqueName();
        if (hierName == null || hierName.equals("") || hierName.equals(MEASURES_STR)) {
            hierName = dimName;
        }
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hierName);
        ICacheKey cacheKey = null;
        try {
            SecurityAwareLayer sal = cube.getSecuredMetadataProvider().getSAL();
            if (sal.isReplacementVariableUsedFor(restrictions)) {
                sal.setCube(cube);
            }
            cacheKey = cube.getSecuredMetadataProvider().cacheAlreadyRetrievedMember(member, restrictions, memberRecord);
        }
        catch (Exception e) {
            String msTsInfo = LOLAPMemberProxy.gatherMemberStorageTimestampInfo(cube);
            if (msTsInfo != null) {
                StringBuilder strBldr = new StringBuilder("SAL exception encountered for member ");
                strBldr.append(member.getUniqueName());
                strBldr.append(msTsInfo);
                mMSErrorLogger.log(strBldr.toString());
            }
            throw XQERuntimeException.wrap(e);
        }
        return cacheKey;
    }

    public static LOLAPMemberProxy initMemberProxy(ICacheKey memberKey, Level level) {
        LOLAPCube c = (LOLAPCube)level.getDimension().getCube();
        LOLAPHierarchy hier = (LOLAPHierarchy)level.getHierarchy();
        LOLAPMemberProxy memberShell = null;
        try {
            SecurityAwareLayer sal = c.getSAL();
            String name = c.getMemberName(memberKey);
            String pun = sal.getParentUniqueNameFromCache(memberKey);
            int memberLevelNumber = c.getCorrespondingLOLAPLevelIndex(hier, sal.getMemberLevelIndexFromCache(memberKey));
            memberShell = new LOLAPMemberProxy((MemberStorageKey)memberKey, name, (ILevel)level);
            sal.isDataMember(memberKey);
            LOLAPMemberProxy parentMemberShell = null;
            if (memberLevelNumber > 0 && pun != null) {
                int parentLevelNumber = c.getCorrespondingLOLAPLevelIndex(hier, sal.getParentLevelIndexFromCache(memberKey));
                MemberStorageKey parentCacheKey = sal.getParentMemberRefKeyFromCache(memberKey);
                String parentName = pun.substring(pun.lastIndexOf(BRACE_STR) + 1, pun.length() - 1);
                if (sal.isParentMemberRefFullyCached(memberKey)) {
                    parentMemberShell = (LOLAPMemberProxy)((Level)hier.getLevel(parentLevelNumber)).getMember(parentName, sal.getMemberIdFromCache(parentCacheKey));
                }
                if (parentMemberShell == null) {
                    parentMemberShell = (LOLAPMemberProxy)hier.findMember(parentName);
                }
                LOLAPMemberProxy.createFillerMemberChain(parentMemberShell, parentLevelNumber, memberShell, memberLevelNumber);
            }
            level.addMember(memberShell);
        }
        catch (Exception e) {
            String msTsInfo = LOLAPMemberProxy.gatherMemberStorageTimestampInfo(c);
            if (msTsInfo != null) {
                StringBuilder strBldr = new StringBuilder("SAL exception encountered during an individual member load");
                strBldr.append(msTsInfo);
                mMSErrorLogger.log(strBldr.toString());
            }
            throw XQERuntimeException.wrap(e);
        }
        return memberShell;
    }

    @Override
    public String getV5UniqueName() {
        if (this.getDimension().isMeasuresDimension()) {
            IMember measure = ((LOLAPCube)this.getDimension().getCube()).getMeasure(this.getUniqueName());
            return measure.getV5UniqueName();
        }
        return UniqueNameGenerator.createMemberV5UniqueName(this.getLevel(), this.getUniqueName());
    }

    @Override
    public boolean isMeasure() {
        return this.getDimension().isMeasuresDimension();
    }

    @Override
    public IDataType getDataType() {
        return MemberType.MEMBERTYPE;
    }

    @Override
    public int getIndex() {
        return (int)this.memberId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIndexInParentsChildren() {
        if (this.indexInParentsChildrenList == -1) {
            int index = -1;
            IMember parentMember = null;
            this.parentLock.lock();
            try {
                parentMember = this.getParent(true);
            }
            finally {
                this.parentLock.unlock();
            }
            if (parentMember == null) {
                List<IMember> rootLevelMembers = null;
                this.membersLock.lock();
                try {
                    rootLevelMembers = ((LOLAPHierarchy)this.getLevel().getHierarchy()).getRootMembers();
                    if (rootLevelMembers.size() > 0) {
                        index = rootLevelMembers.indexOf(this);
                    }
                    index = -1;
                }
                finally {
                    this.membersLock.unlock();
                }
            } else {
                this.parentLock.lock();
                try {
                    if (((IMemberCubics)parentMember).isFillerMember()) {
                        IMember realParent = parentMember;
                        while (((IMemberCubics)realParent).isFillerMember()) {
                            realParent = parentMember.getParent();
                        }
                        index = ((MemberProxy)realParent).getChildIndex(this);
                    } else {
                        index = ((MemberProxy)parentMember).getChildIndex(this, true);
                    }
                }
                finally {
                    this.parentLock.unlock();
                }
            }
            this.childIndexLock.lock();
            try {
                this.indexInParentsChildrenList = index;
            }
            finally {
                this.childIndexLock.unlock();
            }
        }
        return this.indexInParentsChildrenList;
    }

    @Override
    public long getMemberId() {
        return this.memberId;
    }

    @Override
    public void setMemberId(long id) {
        this.memberId = id;
    }

    @Override
    public String getMUNPropValue() {
        return (String)this.retrievePropValueFromCache(((LOLAPCube)this.getDimension().getCube()).getCachedMUNPropName());
    }

    @Override
    public boolean isFillerMember() {
        return this.isFillerMember;
    }

    @Override
    public synchronized ArrayList<IMember> getChildFillerMembers() {
        if (this.fillerMembers == null) {
            return null;
        }
        ArrayList<IMember> childFillerMembers = new ArrayList<IMember>();
        childFillerMembers.addAll(this.fillerMembers.values());
        return childFillerMembers;
    }

    public void setFillerMember(boolean theIsFillerMember) {
        this.isFillerMember = theIsFillerMember;
    }

    @Override
    public boolean isDummyMember() {
        return this.isDummyMember;
    }

    @Override
    public String getDescription() {
        Object description = this.retrievePropValueFromCache("DESCRIPTION");
        String sDescription = null;
        if (description instanceof String) {
            sDescription = (String)description;
        } else if (description instanceof StringValue) {
            sDescription = ((StringValue)description).getString();
        }
        return sDescription;
    }

    @Override
    public Value getDescriptionValue() {
        StringValue v = null;
        Object description = this.retrievePropValueFromCache("DESCRIPTION");
        if (description instanceof String) {
            v = DataValueFactory.createStringValue();
            ((Value)v).set((String)description);
        } else if (description instanceof StringValue) {
            v = (StringValue)description;
        }
        return v;
    }

    @Override
    public List<IMember> getChildren(boolean includeFillerMembers, int maxLevelIndex) {
        if (this.hasGotAllChildren() || !this.getHierarchy().isRagged() || maxLevelIndex == -1) {
            return this.getChildren(includeFillerMembers);
        }
        ArrayList<IMember> result = new ArrayList<IMember>();
        IOrderedMap<IMember> children = this.getChildrenOrderedMap(maxLevelIndex);
        if (children != null) {
            if (includeFillerMembers) {
                result.addAll(children.toArrayList());
            } else {
                for (IMemberCubics iMemberCubics : children) {
                    if (iMemberCubics.isFillerMember()) {
                        List<IMember> nonFillerChildren = iMemberCubics.getChildren(false, maxLevelIndex);
                        result.addAll(nonFillerChildren);
                        continue;
                    }
                    result.add(iMemberCubics);
                }
            }
        }
        return result;
    }

    @Override
    public int getChildIndex(IMember child, boolean includeFillerMembers) {
        List<IMember> children = this.getChildren(includeFillerMembers, child.getLevel().getIndex());
        if (children.size() > 0) {
            return children.indexOf(child);
        }
        return -1;
    }

    @Override
    public IOrderedMap<IMember> getChildrenOrderedMap(int maxLevelIndex) {
        if (!this.getHierarchy().isRagged()) {
            return this.getChildrenOrderedMap();
        }
        if (this.hasGotAllChildren(maxLevelIndex)) {
            return this.childrenOrderedMap;
        }
        this.initChildrenOrderedMap(maxLevelIndex);
        return this.childrenOrderedMap;
    }

    private void initChildrenOrderedMap(int maxLevelIndex) {
        this.getChildrenLock.lock();
        try {
            if (!this.hasGotAllChildren(maxLevelIndex)) {
                this.setChildren(this.fetchChildren(maxLevelIndex), maxLevelIndex);
            }
        }
        finally {
            this.getChildrenLock.unlock();
        }
    }

    @Override
    public void setChildren(IOrderedMap<IMember> children) {
        this.setChildren(children, -1);
    }

    private void setChildren(IOrderedMap<IMember> children, int maxLevelIndex) {
        this.childrenRetrievedLevelIndex = maxLevelIndex;
        super.setChildren(children);
    }

    @Override
    public boolean hasGotAllChildren() {
        return super.hasGotAllChildren() && this.childrenRetrievedLevelIndex == -1;
    }

    private boolean hasGotAllChildren(int maxLevelIndex) {
        return super.hasGotAllChildren() && (this.childrenRetrievedLevelIndex == -1 || maxLevelIndex <= this.childrenRetrievedLevelIndex);
    }

    @Override
    public Value getBusinessKeyValue() {
        ICube.CubeTypeEnum cubeType = this.getDimension().getCube().getType();
        if (ICube.CubeTypeEnum.TM1 == cubeType || ICube.CubeTypeEnum.TMR == cubeType) {
            StringValue key = DataValueFactory.createStringValue();
            key.set(this.retrievePropValueFromCache("MEMBER_KEY"));
            return key;
        }
        return super.getBusinessKeyValue();
    }

    public boolean isMultiHierarchySlicer() {
        return this.isMultiHierarchySlicer;
    }

    public void setMultiHierarchySlicer(boolean value) {
        this.isMultiHierarchySlicer = value;
    }

    @Override
    public IMember getParent() {
        if (!(this.isCached || null != this.parentMember && ((LOLAPMemberProxy)this.parentMember).getMemberId() != 0xFFFFFFL)) {
            LOLAPCube cube = (LOLAPCube)this.getDimension().getCube();
            IRestrictions restrictions = cube.getCubeRestrictions();
            restrictions.add(RestrictionType.DATA_QUERY, true);
            restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getDimension().getUniqueName());
            restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getHierarchy().getUniqueName());
            restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, this.getUniqueName());
            restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMANCESTORS);
            List<MemberRecord> memberRecords = cube.getSecuredMetadataProvider().getMembers(restrictions);
            if (memberRecords.isEmpty()) {
                if (null == this.parentMember || this.parentMember.getLevel() == null) {
                    return null;
                }
                return super.getParent();
            }
            SecurityAwareLayer sal = cube.getSAL();
            IHierarchy hierarchy = this.getHierarchy();
            HashMap<Integer, LOLAPMemberProxy> ancestorsByLevel = new HashMap<Integer, LOLAPMemberProxy>();
            for (MemberRecord record : memberRecords) {
                int levelNumber = record.getLevelNumber();
                ILevel level = hierarchy.getLevel(levelNumber);
                LOLAPMemberProxy cachedMember = (LOLAPMemberProxy)level.getMember(record.getUniqueName());
                if (cachedMember != null) {
                    ancestorsByLevel.put(levelNumber, cachedMember);
                    continue;
                }
                LOLAPMemberProxy member = new LOLAPMemberProxy(record, level);
                ancestorsByLevel.put(levelNumber, member);
                ICacheKey cacheKey = LOLAPMemberProxy.cacheAlreadyRetrievedMember(member, cube, record);
                member.setCacheKey(cacheKey);
                member.setMemberId(sal.getMemberIdFromCache(cacheKey));
            }
            for (int i = this.getLevel().getIndex() - 1; i > 0; --i) {
                LOLAPMemberProxy ancestor = (LOLAPMemberProxy)ancestorsByLevel.get(i);
                if (ancestor == null) continue;
                ancestor.setParentMember((IMember)ancestorsByLevel.get(i - 1));
            }
            LOLAPMemberProxy parent = (LOLAPMemberProxy)ancestorsByLevel.get(this.getLevel().getIndex() - 1);
            this.setParentMember(parent);
            return parent;
        }
        return super.getParent();
    }

    @Override
    public String getParentUniqueName() {
        if (this.parentMember != null && !((LOLAPMemberProxy)this.parentMember).isCached()) {
            return this.parentMember.getUniqueName();
        }
        return super.getParentUniqueName();
    }

    @Override
    public String getUniqueName() {
        if (!this.isCached()) {
            return this.memberUniqueName;
        }
        return super.getUniqueName();
    }
}

