/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetToListAdaptor;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SingleHierarchySimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMDXQuery;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMediator;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.util.SymmetricSubqueryIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.concurrent.Gate;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class LOLAPQueryStrategy
extends QueryStrategy {
    protected static final String CROSSJION_STR = "CROSSJOIN( ";
    protected static final String COMMA_STR = ", ";
    protected static final String CLOSE_BRACKET1_STR = "}";
    protected static final String OPEN_BRACKET1_STR = "{";
    protected static final String DOT_MEMBERS_STR = ".MEMBERS";
    protected static final String CLOSE_BRACKET_STR = ")";
    protected static final String NON_EMPTY_MDX_STR = "  NON EMPTY  ";
    protected static final String STR_PERCENT = "%";
    protected static final long SUPRESSION_THRESHOLD = 1000000L;
    protected static final int INT_PERCENT = 100;
    protected static final String NEWLINE_STR = "\n";
    protected boolean factLessQuery = false;
    protected boolean keyFigureRegularDimension = false;
    protected long tuplesCount = 0L;
    protected long nullTuplesCount = 0L;
    protected long nonNullTuplesCount = 0L;
    protected double density = 0.0;
    protected double sparsity = 0.0;
    protected long queryExecuteAndWriteTime = 0L;
    protected IHierarchy backupSlicerHier = null;
    protected ArrayList<IMember> slicerMembers = null;
    protected ArrayList<IMember> attributeMemberList = null;
    protected StringBuilder mmdx;
    protected ArrayList<IHierarchy> mhierarchyList;
    protected OrderedMap<String> mproperties;
    protected HashMap<IHierarchy, HashMap<String, IMember>> mmemberUniqueNameToMember;
    private HashMap<IHierarchy, List<ILevel>> levelsReplaced = new HashMap();
    private HashMap<IHierarchy, ArrayList<IMember>> hierarchyToSelections = new HashMap();
    protected static XQELogger statsLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryStrategyStatistics", LogLevel.INFO);
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected StringBuilder strBldr;
    private static final Value DUMMY_VALUE = DataValueFactory.createDoubleValue();
    public static final List<String> MDX_EXECUTED = new ArrayList<String>();
    private IDataSourceCapabilities capabilities;
    private boolean applySuppression;
    private String threshold;
    private boolean pushQueryContext;
    private static int queryCount;
    private static final long MAX_TUPLES_CACHE_CHECK = Long.MAX_VALUE;
    private static final Cell DUMMY_CELL;
    private final CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();

    public static int getQueryCount() {
        return queryCount;
    }

    public static void resetQueryCount() {
        queryCount = 0;
    }

    public LOLAPQueryStrategy() {
        this.mmemberUniqueNameToMember = new HashMap();
        this.mhierarchyList = new ArrayList();
        this.slicerMembers = new ArrayList();
        if (this.attributeMemberList == null) {
            this.attributeMemberList = new ArrayList();
        }
    }

    @Override
    public void rebuildCalculatedMembersSets(CalculationEngine calculationEngine, IResultSet resultSet) throws InterpreterException {
        if (this.suppressBeforeEvaluatingExpressionsEnabled()) {
            CrossJoinedSet querySet = resultSet.getQuerySet();
            calculationEngine.populateBaseAndCalculationSets(querySet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CrossJoinedSet cjs, IResultSet iResultSet) throws InterpreterException {
        AbstractResultSet resultSet = (AbstractResultSet)iResultSet;
        LOLAPCube cube = (LOLAPCube)this.getCube();
        IBlockTupleStorage blockStorage = cube.getBlockTupleStorage();
        if (statsLogger.isOn(LogLevel.INFO)) {
            this.strBldr = new StringBuilder(NEWLINE);
        }
        this.tuplesCount = cjs.size();
        ICubeResultSet cubeResult = null;
        QueryContext infoData = this.getInfoData();
        boolean providerDefaultMemberRequested = infoData.isProviderDefaultMemberRequested();
        boolean isPrimingQuery = infoData.isPrimingQuery();
        boolean useQueryContext = infoData.useQueryContext();
        boolean isLargeDataSet = BlockTupleStorageUtil.isLargeSet(this.tuplesCount);
        if (!useQueryContext && this.pushQueryContext && isLargeDataSet) {
            useQueryContext = infoData.getVDFilter() != null;
            infoData.setUseQueryContext(useQueryContext);
        }
        if (!useQueryContext && !infoData.isPrimingQuery() && this.suppressBeforeEvaluatingExpressionsEnabled() && !providerDefaultMemberRequested) {
            cubeResult = this.executeWithSuppressionBeforeEvaluatingExpr(cjs, resultSet);
        }
        ResultSetToListAdaptor resultContainer = null;
        if (isPrimingQuery) {
            if (isLargeDataSet && (infoData.hasUnResolvedDefaultMember() || !useQueryContext) || providerDefaultMemberRequested) {
                return;
            }
        } else {
            resultContainer = new ResultSetToListAdaptor(resultSet);
        }
        long ticks = System.currentTimeMillis();
        CrossJoinedSet pdmSubCjs = null;
        ProviderDefMemberSubSetIterator pdmSubIterator = new ProviderDefMemberSubSetIterator(cjs, providerDefaultMemberRequested);
        while (pdmSubIterator.hasNext()) {
            pdmSubCjs = pdmSubIterator.next();
            int minExcessTuplesForSplitQuery = this.capabilities.getIntegerValue("lolap.minExcessTuplesForSplitQuery");
            double excessTuplesRatioForSplitQuery = this.capabilities.getIntegerValue("lolap.excessTuplesRatioForSplitQuery");
            SymmetricSubqueryIterator iterator = null;
            if (minExcessTuplesForSplitQuery >= 0 && excessTuplesRatioForSplitQuery >= 0.0 && statsLogger.isOn(LogLevel.TRACE)) {
                this.strBldr.append("min Excess tuples :" + minExcessTuplesForSplitQuery + ", ratio: " + excessTuplesRatioForSplitQuery).append(NEWLINE);
            }
            iterator = new SymmetricSubqueryIterator(pdmSubCjs, minExcessTuplesForSplitQuery, excessTuplesRatioForSplitQuery, false, this.strBldr);
            int i = 0;
            while (iterator.hasNext()) {
                Set requestedCJS = (Set)iterator.next();
                ++i;
                long requiredTuples = requestedCJS.size();
                long symmetricTuples = 1L;
                IMember[][] members = requestedCJS.getMembers(pdmSubCjs.getHierarchies());
                for (int k = 0; k < members.length; ++k) {
                    symmetricTuples *= (long)members[k].length;
                }
                if (statsLogger.isOn(LogLevel.INFO)) {
                    this.strBldr.append("Subquery " + i + " | RequiredTuples:" + requiredTuples + " SymmetricTuples:" + symmetricTuples).append(NEWLINE);
                }
                ticks = System.currentTimeMillis();
                this.tuplesCount = requestedCJS.size();
                ISet setToFetch = null;
                boolean useCache = false;
                if (!resultSet.getResultSetDelegateMode() && this.tuplesCount > 0L || useQueryContext) {
                    useCache = true;
                    setToFetch = blockStorage.getTupleValues((ISet)requestedCJS, resultContainer, this.getVDFilterWithQueryContext()).createSet();
                } else {
                    setToFetch = requestedCJS;
                }
                this.tuplesCount = setToFetch.size();
                if (statsLogger.isOn(LogLevel.TRACE)) {
                    this.strBldr.append("BlockTupleStorage getTupleValues Time:" + (System.currentTimeMillis() - ticks)).append(NEWLINE);
                }
                if (setToFetch == null || setToFetch.isEmpty()) {
                    if (statsLogger.isOn(LogLevel.TRACE)) {
                        this.strBldr.append("Query entirely resolved by the data cache").append(NEWLINE);
                        statsLogger.log(LogLevel.TRACE, this.strBldr.toString());
                    }
                } else {
                    long ticks1;
                    block30: {
                        if (statsLogger.isOn(LogLevel.INFO)) {
                            this.strBldr.append("Query partially resolved or not resolved by the data cache").append(NEWLINE);
                        }
                        ticks1 = System.currentTimeMillis();
                        this.buildMDXStatement(setToFetch);
                        if (useCache) {
                            String currMDX = this.mmdx.toString();
                            Gate newGate = new Gate();
                            newGate.close();
                            Gate gate = cube.getMDXExecutionGate().putIfAbsent(currMDX, newGate);
                            if (gate != null) {
                                try {
                                    gate.await();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if ((setToFetch = blockStorage.getTupleValues(setToFetch, resultContainer, this.getVDFilterWithQueryContext()).createSet()) == null || setToFetch.isEmpty()) continue;
                            }
                            try {
                                if (!this.levelsReplaced.isEmpty() && this.populateCacheWithLevelMembers(resultSet, setToFetch, cubeResult)) {
                                    if (!isPrimingQuery && ((setToFetch = blockStorage.getTupleValues(setToFetch, resultContainer, this.getVDFilterWithQueryContext()).createSet()) == null || setToFetch.isEmpty())) {
                                        continue;
                                    }
                                } else {
                                    this.executeRequest(resultSet, setToFetch, cubeResult);
                                }
                                break block30;
                            }
                            finally {
                                gate = (Gate)cube.getMDXExecutionGate().remove(currMDX);
                                if (gate == null) continue;
                                gate.open();
                                continue;
                            }
                        }
                        this.executeRequest(resultSet, setToFetch, cubeResult);
                    }
                    ++queryCount;
                    if (statsLogger.isOn(LogLevel.INFO)) {
                        this.strBldr.append("LOLAP Loading data cache Time: " + (System.currentTimeMillis() - ticks1)).append(NEWLINE);
                        statsLogger.log(LogLevel.INFO, this.strBldr.toString());
                    }
                }
                if (!statsLogger.isOn(LogLevel.INFO)) continue;
                this.strBldr = new StringBuilder(NEWLINE);
            }
        }
        resultSet.undelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequest(AbstractResultSet resultSet, ISet setToFetch, ICubeResultSet cubeResult) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DQMDXEngineDataQuery", ZipiContext.getQRDName());
        try {
            this.tryToExecuteRequest(resultSet, setToFetch, cubeResult);
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToExecuteRequest(AbstractResultSet resultSet, ISet setToFetch, ICubeResultSet cubeResult) {
        LOLAPCube cube = (LOLAPCube)this.getCube();
        IBlockTupleStorage blockStorage = cube.getBlockTupleStorage();
        long ticks = System.currentTimeMillis();
        if (cubeResult == null) {
            boolean useNullSuppression;
            LOLAPMDXQuery mdxQuery = new LOLAPMDXQuery(this.mmdx.toString(), cube, this.mhierarchyList);
            if (cube instanceof LOLAPTM1Cube && (useNullSuppression = ((LOLAPTM1Cube)cube).isNullSuppressionAllowed())) {
                mdxQuery.setPropertyValue("PXJEnabled", Boolean.TRUE);
            }
            cubeResult = cube.performExecuteRequest(mdxQuery, this.mproperties, cube);
        }
        CubeResultSetToReadOnlyListAdapter resultList = null;
        try {
            if (statsLogger.isOn(LogLevel.INFO)) {
                this.strBldr.append("LOLAP MDX Execute Time:");
                this.strBldr.append(System.currentTimeMillis() - ticks);
                this.strBldr.append(NEWLINE);
            }
            if (cubeResult.getNumAxes() >= 1) {
                ResourceMonitor.checkMaxSetSize(cubeResult.getAxisSize(0), this.getInfoData(), XQEMessageKeys.MDX_MaxSubQuerySize);
            }
            resultList = new CubeResultSetToReadOnlyListAdapter(cubeResult, resultSet, this.getCube());
            ticks = System.currentTimeMillis();
            if ((resultSet.getResultSetDelegateMode() || setToFetch.size() < 0L) && !this.getInfoData().useQueryContext()) {
                for (TupleValue tupleValue : resultList) {
                }
            } else {
                blockStorage.putTupleValues(setToFetch, resultList.iterator(), this.getVDFilterWithQueryContext());
            }
            if (statsLogger.isOn(LogLevel.TRACE)) {
                this.strBldr.append("BlockTupleStorage putTupleValues Time:" + (System.currentTimeMillis() - ticks)).append(NEWLINE);
            }
            this.nonNullTuplesCount = resultList.getNumberOfValues();
            this.collectDataStatistics();
            if (statsLogger.isOn(LogLevel.TRACE)) {
                this.strBldr.append("LOLAP Cell Fetch Time:" + resultList.getValueFetchingTime()).append(NEWLINE);
            }
            this.queryExecuteAndWriteTime = System.currentTimeMillis() - ticks;
            if (statsLogger.isOn(LogLevel.TRACE)) {
                this.strBldr.append("Query Execute and Write Time: " + this.queryExecuteAndWriteTime).append(NEWLINE);
            }
        }
        catch (InterpreterException interpreterException) {
        }
        finally {
            if (resultList != null) {
                resultList.release();
            }
            cubeResult.release();
        }
    }

    private String getVDFilterWithQueryContext() {
        QueryContext infoData = this.getInfoData();
        if (infoData.useQueryContext()) {
            return infoData.getVDFilter();
        }
        return null;
    }

    private boolean populateCacheWithLevelMembers(AbstractResultSet resultSet, ISet setToFetch, ICubeResultSet cubeResult) throws InterpreterException {
        ISet currResultSetMetadataSet;
        ISet newResultSetMetadataSet;
        ISet updatedSet = this.createSetWithLevelMembers(setToFetch);
        if (updatedSet != null && (newResultSetMetadataSet = this.createSetWithLevelMembers(currResultSetMetadataSet = resultSet.getAxis(0))) != null) {
            List<ILevel> levelsSameHier = null;
            List<IMember> currLevelMembers = null;
            String mun = null;
            for (Map.Entry<IHierarchy, List<ILevel>> entry : this.levelsReplaced.entrySet()) {
                IHierarchy hier = entry.getKey();
                levelsSameHier = entry.getValue();
                HashMap<String, IMember> dimMemberUniqueNameToMember = this.mmemberUniqueNameToMember.get(hier);
                for (ILevel level : levelsSameHier) {
                    currLevelMembers = level.getMembers();
                    for (IMember levelMember : currLevelMembers) {
                        mun = levelMember.getUniqueName();
                        if (dimMemberUniqueNameToMember.containsKey(mun)) continue;
                        dimMemberUniqueNameToMember.put(mun, levelMember);
                    }
                }
            }
            ISet[] axis = resultSet.getAxes();
            axis[0] = newResultSetMetadataSet;
            resultSet.getMetadata().setAxes(axis);
            this.tryToExecuteRequest(resultSet, updatedSet, cubeResult);
            axis[0] = currResultSetMetadataSet;
            resultSet.getMetadata().setAxes(axis);
            return true;
        }
        return false;
    }

    private ISet createSetWithLevelMembers(ISet originalSet) throws InterpreterException {
        if (!(originalSet instanceof CrossJoinedSet)) {
            return null;
        }
        Set[] origChildrenSets = ((CrossJoinedSet)originalSet).getSets();
        ArrayList<Set> newChildrenSets = new ArrayList<Set>();
        ITupleList childTupleList = null;
        IHierarchy[] childSetHierarchies = null;
        List hierListSelections = null;
        IMember[] hierArraySelections = null;
        for (Set set : origChildrenSets) {
            childSetHierarchies = set.getHierarchies();
            if (childSetHierarchies.length == 1) {
                childTupleList = this.createTupleListFromLevel(childSetHierarchies[0]);
                if (childTupleList != null) {
                    newChildrenSets.add(new Set(childTupleList));
                    childTupleList = null;
                    continue;
                }
                newChildrenSets.add(set);
                continue;
            }
            for (IHierarchy hier : childSetHierarchies) {
                childTupleList = this.createTupleListFromLevel(childSetHierarchies[0]);
                if (childTupleList == null) {
                    hierListSelections = this.hierarchyToSelections.get(hier);
                    hierArraySelections = hierListSelections.toArray(new IMember[hierListSelections.size()]);
                    childTupleList = SingleHierarchySimpleTupleList.construct(hierArraySelections);
                }
                newChildrenSets.add(new Set(childTupleList));
                childTupleList = null;
            }
        }
        return new CrossJoinedSet(newChildrenSets.toArray(new ISet[newChildrenSets.size()]));
    }

    private ITupleList createTupleListFromLevel(IHierarchy hier) {
        IMember[] arrayMembersToReplace = null;
        ArrayList<IMember> listMembersToReplace = null;
        List<ILevel> levels = this.levelsReplaced.get(hier);
        listMembersToReplace = new ArrayList<IMember>();
        if (levels != null && !levels.isEmpty()) {
            for (ILevel level : levels) {
                listMembersToReplace.addAll(level.getMembers());
            }
            arrayMembersToReplace = listMembersToReplace.toArray(new IMember[listMembersToReplace.size()]);
            return SingleHierarchySimpleTupleList.construct(arrayMembersToReplace);
        }
        return null;
    }

    public void buildMDXStatement(ISet requestedSet) {
        LOLAPCube cube = (LOLAPCube)this.getCube();
        this.hierarchyToSelections.clear();
        this.mmemberUniqueNameToMember.clear();
        this.mhierarchyList.clear();
        this.slicerMembers.clear();
        this.levelsReplaced.clear();
        IHierarchy[] hierarchies = requestedSet.getHierarchies();
        ArrayList<IMember> currentSelectionsInHierarchy = null;
        HashMap<String, IMember> hierMemberUniqueNameToMember = null;
        for (int j = 0; j < hierarchies.length; ++j) {
            currentSelectionsInHierarchy = new ArrayList<IMember>();
            IMember[] mems = requestedSet.getMembers(hierarchies[j]);
            boolean skipGetCubicsMUN = false;
            LOLAPHierarchy hierarchy = (LOLAPHierarchy)hierarchies[j];
            hierMemberUniqueNameToMember = new HashMap<String, IMember>();
            this.mhierarchyList.add(hierarchies[j]);
            for (int i = 0; i < mems.length; ++i) {
                IMember m = mems[i];
                currentSelectionsInHierarchy.add(m);
                if (hierarchy.getDimension().isAttributeDimension() && mems.length == 1 && ((IMemberCubics)mems[0]).isDummyMember()) {
                    skipGetCubicsMUN = true;
                    this.attributeMemberList.add(m);
                }
                if (skipGetCubicsMUN) continue;
                hierMemberUniqueNameToMember.put(m.getUniqueName(), m);
            }
            if (mems.length == 1) {
                if (hierarchy.getDimension().isMeasuresDimension() && ((IMemberCubics)mems[0]).isDummyMember()) {
                    this.factLessQuery = true;
                } else if (hierarchy.getDimension().isKeyFigureStructure() && ((IMemberCubics)mems[0]).isDummyMember()) {
                    this.keyFigureRegularDimension = true;
                }
            }
            this.hierarchyToSelections.put(hierarchies[j], currentSelectionsInHierarchy);
            this.mmemberUniqueNameToMember.put(hierarchy, hierMemberUniqueNameToMember);
        }
        Arrays.sort(hierarchies, new HierarchySelectionComparator(this.hierarchyToSelections));
        ArrayList<IHierarchy> slicer = new ArrayList<IHierarchy>();
        ArrayList<IHierarchy> axis0 = new ArrayList<IHierarchy>();
        ArrayList<IHierarchy> axis1 = new ArrayList<IHierarchy>();
        boolean putOnAxis0 = true;
        int axis0size = 1;
        int axis1size = 1;
        boolean forceSingleAxis = this.capabilities.getStringValue("lolap.singleAxis", "false").equals("true");
        if (!forceSingleAxis) {
            forceSingleAxis = this.factLessQuery || this.keyFigureRegularDimension;
        }
        boolean addVDFilter = this.getInfoData().useQueryContext();
        boolean copySlicerHier = true;
        for (int i = 0; i < hierarchies.length; ++i) {
            IHierarchy hier = hierarchies[i];
            ArrayList<IMember> sels = this.hierarchyToSelections.get(hier);
            if (sels.size() > 1 || !this.factLessQuery && hier.getDimension().isMeasuresDimension() && addVDFilter) {
                if (axis1.size() > 0) {
                    boolean bl = putOnAxis0 = axis0size * sels.size() < axis1size * sels.size();
                }
                if (putOnAxis0 || forceSingleAxis) {
                    axis0.add(hier);
                    axis0size *= sels.size();
                    putOnAxis0 = false;
                    continue;
                }
                axis1.add(hier);
                axis1size *= sels.size();
                putOnAxis0 = true;
                continue;
            }
            if (copySlicerHier && !forceSingleAxis) {
                this.backupSlicerHier = ((LOLAPCube)this.getCube()).pushSingleMemberDimensionOnToRow(hier);
                if (this.backupSlicerHier == null) {
                    slicer.add(hier);
                }
                copySlicerHier = false;
                continue;
            }
            slicer.add(hier);
        }
        this.mmdx = new StringBuilder();
        this.mmdx.append("SELECT \n");
        if (this.backupSlicerHier != null) {
            if (axis0.size() > 0 && axis1.size() == 0) {
                axis1.add(this.backupSlicerHier);
            } else {
                slicer.add(this.backupSlicerHier);
            }
        }
        if (axis0.size() > 0) {
            this.mmdx.append(NON_EMPTY_MDX_STR);
            this.mmdx.append(this.axisToSetExpression(axis0));
            this.mmdx.append(cube.getMDXAxisAttributes(0));
            this.mmdx.append(NEWLINE_STR);
        }
        if (axis1.size() > 0) {
            this.mmdx.append(",\n");
            this.mmdx.append(NON_EMPTY_MDX_STR);
            this.mmdx.append(this.axisToSetExpression(axis1));
            this.mmdx.append(cube.getMDXAxisAttributes(1));
            this.mmdx.append(NEWLINE_STR);
        }
        this.mmdx.append(cube.getMDXFromClause());
        this.mmdx.append(this.axisToWhereCondition(slicer, this.mhierarchyList));
        this.mmdx.append(cube.getMDXQueryAttributes());
        String sapVariables = cube.getSAPVariables();
        if (sapVariables != null) {
            this.mmdx.append(" SAP VARIABLES ");
            this.mmdx.append(sapVariables);
        }
        this.mproperties = new OrderedMap();
        this.mproperties.put("Format", "Multidimensional");
        this.mproperties.put("AxisFormat", "TupleFormat");
        this.mproperties.put("Content", "Data");
        if (statsLogger.isOn(LogLevel.TRACE)) {
            this.strBldr.append("MDX: " + this.mmdx.toString()).append(NEWLINE);
        }
    }

    public String axisToWhereCondition(ArrayList<IHierarchy> axis, List<IHierarchy> hierarchySet) {
        StringBuilder result = new StringBuilder();
        boolean whereAdded = false;
        int count = 0;
        for (int i = 0; i < axis.size(); ++i) {
            IHierarchy hier = axis.get(i);
            ArrayList<IMember> selections = this.hierarchyToSelections.get(hier);
            IMember m = selections.get(0);
            if (((IMemberCubics)m).isDummyMember()) {
                if (!this.keyFigureRegularDimension && !((LOLAPDimension)hier.getDimension()).isAttributeDimension()) {
                    this.factLessQuery = true;
                }
                this.slicerMembers.add(m);
                continue;
            }
            boolean addToWhereCondition = ((LOLAPCube)this.getCube()).addToWhereCondition(hier.getDimension(), m);
            if (LOLAPQueryStrategy.removeMember(m)) {
                addToWhereCondition = false;
            }
            if (addToWhereCondition) {
                IHierarchy hierarchy;
                if (!whereAdded) {
                    result.append(" WHERE (");
                    whereAdded = true;
                }
                if (count > 0 && this.slicerMembers.size() < axis.size()) {
                    result.append(COMMA_STR);
                }
                if ((hierarchy = ((LOLAPHierarchy)m.getHierarchy()).getModelHierarchy()) != null && !hierarchySet.contains(hierarchy)) {
                    hierarchySet.add(hierarchy);
                }
                String uniqueName = ((LOLAPCube)this.getCube()).getMDXMemberUniqueName(m);
                result.append(uniqueName);
                ++count;
            }
            this.slicerMembers.add(m);
        }
        if (whereAdded) {
            result.append(CLOSE_BRACKET_STR);
        }
        return result.toString();
    }

    private String axisToSetExpression(ArrayList<IHierarchy> axis) {
        int i;
        StringBuilder result = new StringBuilder();
        LOLAPCube cube = (LOLAPCube)this.getCube();
        boolean shouldAddFilter = this.getInfoData().useQueryContext() && !this.factLessQuery && axis.size() > 1;
        String vdFilter = null;
        if (shouldAddFilter) {
            vdFilter = this.getInfoData().getVDFilter();
        }
        ArrayList<IMember> measures = null;
        if (vdFilter != null) {
            IDimension measureDim = cube.getMeasureDimension();
            IHierarchy measureHier = null;
            for (IHierarchy hierKey : this.hierarchyToSelections.keySet()) {
                if (!measureDim.equals(hierKey.getDimension())) continue;
                measureHier = hierKey;
                break;
            }
            if ((measures = this.hierarchyToSelections.get(measureHier)).size() > 0) {
                axis.remove(measureHier);
                result.append(CROSSJION_STR);
            }
            result.append("Filter(");
        }
        for (i = 0; i < axis.size(); ++i) {
            boolean useDotMembers;
            if (i != 0) {
                result.append(COMMA_STR);
            }
            if (i < axis.size() - 1) {
                result.append(CROSSJION_STR);
            }
            IHierarchy hier = axis.get(i);
            if (vdFilter != null && hier.getDimension().isMeasuresDimension()) continue;
            ArrayList<IMember> selections = this.hierarchyToSelections.get(hier);
            int selCount = selections.size();
            result.append(OPEN_BRACKET1_STR);
            boolean levelBased = true;
            ArrayList<ILevel> levels = new ArrayList<ILevel>();
            int index = 0;
            for (int j = 0; j < selCount; ++j) {
                ILevel level = selections.get(j).getLevel();
                if (level != null) {
                    for (index = 0; index < levels.size() && !((ILevel)levels.get(index)).equals(level); ++index) {
                    }
                    if (index < levels.size()) continue;
                    levels.add(level);
                    continue;
                }
                levelBased = false;
                break;
            }
            boolean bl = useDotMembers = !hier.getDimension().isMeasuresDimension() && LOLAPQueryStrategy.useDotMembers(selCount, hier.getDimension(), false);
            if (!levelBased && useDotMembers) {
                result.append(hier.getUniqueName());
                result.append(DOT_MEMBERS_STR);
            } else if (levelBased && (useDotMembers || LOLAPQueryStrategy.useLevelDotMembers(selCount, levels, false))) {
                if (levels.size() > 1) {
                    result.append(OPEN_BRACKET1_STR);
                }
                for (index = 0; index < levels.size(); ++index) {
                    result.append(((ILevel)levels.get(index)).getUniqueName());
                    result.append(DOT_MEMBERS_STR);
                    if (index >= levels.size() - 1) continue;
                    result.append(COMMA_STR);
                }
                if (levels.size() > 1) {
                    result.append(CLOSE_BRACKET1_STR);
                }
                boolean membersLoaded = true;
                int levelsSelectionCound = 0;
                for (ILevel level : levels) {
                    if (!((Level)level).hasGotAllMembers()) {
                        membersLoaded = false;
                        break;
                    }
                    levelsSelectionCound += level.getMembers().size();
                }
                if (membersLoaded && selCount < levelsSelectionCound) {
                    this.levelsReplaced.put(hier, levels);
                }
            } else {
                List<IMember> collapsedMember = LOLAPQueryStrategy.collapseMember(levelBased, selections, levels, false);
                if (levelBased && collapsedMember != null && collapsedMember.size() == 1) {
                    result.append("DESCENDANTS( ");
                    String uniqueName = ((LOLAPCube)this.getCube()).getMDXMemberUniqueName(collapsedMember.get(0));
                    result.append(uniqueName);
                    result.append(COMMA_STR);
                    result.append(((ILevel)levels.get(0)).getUniqueName());
                    result.append(COMMA_STR);
                    result.append(" SELF");
                    result.append(CLOSE_BRACKET_STR);
                } else {
                    boolean appendComma = false;
                    for (int j = 0; j < selCount; ++j) {
                        IMember m = selections.get(j);
                        if (LOLAPQueryStrategy.removeMember(m)) continue;
                        if (appendComma) {
                            result.append(COMMA_STR);
                            appendComma = false;
                        }
                        String uniqueName = ((LOLAPCube)this.getCube()).getMDXMemberUniqueName(m);
                        result.append(uniqueName);
                        appendComma = true;
                    }
                }
            }
            result.append(CLOSE_BRACKET1_STR);
        }
        for (i = 0; i < axis.size() - 1; ++i) {
            result.append(CLOSE_BRACKET_STR);
        }
        if (vdFilter != null) {
            result.append(COMMA_STR);
            result.append(vdFilter);
            result.append(CLOSE_BRACKET_STR);
            if (measures != null && measures.size() != 0) {
                result.append(COMMA_STR);
                result.append(OPEN_BRACKET1_STR);
                for (i = 0; i < measures.size(); ++i) {
                    if (i != 0) {
                        result.append(COMMA_STR);
                    }
                    result.append(measures.get(i).getUniqueName());
                }
                result.append(CLOSE_BRACKET1_STR);
                result.append(CLOSE_BRACKET_STR);
            }
        }
        return result.toString();
    }

    public static boolean useDotMembers(int selCount, IDimension dim, boolean useExactMembers) {
        if (useExactMembers) {
            return false;
        }
        LOLAPCube lolapCube = (LOLAPCube)dim.getCube();
        IDataSourceCapabilities staticCapabilities = lolapCube.getCapabilities();
        int maxAxisSelections = staticCapabilities.getIntegerValue("lolap.maxAxisSelections");
        double maxAxisSelectionRatio = staticCapabilities.getDoubleValue("lolap.maxAxisSelectionsRatio");
        int maxAxisSelectionsIgnoreRatio = staticCapabilities.getIntegerValue("lolap.maxAxisSelectionsIgnoreRatio");
        if (maxAxisSelectionsIgnoreRatio > -1 && selCount > maxAxisSelectionsIgnoreRatio) {
            return true;
        }
        int cardinality = dim.getCardinality();
        if (cardinality < 1) {
            return false;
        }
        if (!dim.isMeasuresDimension()) {
            if (selCount > maxAxisSelections && (double)selCount > (double)cardinality * maxAxisSelectionRatio) {
                return true;
            }
            if (selCount == cardinality && !DataSourceTypeEnum.isSAPBW(lolapCube.getDatasourceType())) {
                return true;
            }
        }
        return false;
    }

    public static boolean useLevelDotMembers(int selCount, List<ILevel> levels, boolean useExactMembers) {
        if (useExactMembers) {
            return false;
        }
        IDimension dim = levels.get(0).getDimension();
        LOLAPCube lolapCube = (LOLAPCube)dim.getCube();
        IDataSourceCapabilities staticCapabilities = lolapCube.getCapabilities();
        int maxAxisSelections = staticCapabilities.getIntegerValue("lolap.maxAxisSelections");
        double maxAxisSelectionRatio = staticCapabilities.getDoubleValue("lolap.maxAxisSelectionsRatio");
        int maxAxisSelectionsIgnoreRatio = staticCapabilities.getIntegerValue("lolap.maxAxisSelectionsIgnoreRatio");
        if (maxAxisSelectionsIgnoreRatio > -1 && selCount > maxAxisSelectionsIgnoreRatio) {
            return true;
        }
        long cardinality = 0L;
        for (ILevel level : levels) {
            if (level.getCardinality() < 1) {
                return false;
            }
            cardinality += (long)level.getCardinality();
        }
        if (!dim.isMeasuresDimension()) {
            if (selCount > maxAxisSelections && (double)selCount > (double)cardinality * maxAxisSelectionRatio) {
                return true;
            }
            if ((long)selCount == cardinality && !DataSourceTypeEnum.isSAPBW(lolapCube.getDatasourceType())) {
                return true;
            }
        }
        return false;
    }

    private void collectDataStatistics() {
        this.nullTuplesCount = this.tuplesCount - this.nonNullTuplesCount;
        if (this.tuplesCount > 0L) {
            this.density = (double)this.nonNullTuplesCount / (double)this.tuplesCount * 100.0;
            this.sparsity = (double)this.nullTuplesCount / (double)this.tuplesCount * 100.0;
        }
        if (statsLogger.isOn(LogLevel.TRACE)) {
            this.strBldr.append("All Tuple Count = " + this.tuplesCount).append(NEWLINE);
            this.strBldr.append("TupleCount = " + this.nonNullTuplesCount).append(NEWLINE);
            this.strBldr.append("Density of data = " + this.density + STR_PERCENT).append(NEWLINE);
            this.strBldr.append("Null Tuple Count = " + this.nullTuplesCount).append(NEWLINE);
            this.strBldr.append("Sparsity of data = " + this.sparsity + STR_PERCENT).append(NEWLINE);
        }
    }

    private ArrayList<ArrayList<Integer>> getCombinations(ArrayList<Integer> available, int choose) {
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>(1);
        if (choose == 1) {
            for (Integer element : available) {
                ArrayList<Integer> list = new ArrayList<Integer>(1);
                list.add(element);
                result.add(list);
            }
            return result;
        }
        if (choose == available.size()) {
            result.add(available);
            return result;
        }
        ArrayList localAvailable = (ArrayList)available.clone();
        int current = (Integer)localAvailable.remove(0);
        ArrayList<ArrayList<Integer>> resultToIncludeCurrent = this.getCombinations(localAvailable, choose - 1);
        for (ArrayList<Integer> list : resultToIncludeCurrent) {
            ArrayList<Integer> listToIncludeCurrent = new ArrayList<Integer>();
            listToIncludeCurrent.add(current);
            listToIncludeCurrent.addAll(list);
            result.add(listToIncludeCurrent);
        }
        ArrayList<ArrayList<Integer>> resultNotToIncludeCurrent = this.getCombinations(localAvailable, choose);
        result.addAll(resultNotToIncludeCurrent);
        return result;
    }

    private boolean suppressBeforeEvaluatingExpressionsEnabled() {
        return this.nonEmptyAxes != null && this.applySuppression;
    }

    private long suppressBeforeEvaluatingExpressionsThreshold() {
        long lThreshold;
        try {
            lThreshold = Long.valueOf(this.threshold);
        }
        catch (NumberFormatException e) {
            lThreshold = 1000000L;
        }
        return lThreshold;
    }

    private boolean[] suppressAxes(AbstractResultSet resultSet, boolean[] nonEmptyAxes) {
        ISet[] axes = resultSet.getAxes();
        HashSet<Integer> axesWithCalculatedMembers = new HashSet<Integer>();
        for (int i = 0; i < axes.length; ++i) {
            if (!((Set)axes[i]).getTupleList().containsCalculatedMembers()) continue;
            axesWithCalculatedMembers.add(i);
        }
        boolean[] axesForNonEmpty = new boolean[axes.length];
        if (axesWithCalculatedMembers.size() > 1) {
            return axesForNonEmpty;
        }
        if (axesWithCalculatedMembers.size() == 1) {
            for (int i = 0; i < axes.length; ++i) {
                if (!nonEmptyAxes[i] || !axesWithCalculatedMembers.contains(i)) continue;
                axesForNonEmpty[i] = true;
                break;
            }
        } else {
            System.arraycopy(nonEmptyAxes, 0, axesForNonEmpty, 0, axes.length);
        }
        return axesForNonEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICubeResultSet executeWithSuppressionBeforeEvaluatingExpr(CrossJoinedSet cjs, AbstractResultSet resultSet) throws InterpreterException {
        if (resultSet.size() > 0L && resultSet.size() < this.suppressBeforeEvaluatingExpressionsThreshold()) {
            return null;
        }
        boolean[] suppressAxes = this.suppressAxes(resultSet, this.nonEmptyAxes);
        boolean delegate = false;
        for (boolean b : suppressAxes) {
            if (!b) continue;
            delegate = true;
            break;
        }
        if (!delegate) {
            return null;
        }
        resultSet.delegate(suppressAxes);
        this.buildMDXStatement(cjs);
        LOLAPMDXQuery mdxQuery = new LOLAPMDXQuery(this.mmdx.toString(), this.getCube(), this.mhierarchyList);
        mdxQuery.setPropertyValue("PXJEnabled", Boolean.TRUE);
        ICubeResultSet cubeResult = ((LOLAPCube)this.getCube()).performExecuteRequest(mdxQuery, this.mproperties, this.getCube());
        CubeResultSetToReadOnlyListAdapter resultList = null;
        try {
            resultList = new CubeResultSetToReadOnlyListAdapter(cubeResult, resultSet, this.getCube());
            for (TupleValue tupleValue : resultList) {
            }
        }
        finally {
            if (resultList != null) {
                resultList.release();
            }
            this.resetQueryStrategy();
        }
        resultSet.undelegate();
        return cubeResult;
    }

    private void resetQueryStrategy() {
        this.factLessQuery = false;
        this.keyFigureRegularDimension = false;
        this.tuplesCount = 0L;
        this.nullTuplesCount = 0L;
        this.nonNullTuplesCount = 0L;
        this.density = 0.0;
        this.sparsity = 0.0;
        this.queryExecuteAndWriteTime = 0L;
        this.backupSlicerHier = null;
    }

    public static boolean removeMember(IMember member) {
        return member.isProviderDefaultMember() || member.getDimension().getType() == DimensionTypeEnum.INTERNAL;
    }

    protected static List<IMember> collapseMember(boolean levelBased, ArrayList<IMember> selections, List<ILevel> levels, boolean useExactMembers) {
        if (levels.size() != 1 || useExactMembers) {
            return null;
        }
        IDimension dim = levels.get(0).getDimension();
        LOLAPCube lolapCube = (LOLAPCube)dim.getCube();
        IDataSourceCapabilities staticCapabilities = lolapCube.getCapabilities();
        int maxAxisSelections = staticCapabilities.getIntegerValue("lolap.maxAxisSelections");
        double maxAxisSelectionRatio = staticCapabilities.getDoubleValue("lolap.maxAxisSelectionsRatio");
        int maxAxisSelectionsIgnoreRatio = staticCapabilities.getIntegerValue("lolap.maxAxisSelectionsIgnoreRatio");
        ILevel level = levels.get(0);
        if (selections.size() < maxAxisSelections) {
            return null;
        }
        HashSet<IMember> parents = new HashSet<IMember>();
        for (IMember m : selections) {
            IMember parent = m.getParent();
            if (parent == null) {
                return null;
            }
            parents.add(parent);
        }
        ArrayList<IMember> rootAncestors = new ArrayList<IMember>();
        while (parents.size() > 1) {
            HashSet<IMember> members = parents;
            parents = new HashSet();
            for (IMember m : members) {
                IMember[] siblings;
                IMember parent = m.getParent();
                if (parent == null) {
                    return null;
                }
                if (parent instanceof LOLAPMemberProxy && !((LOLAPMemberProxy)parent).hasGotAllChildren()) {
                    rootAncestors.add(m);
                    continue;
                }
                for (IMember sibling : siblings = m.getSiblings(true)) {
                    if (!(sibling instanceof LOLAPMemberProxy) || ((LOLAPMemberProxy)sibling).hasGotAllChildren()) continue;
                    rootAncestors.add(m);
                    break;
                }
                if (rootAncestors.contains(m)) continue;
                parents.add(parent);
            }
        }
        rootAncestors.addAll(parents);
        ILevel previousLevel = level.getPreviousLevel();
        int cardinality = 0;
        for (IMember m : rootAncestors) {
            int descCardinality = LOLAPQueryStrategy.descendantsCardinality(m, previousLevel.getIndex());
            if (descCardinality <= 0) {
                return null;
            }
            cardinality += descCardinality;
        }
        if (maxAxisSelectionsIgnoreRatio > -1 && selections.size() > maxAxisSelectionsIgnoreRatio) {
            return rootAncestors;
        }
        if ((double)selections.size() < (double)cardinality * maxAxisSelectionRatio) {
            return null;
        }
        return rootAncestors;
    }

    private static int descendantsCardinality(IMember member, int previousLevelIndex) {
        int index = member.getLevel().getIndex();
        if (index == previousLevelIndex) {
            return member.getChildrenCardinality();
        }
        if (index > previousLevelIndex) {
            return 1;
        }
        int cardinality = 0;
        for (IMember child : member.getChildren()) {
            if (child instanceof LOLAPMemberProxy && !((LOLAPMemberProxy)child).hasGotAllChildren()) {
                return -1;
            }
            int descendantCardinality = LOLAPQueryStrategy.descendantsCardinality(child, previousLevelIndex);
            if (descendantCardinality < 0) {
                return -1;
            }
            cardinality += descendantCardinality;
        }
        return cardinality;
    }

    @Override
    public void setCube(ICube c) {
        super.setCube(c);
        if (this.capabilities == null) {
            this.capabilities = ((LOLAPCube)c).getCapabilities();
            this.applySuppression = this.capabilities.getBooleanValue("mdx.suppression.beforeEvaluatingExpressions", Boolean.FALSE);
            this.threshold = this.capabilities.getStringValue("mdx.suppression.beforeEvaluatingExpressions.threshold", "");
            this.pushQueryContext = this.capabilities.getBooleanValue("mdx.pushQueryContextForDataFetching", Boolean.FALSE);
        }
    }

    static {
        DUMMY_VALUE.set(-1.0);
        DUMMY_VALUE.setFormatId(FormatId.EMPTY_FORMAT_FID);
        queryCount = 0;
        DUMMY_CELL = new Cell(DUMMY_VALUE);
    }

    private class SubDefMemberSetsIterator
    implements Iterator<Set> {
        ArrayList<ArrayList<ITuple>> subDefMembersSets = new ArrayList();
        Iterator<ArrayList<ITuple>> subDefMembersSetsIter;
        ArrayList<ArrayList<Integer>> groupToDimensionIndexes = new ArrayList();
        Set[] inputSets = null;
        int dmSetIndex;

        SubDefMemberSetsIterator(Set[] sets, int defMemberSetIndex) {
            this.inputSets = sets;
            this.dmSetIndex = defMemberSetIndex;
            Set defMembersSet = sets[defMemberSetIndex];
            int t = 0;
            while ((long)t < defMembersSet.size()) {
                ITuple tuple = defMembersSet.getTuple(t);
                ArrayList<Integer> dimIndexes = new ArrayList<Integer>();
                for (int m = 0; m < tuple.size(); ++m) {
                    IMember member = tuple.getMember(m);
                    if (!member.isProviderDefaultMember()) continue;
                    dimIndexes.add(member.getDimension().getIndex());
                }
                boolean newGroup = true;
                for (int g = 0; g < this.groupToDimensionIndexes.size(); ++g) {
                    if (!this.groupToDimensionIndexes.get(g).containsAll(dimIndexes)) continue;
                    this.subDefMembersSets.get(g).add(tuple);
                    newGroup = false;
                    break;
                }
                if (newGroup) {
                    this.groupToDimensionIndexes.add(dimIndexes);
                    ArrayList<ITuple> tuplesList = new ArrayList<ITuple>();
                    tuplesList.add(tuple);
                    this.subDefMembersSets.add(tuplesList);
                }
                ++t;
            }
            this.subDefMembersSetsIter = this.subDefMembersSets.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.subDefMembersSetsIter.hasNext();
        }

        @Override
        public CrossJoinedSet next() {
            Set subSet;
            List tuples = this.subDefMembersSetsIter.next();
            this.inputSets[this.dmSetIndex] = subSet = new Set(tuples.toArray(new Tuple[tuples.size()]));
            return new CrossJoinedSet(this.inputSets);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ProviderDefMemberSubSetIterator
    implements Iterator<CrossJoinedSet> {
        private Set[] defMemberSets;
        private HashSet<Integer>[] defMemberSetsDimIndexes;
        private Set[] otherSets;
        ArrayList<Integer> defMemberSetsIndexes;
        SubDefMemberSetsIterator subDefMemberSetIterator;
        ArrayList<Integer> otherSetsIndexes;
        ArrayList<HashSet<Integer>> setIndexes = new ArrayList();
        Iterator<HashSet<Integer>> setIndexesIt;

        private ProviderDefMemberSubSetIterator(CrossJoinedSet set, boolean enable) {
            this.otherSets = set.getSets();
            if (enable) {
                if (statsLogger.isOn(LogLevel.TRACE)) {
                    LOLAPQueryStrategy.this.strBldr.append("Provider default member (NoMember) enabled.").append(NEWLINE);
                }
                this.defMemberSets = new Set[this.otherSets.length];
                this.defMemberSetsDimIndexes = new HashSet[this.otherSets.length];
                this.initializeSubCrossJoinedSets();
            } else {
                HashSet<Integer> t = new HashSet<Integer>();
                for (int i = 0; i < this.otherSets.length; ++i) {
                    t.add(i);
                }
                this.setIndexes.add(t);
                this.setIndexesIt = this.setIndexes.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.subDefMemberSetIterator != null && this.subDefMemberSetIterator.hasNext()) {
                return true;
            }
            return this.setIndexesIt.hasNext();
        }

        @Override
        public CrossJoinedSet next() {
            if (this.subDefMemberSetIterator != null && this.subDefMemberSetIterator.hasNext()) {
                return this.subDefMemberSetIterator.next();
            }
            HashSet<Integer> s = this.setIndexesIt.next();
            ISet[] nextSets = new Set[this.otherSets.length];
            int multiplDefMembersSetIndex = -1;
            for (int ind : s) {
                if (ind >= 0) {
                    nextSets[ind] = this.otherSets[ind];
                    continue;
                }
                if (this.defMemberSetsDimIndexes[ind = ind * -1 - 1].size() > 1) {
                    multiplDefMembersSetIndex = ind;
                }
                nextSets[ind] = this.defMemberSets[ind];
            }
            if (multiplDefMembersSetIndex != -1) {
                this.subDefMemberSetIterator = new SubDefMemberSetsIterator((Set[])nextSets, multiplDefMembersSetIndex);
                return this.subDefMemberSetIterator.next();
            }
            return new CrossJoinedSet(nextSets);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void initializeSubCrossJoinedSets() {
            int i;
            for (i = 0; i < this.otherSets.length; ++i) {
                ArrayList<Tuple> tuples = new ArrayList<Tuple>();
                ArrayList<Tuple> defMemberTuples = new ArrayList<Tuple>();
                if (this.otherSets[i].size() == 1L) continue;
                int t = 0;
                while ((long)t < this.otherSets[i].size()) {
                    Tuple tuple = (Tuple)this.otherSets[i].getTuple(t);
                    boolean defMemberTuple = false;
                    for (int m = 0; m < tuple.size(); ++m) {
                        IMember mem = tuple.getMember(m);
                        if (!mem.isProviderDefaultMember()) continue;
                        defMemberTuples.add(tuple);
                        if (this.defMemberSetsDimIndexes[i] == null) {
                            this.defMemberSetsDimIndexes[i] = new HashSet();
                        }
                        this.defMemberSetsDimIndexes[i].add(mem.getDimension().getIndex());
                        defMemberTuple = true;
                        break;
                    }
                    if (!defMemberTuple) {
                        tuples.add(tuple);
                    }
                    ++t;
                }
                this.otherSets[i] = new Set(tuples.toArray(new Tuple[tuples.size()]));
                if (defMemberTuples.isEmpty()) continue;
                this.defMemberSets[i] = new Set(defMemberTuples.toArray(new Tuple[defMemberTuples.size()]));
            }
            this.defMemberSetsIndexes = new ArrayList();
            this.otherSetsIndexes = new ArrayList();
            for (i = 0; i < this.otherSets.length; ++i) {
                if (this.defMemberSets[i] != null) {
                    this.defMemberSetsIndexes.add(i);
                }
                if (this.otherSets[i].size() <= 0L) continue;
                this.otherSetsIndexes.add(i);
            }
            HashSet<Integer> s = new HashSet<Integer>();
            if (this.otherSetsIndexes.size() == this.otherSets.length) {
                s.addAll(this.otherSetsIndexes);
                this.setIndexes.add(s);
            }
            if (this.defMemberSetsIndexes.isEmpty()) {
                this.setIndexesIt = this.setIndexes.iterator();
                return;
            }
            int min = 1;
            int max = this.defMemberSetsIndexes.size();
            for (int i2 = min; i2 <= max; ++i2) {
                s = new HashSet();
                s.addAll(this.otherSetsIndexes);
                ArrayList results = LOLAPQueryStrategy.this.getCombinations(this.defMemberSetsIndexes, i2);
                for (ArrayList chosenDefMemberSets : results) {
                    Iterator dIter = chosenDefMemberSets.iterator();
                    HashSet<Integer> t = new HashSet<Integer>();
                    t.addAll(s);
                    while (dIter.hasNext()) {
                        int dSet = (Integer)dIter.next();
                        if (t.contains(dSet)) {
                            t.remove(dSet);
                        }
                        t.add(-1 * dSet - 1);
                    }
                    if (t.size() < this.otherSets.length) continue;
                    this.setIndexes.add(t);
                }
            }
            this.setIndexesIt = this.setIndexes.iterator();
        }
    }

    private class CubeResultSetToReadOnlyListAdapter
    implements List<TupleValue> {
        private AbstractResultSet queryResultSet = null;
        private ICubeResultSet cubeResultSet = null;
        private long numberOfValues = 0L;
        private long valueFetchingTime = 0L;
        private HashMap<IDimension, Integer> dimensionToIndex = null;
        private HashMap<IHierarchy, Integer> hierarchyToIndex = null;
        private IMember[] tupleTemplate = null;
        private int axisCount = 0;
        ArrayList<ITuple>[] axisTuples;
        List<XCellIterator> cellIterators = new ArrayList<XCellIterator>(1);
        List<XIterator> axesIterators = new ArrayList<XIterator>();
        Iterator<TupleValue> iterator = null;
        private final LOLAPMediator<Boolean> mMediator;

        CubeResultSetToReadOnlyListAdapter(ICubeResultSet result, AbstractResultSet resultSet, ICube cube) {
            this.queryResultSet = resultSet;
            this.cubeResultSet = result;
            this.mMediator = new LOLAPMediator(() -> ICube.CubeTypeEnum.TMR == cube.getType(), () -> ((LOLAPTM1Cube)cube).getTM1ServerVersion());
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            IMember member;
            int j;
            IHierarchy[] originalHierarchyOrder = LOLAPQueryStrategy.this.mhierarchyList.toArray(new IHierarchy[0]);
            this.hierarchyToIndex = new HashMap();
            for (int i = 0; i < originalHierarchyOrder.length; ++i) {
                IHierarchy hierarchy = originalHierarchyOrder[i];
                this.hierarchyToIndex.put(hierarchy, new Integer(i));
            }
            long ticks = System.currentTimeMillis();
            this.axisCount = this.cubeResultSet.getNumAxes();
            if (LOLAPQueryStrategy.this.factLessQuery && this.axisCount > 1) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Factless query must have one axes only.");
            }
            if (!LOLAPQueryStrategy.this.factLessQuery) {
                this.axisTuples = (ArrayList[])ArrayCast.uncheckedCast(new ArrayList[this.axisCount]);
                for (j = 0; j < this.axisCount; ++j) {
                    this.axisTuples[j] = new ArrayList();
                    XIterator it = this.cubeResultSet.getAxisIterator(j);
                    try {
                        ITuple tuple = null;
                        while ((tuple = (ITuple)it.next()) != null) {
                            this.axisTuples[j].add(tuple);
                        }
                        continue;
                    }
                    finally {
                        it.release();
                    }
                }
            }
            this.tupleTemplate = new IMember[originalHierarchyOrder.length];
            for (j = 0; j < LOLAPQueryStrategy.this.slicerMembers.size(); ++j) {
                member = LOLAPQueryStrategy.this.slicerMembers.get(j);
                if (this.mMediator.execute(LOLAPMediator.Condition.LESS_THAN, "11.8.00600.6", () -> member instanceof LOLAPMemberProxy && ((LOLAPMemberProxy)member).isMultiHierarchySlicer()) && Boolean.TRUE.equals(this.mMediator.getResult()) || member == null) continue;
                int hierIndex = this.hierarchyToIndex.get(member.getHierarchy());
                this.tupleTemplate[hierIndex] = member;
            }
            for (int i = 0; i < LOLAPQueryStrategy.this.attributeMemberList.size(); ++i) {
                member = LOLAPQueryStrategy.this.attributeMemberList.get(i);
                if (member == null) continue;
                int hierIndex = this.hierarchyToIndex.get(member.getHierarchy());
                this.tupleTemplate[hierIndex] = member;
            }
            this.iterator = this.getIterator();
            if (statsLogger.isOn(LogLevel.TRACE)) {
                LOLAPQueryStrategy.this.strBldr.append("LOLAP Axis Fetch Time:" + (System.currentTimeMillis() - ticks)).append(NEWLINE);
            }
        }

        public long getNumberOfValues() {
            return this.numberOfValues;
        }

        public long getValueFetchingTime() {
            return this.valueFetchingTime;
        }

        public void release() {
            for (XIterator axesIter : this.axesIterators) {
                axesIter.release();
            }
            for (XCellIterator cellIter : this.cellIterators) {
                cellIter.release();
            }
        }

        @Override
        public boolean isEmpty() {
            boolean bEmpty = false;
            if (LOLAPQueryStrategy.this.factLessQuery) {
                if (this.axisCount == 0) {
                    return false;
                }
                XIterator iter = this.cubeResultSet.getAxisIterator(0);
                bEmpty = iter.next() == null;
                iter.release();
            } else {
                XCellIterator iter = this.cubeResultSet.getCellIterator();
                bEmpty = iter.hasNext();
                iter.release();
            }
            return bEmpty;
        }

        @Override
        public Iterator<TupleValue> iterator() {
            return this.iterator;
        }

        private Iterator<TupleValue> getIterator() {
            if (LOLAPQueryStrategy.this.factLessQuery) {
                XIterator iter = null;
                if (this.axisCount == 1) {
                    iter = this.cubeResultSet.getAxisIterator(0);
                    this.axesIterators.add(iter);
                }
                return new TupleValueIterator(iter);
            }
            XCellIterator iter = this.cubeResultSet.getCellIterator();
            this.cellIterators.add(iter);
            return new TupleValueIterator(iter);
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(TupleValue o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends TupleValue> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, TupleValue element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends TupleValue> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TupleValue get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<TupleValue> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<TupleValue> listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TupleValue remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TupleValue set(int index, TupleValue element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<TupleValue> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        private final class TupleValueIterator
        implements Iterator<TupleValue> {
            XCellIterator baseCellIterator = null;
            XIterator baseAxesIterator = null;
            ITuple nextTuple = null;

            TupleValueIterator(XCellIterator iter) {
                this.baseCellIterator = iter;
            }

            TupleValueIterator(XIterator iter) {
                if (iter == null) {
                    this.nextTuple = new Tuple((IMember[])CubeResultSetToReadOnlyListAdapter.this.tupleTemplate.clone(), false);
                } else {
                    this.baseAxesIterator = iter;
                }
            }

            @Override
            public boolean hasNext() {
                if (LOLAPQueryStrategy.this.factLessQuery) {
                    if (this.nextTuple == null && this.baseAxesIterator != null) {
                        this.nextTuple = (ITuple)this.baseAxesIterator.next();
                    }
                    return this.nextTuple != null;
                }
                return this.baseCellIterator.hasNext();
            }

            @Override
            public TupleValue next() {
                if (LOLAPQueryStrategy.this.cancelManager != null && LOLAPQueryStrategy.this.cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                IValue cellValue = null;
                long ticks = System.currentTimeMillis();
                while (this.hasNext() && (cellValue = this.internalNext(CubeResultSetToReadOnlyListAdapter.this.tupleTemplate)) == null) {
                }
                if (cellValue == null) {
                    return null;
                }
                CubeResultSetToReadOnlyListAdapter.this.valueFetchingTime = CubeResultSetToReadOnlyListAdapter.this.valueFetchingTime + (System.currentTimeMillis() - ticks);
                Tuple t = new Tuple((IMember[])CubeResultSetToReadOnlyListAdapter.this.tupleTemplate.clone(), false);
                Cell c = LOLAPQueryStrategy.this.factLessQuery ? DUMMY_CELL : new Cell(cellValue);
                if (CubeResultSetToReadOnlyListAdapter.this.queryResultSet != null) {
                    CubeResultSetToReadOnlyListAdapter.this.queryResultSet.addCell(t, c);
                }
                CubeResultSetToReadOnlyListAdapter.this.numberOfValues++;
                return new TupleValue(t, c);
            }

            private IValue internalNext(IMember[] tuple) {
                boolean foundValidTuple = false;
                IValue cellValue = null;
                if (LOLAPQueryStrategy.this.factLessQuery) {
                    foundValidTuple = this.getTupleForFactlessQuery(tuple);
                    if (foundValidTuple) {
                        cellValue = DUMMY_VALUE;
                    }
                } else {
                    long ordinal = -1L;
                    ICell cell = this.baseCellIterator.next();
                    if (cell == null) {
                        return null;
                    }
                    ordinal = cell.getOrdinal();
                    cellValue = cell.getValue();
                    if (ordinal >= 0L && !cellValue.isNull()) {
                        foundValidTuple = this.getTupleForRegularQuery(ordinal, tuple);
                    }
                    if (!foundValidTuple) {
                        cellValue = null;
                    }
                }
                return cellValue;
            }

            private boolean getTupleForFactlessQuery(IMember[] tuple) {
                if (this.nextTuple == null) {
                    return false;
                }
                ITuple currentTuple = this.nextTuple;
                this.nextTuple = null;
                for (int memTupleInx = 0; memTupleInx < currentTuple.size(); ++memTupleInx) {
                    IMember member = this.getV5Member(currentTuple.getMember(memTupleInx));
                    if (member == null) {
                        return false;
                    }
                    int dimIndex = (Integer)CubeResultSetToReadOnlyListAdapter.this.hierarchyToIndex.get(member.getHierarchy());
                    tuple[dimIndex] = member;
                }
                return true;
            }

            private boolean getTupleForRegularQuery(long ordinal, IMember[] tuple) {
                for (int axisInx = 0; axisInx < CubeResultSetToReadOnlyListAdapter.this.axisCount; ++axisInx) {
                    int index = (int)(ordinal % (long)CubeResultSetToReadOnlyListAdapter.this.axisTuples[axisInx].size());
                    ordinal /= (long)CubeResultSetToReadOnlyListAdapter.this.axisTuples[axisInx].size();
                    ITuple axisTuple = CubeResultSetToReadOnlyListAdapter.this.axisTuples[axisInx].get(index);
                    for (int axisTupleInx = 0; axisTupleInx < axisTuple.size(); ++axisTupleInx) {
                        IMember member = this.getV5Member(axisTuple.getMember(axisTupleInx));
                        if (member == null) {
                            return false;
                        }
                        int dimIndex = (Integer)CubeResultSetToReadOnlyListAdapter.this.hierarchyToIndex.get(member.getHierarchy());
                        tuple[dimIndex] = member;
                    }
                }
                return true;
            }

            private IMember getV5Member(IMember providerMember) {
                if (providerMember == null) {
                    return null;
                }
                String uniqueName = providerMember.getUniqueName();
                IHierarchy hierarchy = providerMember.getHierarchy();
                if (null == LOLAPQueryStrategy.this.mmemberUniqueNameToMember.get(hierarchy)) {
                    return null;
                }
                HashMap<String, IMember> membersMap = LOLAPQueryStrategy.this.mmemberUniqueNameToMember.get(hierarchy);
                if (CubeResultSetToReadOnlyListAdapter.this.mMediator.execute(LOLAPMediator.Condition.GREATER_OR_EQUAL, "11.8.00600.6", () -> membersMap.size() == 1 && membersMap.get(((Hierarchy)hierarchy).getProviderDefaultMember().getUniqueName()) != null) && Boolean.TRUE.equals(CubeResultSetToReadOnlyListAdapter.this.mMediator.getResult())) {
                    return ((Hierarchy)hierarchy).getProviderDefaultMember();
                }
                return LOLAPQueryStrategy.this.mmemberUniqueNameToMember.get(hierarchy).get(uniqueName);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public class HierarchySelectionComparator
    implements Comparator<Object> {
        HashMap<IHierarchy, ArrayList<IMember>> hierarchyToSelections;

        public HierarchySelectionComparator(HashMap<IHierarchy, ArrayList<IMember>> theHierarchyToSelections) {
            this.hierarchyToSelections = theHierarchyToSelections;
        }

        @Override
        public int compare(Object o1, Object o2) {
            ArrayList<IMember> selections1 = this.hierarchyToSelections.get(o1);
            ArrayList<IMember> selections2 = this.hierarchyToSelections.get(o2);
            return selections1.size() - selections2.size();
        }
    }
}

