/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEUberNodeFactory;
import com.cognos.xqe.ast.mdx.parser.MDXNodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.OLAPNodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.olap.mdx.functions.numeric.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ExternalAggregateStrategyException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IExternalAggregateStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMDXQuery;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.HashSetInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.collections.map.MultiValueMap;

public class LOLAPTM1ExternalAggregateStategy
implements IExternalAggregateStrategy {
    private Block block;

    @Override
    public Value[] execute(InterpreterContext interpreterContext, IHierarchy[] aggHiers, Set[] aggSets) throws ExternalAggregateStrategyException {
        Value[] aggValues = new Value[aggSets.length];
        ArrayList<Long> extAggregatePositions = new ArrayList<Long>();
        Set[] externalAggregateSets = this.calculateLocalAggregates(interpreterContext, aggSets, aggValues, extAggregatePositions);
        if (externalAggregateSets.length == 0) {
            return aggValues;
        }
        Value[] extAggValues = new Value[externalAggregateSets.length];
        try {
            AggregationUtils.executeCalculationSet(interpreterContext, externalAggregateSets, extAggValues);
            this.executeAsymmetricSets(externalAggregateSets, extAggValues);
            this.executeBaseSet(interpreterContext, externalAggregateSets, extAggValues);
            this.mergeExternallyAndLocallyAggregatedValues(extAggregatePositions, aggValues, extAggValues);
        }
        catch (InterpreterException ie) {
            throw new ExternalAggregateStrategyException("LOLAPTM1ExternalAggregateStategy failure", ie);
        }
        return aggValues;
    }

    private void executeAsymmetricSets(Set[] externalAggregateSets, Value[] extAggValues) {
        for (int i = 0; i < externalAggregateSets.length; ++i) {
            Set set = externalAggregateSets[i];
            if (set == null || set.isEmpty()) continue;
            long requiredTuples = set.size();
            double symmetricTuples = 1.0;
            IMember[][] members = set.getMembers(set.getHierarchies());
            for (int j = 0; j < members.length; ++j) {
                symmetricTuples *= (double)members[j].length;
            }
            if (!((double)requiredTuples < symmetricTuples)) continue;
            extAggValues[i] = TextValue.ERROR_VALUE;
            externalAggregateSets[i] = null;
        }
    }

    private void mergeExternallyAndLocallyAggregatedValues(List<Long> extAggregatePositions, Value[] aggValues, Value[] extAggValues) {
        int i = 0;
        for (Long pos : extAggregatePositions) {
            int position = pos.intValue();
            aggValues[position] = extAggValues[i];
            ++i;
        }
    }

    private Set[] calculateLocalAggregates(InterpreterContext interpreterContext, Set[] aggSets, Value[] aggValues, List<Long> extAggregatePositions) {
        IBlockIterator blockIterTM1Data = Block.getBlockIterator(new Block[]{this.block});
        ArrayList<Set> extAggrSets = new ArrayList<Set>();
        int position = -1;
        while (blockIterTM1Data.hasNext()) {
            Object[] blockObjValue = (Object[])blockIterTM1Data.next();
            long newPosition = blockIterTM1Data.pos();
            while (newPosition > (long)(position + 1)) {
                NullValue v = DataValueFactory.createNullValue();
                aggValues[++position] = v;
            }
            TreeSet valuesReal = (TreeSet)blockObjValue[0];
            Iterator cellDataIter = valuesReal.iterator();
            boolean isCalc = false;
            while (cellDataIter.hasNext()) {
                Cell cellDataValue = (Cell)cellDataIter.next();
                IValue value = cellDataValue.getValue();
                if (!(value instanceof Value) || !((Value)value).isCALC()) continue;
                isCalc = true;
            }
            int numberOfDimensions = interpreterContext.getCube().getDimensionCount();
            Set aggTuples = aggSets[(int)newPosition];
            if (!aggTuples.isEmpty() && isCalc && (aggTuples.size() > 1L || ((Tuple)aggTuples.getTuple(0L)).getDimensions().length < numberOfDimensions || ((Tuple)aggTuples.getTuple(0L)).containsCalculation())) {
                extAggrSets.add(aggTuples);
                extAggregatePositions.add(newPosition);
            } else {
                Value value = (Value)Aggregate.aggregate(interpreterContext, valuesReal, 0);
                if (isCalc && value.isOK()) {
                    value.setState(ValueState.CALC);
                }
                aggValues[(int)newPosition] = value;
            }
            position = (int)newPosition;
        }
        return extAggrSets.toArray(new Set[extAggrSets.size()]);
    }

    public void setBlock(Block b) {
        this.block = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBaseSet(InterpreterContext interpreterContext, Set[] aggSets, Value[] aggValues) throws ExternalAggregateStrategyException {
        MultiValueMap combinationToSetIndex = new MultiValueMap();
        IHierarchy[] hiearchies = null;
        HashSet<IHierarchy> aggregateHierarchies = new HashSet<IHierarchy>();
        for (int i = 0; i < aggSets.length; ++i) {
            if (aggSets[i] == null) continue;
            aggregateHierarchies.addAll(LOLAPTM1ExternalAggregateStategy.getAggregateHierarchies(aggSets[i]));
            if (hiearchies != null) continue;
            hiearchies = aggSets[i].getHierarchies();
        }
        if (hiearchies == null) {
            return;
        }
        List<List<Object>> combinations = LOLAPTM1ExternalAggregateStategy.getSelectionCombinations(aggSets, aggregateHierarchies, Arrays.asList(hiearchies), combinationToSetIndex);
        int i = 0;
        for (List<Object> combination : combinations) {
            String mdx = this.buildMDXStatement(interpreterContext, combination, aggregateHierarchies);
            LOLAPCube cube = (LOLAPCube)interpreterContext.getCube();
            LOLAPMDXQuery mdxQuery = new LOLAPMDXQuery(mdx, cube, null);
            ICubeResultSet cubeResult = null;
            XCellIterator cellIterator = null;
            try {
                cubeResult = cube.performExecuteRequest(mdxQuery, null, cube);
                cellIterator = cubeResult.getCellIterator();
                List indexes = (List)combinationToSetIndex.get((Object)i);
                ICell next = cellIterator.next();
                for (int s = 0; s < indexes.size(); ++s) {
                    if (next == null || next.getOrdinal() < (long)s) {
                        next = cellIterator.hasNext() ? cellIterator.next() : null;
                    }
                    if (next == null) continue;
                    Value value = (Value)next.getValue();
                    if (value.isOK()) {
                        value.setState(ValueState.CALC);
                    }
                    int ordinal = (int)next.getOrdinal();
                    aggValues[((Integer)indexes.get((int)ordinal)).intValue()] = (Value)next.getValue().copy();
                }
            }
            finally {
                if (cellIterator != null) {
                    cellIterator.release();
                }
                if (cubeResult != null) {
                    cubeResult.release();
                }
            }
            ++i;
        }
    }

    public String buildMDXStatement(InterpreterContext interpreterContext, List<Object> combination, HashSet<IHierarchy> aggregateDimensions) {
        IXQEQueryNode edge1set;
        int i;
        LOLAPCube cube = (LOLAPCube)interpreterContext.getCube();
        IHierarchy[] hierarchies = cube.getHierarchies().toArray(new Hierarchy[0]);
        ArrayList<IMember> slicerMembers = new ArrayList<IMember>();
        HashMap<IHierarchy, ArrayList<IMember>> hierarchyToSelections = new HashMap<IHierarchy, ArrayList<IMember>>();
        HashSet<IDimension> projectedDims = new HashSet<IDimension>();
        for (int k = 0; k < combination.size(); ++k) {
            ArrayList members;
            if (combination.get(k) instanceof IMember) {
                members = new ArrayList();
                members.add((IMember)combination.get(k));
            } else {
                members = (ArrayList)combination.get(k);
            }
            IHierarchy hierarchy = ((IMember)members.get(0)).getHierarchy();
            hierarchyToSelections.put(hierarchy, members);
            projectedDims.add(hierarchy.getDimension());
        }
        ArrayList<IHierarchy> axis0 = new ArrayList<IHierarchy>();
        ArrayList<IHierarchy> axis1 = new ArrayList<IHierarchy>();
        for (i = 0; i < hierarchies.length; ++i) {
            IHierarchy hier = hierarchies[i];
            ArrayList sels = (ArrayList)hierarchyToSelections.get(hier);
            if (sels == null) {
                if (projectedDims.contains(hier.getDimension())) continue;
                sels = new ArrayList();
                hierarchyToSelections.put(hier, sels);
                projectedDims.add(hier.getDimension());
            }
            if (aggregateDimensions.contains(hier) && sels.size() > 1) {
                axis0.add(hier);
                continue;
            }
            if (sels.size() == 1) {
                slicerMembers.add((IMember)sels.get(0));
                continue;
            }
            axis1.add(hier);
        }
        if (axis0.isEmpty() && !slicerMembers.isEmpty()) {
            for (i = 0; i < slicerMembers.size(); ++i) {
                IMember m = (IMember)slicerMembers.get(i);
                if (LOLAPQueryStrategy.removeMember(m)) continue;
                axis0.add(m.getHierarchy());
                slicerMembers.remove(m);
                break;
            }
        }
        XQEUberNodeFactory nodeFactory = new XQEUberNodeFactory();
        nodeFactory.addNodeFactory(new OLAPNodeFactory());
        nodeFactory.addNodeFactory(new MDXNodeFactory());
        MDXQuery mdxQuery = (MDXQuery)nodeFactory.createNode(1002);
        mdxQuery.getCellProperties().addCellProperty("TM1RULEDERIVED");
        IXQEQueryNode edge0set = LOLAPTM1QueryStrategy.axisToSetNode(axis0, hierarchyToSelections, nodeFactory, true, false);
        if (edge0set != null) {
            MDXEdge mdxEdge0 = (MDXEdge)nodeFactory.createNode(1006);
            mdxEdge0.setEdgeID(0);
            MDXHierInfo hierInfo = ((AbstractMDXSet)edge0set).getHierarchyInfo();
            MDXSummaryFunction agg = (MDXSummaryFunction)nodeFactory.createNode(1060);
            agg.addChildNonIndexed(edge0set);
            MDXCalculatedMemberDefinition calc = (MDXCalculatedMemberDefinition)nodeFactory.createNode(1005);
            calc.setHierarchy(hierInfo.getProjectedHierarchy(0));
            calc.setPrefix("ext");
            calc.setSolveOrder(1);
            calc.addChildNonIndexed(agg);
            mdxQuery.addChildNonIndexed(calc);
            MDXCalculatedMemberReference mdxCalculatedMemberRef = (MDXCalculatedMemberReference)nodeFactory.createNode(1013);
            mdxCalculatedMemberRef.setPropertyValue("definition", calc);
            calc.generateUniqueName();
            String member = calc.getCustomUniqueName();
            IDimension dimension = hierInfo.getProjectedHierarchy(0).getDimension();
            StringBuilder un = new StringBuilder(dimension.getUniqueName());
            un.append(".");
            String hierarchyName = null;
            String calcName = null;
            try {
                String[] parts = UniqueNameParser.parse(member);
                if (parts.length > 2 && parts[1].length() != 0) {
                    hierarchyName = parts[1];
                }
                calcName = parts[parts.length - 1];
            }
            catch (UniqueNameParserException e) {
                XQEDebugLog.err.println("Error parsing PowerCube unique name. " + member);
                return "";
            }
            if (hierarchyName != null) {
                un.append("[" + hierarchyName + "]");
            }
            if (DataSourceTypeEnum.isTM1(cube.getDatasourceType())) {
                un.append(".[@MEMBER]");
            }
            un.append(".");
            un.append("[" + calcName + "]");
            calc.setCustomUniqueName(un.toString());
            MDXSet mdxSet = (MDXSet)nodeFactory.createNode(1039);
            mdxSet.addChildNonIndexed(mdxCalculatedMemberRef);
            mdxEdge0.addChildNonIndexed(mdxSet);
            mdxQuery.addChildNonIndexed(mdxEdge0);
        }
        if ((edge1set = LOLAPTM1QueryStrategy.axisToSetNode(axis1, hierarchyToSelections, nodeFactory, true, false)) != null) {
            MDXEdge mdxEdge1 = (MDXEdge)nodeFactory.createNode(1006);
            mdxEdge1.setEdgeID(0);
            mdxEdge1.addChildNonIndexed(edge1set);
            mdxQuery.addChildNonIndexed(mdxEdge1);
        }
        MDXFromCube mdxFrom = (MDXFromCube)nodeFactory.createNode(1007);
        mdxFrom.setPropertyValue("referencedCube", cube);
        mdxFrom.setPropertyValue("dataSource", cube.getRuntreeDataSource());
        mdxFrom.setHaveVariablesBeenRead(false);
        mdxQuery.addChildNonIndexed(mdxFrom);
        IXQEQueryNode dimLine = this.axisToDimensionTuple(nodeFactory, slicerMembers);
        if (dimLine != null) {
            mdxQuery.addChildNonIndexed(dimLine);
        }
        String sQuery = null;
        Boolean useNativeEngine = LOLAPTM1QueryStrategy.useNativeTM1Engine(cube.getDatasourceType());
        if (useNativeEngine.booleanValue()) {
            StringBuilder buf = new StringBuilder();
            buf.append("NativeTM1Query:");
            buf.append(mdxQuery.getMDX());
            sQuery = buf.toString();
            sQuery = sQuery.replaceAll("\\.\\[@MEMBER\\]", "");
        } else {
            sQuery = mdxQuery.getMDQuery();
        }
        return sQuery;
    }

    private IXQEQueryNode axisToDimensionTuple(IXQENodeFactory nodeFactory, ArrayList<IMember> slicerMembers) {
        MDXDimensionLine dimLine = null;
        MDXTuple tuple = null;
        for (IMember member : slicerMembers) {
            if (((IMemberCubics)member).isDummyMember()) continue;
            IDimension dim = member.getDimension();
            boolean addToWhereCondition = ((LOLAPCube)dim.getCube()).addToWhereCondition(dim, member);
            if (LOLAPQueryStrategy.removeMember(member)) {
                addToWhereCondition = false;
            }
            if (!addToWhereCondition) continue;
            if (dimLine == null) {
                dimLine = (MDXDimensionLine)nodeFactory.createNode(1008);
                tuple = (MDXTuple)nodeFactory.createNode(1069);
                dimLine.addChildNonIndexed(tuple);
            }
            BaseMember baseMember = (BaseMember)nodeFactory.createNode(1067);
            baseMember.bind(member);
            tuple.addChildNonIndexed(baseMember);
        }
        return dimLine;
    }

    public static HashSet<IHierarchy> getAggregateHierarchies(Set aggregateSet) {
        HashSet<IHierarchy> aggregateHiers = new HashSet<IHierarchy>();
        IHierarchy[] hiers = aggregateSet.getHierarchies();
        int[] cardinalities = aggregateSet.getDimensionCardinality();
        for (int i = 0; i < cardinalities.length; ++i) {
            if (cardinalities[i] <= 1) continue;
            aggregateHiers.add(hiers[i]);
        }
        return aggregateHiers;
    }

    public static List<ArrayListInt> findDifferentSelections(int selectionXIndex, Object[][] allSelections, HashSetInt selectionsCombined) {
        List<Object> thisSelection = Arrays.asList(allSelections[selectionXIndex]);
        ArrayList<ArrayListInt> differentSelections = new ArrayList<ArrayListInt>();
        for (int j = 0; j < allSelections.length; ++j) {
            ArrayListInt differentColumns = new ArrayListInt();
            if (allSelections[j] == null) {
                differentSelections.add(differentColumns);
                continue;
            }
            if (!selectionsCombined.contains(j)) {
                block1: for (int k = 0; k < thisSelection.size(); ++k) {
                    if (thisSelection.get(k) instanceof IMember && allSelections[j][k] instanceof ArrayList || thisSelection.get(k) instanceof ArrayList && allSelections[j][k] instanceof IMember) {
                        differentColumns.add(k);
                        continue;
                    }
                    if (thisSelection.get(k) instanceof IMember && allSelections[j][k] instanceof IMember) {
                        if ((IMember)thisSelection.get(k) == (IMember)allSelections[j][k]) continue;
                        differentColumns.add(k);
                        continue;
                    }
                    if (((List)thisSelection.get(k)).size() != ((List)allSelections[j][k]).size()) {
                        differentColumns.add(k);
                        continue;
                    }
                    Iterator membersIt = CollectionCast.uncheckedCast((List)allSelections[j][k]).iterator();
                    List column = CollectionCast.uncheckedCast((List)thisSelection.get(k));
                    while (membersIt.hasNext()) {
                        if (column.contains(membersIt.next())) continue;
                        differentColumns.add(k);
                        continue block1;
                    }
                }
            }
            differentSelections.add(differentColumns);
        }
        return differentSelections;
    }

    public static List<List<Object>> getSelectionCombinations(Set[] aggSets, HashSet<IHierarchy> aggregateHierarchies, List<IHierarchy> list, MultiValueMap combinationToSetIndex) {
        ArrayList<List<Object>> combinations = new ArrayList<List<Object>>();
        Object[][] selectionsByDimension = LOLAPTM1ExternalAggregateStategy.getSelectionsByDimensions(aggSets, list);
        HashSetInt selectionsAlreadyCombined = new HashSetInt();
        for (int i = 0; i < selectionsByDimension.length; ++i) {
            if (selectionsByDimension[i] == null || selectionsAlreadyCombined.contains(i)) continue;
            List<Object> combination = Arrays.asList(selectionsByDimension[i]);
            selectionsAlreadyCombined.add(i);
            combinations.add(combination);
            combinationToSetIndex.put((Object)(combinations.size() - 1), (Object)i);
            List<ArrayListInt> differentSelections = LOLAPTM1ExternalAggregateStategy.findDifferentSelections(i, selectionsByDimension, selectionsAlreadyCombined);
            int[] oneDifferentCounter = new int[list.size()];
            for (int k = 0; k < differentSelections.size(); ++k) {
                if (differentSelections.get(k).size() != 1) continue;
                int n = differentSelections.get(k).get(0);
                oneDifferentCounter[n] = oneDifferentCounter[n] + 1;
            }
            int optimalHierarchy = 0;
            int maxCount = 0;
            for (int k = 0; k < oneDifferentCounter.length; ++k) {
                if (oneDifferentCounter[k] <= maxCount) continue;
                optimalHierarchy = k;
                maxCount = oneDifferentCounter[k];
            }
            LOLAPTM1ExternalAggregateStategy.addSetSelectionsToCombination(selectionsByDimension, selectionsAlreadyCombined, combinations, combinationToSetIndex, aggregateHierarchies, differentSelections, optimalHierarchy);
        }
        return combinations;
    }

    private static void addSetSelectionsToCombination(Object[][] selectionsByDimension, HashSetInt selectionsAlreadyCombined, List<List<Object>> combinations, MultiValueMap combinationToSetIndex, HashSet<IHierarchy> aggregateHierarchies, List<ArrayListInt> differentSelections, int optimalHierarchy) {
        int currentCombinationInd = combinations.size() - 1;
        List<Object> currentCombination = combinations.get(currentCombinationInd);
        for (int selection = 0; selection < differentSelections.size(); ++selection) {
            if (differentSelections.get(selection).size() != 1 || differentSelections.get(selection).get(0) != optimalHierarchy) continue;
            int hierarchyInd = differentSelections.get(selection).get(0);
            boolean combine = true;
            if (selectionsByDimension[selection][hierarchyInd] instanceof IMember) {
                IMember selectionMember = (IMember)selectionsByDimension[selection][hierarchyInd];
                if (aggregateHierarchies != null && aggregateHierarchies.contains(selectionMember.getHierarchy())) break;
                if (currentCombination.get(hierarchyInd) instanceof ArrayList) {
                    ((List)currentCombination.get(hierarchyInd)).add(selectionMember);
                } else {
                    IMember member0 = (IMember)currentCombination.get(hierarchyInd);
                    ArrayList<IMember> list = new ArrayList<IMember>();
                    list.add(member0);
                    list.add(selectionMember);
                    currentCombination.set(hierarchyInd, list);
                }
            } else {
                List selections = (List)selectionsByDimension[selection][hierarchyInd];
                if (selections.size() > 0) {
                    IMember member1 = (IMember)selections.get(0);
                    if (aggregateHierarchies != null && aggregateHierarchies.contains(member1.getHierarchy())) break;
                }
                Iterator membersIt = selections.iterator();
                for (IMember member : selections) {
                    if (currentCombination.get(hierarchyInd) instanceof List) {
                        if (((List)currentCombination.get(hierarchyInd)).contains(member)) continue;
                        List list = (List)currentCombination.get(hierarchyInd);
                        list.add(member);
                        currentCombination.set(hierarchyInd, list);
                        continue;
                    }
                    IMember member0 = (IMember)currentCombination.get(hierarchyInd);
                    ArrayList<IMember> list = new ArrayList<IMember>();
                    list.add(member0);
                    if (!list.contains(member)) {
                        list.add(member);
                    }
                    currentCombination.set(hierarchyInd, list);
                }
            }
            if (!combine) continue;
            combinationToSetIndex.put((Object)currentCombinationInd, (Object)selection);
            selectionsAlreadyCombined.add(selection);
        }
    }

    public static Object[][] getSelectionsByDimensions(Set[] aggSets, List<IHierarchy> hierarchies) {
        Object[][] selectionsByDimension = (Object[][])ArrayCast.uncheckedCast(new Object[aggSets.length][hierarchies.size()]);
        for (int j = 0; j < aggSets.length; ++j) {
            if (aggSets[j] == null || aggSets[j].isEmpty()) {
                selectionsByDimension[j] = null;
                continue;
            }
            for (int i = 0; i < hierarchies.size(); ++i) {
                IHierarchy dim = hierarchies.get(i);
                IMember[] mems = aggSets[j].getMembers(dim);
                selectionsByDimension[j][i] = mems.length == 1 ? mems[0] : new ArrayList<IMember>(Arrays.asList(mems));
            }
        }
        return selectionsByDimension;
    }
}

