/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.XMdxCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import java.util.ArrayList;
import java.util.HashMap;

public class AggregateMember
extends CalculatedMember {
    CalculatedMember calculatedMember;
    HashMap<IHierarchy, Integer> caclSetHierarchyMap;
    IHierarchy[] orderedHierarchies;
    boolean errorCell = false;
    ArrayList<Tuple> tuples = new ArrayList();
    Value value = null;

    public AggregateMember(CalculatedMember cm, IHierarchy[] hierarchies) throws MetadataException {
        super(cm.getCaption(), cm.getLevel(), null);
        this.calculatedMember = cm;
        this.orderedHierarchies = hierarchies;
        this.caclSetHierarchyMap = new HashMap();
        for (int i = 0; i < hierarchies.length; ++i) {
            this.caclSetHierarchyMap.put(hierarchies[i], new Integer(i));
        }
    }

    @Override
    public boolean isAggregateMember() {
        return true;
    }

    public void addTuple(Tuple t) {
        this.tuples.add(t);
    }

    public void addValue(Value v) {
        if (this.value != null) {
            this.errorCell = true;
        }
        this.value = v;
    }

    public void addTuples(Set set, InterpreterContext interpreterContext) {
        if (set.isEmpty()) {
            return;
        }
        ITuple tuple = set.getTuple(0L);
        boolean reorderTuple = this.tupleNeedsReorder(tuple);
        ResourceMonitor.checkMaxSetSize(set.size(), interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
        int i = 0;
        while ((long)i < set.size()) {
            ITuple t = set.getTuple(i);
            if (reorderTuple) {
                t = this.orderTuple(t);
            }
            this.tuples.add((Tuple)t);
            ++i;
        }
    }

    public boolean tupleNeedsReorder(ITuple tuple) {
        for (int i = 0; i < tuple.size(); ++i) {
            if (tuple.getMember(i).getHierarchy() == this.orderedHierarchies[i]) continue;
            return true;
        }
        return false;
    }

    public ITuple orderTuple(ITuple tuple) {
        IMember[] tupleMembers = new IMember[tuple.size()];
        for (int i = 0; i < tuple.size(); ++i) {
            tupleMembers[i] = tuple.getMember(this.orderedHierarchies[i]);
        }
        return new Tuple(tupleMembers);
    }

    public ArrayList<Tuple> getTuples() {
        return this.tuples;
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public void setOriginalV5Name(String name) {
        this.calculatedMember.setOriginalV5Name(name);
    }

    @Override
    public String getOriginalV5Name() {
        return this.calculatedMember.getOriginalV5Name();
    }

    @Override
    protected void parseCalculationString(String calculationObj) {
        this.calculatedMember.parseCalculationString(calculationObj);
    }

    @Override
    public MetadataType getObjectType() {
        return this.calculatedMember.getObjectType();
    }

    @Override
    public void setUniqueName(String uniqueName) {
        this.calculatedMember.setUniqueName(uniqueName);
    }

    @Override
    public boolean isMeasure() {
        return this.calculatedMember.isMeasure();
    }

    @Override
    public void setIsMeasure(boolean isMeasure) {
        this.calculatedMember.setIsMeasure(isMeasure);
    }

    @Override
    public boolean isRelational() {
        return this.calculatedMember.isRelational();
    }

    @Override
    public void setParentMember(IMember parent) {
        this.calculatedMember.setParentMember(parent);
    }

    @Override
    public void setSolveOrder(int solveOrd) {
        this.calculatedMember.setSolveOrder(solveOrd);
    }

    @Override
    public int getSolveOrder() {
        return this.calculatedMember.getSolveOrder();
    }

    @Override
    public void setCaption(String caption) {
        this.calculatedMember.setCaption(caption);
    }

    @Override
    public void setCalculationString(String calcString) {
        this.calculatedMember.setCalculationString(calcString);
    }

    @Override
    public String getCalculationString() {
        return this.calculatedMember.getCalculationString();
    }

    @Override
    public String getUnescapeCalculationString() {
        return this.calculatedMember.getUnescapeCalculationString();
    }

    @Override
    public boolean isCalculatedMember() {
        return true;
    }

    @Override
    public boolean isNullTag() {
        return this.calculatedMember.isNullTag();
    }

    @Override
    public XMdxCalculatedMember getRuntreeCalculatedMember() {
        return this.calculatedMember.getRuntreeCalculatedMember();
    }

    @Override
    public void setRuntreeCalculatedMember(XMdxNode xNode) {
        this.calculatedMember.setRuntreeCalculatedMember(xNode);
    }

    @Override
    public OrderedMap<IMember> fetchChildMembers() throws MetadataException, ProviderException {
        return this.calculatedMember.fetchChildMembers();
    }

    @Override
    public IMember getChildMember(String memberName) throws MetadataException {
        return this.calculatedMember.getChildMember(memberName);
    }

    @Override
    public IResultSet executeToResultSet(InterpreterContext interpreterContext) throws InterpreterException {
        return this.calculatedMember.executeToResultSet(interpreterContext);
    }

    @Override
    public IResultSet fetchTupleValues(CrossJoinedSet cjs, InterpreterContext interpreterContext) throws InterpreterException {
        return this.calculatedMember.fetchTupleValues(cjs, interpreterContext);
    }

    @Override
    public Object getBusinessKey() {
        return this.calculatedMember.getBusinessKey();
    }

    public boolean resultsInErrorCell() {
        return this.errorCell;
    }
}

