/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.DimensionType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderDefaultMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Dimension
extends Metadata
implements IDimension {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(Dimension.class);
    private static final String LEFT_BRACE = "[";
    private ICube cube;
    private long flushTime;
    private int dimensionIndex;
    private OrderedMap<IHierarchy> hierarchies;
    protected IHierarchy defaultHierarchy;
    private int hierarchyOrdinalCounter = 0;
    private int cardinality = -1;
    private AtomicInteger maxMemberId = new AtomicInteger(0);
    private int hashCode = -1;
    private IMember nullMember = null;
    private IMember providerDefaultMember = null;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    protected DimensionTypeEnum dimensionType = DimensionTypeEnum.REGULAR;
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);

    @Override
    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = super.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public synchronized IMember getNullMember() {
        if (this.nullMember == null) {
            ILevel rootLevel = this.getLevel(0);
            this.nullMember = new NullMember(rootLevel);
        }
        return this.nullMember;
    }

    public synchronized IMember getProviderDefaultMember() {
        if (this.providerDefaultMember == null) {
            ILevel rootLevel = this.getLevel(0);
            this.providerDefaultMember = new ProviderDefaultMember(rootLevel);
        }
        return this.providerDefaultMember;
    }

    public Dimension(String n, Cube c) {
        super(n);
        c.addDimension(this);
        this.cube = c;
        this.flushTime = System.currentTimeMillis();
        this.dimensionIndex = this.cube.getDimensionIndex(this);
        this.hierarchies = new OrderedMap();
        this.defaultHierarchy = null;
        this.maxMemberId.set(0);
    }

    @Override
    public IDataType getDataType() {
        return DimensionType.DIMENSIONTYPE;
    }

    public int getmaxMemberId() {
        return this.maxMemberId.getAndIncrement();
    }

    public int getHierarchyOrdinalCounter() {
        return this.hierarchyOrdinalCounter;
    }

    @Override
    public List<IHierarchy> getHierarchies() {
        return this.hierarchies.toArrayList();
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int theCardinality) {
        this.cardinality = theCardinality;
    }

    public boolean isDBMeasuresDimension() {
        return false;
    }

    @Override
    public boolean isMeasuresDimension() {
        return this.getType() == DimensionTypeEnum.MEASURE;
    }

    @Override
    public boolean isShell() {
        return false;
    }

    @Override
    public boolean getMembersRollup() {
        return true;
    }

    @Override
    public IHierarchy getDefaultHierarchy() {
        if (this.defaultHierarchy != null) {
            return this.defaultHierarchy;
        }
        if (this.hierarchies.size() > 0) {
            return (Hierarchy)this.hierarchies.get(0);
        }
        return null;
    }

    public void flushDimension() {
        XQEDebugLog.out.println("Flushing Dimension :" + this.getName());
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            Hierarchy h = (Hierarchy)this.hierarchies.get(i);
            h.flushHierarchy();
        }
        this.flushTime = System.currentTimeMillis();
    }

    public long getFlushTime() {
        return this.flushTime;
    }

    public void setHierarchy(IHierarchy h, boolean setHierarchyWithDefaultHierarchy) {
        ++this.hierarchyOrdinalCounter;
        this.hierarchies.put(h);
        if (this.defaultHierarchy == null && setHierarchyWithDefaultHierarchy) {
            this.defaultHierarchy = h;
        }
    }

    protected void setDefaultHierarchy(IHierarchy h) {
        this.defaultHierarchy = h;
    }

    @Override
    public IHierarchy getHierarchy(String hierName) {
        hierName = UniqueNameParser.undoEscapedSquareBracket(hierName);
        return this.hierarchies.get(hierName);
    }

    @Override
    public IHierarchy getHierarchy(String hierarchyUniqueName, String keyDate, DateValue validFrom, DateValue validTo) {
        return this.getHierarchy(hierarchyUniqueName);
    }

    @Override
    public IHierarchy getHierarchy(int index) {
        return this.hierarchies.get(index);
    }

    @Override
    public int getHierarchyIndex(IHierarchy h) {
        return this.hierarchies.indexOf(h);
    }

    @Override
    public boolean isTimeDimension() {
        return this.getType() == DimensionTypeEnum.TIME;
    }

    protected void setDefaultProperties() {
        this.setProperty("description", "");
        this.setProperty("all level", "No");
        this.setProperty("all caption", "");
        this.setProperty("default member", "");
    }

    @Override
    public int getIndex() {
        return this.dimensionIndex;
    }

    @Override
    public int getIndex(String cubeName) {
        return this.getIndex();
    }

    protected IOrderedMap<IMember> fetchFirstLevelMembers() throws MetadataException, ProviderException {
        return ((Hierarchy)this.getDefaultHierarchy()).fetchFirstLevelMembers();
    }

    @Override
    public int getHierarchyCount() {
        return this.hierarchies.size();
    }

    @Override
    public int getLevelCount() {
        return this.getDefaultHierarchy().getLevelCount();
    }

    public ILevel[] getLevels() {
        ILevel[] result = ((Hierarchy)this.getDefaultHierarchy()).getLevels().toArray(new Level[0]);
        return result;
    }

    @Override
    public ILevel getLevel(String levName) {
        return this.getDefaultHierarchy().getLevel(levName);
    }

    @Override
    public int getLevelIndex(ILevel l) {
        return this.getDefaultHierarchy().getLevelIndex(l);
    }

    @Override
    public ILevel getLevel(int index) {
        return this.getDefaultHierarchy().getLevel(index);
    }

    @Override
    public IMember getMember(String memberName) throws MetadataException {
        ILevel l = this.getLevel(0);
        IMember result = ((Level)l).getMember(memberName);
        if (result == null) {
            int size = this.getHierarchyCount();
            for (int i = 0; i < size && result == null; ++i) {
                IHierarchy h = this.getHierarchy(i);
                result = ((Level)h.getLevel(0)).getMember(memberName);
            }
        }
        return result;
    }

    @Override
    public ICube getCube() {
        return this.cube;
    }

    public IMember getDefaultMember() {
        return this.getDefaultHierarchy().getDefaultMember();
    }

    public IMember getDefaultMemberWithSecurity() throws MetadataException {
        SecurityManagerInterface sec = ((Cube)this.getCube()).getSecurityManager();
        if (sec != null) {
            return sec.getDefaultMember(this);
        }
        return this.getDefaultMember();
    }

    @Override
    public IMember[] getMembers() {
        IMember[] result = this.getDefaultHierarchy().getMembers();
        return result;
    }

    public IMember findDescendant(IMember parent, String memberNamePart) {
        return this.findDescendant(parent, memberNamePart, false);
    }

    public IMember findDescendant(IMember parent, String memberNamePart, boolean caseSensitive) {
        IMember result = null;
        for (ILevel l = parent.getLevel().getNextLevel(); result == null && l != null; l = l.getNextLevel()) {
            result = this.findDescendant(parent, memberNamePart, l, caseSensitive);
        }
        return result;
    }

    public IMember findDescendant(IMember parent, String memberNamePart, ILevel level) {
        return this.findDescendant(parent, memberNamePart, level, false);
    }

    public IMember findDescendant(IMember parent, String memberNamePart, ILevel level, boolean caseSensitive) {
        IMember result = null;
        try {
            String hierName = level.getHierarchy().getName();
            IHierarchy hierarchy = this.getHierarchy(hierName);
            ILevel rightLevel = hierarchy.getLevel(level.getIndex());
            for (IMember member : rightLevel.getMembers()) {
                String memberName = member.getName();
                if (memberName == null || memberName.length() == 0) {
                    String memberUniqueName = member.getUniqueName();
                    memberName = memberUniqueName.substring(memberUniqueName.lastIndexOf(LEFT_BRACE) + 1, memberUniqueName.length() - 1);
                }
                if (!(caseSensitive ? memberName.equals(memberNamePart) : memberName.equalsIgnoreCase(memberNamePart))) continue;
                return member;
            }
        }
        catch (MetadataException e) {
            mErrorLogger.log(e);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IMember findMember(String memberNamePart) {
        if (memberNamePart == null) return null;
        if (memberNamePart.isEmpty()) {
            return null;
        }
        IMember result = null;
        IHierarchy hierarchy = null;
        String trimmedName = memberNamePart.trim();
        if (!trimmedName.startsWith(LEFT_BRACE)) return this.findMemberByName(memberNamePart, null, true);
        com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser parser = new com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser();
        try {
            int idx;
            String[] parts;
            block6: {
                block8: {
                    block7: {
                        parts = parser.parse(trimmedName);
                        if (parts.length <= 0) return result;
                        idx = 0;
                        if (!parts[idx].equals(this.getName())) break block6;
                        if (++idx != parts.length) break block7;
                        result = this.getDefaultMember();
                        break block6;
                    }
                    if (!parts[idx].equalsIgnoreCase("HIERARCHY")) break block8;
                    hierarchy = this.getDefaultHierarchy();
                    if (++idx != parts.length) break block6;
                    result = hierarchy.getDefaultMember();
                    break block6;
                }
                for (IHierarchy h : this.hierarchies) {
                    if (!parts[idx].equals(h.getName())) continue;
                    hierarchy = h;
                    if (++idx != parts.length) break;
                    result = hierarchy.getDefaultMember();
                    break;
                }
            }
            if (idx >= parts.length) return result;
            if (parts[idx].equals("@MEMBER")) {
                ++idx;
            }
            result = this.findMemberByName(parts[idx], hierarchy, true);
            ++idx;
            while (result != null) {
                if (idx >= parts.length) return result;
                result = this.findDescendant(result, parts[idx], true);
                ++idx;
            }
            return result;
        }
        catch (Exception e) {
            mErrorLogger.log(e);
            return result;
        }
    }

    private IMember findMemberByName(String nameNoBrackets, IHierarchy hierarchy, boolean caseSensitive) {
        Hierarchy[] allHiers;
        IMember result = null;
        if (hierarchy != null) {
            allHiers = new Hierarchy[]{(Hierarchy)hierarchy};
        } else if (this.defaultHierarchy != null) {
            ArrayList<IHierarchy> defaultFirstHierList = new ArrayList<IHierarchy>();
            defaultFirstHierList.add(this.defaultHierarchy);
            for (IHierarchy hier : this.hierarchies) {
                if (hier == this.defaultHierarchy) continue;
                defaultFirstHierList.add(hier);
            }
            allHiers = defaultFirstHierList.toArray(new Hierarchy[0]);
        } else {
            allHiers = (Hierarchy[])this.hierarchies.toArray(new Hierarchy[0]);
        }
        for (int k = 0; k < allHiers.length && result == null; ++k) {
            IMember member;
            int i;
            Hierarchy hier = allHiers[k];
            List<ILevel> levsList = hier.getLevels();
            ILevel[] levels = levsList.toArray(new ILevel[0]);
            ILevel base = levels[0];
            List<IMember> memsList = ((Level)base).getMembers(true, true);
            IMember[] members = memsList.toArray(new IMember[0]);
            for (i = 0; result == null && i < members.length; ++i) {
                member = members[i];
                String memberName = member.getName();
                if (caseSensitive) {
                    if (!memberName.equals(nameNoBrackets)) continue;
                    result = member;
                    continue;
                }
                if (!memberName.equalsIgnoreCase(nameNoBrackets)) continue;
                result = member;
            }
            for (i = 0; result == null && i < members.length; ++i) {
                member = members[i];
                for (int j = 1; result == null && j < levels.length; ++j) {
                    ILevel onLevel = levels[j];
                    result = this.findDescendant(member, nameNoBrackets, onLevel, caseSensitive);
                }
            }
        }
        return result;
    }

    public void setCube(ICube c) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() {
        if (!this.isInitialized.get()) {
            Dimension dimension = this;
            synchronized (dimension) {
                this.setDefaultProperties();
                this.isInitialized.set(true);
            }
        }
    }

    @Override
    public void initialiseProperties() {
        this.initialise();
    }

    @Override
    public int compareTo(Object pObject) {
        int ret = -1;
        if (pObject instanceof Dimension) {
            if (this == pObject) {
                ret = 0;
            }
        } else if (pObject instanceof IDimension) {
            ret = this.getUniqueName().compareTo(((IDimension)pObject).getUniqueName());
        }
        return ret;
    }

    @Override
    public String getV5UniqueName() {
        return UniqueNameGenerator.createUniqueName(this.getCube().getName(), UniqueNameGenerator.cleanIdentifier(this.getName()));
    }

    @Override
    public DimensionTypeEnum getType() {
        this.initialise();
        return this.dimensionType;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.DIMENSION;
    }

    public void setType(DimensionTypeEnum theDimensionType) {
        this.dimensionType = theDimensionType;
    }

    @Override
    public boolean isRegularDimension() {
        this.initialise();
        return this.getType() == DimensionTypeEnum.REGULAR;
    }

    public IMember getDummyMember(IHierarchy hier) {
        return null;
    }

    @Override
    public boolean isAttributeDimension() {
        return false;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public double getOrderOfMagnitude() {
        return 0.0;
    }

    @Override
    public boolean isUnderNamespaceShortcut() {
        return false;
    }

    @Override
    public boolean isShareable() {
        return false;
    }

    @Override
    public String[] getParentNamespaces() {
        return null;
    }

    @Override
    public boolean isDefaultHierarchyExistInModel() {
        return false;
    }

    @Override
    public IDimension getDimUnderTargetNamespace() {
        return null;
    }

    @Override
    public IScopeRelationship getScopeRelationship(IMetadata otherMetadata) {
        return null;
    }

    @Override
    public List<IEmbeddedFilter> getFilters() {
        return null;
    }

    @Override
    public List<IEmbeddedFilter> getPreviewFilters() {
        return null;
    }

    @Override
    public List<IEmbeddedFilter> getSecurityFilters() {
        return null;
    }

    @Override
    public boolean compareTDHierarchies(IHierarchy hier1, IHierarchy hier2) {
        return false;
    }

    @Override
    public boolean isDBMeasureDimension() {
        return false;
    }

    @Override
    public boolean isKeyFigureStructure() {
        return false;
    }

    @Override
    public boolean getSortMembersData() {
        return false;
    }

    @Override
    public boolean getSortMembersAndEnableMrf() {
        return false;
    }

    @Override
    public IDimension getShortcutTarget(IDimension dimension) {
        return null;
    }

    @Override
    public boolean isAccessedViaShortcut() {
        return false;
    }

    @Override
    public IShortcut getShortcut() {
        return null;
    }

    @Override
    public boolean convertedFromDBQuerySubject() {
        return false;
    }

    @Override
    public INamespace getParentNamespace() {
        return null;
    }
}

