/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LevelType;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.metadata.AllLevel;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.SimpleMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.VirtualMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.IROLAPSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPUserSecurityContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevel;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.DMRPushdownAdapter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.IPushdown;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.IPushdownAdapter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class Level
extends Metadata
implements ILevel,
IPushdown {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(Level.class);
    private static final String LEFT_BRACE = "[";
    private static final String RIGHT_BRACE = "]";
    private static final String DOT = ".";
    private static final String YES = "Yes";
    private static final int THOUSAND = 1000;
    private static final int NUMBER_5 = 5;
    private static final double FIFTY_PERCENT = 0.5;
    private IHierarchy hierarchy;
    protected IOrderedMap<IMember> members;
    private int index;
    protected int cardinality = -1;
    protected boolean isUnique = true;
    private volatile boolean gotAllMembers;
    protected OrderedMap<IProperty> memberProperties;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock rLock = this.rwLock.readLock();
    private final Lock wLock = this.rwLock.writeLock();
    private Integer xmdxTupleId = 0;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    protected PushdownManager mPushdownManager = null;
    private static final String VIRTUAL_MEMBER = "VirtualMember";

    @Override
    public IDataType getDataType() {
        return LevelType.LEVELTYPE;
    }

    public boolean hasGotAllMembers() {
        if (this.gotAllMembers) {
            return this.gotAllMembers;
        }
        this.rLock.lock();
        try {
            boolean bl = this.gotAllMembers;
            return bl;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public boolean loadMeasuresOnDemanding() {
        return false;
    }

    protected boolean hasGotAllMembersNoLock() {
        return this.gotAllMembers;
    }

    public void setGotAllMembers() {
        this.wLock.lock();
        try {
            this.gotAllMembers = true;
        }
        finally {
            this.wLock.unlock();
        }
    }

    public Lock writeLock() {
        return this.wLock;
    }

    public Lock readLock() {
        return this.rLock;
    }

    public int estimateMemberCount() {
        int result = 1000;
        if (this.index < 5) {
            result = 5 ^ this.index + 1;
        }
        if (this.hasGotAllMembers()) {
            result = this.getMemberCount();
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " " + this.hierarchy.getUniqueName() + DOT + LEFT_BRACE + this.getName() + RIGHT_BRACE;
    }

    public Level(String n, Dimension d) {
        super(n);
        this.members = this.createOrderedMap();
        this.memberProperties = new OrderedMap();
        this.hierarchy = d.getDefaultHierarchy();
        if (this.hierarchy == null) {
            new Hierarchy(d.getName(), d);
            this.hierarchy = d.getDefaultHierarchy();
        }
        this.addAllLevel();
        this.index = this.hierarchy.getLevelCount();
        if (d.getType() == DimensionTypeEnum.INTERNAL) {
            ArrayList<VirtualMember> mems = new ArrayList<VirtualMember>();
            VirtualMember member = new VirtualMember(VIRTUAL_MEMBER, this);
            mems.add(member);
            this.members.putAll(mems);
            this.gotAllMembers = true;
        }
        ((Hierarchy)this.hierarchy).setLevel(this);
    }

    public Level(String n, Hierarchy h) {
        super(n);
        this.members = this.createOrderedMap();
        this.memberProperties = new OrderedMap();
        this.hierarchy = h;
        this.addAllLevel();
        this.index = h.getLevelCount();
        if (h.getDimension().getType() == DimensionTypeEnum.INTERNAL && !(this instanceof ROLAPVirtualLevel)) {
            ArrayList<VirtualMember> mems = new ArrayList<VirtualMember>();
            VirtualMember member = new VirtualMember(VIRTUAL_MEMBER, this);
            mems.add(member);
            this.members.putAll(mems);
            this.gotAllMembers = true;
        }
        h.setLevel(this);
    }

    protected void flushLevel() {
        this.wLock.lock();
        try {
            this.gotAllMembers = false;
            this.members = this.createOrderedMap();
            this.memberProperties = new OrderedMap();
        }
        finally {
            this.wLock.unlock();
        }
    }

    public void addMemberProperty(IProperty prop) {
        if (!this.memberProperties.contains(prop.getName())) {
            this.memberProperties.put(prop);
        }
    }

    public boolean isValidPropertyName(String name) {
        return this.memberProperties.contains(name);
    }

    @Override
    public IProperty getMemberProperty(String name) {
        return this.memberProperties.get(name);
    }

    @Override
    public List<IProperty> getMemberProperties() {
        IDimension dimension = this.getDimension();
        SecurityManagerInterface securityManager = ((Cube)dimension.getCube()).getSecurityManager();
        if (securityManager != null) {
            return this.getMemberPropertiesWithSecurity(securityManager);
        }
        return this.memberProperties.toArrayList();
    }

    public List<IProperty> getMemberPropertiesWithSecurity(SecurityManagerInterface securityManager) {
        ArrayList<IProperty> properties = this.memberProperties.toArrayList();
        List<IProperty> outputProperties = securityManager.applySecurity(properties);
        return outputProperties;
    }

    public Set<String> getMemberPropertiesKeys() {
        return this.memberProperties.keySet();
    }

    private void addAllLevel() {
        String value;
        if (this.hierarchy.getLevelCount() == 0 && !(this instanceof AllLevel) && (value = (String)this.hierarchy.getProperty("all level")) != null && value.equals(YES)) {
            String allLevelName = "All " + this.hierarchy.getName();
            if (!this.hierarchy.getProperty("all caption").equals("")) {
                allLevelName = (String)this.hierarchy.getProperty("all caption");
            }
            new AllLevel(allLevelName, (Hierarchy)this.hierarchy);
        }
    }

    public boolean isAllLevel() {
        return false;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public boolean isBottomLevel() {
        return this.index == this.hierarchy.getLevelCount() - 1;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = UniqueNameGenerator.appendUniqueName(this.hierarchy.getUniqueName(), this.getName());
        }
        return this.uniqueName;
    }

    @Override
    public IDimension getDimension() {
        return this.hierarchy.getDimension();
    }

    @Override
    public IHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public IMember getMember(String memberName) throws MetadataException {
        if (!this.hasGotAllMembers()) {
            this.getMembers();
        }
        this.rLock.lock();
        try {
            IMember iMember = this.getMemberNolocking(memberName);
            return iMember;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public int getMemberIndex(IMember m) throws MetadataException {
        if (!this.hasGotAllMembers()) {
            this.getMembers();
        }
        this.rLock.lock();
        try {
            int n = this.members.indexOf(m);
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected void setMembers(IOrderedMap<IMember> memb) {
        this.wLock.lock();
        try {
            this.members = memb;
        }
        finally {
            this.wLock.unlock();
        }
    }

    protected void addMeasures(IOrderedMap<IMember> measures) {
        if (this.members == null) {
            this.members = this.createOrderedMap();
        }
        this.wLock.lock();
        try {
            this.members.putAll(measures);
        }
        finally {
            this.wLock.unlock();
        }
    }

    public IOrderedMap<IMember> getMembersOrderedMap() {
        this.rLock.lock();
        try {
            IOrderedMap<IMember> iOrderedMap = this.members;
            return iOrderedMap;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public void clearMemberOrderedMap() {
        this.wLock.lock();
        try {
            this.members.clear();
        }
        finally {
            this.wLock.unlock();
        }
    }

    public int getMemberCount() {
        this.rLock.lock();
        try {
            int n = this.members.size();
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public void addMember(IMember m) {
        this.wLock.lock();
        try {
            if (this.getMember(m.getName(), ((IMemberCubics)m).getMemberId()) == null) {
                this.members.put(m);
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    public void removeMember(IMember m) {
        this.wLock.lock();
        try {
            this.members.remove(m);
        }
        finally {
            this.wLock.unlock();
        }
    }

    public IMember getMember(int indx) throws MetadataException {
        if (!this.hasGotAllMembers()) {
            this.getMembers();
        }
        this.rLock.lock();
        try {
            IMember iMember = this.members.get(indx);
            return iMember;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMember getMember(String name, long memberId) {
        boolean memFound = false;
        this.rLock.lock();
        try {
            IMemberCubics iMemberCubics;
            IMemberCubics mem = (IMemberCubics)this.members.get(name);
            if (mem != null) {
                if (mem.getMemberId() == memberId) {
                    memFound = true;
                } else {
                    List<IMember> duplicates = this.members.getDuplicates(name);
                    for (IMember duplicate : duplicates) {
                        mem = (IMemberCubics)duplicate;
                        if (mem.getMemberId() != memberId) continue;
                        memFound = true;
                        break;
                    }
                }
            }
            if (memFound) {
                iMemberCubics = mem;
                return iMemberCubics;
            }
            iMemberCubics = null;
            return iMemberCubics;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.LEVEL;
    }

    public void memberAddedNotification(IMember m) {
        if (this.hasGotAllMembers()) {
            this.addMember(m);
        }
    }

    public IMember createNotSpecifiedChild() throws MetadataException {
        try {
            if (!this.hasGotAllMembers()) {
                this.getMembers();
            }
        }
        catch (MetadataException e) {
            mErrorLogger.log(e);
        }
        SimpleMember child = new SimpleMember(this);
        this.addMember(child);
        return child;
    }

    @Override
    public ILevel getPreviousLevel() {
        ILevel result = null;
        if (this.index != 0) {
            result = this.hierarchy.getLevel(this.index - 1);
        }
        return result;
    }

    @Override
    public ILevel getNextLevel() {
        ILevel result = null;
        if (this.index < this.hierarchy.getLevelCount() - 1) {
            result = this.hierarchy.getLevel(this.index + 1);
        }
        return result;
    }

    @Override
    public boolean isLeafLevel() {
        return this.isBottomLevel();
    }

    @Override
    public boolean isRootLevel() {
        return this.getIndex() == 0;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int theCardinality) {
        this.cardinality = theCardinality;
    }

    @Override
    public List<IMember> getMembers(int startIndex, int count) {
        return this.getMembers().subList(startIndex, startIndex + count);
    }

    @Override
    public List<IMember> getMembers() throws MetadataException {
        return this.getMembers(false, false);
    }

    public IMember[] getAllMembers() {
        if (!this.hasGotAllMembers()) {
            if (this.loadMeasuresOnDemanding()) {
                ((LOLAPLevel)this).fetchReferencedMeasuresOnLevel();
            } else {
                this.initMembersOrderedMap();
            }
        }
        this.rLock.lock();
        try {
            IMember[] iMemberArray = (IMember[])this.members.toArray(new IMember[this.members.size()]);
            return iMemberArray;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public List<IMember> getMembers(boolean includeFillerMembers, boolean includeHiddenMembers) throws MetadataException {
        if (!this.hasGotAllMembers()) {
            if (this.loadMeasuresOnDemanding()) {
                ((LOLAPLevel)this).fetchReferencedMeasuresOnLevel();
            } else {
                this.initMembersOrderedMap();
            }
        }
        return this.copyMemberMap(includeFillerMembers, includeHiddenMembers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IMember> copyMemberMap(boolean includeFillerMembers, boolean includeHiddenMembers) {
        boolean mayContainFillers = this.getHierarchy().isRagged() || this.getHierarchy().isUnbalanced();
        this.rLock.lock();
        try {
            ArrayList<IMember> result = new ArrayList<IMember>(this.members.size());
            Iterator<IMember> it = this.members.iterator();
            if (!mayContainFillers || includeFillerMembers) {
                Object m;
                while (it.hasNext()) {
                    m = (IMemberCubics)it.next();
                    if (!includeHiddenMembers && m.isHidden()) continue;
                    result.add((IMember)m);
                }
                m = result;
                return m;
            }
            while (it.hasNext()) {
                IMemberCubics m = (IMemberCubics)it.next();
                if (m.isFillerMember() || !includeHiddenMembers && m.isHidden()) continue;
                result.add(m);
            }
            ArrayList<IMember> arrayList = result;
            return arrayList;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected List<IMember> getMembersWithSecurity(InterpreterContext ic, IROLAPSecurityManager secManager, ROLAPUserSecurityContext secContext, ILevel requestedLevel) {
        List<IMember> thisLevelMembers = new ArrayList<IMember>();
        ILevel previousLevel = this.getPreviousLevel();
        if (previousLevel == null) {
            thisLevelMembers.addAll(this.getMembers(false, false));
            thisLevelMembers = MemberOperations.applySecurityToMembers(thisLevelMembers, this.getHierarchy(), ic, secContext);
            return thisLevelMembers;
        }
        if (secManager == null || secManager.hasSecurityPaddingMembers(this)) {
            List<IMember> previousLevelMembers = ((Level)previousLevel).getMembersWithSecurity(ic, secManager, secContext, requestedLevel);
            for (IMember previousLevelMember : previousLevelMembers) {
                MemberOperations.getChildrenOp((IMemberCubics)previousLevelMember, false, true, null, true, secContext, thisLevelMembers);
            }
        } else {
            thisLevelMembers.addAll(this.getMembers(false, false));
        }
        if (this == requestedLevel) {
            thisLevelMembers = secManager instanceof SecManager ? ((SecManager)secManager).applySecurity(secContext, thisLevelMembers, this.getHierarchy(), this.getIndex()) : MemberOperations.applySecurityToMembers(thisLevelMembers, this.getHierarchy(), ic, secContext);
        } else {
            List<IMember> nextLevelUnfilteredMembers = ((Level)this.getNextLevel()).getMembers(false, false);
            double levelSizeRatio = (double)thisLevelMembers.size() / (double)nextLevelUnfilteredMembers.size();
            if (levelSizeRatio <= 0.5) {
                thisLevelMembers = secManager instanceof SecManager ? ((SecManager)secManager).applySecurity(secContext, thisLevelMembers, this.getHierarchy(), this.getIndex()) : MemberOperations.applySecurityToMembers(thisLevelMembers, this.getHierarchy(), ic, secContext);
            }
        }
        return thisLevelMembers;
    }

    public List<IMember> getMembersWithContext(InterpreterContext ic) {
        return this.getMembers();
    }

    protected void initMembersOrderedMap() {
        block6: {
            this.wLock.lock();
            try {
                if (this.gotAllMembers) break block6;
                try {
                    this.members = this.fetchMembers();
                }
                catch (ProviderException e) {
                    throw new MetadataException("X01508", new String[]{this.getDimension().getCube().getName(), this.getDimension().getName(), this.getName(), e.toString()}, e);
                }
                if (!(this instanceof DMRLevel) || ((DMRLevel)this).getRestrictionMembers().isEmpty()) {
                    this.gotAllMembers = true;
                }
            }
            finally {
                this.wLock.unlock();
            }
        }
    }

    protected IOrderedMap<IMember> fetchMembers() {
        IOrderedMap<IMember> result = this.members;
        int firstLevel = 0;
        String propValue = (String)this.hierarchy.getProperty("all level");
        if (propValue != null && propValue.equals(YES)) {
            ++firstLevel;
        }
        if (this.index == firstLevel) {
            result = ((Hierarchy)this.hierarchy).fetchFirstLevelMembers();
        } else {
            ILevel previousLevel = this.getPreviousLevel();
            List<IMember> lMems = ((Level)previousLevel).getMembers(true, false);
            CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
            ArrayList<IMember> allChildren = new ArrayList<IMember>();
            for (int i = 0; i < lMems.size(); ++i) {
                if (cancelManager != null && cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                IMember[] childrenMems = ((IMemberCubics)lMems.get(i)).getChildMembers(true);
                for (int j = 0; j < childrenMems.length; ++j) {
                    if (cancelManager != null && cancelManager.isRequestCancelled()) {
                        throw new OperationCanceledException();
                    }
                    allChildren.add(childrenMems[j]);
                }
            }
            result.putAll(allChildren);
        }
        return result;
    }

    protected void setDefaultProperties() {
        this.setProperty("description", "");
        this.setProperty("aggregate", "No");
    }

    public void initialise() {
        this.wLock.lock();
        try {
            this.setDefaultProperties();
        }
        finally {
            this.wLock.unlock();
        }
    }

    @Override
    public int compareTo(Object pObject) {
        int ret = -1;
        if (pObject instanceof Level) {
            if (this == pObject) {
                ret = 0;
            }
        } else if (pObject instanceof ILevel) {
            ret = this.getUniqueName().compareTo(((ILevel)pObject).getUniqueName());
        }
        return ret;
    }

    @Override
    public String getV5UniqueName() {
        if (null == this.getConnection()) {
            return null;
        }
        IDimension dimension = this.hierarchy.getDimension();
        return UniqueNameGenerator.createUniqueName(dimension.getCube().getName(), dimension.getName(), this.hierarchy.getName(), UniqueNameGenerator.cleanIdentifier(this.getName()));
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public double getOrderOfMagnitude() {
        return 0.0;
    }

    public void setIsUnique(boolean theUnique) {
        this.isUnique = theUnique;
    }

    @Override
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public ISortItem[] getSortItems() {
        return new ISortItem[0];
    }

    public void setXmdxTupleId(Integer xmdxTuleNodeId) {
        this.xmdxTupleId = xmdxTuleNodeId;
    }

    public Integer getXmdxTupleId() {
        return this.xmdxTupleId;
    }

    @Override
    public PushdownManager getPushdownManager() {
        this.readLock().lock();
        try {
            PushdownManager pushdownManager = this.mPushdownManager;
            return pushdownManager;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public void setPushdownManager(PushdownManager pushdownManager) {
        this.writeLock().lock();
        try {
            this.mPushdownManager = pushdownManager;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    public void resetPushdownManager() {
        this.writeLock().lock();
        try {
            this.mPushdownManager = null;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    public boolean getPushDownMode() {
        this.readLock().lock();
        try {
            boolean bl = this.mPushdownManager != null && this.mPushdownManager.isEnabled();
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public IPushdownAdapter getPushdownAdapter() {
        return new DMRPushdownAdapter();
    }

    public IMember getMemberNolocking(String memberName) throws MetadataException {
        String[] parts = UniqueNameParser.parseNoThrow(memberName);
        if (parts != null && parts.length > 0) {
            return this.members.get(parts[parts.length - 1]);
        }
        return this.members.get(memberName);
    }

    protected IOrderedMap<IMember> createOrderedMap() {
        return new OrderedMap<IMember>();
    }
}

