/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.olap.SecuredOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelAttributeWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.XRelationalCrosstab;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRHierarchy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMetadataProvider;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryOptimizationInfo;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategyPreCellLoading;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.RelationalCrosstabCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.PreLoadDMRCubeUtil;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.PreciseCubeLoadInfo;
import com.cognos.xqe.runtree.olap.mdx.metadata.Catalog;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.CubeReuseLogger;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.AbstractCubeManager;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContext;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContextKey;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.DimensionCacheManager;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.SecurityContext;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanKey;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanResult;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.SetOfTables;
import com.cognos.xqe.util.FileHandler;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.eviction.ConcurrentSimpleDLinkLRUMap;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqe.util.xml.XMLWriter;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class CubeContextManager
extends AbstractCubeManager<CubeContextKey, CubeContext> {
    private static final int PREPLAN_CACHE_SIZE = 300;
    private static final int PREPLAN_RESULT_LIMIT = 5;
    private static final long FIVE_MINUTE = 300000L;
    protected final Lock readLock;
    protected final Lock writeLock;
    private AtomicInteger uniqueKey = new AtomicInteger(0);
    protected final ConcurrentSimpleDLinkLRUMap<PrePlanKey, ArrayList<PrePlanResult>> prePlanCache = new ConcurrentSimpleDLinkLRUMap(300);
    protected final ConcurrentSimpleDLinkLRUMap<String, Pair> modelModifyCache = new ConcurrentSimpleDLinkLRUMap(300);
    private IUsageIndicator preplanCacheHits = null;
    private IUsageIndicator preplanCacheMisses = null;
    protected static SingletonHelper<CubeContextManager> singletonHelper = new SingletonHelper<CubeContextManager>(){

        @Override
        protected CubeContextManager newInstance() {
            return new CubeContextManager();
        }

        @Override
        protected void initializeImpl(CubeContextManager theInstance) {
        }

        @Override
        protected void releaseImpl(CubeContextManager theInstance) {
            theInstance.release();
        }
    };

    public CubeContextManager() {
        ReentrantReadWriteLock reRwLock = new ReentrantReadWriteLock();
        this.readLock = reRwLock.readLock();
        this.writeLock = reRwLock.writeLock();
        this.preplanCacheHits = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.DMRPREPLAN, "cacheHits");
        this.preplanCacheMisses = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.DMRPREPLAN, "cacheMisses");
    }

    public Cube getCube(CubeWrapper cubeWrapper, CubeContextKey key, SecuredOLAPMetadataProvider securedMetadataProvider, boolean memberStorageEnabled, ExecutionEnvironment execEnvironment) {
        CubeContext cubeContext = this.getCubeContext(key, securedMetadataProvider, memberStorageEnabled);
        if (cubeContext == null) {
            return null;
        }
        return cubeContext.buildDMRCube(cubeWrapper, execEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cube getCube(IDataSource dataSource, ExecutionEnvironment exeEnvironment, ICube modelCube, String additionalContext, XMdxLocal xmdxLocal) {
        MDXLevelInfo levelInfo = xmdxLocal.getLevelInfoProperty();
        List<IMeasure> cubeMeasures = xmdxLocal.getMDXQuery().getInvolvedMeasuresAndMeasuresFactDrivenCustomValue();
        Map<IXQEQueryNode, MDXLevelInfo> aggregationLevelInfo = xmdxLocal.getMDXQuery().getReportSummaryAggregationLevelInfo();
        DMRQueryOptimizationInfo optimizationInfo = xmdxLocal.getMDXQuery().getOptimizationInfo();
        DMRCube cube = null;
        String passport = ((RequestEnvironment)exeEnvironment.getRequestEnvironment()).getCAMPassport();
        BIBusEnvelope envelope = ((RequestEnvironment)exeEnvironment.getRequestEnvironment()).getRequestEnvelope();
        ArrayList<PreciseCubeLoadInfo> preciseLoadInfo = new ArrayList<PreciseCubeLoadInfo>();
        DMRQueryStrategyPreCellLoading.LoadType[] loadType = new DMRQueryStrategyPreCellLoading.LoadType[]{null};
        if (xmdxLocal.isDMR() && this.setSingleQueryLoadingForTemporaryDMRCube(modelCube, xmdxLocal, preciseLoadInfo, loadType) || !xmdxLocal.isDMR() || !xmdxLocal.isDMRCubeReuseEnabled() || this.getModelModificationTime(modelCube.getConnection(), passport, envelope) == -1L || this.isExecuteForValidate(xmdxLocal)) {
            Catalog catalog = new Catalog(modelCube.getConnection().getModelName());
            if (xmdxLocal.getParent().getType() == 501088) {
                cube = ((XRelationalCrosstab)xmdxLocal.getParent()).getCube(exeEnvironment, catalog, modelCube, xmdxLocal);
                if (cube == null) {
                    cube = new RelationalCrosstabCube(catalog, modelCube, null);
                }
            } else {
                DimensionCacheManager dimCache = ((CubeWrapper)modelCube).getDimensionContextManager();
                cube = dimCache != null && !this.isExecuteForValidate(xmdxLocal) && !((CubeWrapper)modelCube).getSingleQueryLoading() ? new DMRCube(catalog, dimCache, modelCube, exeEnvironment) : new DMRCube(catalog, modelCube, null);
                cube.setExecuteForValidate(this.isExecuteForValidate(xmdxLocal));
            }
            ((CubeWrapper)modelCube).setDimensionContextManager(null);
            cube.setAggregationLevelInfo(aggregationLevelInfo);
            cube.setMeasureInfo(cubeMeasures);
            cube.setMDXQueryInfo(levelInfo);
            cube.setOptimizationInfo(optimizationInfo);
            cube.setQueryListReport(xmdxLocal.isListReport());
            cube.setDatasourceType(dataSource.getType());
            cube.setLevelCountThreshold(this.getLevelCountThreshold(dataSource, cube));
            cube.setRestrictionMembersCountThreshold(this.getRestrictionMembersCountThreshold(dataSource, cube));
            cube.setReusableCube(false);
            cube.setIncrementalMemberLoadingFromSetting(dataSource);
            cube.setMaxMembersInSubQueryDetailFilter(CubeContextManager.getMaxMembersInSubQueryDetailFilter(dataSource));
            cube.setDecomposeCalculatedMeasure(CubeContextManager.getDecomposeCalculatedMeasure(dataSource));
            if (xmdxLocal.isDMR()) {
                cube.setLevelPropertiesLoadedWithMembers(this.collectLevelPropertiesLoadedWithMembers(xmdxLocal, cube));
                cube.setProjectedLevelProperties(this.collectProjectedLevelProperties(xmdxLocal, cube));
                if (!((CubeWrapper)modelCube).getSingleQueryLoading()) {
                    if (PreLoadDMRCubeUtil.checkEmbeddedFilterInRegularDimension((CubeWrapper)modelCube)) {
                        cube.setPreLoadCellCountThreshold(this.getPreLoadCellCountThreshold(dataSource, xmdxLocal, modelCube));
                        cube.setLoadingTypeAfterPreLoading(loadType[0]);
                    }
                } else if (!preciseLoadInfo.isEmpty()) {
                    cube.setPreciseLoadInfo(preciseLoadInfo);
                    cube.setLoadingTypeAfterPreLoading(loadType[0]);
                }
            }
            return cube;
        }
        String localeStr = LocaleConverter.localeToStr(((RequestEnvironment)exeEnvironment.getRequestEnvironment()).getRunLocale());
        MetadataConnection connection = modelCube.getConnection();
        ArrayList<IDataSource> ds = new ArrayList<IDataSource>();
        ds.addAll(exeEnvironment.getDataSources());
        SecurityContext securityContext = new SecurityContext((RequestEnvironment)exeEnvironment.getRequestEnvironment(), connection, ds, exeEnvironment.getGovernors());
        MemberStorage.MemberStorageIdentifier memberProviderMRCKey = this.getMemberProviderMRCKey(modelCube, localeStr, securityContext);
        SecuredOLAPMetadataProvider securedMetadataProvider = exeEnvironment.getMultiRequestContext().getSecuredOLAPMetadataProvider(memberProviderMRCKey);
        boolean memberStorageEnabled = this.isMemberStorageEnabled(dataSource);
        if (securedMetadataProvider == null && memberStorageEnabled) {
            DMRMetadataProvider metadataProvider = new DMRMetadataProvider();
            securedMetadataProvider = new SecuredOLAPMetadataProvider(metadataProvider, dataSource, "");
            securedMetadataProvider.initSAL(modelCube, localeStr, securityContext);
            exeEnvironment.getMultiRequestContext().setSecuredOLAPMetadataProvider(memberProviderMRCKey, securedMetadataProvider);
        }
        String memberStorageTS = "";
        DMRMemberStorage requestContextMemberStorage = null;
        if (memberStorageEnabled) {
            requestContextMemberStorage = (DMRMemberStorage)securedMetadataProvider.getSAL().getMemberStorage();
            memberStorageTS = requestContextMemberStorage.toString();
        }
        CubeContextKey cubeContextKey = new CubeContextKey((CubeWrapper)modelCube, securityContext, memberStorageTS, localeStr, this.getModelModificationTime(connection, passport, envelope), ((RequestEnvironment)exeEnvironment.getRequestEnvironment()).getResolvedMacros());
        CubeContext cubeContext = this.getCubeContext(cubeContextKey, securedMetadataProvider, memberStorageEnabled);
        int dmrResultSetCacheSize = CubeContextManager.getResultSetCacheSize(dataSource);
        if (cubeContext == null) {
            this.writeLock.lock();
            try {
                SoftReference softRef = (SoftReference)this.cubeMap.get(cubeContextKey);
                if (softRef != null && null != (cubeContext = (CubeContext)softRef.get()) && memberStorageEnabled && CubeContextManager.isDMRMemberStorageDifferent(securedMetadataProvider, cubeContext)) {
                    cubeContext = null;
                }
                if (cubeContext == null) {
                    cubeContext = new CubeContext(cubeContextKey, requestContextMemberStorage, dmrResultSetCacheSize, this.uniqueKey.getAndIncrement());
                    this.addContext(cubeContextKey, cubeContext);
                    CubeReuseLogger.getLogger().createCubeContext(cubeContextKey.toString());
                }
                CubeReuseLogger.getLogger().reuseCubeContext(cubeContextKey.toString());
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            CubeReuseLogger.getLogger().reuseCubeContext(cubeContextKey.toString());
        }
        cube = cubeContext.buildDMRCube((CubeWrapper)modelCube, exeEnvironment);
        cube.setAggregationLevelInfo(aggregationLevelInfo);
        cube.setMeasureInfo(cubeMeasures);
        cube.setMDXQueryInfo(levelInfo);
        cube.setOptimizationInfo(optimizationInfo);
        cube.setQueryListReport(xmdxLocal.isListReport());
        cube.setDatasourceType(dataSource.getType());
        cube.setLevelPropertiesLoadedWithMembers(this.collectLevelPropertiesLoadedWithMembers(xmdxLocal, cube));
        cube.setReusableCube(true);
        cube.setLevelCountThreshold(this.getLevelCountThreshold(dataSource, cube));
        cube.setRestrictionMembersCountThreshold(this.getRestrictionMembersCountThreshold(dataSource, cube));
        cube.setIncrementalMemberLoadingFromSetting(dataSource);
        cube.setResultSetCacheEnabled(dmrResultSetCacheSize > 0);
        cube.setBlockingFetchingSameCells(this.isBlockingFetchingSameCellsEnabled(dataSource));
        cube.setBlockingSameMDXExecution(this.isBlockingSameMDXExecutionEnabled(dataSource));
        cube.setMaxMembersInSubQueryDetailFilter(CubeContextManager.getMaxMembersInSubQueryDetailFilter(dataSource));
        cube.setDecomposeCalculatedMeasure(CubeContextManager.getDecomposeCalculatedMeasure(dataSource));
        return cube;
    }

    protected boolean setSingleQueryLoadingForTemporaryDMRCube(ICube modelCube, XMdxLocal mdxLocal, List<PreciseCubeLoadInfo> preciseLoadInfo, DMRQueryStrategyPreCellLoading.LoadType[] rtLoadType) {
        boolean usesBridge = CubeContextManager.isBridgeQuery((CubeWrapper)modelCube);
        if (PreLoadDMRCubeUtil.useSingleTabularQueryForTemporaryDMRCube(modelCube, mdxLocal, usesBridge, preciseLoadInfo, rtLoadType)) {
            ((CubeWrapper)modelCube).setSingleQueryLoading(Boolean.TRUE);
            return true;
        }
        if (usesBridge) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_NonSupportedDMROverBridgeQuery, mdxLocal.getMDXQuery().getRefQueryProperty());
        }
        return false;
    }

    private static boolean isBridgeQuery(CubeWrapper cubeWrapper) {
        RQPPrePlan prePlan = cubeWrapper.getRQPPrePlanQuery();
        if (prePlan != null) {
            return PrePlanUtilities.isBridgeQuery(prePlan);
        }
        return false;
    }

    private MemberStorage.MemberStorageIdentifier getMemberProviderMRCKey(ICube modelCube, String localeStr, SecurityContext securityContext) {
        String modelPath = modelCube.getConnection().getModelPath();
        DMRMemberStorage.DMRMemberStorageIdentifier memberProviderMRCKey = new DMRMemberStorage.DMRMemberStorageIdentifier(modelPath, localeStr, ((CubeWrapper)modelCube).getModelDatasources(), securityContext);
        return memberProviderMRCKey;
    }

    private Map<IMetadata, List<String>> collectProjectedLevelProperties(XMdxLocal xmdxLocal, DMRCube cube) {
        MDXQuery mdxQuery = xmdxLocal.getMDXQuery();
        if (mdxQuery == null) {
            return null;
        }
        List<IQueryItem> items = mdxQuery.getInvolvedLevelPropertyQueryItems();
        if (items.isEmpty()) {
            return null;
        }
        HashMap<IMetadata, List<String>> rt = new HashMap<IMetadata, List<String>>();
        for (IQueryItem item : items) {
            String propName;
            DMRLevel dmrLevel;
            ILevel level = item.getLevel();
            if (level == null || (dmrLevel = (DMRLevel)cube.getWrapper(level)) == null) continue;
            List<Object> propList = null;
            if (rt.containsKey(dmrLevel)) {
                propList = rt.get(dmrLevel);
            } else {
                propList = new ArrayList();
                rt.put(dmrLevel, propList);
            }
            if (propList.contains(propName = item.getName())) continue;
            propList.add(propName);
        }
        if (rt.isEmpty()) {
            return null;
        }
        return rt;
    }

    private Map<IMetadata, List<String>> collectLevelPropertiesLoadedWithMembers(XMdxLocal xmdxLocal, DMRCube cube) {
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
        boolean bForceLoadPropertyWithMember = providerCapabilities.getBooleanValue("loadLevelPropertyWithMember", false);
        MDXQuery mdxQuery = xmdxLocal.getMDXQuery();
        if (mdxQuery == null) {
            return null;
        }
        List<IQueryItem> items = mdxQuery.getInvolvedLevelPropertyQueryItems();
        if (items.isEmpty()) {
            return null;
        }
        HashMap<IMetadata, List<String>> rt = new HashMap<IMetadata, List<String>>();
        for (IQueryItem item : items) {
            String propName;
            String captionExpr;
            String businessKeyExpr;
            DMRLevel dmrLevel;
            ILevel level;
            if (item instanceof LevelWrapper.DynamicPropertyWrapper || (level = item.getLevel()) == null || (dmrLevel = (DMRLevel)cube.getWrapper(level)) == null) continue;
            if (item instanceof V5DataItemToLevelAttributeWrapper) {
                String propName2;
                List<Object> propList = null;
                if (rt.containsKey(dmrLevel)) {
                    propList = rt.get(dmrLevel);
                } else {
                    propList = new ArrayList();
                    rt.put(dmrLevel, propList);
                }
                if (propList.contains(propName2 = item.getName())) continue;
                propList.add(propName2);
                continue;
            }
            String propExpr = item.getExpression();
            if (propExpr == null) {
                propExpr = (String)item.getProperty("ID");
            }
            if ((propExpr = MetadataUtil.extractExpressionFromModelString(propExpr)).equals(businessKeyExpr = dmrLevel.getQueryItemExpressionForKey()) || propExpr.equals(captionExpr = dmrLevel.getQueryItemExpressionForCaption())) continue;
            boolean bLoadWithMember = bForceLoadPropertyWithMember;
            if (!bLoadWithMember) {
                IQueryItem keyItem = dmrLevel.getBusinessKeyQueryItem();
                SetOfTables tabKey = dmrLevel.getInvolvedTablesForItem(keyItem.getV5UniqueName());
                SetOfTables tabProp = dmrLevel.getInvolvedTablesForItem(item.getV5UniqueName());
                if (tabKey.size() != 0 && tabProp.size() != 0) {
                    bLoadWithMember = tabKey.equals(tabProp);
                }
            }
            if (!bLoadWithMember) continue;
            List<Object> propList = null;
            if (rt.containsKey(dmrLevel)) {
                propList = rt.get(dmrLevel);
            } else {
                propList = new ArrayList();
                rt.put(dmrLevel, propList);
            }
            if (propList.contains(propName = item.getName())) continue;
            propList.add(propName);
        }
        if (rt.isEmpty()) {
            return null;
        }
        return rt;
    }

    private void addContext(CubeContextKey key, CubeContext cubeContext) {
        this.cubeMap.put(key, new SoftReference<CubeContext>(cubeContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CubeContext getCubeContext(CubeContextKey key, SecuredOLAPMetadataProvider securedMetadataProvider, boolean memberStorageEnabled) {
        this.readLock.lock();
        CubeContext cubeContext = null;
        try {
            SoftReference softRef = (SoftReference)this.cubeMap.get(key);
            if (softRef != null) {
                cubeContext = (CubeContext)softRef.get();
            }
            if (null != cubeContext && memberStorageEnabled && CubeContextManager.isDMRMemberStorageDifferent(securedMetadataProvider, cubeContext)) {
                cubeContext = null;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (cubeContext != null) {
            if (cubeContext.getModelModificationTime() != key.getModelModificationTime()) {
                cubeContext.close();
                this.writeLock.lock();
                try {
                    this.cubeMap.remove(key);
                }
                finally {
                    this.writeLock.unlock();
                }
                return null;
            }
            this.writeLock.lock();
            try {
                cubeContext.updateCubeContextKey(key);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return cubeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void release() {
        this.writeLock.lock();
        try {
            for (SoftReference reference : this.cubeMap.values()) {
                CubeContext context;
                if (reference == null || (context = (CubeContext)reference.get()) == null) continue;
                context.close();
            }
            this.cubeMap.clear();
            this.prePlanCache.clear();
            this.modelModifyCache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
        this.errorLogger.close();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    public static CubeContextManager getCubeContextManager() {
        return singletonHelper.getInstance();
    }

    private boolean isMemberStorageEnabled(IDataSource dataSource) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        return capabilities.isSupported("enableDMRmemberStorage");
    }

    private boolean isBlockingFetchingSameCellsEnabled(IDataSource dataSource) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        return capabilities.isSupported("blockingFetchingSameCells");
    }

    private boolean isBlockingSameMDXExecutionEnabled(IDataSource dataSource) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        return capabilities.isSupported("blockingSameMDXExecution");
    }

    private int getRestrictionMembersCountThreshold(IDataSource dataSource, DMRCube cube) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        int levelMemberCountThreshold = capabilities.getIntegerValue("restrictionMembersCountThreshold", cube.getDefaultRestrictionMembersCountThreshold());
        return levelMemberCountThreshold;
    }

    public static int getResultSetCacheSize(IDataSource dataSource) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        int dmrResultSetCacheSize = capabilities.getIntegerValue("dmrResultSetCacheSize", 0);
        return dmrResultSetCacheSize;
    }

    private int getLevelCountThreshold(IDataSource dataSource, DMRCube cube) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        int levelThreshold = capabilities.getIntegerValue("dmrNumberOfLevelsToIncludeInMultipleLevelFetch", cube.getDefaultCubeLevelThreshold());
        return levelThreshold;
    }

    private static int getMaxMembersInSubQueryDetailFilter(IDataSource dataSource) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        return capabilities.getIntegerValue("maxMembersInSubQueryDetailFilter", 2000);
    }

    private static boolean getDecomposeCalculatedMeasure(IDataSource dataSource) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        return capabilities.getBooleanValue("decomposeDMRCalculatedMeasure", false);
    }

    private int getPreLoadCellCountThreshold(IDataSource dataSource, XMdxLocal xmdxLocal, ICube modelCube) {
        return DMRQueryStrategyPreCellLoading.getPreLoadCellCountThreshold(dataSource, xmdxLocal, modelCube);
    }

    private static boolean isDMRMemberStorageDifferent(SecuredOLAPMetadataProvider securedMetadataProvider, CubeContext dmrCubeContext) {
        MemberStorage cubeMemberStorage;
        boolean result = false;
        MemberStorage requestContextMemberStorage = securedMetadataProvider.getSAL().getMemberStorage();
        if (!requestContextMemberStorage.equals(cubeMemberStorage = dmrCubeContext.getMemberStorage())) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberStorageCubes(MemberStorage memberStorage) {
        this.writeLock.lock();
        try {
            ArrayList entriesToRemove = new ArrayList();
            for (Map.Entry entry : this.cubeMap.entrySet()) {
                CubeContext cubeContext;
                SoftReference cubeRef = (SoftReference)entry.getValue();
                if (cubeRef == null || (cubeContext = (CubeContext)cubeRef.get()) == null || !cubeContext.getMemberStorage().equals(memberStorage)) continue;
                try {
                    cubeContext.close();
                    entriesToRemove.add(entry.getKey());
                }
                catch (Throwable e) {
                    this.errorLogger.log("Unable to close DMR cube context.", e);
                }
            }
            for (CubeContextKey cubeMapKey : entriesToRemove) {
                this.cubeMap.remove(cubeMapKey);
            }
            this.prePlanCache.clear();
            this.modelModifyCache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getModelModificationTime(MetadataConnection connection, String passport, BIBusEnvelope envelope) {
        Pair p;
        String key = connection.getModelName();
        if (key == null) {
            key = connection.toString();
        }
        if ((p = (Pair)this.modelModifyCache.get(key)) == null || System.currentTimeMillis() - (Long)p.getFirst() > 300000L) {
            p = new Pair(new Long(System.currentTimeMillis()), new Long(connection.getModelModificationTime(passport, envelope)));
            this.modelModifyCache.put(key, p);
        }
        return (Long)p.getSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrePlanResult getOrCreatePrePlanResult(IPlanningEnvironment env, PrePlanKey key) {
        ArrayList<PrePlanResult> r = new ArrayList<PrePlanResult>();
        ArrayList pre = this.prePlanCache.putIfAbsent(key, r);
        if (pre != null) {
            r = pre;
        }
        ArrayList<PrePlanResult> arrayList = r;
        synchronized (arrayList) {
            for (PrePlanResult ppr : r) {
                if (ppr.getState() != PrePlanResult.PrePlanResultState.PREPLAN_STATE_CACHED || !MacroExpander.macrosResolveToSameValues(ppr.getMacros(), env)) continue;
                this.incrementPreplanCacheHits();
                return ppr;
            }
            for (PrePlanResult ppr : r) {
                PrePlanResult.PrePlanResultState state = ppr.getState();
                if (state == PrePlanResult.PrePlanResultState.PREPLAN_STATE_PLANNING_INPROGRESS || state == PrePlanResult.PrePlanResultState.PREPLAN_STATE_UNINITIALIZED) {
                    return ppr;
                }
                if (state != PrePlanResult.PrePlanResultState.PREPLAN_STATE_INVALID) continue;
                this.incrementPreplanCacheMisses();
                return ppr;
            }
            if (r.size() == 5) {
                r.remove(0);
            }
            PrePlanResult ppr = new PrePlanResult();
            r.add(ppr);
            this.incrementPreplanCacheMisses();
            return ppr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpCachedCubes(String filename) {
        this.readLock.lock();
        try {
            XMLWriter xmlWriter = FileHandler.createOrAppendXMLWriterToFile(filename);
            xmlWriter.beginElement("cubes", -1);
            for (Map.Entry entry : this.cubeMap.entrySet()) {
                CubeContext cubeContext;
                SoftReference cubeRef = (SoftReference)entry.getValue();
                if (cubeRef == null || (cubeContext = (CubeContext)cubeRef.get()) == null) continue;
                xmlWriter.beginElement("cube", -1);
                xmlWriter.attribute("name", cubeContext.getKey().getModelPath());
                List<IHierarchy> hiers = cubeContext.getHierarchies(false);
                for (IHierarchy h : hiers) {
                    ((DMRHierarchy)h).dumpMembers(xmlWriter);
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
            xmlWriter.flush();
            xmlWriter.close();
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected boolean isExecuteForValidate(XMdxLocal xmdxLocal) {
        return xmdxLocal.isDMR() && xmdxLocal.getExecuteForValidate();
    }

    public void incrementPreplanCacheMisses() {
        this.preplanCacheMisses.increment();
    }

    public void incrementPreplanCacheHits() {
        this.preplanCacheHits.increment();
    }
}

