/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStorage;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContextKey;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.DimensionContext;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.SecurityContext;
import com.cognos.xqe.util.eviction.ConcurrentSimpleDLinkLRUMap;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class DimensionCacheManager {
    protected volatile ConcurrentSimpleDLinkLRUMap<CubeContextKey, SoftReference<DimensionContext>> cache;
    private final AtomicBoolean bInitialized = new AtomicBoolean(false);
    private AtomicInteger uniqueKey = new AtomicInteger(Integer.MIN_VALUE);
    protected volatile DMRMemberStorage localStorage = null;

    public synchronized void initialize(int nDims, boolean useLocalMemberStorage, String localeStr, CubeWrapper modelCube, PlanningEnvironment environment) {
        if (this.bInitialized.get()) {
            return;
        }
        this.bInitialized.set(true);
        this.cache = new ConcurrentSimpleDLinkLRUMap(nDims);
        if (useLocalMemberStorage) {
            String modelId = "";
            String packageName = "";
            if (modelCube != null) {
                MetadataConnection conn = modelCube.getConnection();
                modelId = conn.getModelPath();
                if (modelId == null) {
                    modelId = "";
                }
                if ((packageName = conn.getPackageName()) == null) {
                    packageName = "";
                }
            }
            ArrayList<IDataSource> ds = new ArrayList<IDataSource>();
            ds.addAll(((ExecutionEnvironment)environment.getExecutionEnvironment()).getDataSources());
            SecurityContext securityContext = new SecurityContext((RequestEnvironment)environment.getRequestEnvironment(), modelCube.getConnection(), ds, modelCube.getGovernors());
            this.localStorage = new DMRMemberStorage(modelCube.getModelDatasources(), localeStr, modelId, packageName, securityContext);
        }
    }

    public void registerDimension(CubeWrapper modelCube, IDimension dim, int dmrResultSetCacheSize, ExecutionEnvironment execEnvironment) {
        String v5UName = dim.getV5UniqueName();
        CubeContextKey key = new CubeContextKey(v5UName, false, null, "", "", 0L);
        if (this.cache.containsKey(key)) {
            return;
        }
        DimensionContext context = new DimensionContext(key, this.localStorage, dmrResultSetCacheSize, this.uniqueKey.getAndIncrement());
        this.cache.put(key, new SoftReference<DimensionContext>(context));
        context.buildDMRCube(modelCube, dim, execEnvironment);
    }

    public DMRDimension getDimension(DMRCube cube, IDimension dim, ExecutionEnvironment execEnvironment) {
        String v5UName = dim.getV5UniqueName();
        CubeContextKey key = new CubeContextKey(v5UName, false, null, "", "", 0L);
        if (!this.cache.containsKey(key)) {
            return null;
        }
        DimensionContext context = null;
        SoftReference softRef = (SoftReference)this.cache.get(key);
        if (softRef != null && (context = (DimensionContext)softRef.get()) != null) {
            return context.getDimension(cube, dim, execEnvironment);
        }
        return null;
    }
}

