/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache;

import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.bibushandler.Commands;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnectionCommandBlock;
import com.cognos.xqe.bibushandler.datasource.UsernamePasswordSignon;
import com.cognos.xqe.data.model.AmbiguousConnectionException;
import com.cognos.xqe.data.model.AmbiguousSignonException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionCommandBlock;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class SecurityContext {
    private String securityContextId = "";
    private String userAccount = "";
    private boolean couldReuse = true;
    private Set<DatasourceSecurityObject> datasourceSecurityObjects;
    private String camPassport = "";
    private static final int NUMBER_31 = 31;

    public SecurityContext(RequestEnvironment reqEnv, MetadataConnection connection, List<IDataSource> datasources, Governors governors) {
        this.databaseAccessSecurity(reqEnv, datasources, governors);
        Governors.CachePolicyModelSecurity cachePolicyModelSecurity = Governors.CachePolicyModelSecurity.AUTOMATIC;
        if (governors != null) {
            cachePolicyModelSecurity = governors.getCachePolicyModelSecurity();
        }
        this.modelObjectSecurity(reqEnv, connection, cachePolicyModelSecurity);
    }

    private void databaseAccessSecurity(RequestEnvironment reqEnv, List<IDataSource> datasources, Governors governors) {
        if (governors == null || governors.getCachePolicyDBAccess() != Governors.CachePolicyDBAccess.NONE) {
            this.datasourceSecurityObjects = new HashSet<DatasourceSecurityObject>();
            for (IDataSource ds : datasources) {
                String cmDatasourceName;
                if (!ds.isRelational() || MacroExpander.isMacro(cmDatasourceName = ds.getCMDataSourceName())) continue;
                String connString = null;
                try {
                    connString = ds.getDataSourceConnection().getConnectionString();
                }
                catch (XQERuntimeException e) {
                    continue;
                }
                if (!connString.contains("URL=jdbc:") && !DataSourceTypeEnum.isFlint(ds.getType()) && !DataSourceTypeEnum.isColumnar(ds.getType())) continue;
                this.datasourceSecurityObjects.add(new DatasourceSecurityObject(ds, reqEnv.getRunLocale(), governors));
            }
        }
    }

    private void modelObjectSecurity(RequestEnvironment reqEnv, MetadataConnection connection, Governors.CachePolicyModelSecurity cachePolicyModelSecurity) {
        switch (cachePolicyModelSecurity) {
            case NONE: {
                return;
            }
            case USER: {
                this.securityContextId = this.getModelSecurityContextUser(reqEnv, connection);
                break;
            }
            case USERCLASS: {
                this.securityContextId = this.getModelSecurityContextUserClass(reqEnv, connection);
                break;
            }
            case AUTOMATIC: {
                this.securityContextId = this.getAutomaticSecurityContext(reqEnv, connection);
            }
        }
    }

    private String getModelSecurityContextUser(RequestEnvironment reqEnv, MetadataConnection connection) {
        this.getUserGroupsAndAccount(reqEnv);
        return this.userAccount;
    }

    private String getModelSecurityContextUserClass(RequestEnvironment reqEnv, MetadataConnection connection) {
        StringBuilder buffer = new StringBuilder();
        for (ICMSessionIdentity obj : this.getUserGroupsAndAccount(reqEnv)) {
            buffer.append(obj.getIdentity());
            buffer.append(";");
        }
        return buffer.toString();
    }

    private String getAutomaticSecurityContext(RequestEnvironment reqEnv, MetadataConnection connection) {
        boolean found = false;
        for (String string : connection.getModelDataSecurityObjects(reqEnv)) {
            found = false;
            for (ICMSessionIdentity id : this.getUserGroupsAndAccount(reqEnv)) {
                if (!id.getIdentity().equals(string)) continue;
                found = true;
                break;
            }
            if (found) continue;
            break;
        }
        if (!found) {
            if (connection.getModelDataSecurityObjects(reqEnv).size() > 0) {
                return this.userAccount;
            }
            return "";
        }
        HashSet<String> searchPaths = new HashSet<String>();
        for (String securityObject : connection.getModelDataSecurityObjects(reqEnv)) {
            searchPaths.add(securityObject);
        }
        Object[] objectArray = new String[searchPaths.size()];
        searchPaths.toArray(objectArray);
        Arrays.sort(objectArray);
        StringBuilder sb = new StringBuilder();
        for (Object searchPath : objectArray) {
            sb.append((String)searchPath);
            sb.append("_");
        }
        return sb.toString();
    }

    public String toString() {
        if (this.securityContextId == null) {
            return "";
        }
        return this.securityContextId.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityContext)) {
            return false;
        }
        SecurityContext other = (SecurityContext)o;
        if (other.camPassport != null && !other.camPassport.equals(this.camPassport)) {
            return false;
        }
        if (!this.couldReuse || !other.couldReuse) {
            return false;
        }
        if (!other.securityContextId.equals(this.securityContextId)) {
            return false;
        }
        if (this.datasourceSecurityObjects == null) {
            return other.datasourceSecurityObjects == null || other.datasourceSecurityObjects.isEmpty();
        }
        if (other.datasourceSecurityObjects == null) {
            return this.datasourceSecurityObjects == null || this.datasourceSecurityObjects.isEmpty();
        }
        return this.datasourceSecurityObjects.equals(other.datasourceSecurityObjects);
    }

    public int hashCode() {
        if (this.securityContextId == null) {
            return 31;
        }
        int hash = 1;
        hash = hash * 31 + this.securityContextId.hashCode();
        if (this.datasourceSecurityObjects != null) {
            for (DatasourceSecurityObject dso : this.datasourceSecurityObjects) {
                hash = hash * 31 + dso.hashCode();
            }
        }
        return hash;
    }

    private List<ICMSessionIdentity> getUserGroupsAndAccount(RequestEnvironment requestEnv) {
        this.userAccount = null;
        List<ICMSessionIdentity> identities = ContentManager.getIdentitiesList(requestEnv);
        ArrayList<ICMSessionIdentity> filteredIdentities = null;
        for (int i = 0; i < identities.size(); ++i) {
            ICMSessionIdentity identity = identities.get(i);
            if (identity.getType().equals("account")) {
                if (this.userAccount != null) continue;
                this.userAccount = identity.getIdentity();
            }
            if (!identity.getType().equals("group") && !identity.getType().equals("role")) continue;
            if (filteredIdentities == null) {
                filteredIdentities = new ArrayList<ICMSessionIdentity>();
            }
            filteredIdentities.add(identity);
        }
        if (this.userAccount == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Could not find user account");
        }
        return filteredIdentities;
    }

    public void setCamPassport(String passport) {
        this.camPassport = passport;
    }

    private class DatasourceSecurityObject {
        String datasourceType = "";
        String datasourceName = "";
        String catalog = "";
        String schema = "";
        String connectionString = "";
        IDataSourceConnectionSignon signon = null;
        DataSourceConnectionCommandBlock[] commandBlocks;

        DatasourceSecurityObject(IDataSource dataSource, Locale contentLocale, Governors governors) {
            IDataSourceConnection dataSourceConnection = null;
            try {
                String sch;
                if (dataSource.getType() != null) {
                    this.datasourceType = dataSource.getType();
                }
                this.datasourceName = dataSource.getCMDataSourceName();
                String cat = (String)dataSource.getMetadataProperties().get("catalog");
                if (cat != null) {
                    this.catalog = cat;
                }
                if ((sch = (String)dataSource.getMetadataProperties().get("schema")) != null) {
                    this.schema = sch;
                }
                if (null != (dataSourceConnection = dataSource.getDataSourceConnection()) && (governors == null || governors.getCachePolicyDBAccess() == Governors.CachePolicyDBAccess.DB_CONNECTION_SIGNON) || governors.getCachePolicyDBAccess() == Governors.CachePolicyDBAccess.DB_CONNECTION) {
                    this.connectionString = dataSourceConnection.getConnectionString(null);
                }
            }
            catch (AmbiguousConnectionException e) {
                SecurityContext.this.couldReuse = false;
            }
            if (!DataSourceTypeEnum.isFlint(dataSource.getType()) && !DataSourceTypeEnum.isColumnar(dataSource.getType())) {
                if (dataSource.getMetadataProperties().get("isDummy") == null) {
                    if (dataSourceConnection == null) {
                        SecurityContext.this.couldReuse = false;
                    } else if (governors == null || governors.getCachePolicyDBAccess() == Governors.CachePolicyDBAccess.DB_CONNECTION_SIGNON) {
                        try {
                            this.signon = dataSourceConnection.getSignon();
                        }
                        catch (AmbiguousSignonException e) {
                            SecurityContext.this.couldReuse = false;
                        }
                    }
                }
                if (dataSourceConnection != null && (governors == null || (governors.getCachePolicyDBAccess() == Governors.CachePolicyDBAccess.DB_CONNECTION_SIGNON || governors.getCachePolicyDBAccess() == Governors.CachePolicyDBAccess.DB_CONNECTION) && governors.getCachePolicyConnectionCommandBlocks())) {
                    this.buildCommandblocks(dataSourceConnection, contentLocale);
                }
            }
            if (this.signon == null) {
                this.signon = new UsernamePasswordSignon("", null);
            }
            if (this.connectionString.equals("") && (governors == null || governors.getCachePolicyDBAccess() == Governors.CachePolicyDBAccess.DB_CONNECTION_SIGNON || governors.getCachePolicyDBAccess() == Governors.CachePolicyDBAccess.DB_CONNECTION)) {
                SecurityContext.this.couldReuse = false;
            }
        }

        private void buildCommandblocks(IDataSourceConnection dataSourceConnection, Locale contentLocale) {
            ArrayList<DataSourceConnectionCommandBlock> cmdBlocks = new ArrayList<DataSourceConnectionCommandBlock>();
            this.addCommandBlock(dataSourceConnection, Commands.CMD_OPEN_CONNECTION, cmdBlocks);
            this.addCommandBlock(dataSourceConnection, Commands.CMD_OPEN_SESSION, cmdBlocks);
            this.addCommandBlock(dataSourceConnection, Commands.CMD_CLOSE_CONNECTION, cmdBlocks);
            this.addCommandBlock(dataSourceConnection, Commands.CMD_CLOSE_SESSION, cmdBlocks);
            this.commandBlocks = new DataSourceConnectionCommandBlock[cmdBlocks.size()];
            cmdBlocks.toArray(this.commandBlocks);
            Arrays.sort(this.commandBlocks, new Comparator<DataSourceConnectionCommandBlock>(){

                @Override
                public int compare(DataSourceConnectionCommandBlock o1, DataSourceConnectionCommandBlock o2) {
                    if (o1.compareTo(o2)) {
                        return 0;
                    }
                    if (o1.getType() != o2.getType()) {
                        return o1.getType().compareTo(o2.getType());
                    }
                    if (o1.getType() == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_START_COMMAND || o1.getType() == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_END_COMMAND) {
                        return 0;
                    }
                    if (o1.getType() == IDataSourceConnectionCommandBlock.CommandBlockType.SQL_COMMAND) {
                        String o1pwd = (String)o1.getProperty("sql");
                        String o2pwd = (String)o2.getProperty("sql");
                        return o1pwd.compareTo(o2pwd);
                    }
                    return 0;
                }
            });
        }

        private void addCommandBlock(IDataSourceConnection dataSourceConnection, Commands cmdKey, List<DataSourceConnectionCommandBlock> cmdBlocks) {
            List<IDataSourceConnectionCommandBlock> cmdBlockList = dataSourceConnection.getCommandBlock(cmdKey);
            if (cmdBlockList != null) {
                for (IDataSourceConnectionCommandBlock cmdBlock : cmdBlockList) {
                    cmdBlocks.add((DataSourceConnectionCommandBlock)cmdBlock);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DatasourceSecurityObject)) {
                return false;
            }
            DatasourceSecurityObject other = (DatasourceSecurityObject)o;
            if (!(other.datasourceType.equals(this.datasourceType) && other.datasourceName.equals(this.datasourceName) && other.connectionString.equals(this.connectionString) && other.signon.equals(this.signon) && other.schema.equals(this.schema) && other.catalog.equals(this.catalog))) {
                return false;
            }
            return this.commandBlocksEqual(other);
        }

        private boolean commandBlocksEqual(DatasourceSecurityObject other) {
            if (other.commandBlocks == null) {
                return this.commandBlocks == null || this.commandBlocks.length == 0;
            }
            if (this.commandBlocks == null) {
                return other.commandBlocks == null || other.commandBlocks.length == 0;
            }
            if (other.commandBlocks.length != this.commandBlocks.length) {
                return false;
            }
            for (int i = 0; i < this.commandBlocks.length; ++i) {
                DataSourceConnectionCommandBlock thisCmdBlock = this.commandBlocks[i];
                DataSourceConnectionCommandBlock otherCmdblock = other.commandBlocks[i];
                if (thisCmdBlock.compareTo(otherCmdblock)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + this.datasourceType.hashCode();
            hash = hash * 31 + this.datasourceName.hashCode();
            hash = hash * 31 + this.connectionString.hashCode();
            hash = hash * 31 + this.signon.hashCode();
            if (this.commandBlocks != null) {
                for (DataSourceConnectionCommandBlock cmdBlock : this.commandBlocks) {
                    hash = hash * 31 + cmdBlock.hashCode();
                }
            }
            return hash;
        }
    }
}

