/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.mockprovider;

import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.mockprovider.NoddyCube;
import com.cognos.xqe.runtree.olap.mdx.mockprovider.NoddyDimension;
import com.cognos.xqe.util.OrderedMap;

public class NoddyMember
extends Member {
    private static final int LOW_LIMIT = 1000;
    private static final int HIGH_LIMIT = 999999;

    public NoddyMember(String name, ILevel level) {
        super(name, level);
        this.setMemberId(-1L);
    }

    public OrderedMap<IMember> fetchChildMembers() throws MetadataException, ProviderException {
        OrderedMap<IMember> result = new OrderedMap<IMember>();
        if (this.getLevel().getIndex() < ((Level)this.getLevel()).getDimension().getLevelCount()) {
            NoddyCube c = (NoddyCube)this.getDimension().getCube();
            int dimIndex = ((Level)this.getLevel()).getDimension().getIndex();
            int levelIndex = ((Level)this.getLevel()).getIndex();
            int parentLevelCardinality = 1;
            int levelCardinality = c.getMockMetadata().getLevelCardinality(c, dimIndex, levelIndex);
            if (levelIndex > 0) {
                parentLevelCardinality = c.getMockMetadata().getLevelCardinality(c, dimIndex, levelIndex - 1);
            }
            int childCount = levelCardinality / parentLevelCardinality;
            for (int i = 0; i < childCount; ++i) {
                NoddyDimension noddyDim = (NoddyDimension)((Level)this.getLevel()).getDimension();
                int memberRandomId = ((NoddyCube)noddyDim.getCube()).getNextRandom(1000, 999999);
                String memberName = ((NoddyCube)noddyDim.getCube()).getMockMetadata().getDimensionPrefix(noddyDim.getIndex()) + " " + memberRandomId;
                NoddyMember mem = new NoddyMember(memberName, (Level)this.getLevel().getNextLevel());
                mem.setParentMember(this);
                result.put(mem);
            }
        }
        return result;
    }
}

