/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.FilterDuplicatesTupleValueIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.HighSpeedHierarchyReorderTupleValueIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCallable;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.TupleValueGroupIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.util.concurrent.ThreadPool;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.primitive.HashSetLong;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class CachePopulator {
    public static Future<Void> startPopulation(ROLAPCube cube, IBlockTupleStorage cache, ISet querySet, List<IResultSet> resultSets) {
        CachePopulationTask populationTask = new CachePopulationTask(cube, resultSets, querySet, cache);
        Callable<Void> decoratedTask = CachePopulationTask.decorateCallable(populationTask, populationTask.getZipiAction(), populationTask.mCube.getName());
        Future<Void> future = ThreadPool.getInstance().submit(decoratedTask);
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (execEnv != null && execEnv.getTestEnvironmentOptions() != null) {
            execEnv.getTestEnvironmentOptions().addConcurrentTaskFuture(future);
        }
        return future;
    }

    private static class CachePopulationTask
    extends ROLAPCallable<Void> {
        private final List<IResultSet> resultSets;
        private final ISet querySet;
        private final IBlockTupleStorage cache;
        private final long startTime;

        CachePopulationTask(ROLAPCube cube, List<IResultSet> theResultSets, ISet aQuerySet, IBlockTupleStorage aCache) {
            super(cube);
            this.resultSets = theResultSets;
            this.querySet = aQuerySet;
            this.cache = aCache;
            this.startTime = System.currentTimeMillis();
            this.mZipiAction = "DCPopulateResultSetFromCache";
        }

        @Override
        public Void callImpl() throws Exception {
            long totalCellCount = 0L;
            try {
                HashSetLong addedOrdinals = null;
                ArrayList<Iterator<TupleValue>> tvIterList = new ArrayList<Iterator<TupleValue>>();
                for (IResultSet iResultSet : this.resultSets) {
                    if (this.querySet.size() == iResultSet.size()) continue;
                    addedOrdinals = new HashSetLong();
                    break;
                }
                IHierarchy[] querySetHiers = this.querySet.getHierarchies();
                for (IResultSet resultSet : this.resultSets) {
                    totalCellCount += (long)resultSet.cellCount();
                    IHierarchy[] resultSetHiers = resultSet.getQuerySet().getHierarchies();
                    boolean sameHierOrder = true;
                    for (int i = 0; i < querySetHiers.length; ++i) {
                        if (querySetHiers[i] == resultSetHiers[i]) continue;
                        sameHierOrder = false;
                        break;
                    }
                    Iterator<TupleValue> tupleValueIter = resultSet.tupleValueIterator();
                    if (!sameHierOrder) {
                        tupleValueIter = new HighSpeedHierarchyReorderTupleValueIterator(tupleValueIter, querySetHiers);
                    }
                    if (addedOrdinals != null) {
                        tupleValueIter = new FilterDuplicatesTupleValueIterator(tupleValueIter, this.querySet, addedOrdinals);
                    }
                    tvIterList.add(tupleValueIter);
                }
                TupleValueGroupIterator tupleValueGroupIterator = new TupleValueGroupIterator(tvIterList);
                this.cache.putTupleValues(this.querySet, tupleValueGroupIterator);
                ROLAPLog.log("ROLAPCubes.AggregateCache", "Successfully populated data cache for cube " + this.mCube.getUniqueName() + " with " + totalCellCount + " cells in " + (System.currentTimeMillis() - this.startTime) + " millis.");
            }
            catch (Throwable t) {
                Date populationStart = new Date(this.startTime);
                ROLAPLog.logError("ROLAPCubes.AggregateCache", "Error populating data cache for cube " + this.mCube.getUniqueName() + " with  " + totalCellCount + " cells.  Population started at " + populationStart.toString() + ".", t);
            }
            return null;
        }
    }
}

