/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Locale;

public class ROLAPCalculatedMeasure
extends ROLAPMeasure {
    public static final String RIGHTSQUAREBRACKET = "]";
    public static final String LEFTSQUAREBRACKET = ".[";

    public ROLAPCalculatedMeasure(String name, Level level, ROLAPMetaMeasure measure) {
        super(name, level, measure);
    }

    @Override
    protected void setROLAPAggregationRules() {
        this.aggregationType = AggregateTypeEnum.CALCULATED;
        this.aggregationRules = new ArrayList();
    }

    @Override
    public boolean isCalculatedMember() {
        return true;
    }

    public String getUniqueDefaultCaption() {
        String result = this.uniqueName;
        if (result == null) {
            result = "";
            IMember parent = this.getParent();
            result = parent == null ? this.getHierarchy().getUniqueName() : parent.getUniqueName();
            if (!this.isFillerMember()) {
                result = result + LEFTSQUAREBRACKET + this.getDefaultCaption() + RIGHTSQUAREBRACKET;
            }
            this.uniqueName = result;
        }
        return result;
    }

    public String getUniqueRuntimeCaption() {
        String result = null;
        IMember parent = this.getParent();
        result = parent == null ? this.getHierarchy().getUniqueName() : parent.getUniqueName();
        if (!this.isFillerMember()) {
            result = result + LEFTSQUAREBRACKET + this.getCaption() + RIGHTSQUAREBRACKET;
        }
        return result;
    }

    @Override
    public String getV5UniqueName() {
        Locale expressionLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getExpressionLocale();
        String locale = LocaleConverter.localeToStr(expressionLocale);
        String caption = null;
        if (this.getROLAPMetaMeasure() != null && (caption = this.getROLAPMetaMeasure().getCaption(locale)) == null) {
            caption = this.getCaption();
        }
        String part1 = UniqueNameGenerator.createMemberV5ModelPart(this.getHierarchy());
        String part2 = UniqueNameGenerator.createUniqueName(caption);
        return UniqueNameGenerator.join(part1, part2);
    }

    @Override
    public String getCaption() {
        String runLocaleCaption = null;
        if (this.getROLAPMetaMeasure() != null) {
            Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
            String locale = LocaleConverter.localeToStr(runLocale);
            runLocaleCaption = this.getROLAPMetaMeasure().getCaption(locale);
            if (runLocaleCaption == null) {
                runLocaleCaption = this.getROLAPMetaMeasure().getCaption(this.getROLAPMetaMeasure().getDefaultLocale());
            }
        }
        if (runLocaleCaption == null) {
            runLocaleCaption = super.getCaption();
        }
        return runLocaleCaption;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        ILocalizedString captions = null;
        if (this.getROLAPMetaMeasure() != null) {
            captions = this.getROLAPMetaMeasure().getCaptions();
        }
        if (captions == null) {
            captions = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPCube().getDefaultLocale(), this.getCaption());
        }
        return captions;
    }
}

