/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.bibushandler.datasource.DataSource;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.concurrent.Callable;

public abstract class ROLAPCallable<E>
implements Callable<E> {
    protected final ROLAPCube mCube;
    protected String mZipiAction = null;

    public static <V> Callable<V> decorateCallable(Callable<V> rc) {
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        envHelper.copyRequestEnvironmentInfo();
        return envHelper.decorateCallable(rc, true);
    }

    public static <V> Callable<V> decorateCallable(Callable<V> rc, String zipiAction, String zipiObjPath) {
        return ROLAPCallable.decorateCallable(rc, zipiAction, zipiObjPath, 1);
    }

    public static <V> Callable<V> decorateCallable(Callable<V> rc, String zipiAction, String zipiObjPath, int zipiStepsToJumpFactor) {
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        envHelper.copyRequestEnvironmentInfo();
        return envHelper.decorateCallable(rc, true, zipiAction, zipiObjPath, zipiStepsToJumpFactor);
    }

    public static <V> Callable<V> decorateServerTask(Callable<V> task, ICube cube, String zipiAction, String zipiObjPath, int zipiStepsToJumpFactor) {
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        envHelper.setCMRequestExecutor(((ROLAPCube)cube).getAccountManager());
        envHelper.copyRequestEnvironmentInfo();
        envHelper.setInternalUse(true);
        if (envHelper.getExecutionDataSource() == null) {
            envHelper.setExecutionDataSource(new DataSource(cube.getName(), cube.getName(), "RO"));
        }
        Callable<V> decoratedTask = envHelper.decorateCallable(task, true, zipiAction, zipiObjPath, zipiStepsToJumpFactor);
        return decoratedTask;
    }

    public ROLAPCallable(ROLAPCube cube) {
        this.mCube = cube;
    }

    @Override
    public final E call() throws Exception {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        ROLAPContext.queryEnter(execEnv, this.mCube);
        try {
            E e = this.callImpl();
            return e;
        }
        finally {
            ROLAPContext.queryExit(execEnv);
        }
    }

    public abstract E callImpl() throws Exception;

    public String getZipiAction() {
        return this.mZipiAction;
    }
}

