/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPCommonMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDataMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMember;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderCompoundKeyMapping;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQuery;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.CollectionCast;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ROLAPCompoundKeyMapping
extends V5ProviderCompoundKeyMapping {
    private static final int NUM_MEMBERS_TO_PRINT = 20;
    private HashSet<IROLAPCommonMember> mRequestedMembers;
    private boolean completeLevel = false;
    private List<ROLAPMemberProxy> mOverridePredicateMembers;
    protected List<ROLAPMetaAttribute> mProjectedColumns;
    private int mNumColumns = 0;
    private int mColumnOffsetInQuery = -1;
    private ROLAPLevel mLevel = null;
    private boolean pchSelectionForOnlyLeafMembers = false;
    private double mPredicateThreshold;
    private final boolean mOverfetchingAllowed;
    private static final int DEFAULT_MEMBER_PREDICATE_THRESHOLD = 90;
    private static final int HUNDRED_PERCENT = 100;
    private ROLAPMember.LevelKeys levelKeys = new ROLAPMember.LevelKeys(this.getNumColumns());

    public ROLAPCompoundKeyMapping(boolean overfetchingAllowed) {
        this(90, overfetchingAllowed);
    }

    public ROLAPCompoundKeyMapping(int predicateThresholdPercent, boolean overfetchingAllowed) {
        this.mRequestedMembers = new HashSet();
        this.mProjectedColumns = new ArrayList<ROLAPMetaAttribute>();
        this.mOverfetchingAllowed = overfetchingAllowed;
        if (predicateThresholdPercent < 0) {
            predicateThresholdPercent = 0;
        } else if (predicateThresholdPercent > 100) {
            predicateThresholdPercent = 100;
        }
        this.setPredicateThreshold((double)predicateThresholdPercent / 100.0);
    }

    private void setPredicateThreshold(double threshold) {
        this.mPredicateThreshold = threshold != 0.0 && !this.mOverfetchingAllowed ? 0.0 : threshold;
    }

    public IMember getMemberForRowResult(IValue[] row) {
        return this.getMemberForRowResult(row, this.mColumnOffsetInQuery);
    }

    @Override
    public <T> IMember getMemberForRowResult(List<T> row) {
        return this.getMemberForRowResult(row, this.mColumnOffsetInQuery);
    }

    private <T> IMember getMemberForRowResult(List<T> row, int offset) {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            this.levelKeys.setKeyValue((IValue)row.get(offset + i), i);
        }
        IMember member = this.findMemberByLevelKeys();
        return member;
    }

    private IMember findMemberByLevelKeys() {
        ROLAPHierarchy hierarchy = (ROLAPHierarchy)this.mLevel.getHierarchy();
        IMember member = null;
        if (!hierarchy.isRecursive()) {
            member = this.mLevel.getMember(this.levelKeys);
        } else {
            ILevel level;
            Iterator<ILevel> iterator = hierarchy.getLevels().iterator();
            while (iterator.hasNext() && (member = ((ROLAPLevel)(level = iterator.next())).getMember(this.levelKeys)) == null) {
            }
        }
        if (member != null && !this.completeLevel && !this.mRequestedMembers.contains(member)) {
            if (!hierarchy.isRecursive()) {
                return null;
            }
            if (!this.mRequestedMembers.contains(member = member instanceof ROLAPDataMember ? member.getParent() : member.getDataMember())) {
                return null;
            }
        }
        return member;
    }

    public ROLAPLevel getLevel() {
        return this.mLevel;
    }

    protected void setLevel(ROLAPLevel level) {
        this.mLevel = level;
    }

    public boolean isLevelComplete() {
        return this.completeLevel;
    }

    public HashSet<IROLAPCommonMember> getRequestedMembers() {
        if (this.mRequestedMembers == null && this.completeLevel) {
            this.mRequestedMembers = new HashSet(this.mLevel.getCardinality());
            for (IMember m : this.mLevel.getAllMembers()) {
                this.mRequestedMembers.add((IROLAPCommonMember)((Object)m));
            }
            ROLAPLog.log("ROLAPQuery.Performance", "Had to materialize " + this.mRequestedMembers.size() + " members into the mRequestedMembers set in ROLAPCompoundKeyMapping.");
        }
        return this.mRequestedMembers;
    }

    public void setMemberSelections(ROLAPLevel level, HashSet<IROLAPCommonMember> reqMembers) {
        if (!level.isAllLevel()) {
            if (this.mLevel == null) {
                this.mLevel = level;
                ROLAPMetaLevel roLevel = level.getMetaLevel();
                this.mProjectedColumns = roLevel.getLevelKeys();
            }
            this.mRequestedMembers = reqMembers;
        }
    }

    private IMember getMemberForRowResult(IValue[] row, int offset) {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            this.levelKeys.setKeyValue(row[offset + i], i);
        }
        IMember member = this.findMemberByLevelKeys();
        return member;
    }

    @Override
    public void addMemberSelection(IMember member) {
        ROLAPLevel level = (ROLAPLevel)member.getLevel();
        if (!level.isAllLevel()) {
            if (this.mLevel == null) {
                this.mLevel = level;
                ROLAPMetaLevel roLevel = level.getMetaLevel();
                this.mProjectedColumns = roLevel.getLevelKeys();
            }
            this.mRequestedMembers.add((IROLAPCommonMember)((Object)member));
        }
    }

    @Override
    public void addMemberSelections(List<IMember> selections) {
        for (IMember member : selections) {
            if (member instanceof ROLAPVirtualMember) {
                this.addMemberSelection(((ROLAPVirtualMember)member).getSourceMember());
                continue;
            }
            this.addMemberSelection(member);
        }
    }

    public void addMemberSelections(List<IMember> selections, ICube sourceCube) {
        for (IMember member : selections) {
            if (member instanceof ROLAPVirtualMember) {
                this.addMemberSelection(((ROLAPVirtualMember)member).getSourceMember(sourceCube));
                continue;
            }
            this.addMemberSelection(member);
        }
    }

    public void addAllMembersFromLevel(ROLAPLevel level) {
        if (!level.isAllLevel()) {
            this.mLevel = level;
            ROLAPMetaLevel roLevel = level.getMetaLevel();
            this.mProjectedColumns = roLevel.getLevelKeys();
            this.completeLevel = true;
            this.mRequestedMembers = null;
        }
    }

    public boolean hasRecursiveHierarchy() {
        return this.mLevel.hasRecursiveHierarchy();
    }

    @Override
    public void addToQuery(V5ProviderQuery subject) {
        this.addToQuery(subject, null);
    }

    public void addToQuery(V5ProviderQuery subject, ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>> levelKeyValues) {
        ROLAPQuery query = (ROLAPQuery)subject;
        if (query.compoundKeyMappings == null) {
            query.compoundKeyMappings = new ArrayList();
        }
        query.compoundKeyMappings.add(this);
        if (this.hasRecursiveHierarchy()) {
            query.pchCompoundKeyMappings.add(this);
            IROLAPCommonMember sampleMember = this.mRequestedMembers.iterator().next();
            this.pchSelectionForOnlyLeafMembers = this.mLevel.hasRecursiveHierarchy() && (this.mRequestedMembers.size() > 1 || this.mRequestedMembers.size() == 1 && ((IROLAPMember)((Object)sampleMember)).isLeaf());
        } else if (this.mPredicateThreshold == 0.0) {
            if (levelKeyValues != null && !levelKeyValues.isEmpty()) {
                this.addToQueryOriginal(query, levelKeyValues.get(0));
            } else {
                this.addToQueryOriginal(query, null);
            }
        } else {
            this.addToQueryOptimized(query, levelKeyValues);
        }
    }

    public Map<ROLAPMetaAttribute, Collection<IValue>> getPchLevelKeyFilters(IROLAPQuery.QueryTarget target) {
        LinkedHashMap<ROLAPMetaAttribute, Collection<IValue>> levelKeyFilters = new LinkedHashMap<ROLAPMetaAttribute, Collection<IValue>>();
        HashSet<IROLAPCommonMember> memberSelections = this.mRequestedMembers;
        ROLAPMetaAttribute column = this.mProjectedColumns.get(0);
        Iterator<IROLAPCommonMember> it = memberSelections.iterator();
        if (target == IROLAPQuery.QueryTarget.AGG_TABLE || this.isPchSelectionForLeafMembersOnly()) {
            ArrayList<IValue> values = new ArrayList<IValue>();
            while (it.hasNext()) {
                IROLAPCommonMember v = it.next();
                values.add(v.getLevelKeys().getKeyValues()[0]);
            }
            levelKeyFilters.put(column, values);
        } else {
            while (it.hasNext()) {
                IROLAPCommonMember v = it.next();
                if (v instanceof ROLAPDataMember) {
                    ArrayList<IValue> values = new ArrayList<IValue>();
                    values.add(v.getLevelKeys().getKeyValues()[0]);
                    levelKeyFilters.put(column, values);
                    continue;
                }
                HashSet<IMember> mbrSet = new HashSet<IMember>(((IMemberCubics)((Object)v)).getDescendants());
                ArrayList<IValue> values = new ArrayList<IValue>();
                for (IROLAPCommonMember iROLAPCommonMember : mbrSet) {
                    if (iROLAPCommonMember.getLevelKeys() == null) continue;
                    values.add(iROLAPCommonMember.getLevelKeys().getKeyValues()[0]);
                }
                levelKeyFilters.put(column, values);
            }
        }
        return levelKeyFilters;
    }

    public void addPchProjectionGroupingAttributes(ROLAPQuery subject, IROLAPQuery.QueryTarget target) {
        if (this.mColumnOffsetInQuery == -1) {
            this.mColumnOffsetInQuery = subject.getAttributeCount();
        }
        ROLAPMetaAttribute column = this.mProjectedColumns.get(0);
        subject.addLevelKeyFilterToBeParameterized(column);
        if (this.shouldProjectPchColumn(target)) {
            this.addProjectedColumnsToAttributeAvoidDuplicates(subject, target);
        }
    }

    public boolean shouldProjectPchColumn(IROLAPQuery.QueryTarget target) {
        boolean wouldCauseDifferentAggFactProjections = target == IROLAPQuery.QueryTarget.AGG_TABLE && !this.isPchSelectionForLeafMembersOnly();
        boolean shouldProjectPchColumn = this.isPchSelectionForLeafMembersOnly() && !wouldCauseDifferentAggFactProjections;
        return shouldProjectPchColumn;
    }

    public boolean isPchSelectionForLeafMembersOnly() {
        return this.pchSelectionForOnlyLeafMembers;
    }

    private void addToQueryOriginal(ROLAPQuery subject, Map<ROLAPMetaAttribute, HashSet<IValue>> levelKeyValues) {
        this.mColumnOffsetInQuery = subject.getAttributeCount();
        HashSet<IROLAPCommonMember> memberSelections = this.getRequestedMembers();
        if (levelKeyValues == null) {
            ArrayList<IROLAPCommonMember> memberList = new ArrayList<IROLAPCommonMember>();
            memberList.addAll(memberSelections);
            levelKeyValues = this.getLevelKeyValues(memberList);
        }
        for (ROLAPMetaAttribute column : levelKeyValues.keySet()) {
            subject.addAttribute(column, IROLAPQuery.QueryTarget.COMMON);
            this.incrementNumColumns();
            subject.addFilter(column, (Collection<IValue>)levelKeyValues.get(column));
        }
        if (!this.mOverfetchingAllowed) {
            this.addExclusionsForOverfetchMembers(subject, levelKeyValues, memberSelections);
        }
    }

    private void addExclusionsForOverfetchMembers(ROLAPQuery subject, Map<ROLAPMetaAttribute, HashSet<IValue>> keyValuesMap, HashSet<IROLAPCommonMember> memberSelections) {
        IROLAPMember[] lMems;
        for (IROLAPMember lMem : lMems = this.mLevel.getROLAPMembers(false)) {
            ROLAPMember.LevelKeys lKeys = ((IROLAPCommonMember)((Object)lMem)).getLevelKeys();
            IValue[] keys = lKeys.getKeyValues();
            boolean keysMatch = true;
            for (int j = 0; j < keys.length; ++j) {
                HashSet<IValue> keyValues = keyValuesMap.get(this.mProjectedColumns.get(j));
                if (keyValues.contains(keys[j])) continue;
                keysMatch = false;
                break;
            }
            if (!keysMatch || memberSelections.contains(lMem)) continue;
            subject.addExclusionFilter((IROLAPCommonMember)((Object)lMem));
        }
    }

    private void addToQueryOptimized(ROLAPQuery subject, ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>> predicateList) {
        this.mColumnOffsetInQuery = subject.getAttributeCount();
        if (predicateList == null) {
            predicateList = this.getOptimizedPredicate();
        }
        if (predicateList != null) {
            if (predicateList.size() > 1) {
                ROLAPMetaAttribute column = predicateList.get(0).keySet().iterator().next();
                String dim = column.getParent().getName();
                subject.addExtraFilterList(dim, predicateList);
            } else if (predicateList.size() > 0) {
                Map<ROLAPMetaAttribute, HashSet<IValue>> keyValues = predicateList.get(0);
                for (ROLAPMetaAttribute column : keyValues.keySet()) {
                    subject.addFilter(column, (Collection<IValue>)keyValues.get(column));
                }
            }
        }
        this.addProjectedColumnsToAttribute(subject);
    }

    public ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>> getSelectionsLevelKeys() {
        if (this.hasRecursiveHierarchy() || this.completeLevel) {
            return new ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>>();
        }
        if (this.mPredicateThreshold == 0.0) {
            ArrayList<IROLAPCommonMember> memberList = new ArrayList<IROLAPCommonMember>();
            memberList.addAll(this.getRequestedMembers());
            HashMap<ROLAPMetaAttribute, HashSet<IValue>> keyValues = this.getLevelKeyValues(memberList);
            ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>> keyValuesList = new ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>>();
            keyValuesList.add(keyValues);
            return keyValuesList;
        }
        return this.getOptimizedPredicate();
    }

    private ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>> getOptimizedPredicate() {
        List<ROLAPMemberProxy> reducedMembers = this.mOverridePredicateMembers;
        if (reducedMembers == null && !this.completeLevel) {
            reducedMembers = this.optimizeMemberPredicate(this.getRequestedMembers().toArray(new IROLAPCommonMember[0]), false);
        }
        ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>> predicateList = new ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>>();
        if (reducedMembers != null) {
            Iterator<ROLAPMemberProxy> it = reducedMembers.iterator();
            while (it.hasNext()) {
                ROLAPLevel level = (ROLAPLevel)it.next().getLevel();
                if (!level.isAllLevel()) continue;
                return predicateList;
            }
        } else {
            return predicateList;
        }
        LinkedHashMap<Level, ArrayList<IROLAPCommonMember>> memberGroup = new LinkedHashMap<Level, ArrayList<IROLAPCommonMember>>();
        for (IMember iMember : reducedMembers) {
            Level level = (Level)iMember.getLevel();
            ArrayList<IROLAPCommonMember> mbrs = (ArrayList<IROLAPCommonMember>)((HashMap)memberGroup).get(level);
            if (mbrs == null) {
                mbrs = new ArrayList<IROLAPCommonMember>();
            }
            mbrs.add((IROLAPCommonMember)((Object)iMember));
            memberGroup.put(level, mbrs);
        }
        if (((HashMap)memberGroup).keySet().size() > 1) {
            for (Level key : ((HashMap)memberGroup).keySet()) {
                ArrayList memberlist = (ArrayList)((HashMap)memberGroup).get(key);
                HashMap<ROLAPMetaAttribute, HashSet<IValue>> keyValues = this.getLevelKeyValues(memberlist);
                LinkedHashMap<ROLAPMetaAttribute, HashSet<IValue>> mbrsMap = new LinkedHashMap<ROLAPMetaAttribute, HashSet<IValue>>();
                for (ROLAPMetaAttribute column : keyValues.keySet()) {
                    mbrsMap.put(column, keyValues.get(column));
                }
                predicateList.add(mbrsMap);
            }
        } else {
            for (ArrayList memberlist : ((HashMap)memberGroup).values()) {
                HashMap<ROLAPMetaAttribute, HashSet<IValue>> keyValues = this.getLevelKeyValues(memberlist);
                predicateList.add(keyValues);
            }
        }
        return predicateList;
    }

    private void addProjectedColumnsToAttribute(ROLAPQuery subject) {
        for (ROLAPMetaAttribute column : this.mProjectedColumns) {
            subject.addAttribute(column, IROLAPQuery.QueryTarget.COMMON);
            this.incrementNumColumns();
        }
    }

    protected void addProjectedColumnsToAttributeAvoidDuplicates(ROLAPQuery subject, IROLAPQuery.QueryTarget target) {
        for (ROLAPMetaAttribute column : this.mProjectedColumns) {
            int index;
            int curCount = subject.getAttributeSelections(target).size();
            if (curCount != (index = column.addAttributeAvoidingDuplicates(subject, target)) || target != IROLAPQuery.QueryTarget.COMMON) continue;
            this.incrementNumColumns();
        }
    }

    private HashMap<ROLAPMetaAttribute, HashSet<IValue>> getLevelKeyValues(ArrayList<IROLAPCommonMember> members) {
        LinkedHashMap<ROLAPMetaAttribute, HashSet<IValue>> keyValues = new LinkedHashMap<ROLAPMetaAttribute, HashSet<IValue>>();
        List<ROLAPMetaAttribute> predicateColumns = null;
        for (ROLAPMemberProxy rOLAPMemberProxy : members) {
            ROLAPLevel level = (ROLAPLevel)rOLAPMemberProxy.getLevel();
            ROLAPMetaLevel metaLevel = level.getMetaLevel();
            predicateColumns = metaLevel.getLevelKeys();
            ROLAPMember.LevelKeys levelKey = rOLAPMemberProxy.getLevelKeys();
            if (levelKey == null) continue;
            IValue[] levelKeyValues = levelKey.getKeyValues();
            for (int i = 0; i < levelKeyValues.length; ++i) {
                HashSet<IValue> set = (HashSet<IValue>)((HashMap)keyValues).get(predicateColumns.get(i));
                if (set == null) {
                    set = new HashSet<IValue>();
                }
                set.add(levelKeyValues[i]);
                keyValues.put(predicateColumns.get(i), set);
            }
        }
        return keyValues;
    }

    private ArrayList<ROLAPMemberProxy> optimizeMemberPredicate(IROLAPCommonMember[] memberSelections, boolean recursiveCall) {
        LinkedHashMap<ROLAPMemberProxy, Object> pcMap = new LinkedHashMap<ROLAPMemberProxy, Object>(memberSelections.length / 2);
        if (memberSelections.length > 0) {
            ROLAPMemberProxy mbr = (ROLAPMemberProxy)memberSelections[0];
            ROLAPMemberProxy parent = (ROLAPMemberProxy)mbr.getROLAPParent();
            ROLAPLevel pLevel = null;
            if (parent != null) {
                pLevel = (ROLAPLevel)parent.getLevel();
            }
            if (pLevel != null && pLevel.getROLAPCardinality() < memberSelections.length) {
                IROLAPMember[] mems = pLevel.getROLAPMembers(false);
                HashSet<IROLAPCommonMember> selSet = new HashSet<IROLAPCommonMember>(Arrays.asList(memberSelections));
                for (IROLAPMember mem : mems) {
                    ROLAPMemberProxy[] children = CollectionCast.uncheckedCast(mem.getChildren());
                    children.retainAll(selSet);
                    if (children.isEmpty()) continue;
                    pcMap.put((ROLAPMemberProxy)mem, children);
                }
            } else {
                for (int i = 0; i < memberSelections.length; ++i) {
                    mbr = (ROLAPMemberProxy)memberSelections[i];
                    parent = (ROLAPMemberProxy)mbr.getROLAPParent();
                    Collection value = (Collection)((HashMap)pcMap).get(parent);
                    if (value == null) {
                        LinkedHashSet<ROLAPMemberProxy> mbrList = new LinkedHashSet<ROLAPMemberProxy>();
                        mbrList.add(mbr);
                        pcMap.put(parent, mbrList);
                        continue;
                    }
                    value.add(mbr);
                }
            }
        }
        int numReplacedChildren = 0;
        Object[] parents = ((HashMap)pcMap).keySet().toArray();
        ROLAPMemberProxy[] parentList = new ROLAPMemberProxy[parents.length];
        int parentIdx = 0;
        for (int i = 0; i < parents.length; ++i) {
            Object level;
            ROLAPMemberProxy parent = (ROLAPMemberProxy)parents[i];
            if (parent == null) continue;
            Collection mbrList = (Collection)((HashMap)pcMap).get(parent);
            int threshold = (int)((double)parent.getChildrenCardinality() * this.mPredicateThreshold);
            if (mbrList.size() < threshold || mbrList.size() == 1 && ((Level)(level = (ROLAPLevel)parent.getLevel())).isAllLevel()) continue;
            parentList[parentIdx++] = parent;
            numReplacedChildren += mbrList.size();
        }
        ArrayList<ROLAPMemberProxy> returnMbrs = new ArrayList<ROLAPMemberProxy>();
        if (parentIdx > 0) {
            IROLAPCommonMember[] newParentArray = new ROLAPMemberProxy[parentIdx];
            System.arraycopy(parentList, 0, newParentArray, 0, parentIdx);
            ROLAPMemberProxy firstParent = newParentArray[0];
            boolean rootSelected = newParentArray[0].getLevel().isRootLevel();
            if (rootSelected || parentIdx == 1 && !this.parentHasSmallerLevelKey(firstParent)) {
                for (IROLAPCommonMember newParent : newParentArray) {
                    returnMbrs.add((ROLAPMemberProxy)newParent);
                    pcMap.remove(newParent);
                }
            } else {
                ArrayList<ROLAPMemberProxy> optimizedList = this.optimizeMemberPredicate(newParentArray, true);
                if (recursiveCall || this.isOptimizedSelectionEfficient(optimizedList, memberSelections, numReplacedChildren)) {
                    returnMbrs.addAll(optimizedList);
                    for (ROLAPMemberProxy parent : parentList) {
                        pcMap.remove(parent);
                    }
                }
            }
            if (ROLAPLog.isOn("ROLAPQuery", LogLevel.INFO) && !recursiveCall) {
                Object[] membersToPrint;
                String ellipsis = "";
                if (memberSelections.length > 20) {
                    ellipsis = "..." + (memberSelections.length - 20) + " more.";
                    membersToPrint = new IROLAPCommonMember[20];
                    System.arraycopy(memberSelections, 0, membersToPrint, 0, 20);
                } else {
                    membersToPrint = memberSelections;
                }
                ROLAPLog.log("ROLAPQuery", String.format("Member predicate optimization selected parent members: %s\n from original members: %s%s", returnMbrs, Arrays.toString(membersToPrint), ellipsis));
            }
        }
        Object[] keys = ((HashMap)pcMap).keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            Collection values = (Collection)((HashMap)pcMap).get(keys[i]);
            returnMbrs.addAll(values);
        }
        return returnMbrs;
    }

    private boolean parentHasSmallerLevelKey(ROLAPMemberProxy member) {
        ROLAPMemberProxy parent = (ROLAPMemberProxy)member.getROLAPParent();
        if (parent == null) {
            return false;
        }
        return ROLAPCompoundKeyMapping.getNumLevelKeyParts(parent) < ROLAPCompoundKeyMapping.getNumLevelKeyParts(member);
    }

    private boolean isOptimizedSelectionEfficient(ArrayList<ROLAPMemberProxy> optimizedList, IROLAPCommonMember[] memberSelections, int numReplacedChildren) {
        int maxMultipartKeys = 30;
        int minAbsoluteReduction = 100;
        int mpKeyCount = 0;
        boolean optimizedPredWorthwhile = true;
        if (optimizedList.size() * 2 < numReplacedChildren || optimizedList.size() + 100 < numReplacedChildren || numReplacedChildren == memberSelections.length) {
            if (ROLAPCompoundKeyMapping.getNumLevelKeyParts((ROLAPMemberProxy)memberSelections[0]) <= 1) {
                for (ROLAPMemberProxy mem : optimizedList) {
                    if (ROLAPCompoundKeyMapping.getNumLevelKeyParts(mem) <= 1 || mpKeyCount++ != 30) continue;
                    optimizedPredWorthwhile = false;
                    if (ROLAPLog.isOn("ROLAPQuery", LogLevel.INFO)) {
                        ROLAPLog.log("ROLAPQuery", String.format("Member predicate optimization rejected optimized members because there were too many composite keys: %s", optimizedList));
                    }
                    break;
                }
            }
        } else {
            optimizedPredWorthwhile = false;
            if (ROLAPLog.isOn("ROLAPQuery", LogLevel.INFO)) {
                ROLAPLog.log("ROLAPQuery", String.format("Member predicate optimization rejected optimized members because there wasn't a significant simplification: %d:%d", numReplacedChildren, optimizedList.size()));
            }
        }
        return optimizedPredWorthwhile;
    }

    private static int getNumLevelKeyParts(ROLAPMemberProxy mem) {
        if (((ROLAPLevel)mem.getLevel()).isAllLevel()) {
            return 0;
        }
        int keySize = mem.getLevelKeys().getKeyValues().length;
        return keySize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n firstCol: " + this.mColumnOffsetInQuery + "  numCols: " + this.getNumColumns() + "\nLevel: " + this.mLevel + "  level complete: " + this.completeLevel);
        if (this.mRequestedMembers != null) {
            sb.append("\nSelections: " + this.mRequestedMembers + "\n");
        }
        return sb.toString();
    }

    private int getNumColumns() {
        return this.mNumColumns;
    }

    private void incrementNumColumns() {
        ++this.mNumColumns;
        this.levelKeys = new ROLAPMember.LevelKeys(this.mNumColumns);
    }

    public void setOverridePredicateMembers(List<ROLAPMemberProxy> overridePredicateMembers) {
        this.mOverridePredicateMembers = overridePredicateMembers;
    }
}

