/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.INameCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.NameCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.NameCacheNameProvider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheEngine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.IROLAPSecurityManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.LightweightOrderedMap;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ROLAPDimension
extends Dimension
implements IROLAPDimension,
NameCacheNameProvider {
    private static final String BYROW = "byRow";
    ROLAPMetaDimension metaDimension;
    ROLAPMetaHierarchy rolapDefaultHierarchy;
    private XQERuntimeException ex = null;
    private IOrderedMap<ROLAPCalculatedMeasure> calculatedMeasuresMap = null;
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    protected final INameCache v5UniqueNameCache;
    private static final String COMMA_SPLIT = ",";
    private static final int MAGIC_THREE = 3;
    private ConcurrentHashMap<String, String> stringCache = new ConcurrentHashMap();

    public ROLAPDimension(String name, ROLAPCube cube, ROLAPMetaDimension dim, ROLAPMetaHierarchy metaDefaultHierarchy, DimensionTypeEnum dimensionType) {
        super(name, cube);
        this.metaDimension = dim;
        this.v5UniqueNameCache = this.createNameCache();
        this.setType(dimensionType);
        if (dim != null && metaDefaultHierarchy != null) {
            this.rolapDefaultHierarchy = metaDefaultHierarchy;
        }
        if (this.rolapDefaultHierarchy == null || !this.rolapDefaultHierarchy.hasAllLevel()) {
            this.getmaxMemberId();
        }
        if (this.isMeasuresDimension() || dimensionType == DimensionTypeEnum.INTERNAL) {
            this.initialiseHierarchy(cube, metaDefaultHierarchy);
        }
        this.setUniqueName(LEFT_BRACKET + this.getName() + RIGHT_BRACKET);
        this.description = this.getName();
    }

    protected INameCache createNameCache() {
        return new NameCache(this);
    }

    @Override
    public boolean isShareable() {
        return false;
    }

    @Override
    public ROLAPMetaDimension getMetaDimension() {
        return this.metaDimension;
    }

    @Override
    public MetadataConnection getConnection() {
        return this.getCube().getConnection();
    }

    @Override
    public String getV5UniqueName() {
        return this.getV5UniqueName(this.getCube().getName());
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        return this.v5UniqueNameCache.getV5UniqueName(cubeName, ROLAPUtilities.getExpressionLocale(this));
    }

    @Override
    public String getName(String locale) {
        String localizedName = null;
        if (this.getType() == DimensionTypeEnum.MEASURE) {
            ROLAPCube cube = (ROLAPCube)this.getCube();
            ROLAPMetaCube modelCube = cube.getModelCube();
            localizedName = ROLAPCube.getModelCubeFacts(modelCube).getName(locale);
        } else if (this.getMetaDimension() != null) {
            localizedName = this.getMetaDimension().getName(locale);
        }
        if (localizedName == null) {
            localizedName = this.getName();
        }
        return localizedName;
    }

    public ROLAPHierarchy addHierarchy(ROLAPMetaHierarchy metaHierarchy) {
        return this.initialiseHierarchy((ROLAPCube)this.getCube(), metaHierarchy);
    }

    public void setDefaultHierarchy(ROLAPHierarchy h) {
        super.setDefaultHierarchy(h);
    }

    public ROLAPMetaHierarchy getMetaDefaultHierarchy() {
        return this.rolapDefaultHierarchy;
    }

    public ROLAPHierarchy initialiseHierarchy(ROLAPCube cube, ROLAPMetaHierarchy metaHierarchy) {
        String hierarchyName = null;
        boolean hierarchyUsesTwoPartHUN = true;
        if (this.isMeasuresDimension()) {
            hierarchyName = this.getName();
            hierarchyUsesTwoPartHUN = false;
        } else if (metaHierarchy == this.rolapDefaultHierarchy && cube.isCubingServicesCompatible()) {
            hierarchyName = this.getName();
            hierarchyUsesTwoPartHUN = false;
        } else {
            hierarchyName = this.getType() == DimensionTypeEnum.INTERNAL ? this.getName() : metaHierarchy.getName();
        }
        IHierarchy existingHierarchy = this.getHierarchy(hierarchyName);
        if (existingHierarchy != null) {
            if (cube.isCubingServicesCompatible() && hierarchyName.equals(this.getName())) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_DuplicateHierarchyNameFromDimRename, hierarchyName, cube.getName());
            }
            throw new XQERuntimeException(XQEMessageKeys.ROL_DuplicateHierarchyName, hierarchyName, cube.getName());
        }
        return new ROLAPHierarchy(cube.getName(), hierarchyName, this, metaHierarchy, hierarchyUsesTwoPartHUN);
    }

    @Override
    public boolean isMeasuresDimension() {
        return super.isMeasuresDimension();
    }

    @Override
    public boolean isTimeDimension() {
        return super.isTimeDimension();
    }

    public IOrderedMap<ROLAPCalculatedMeasure> fetchCalculatedMeasures(ROLAPLevel rolapLevel) {
        if (this.isMeasuresDimension()) {
            if (this.calculatedMeasuresMap != null) {
                return this.calculatedMeasuresMap;
            }
            OrderedMap<ROLAPCalculatedMeasure> calcMeasuresMap = new OrderedMap<ROLAPCalculatedMeasure>();
            ROLAPCube rolapCube = (ROLAPCube)this.getCube();
            ROLAPMetaCube modelCube = rolapCube.getModelCube();
            ROLAPMetaMeasure[] measures = modelCube.getMeasures();
            for (int i = 0; i < measures.length; ++i) {
                String defaultCaption;
                ROLAPMetaMeasure measure = measures[i];
                if (!measure.isCalculated()) continue;
                String name = measure.getName();
                ROLAPCalculatedMeasure meas = new ROLAPCalculatedMeasure(name, (Level)rolapLevel, measure);
                if (calcMeasuresMap.get(meas.getName()) == null) {
                    calcMeasuresMap.put(meas);
                }
                if ((defaultCaption = measure.getCaption(modelCube.getDefaultLocale())) != null) {
                    meas = new ROLAPCalculatedMeasure(defaultCaption, (Level)rolapLevel, measure);
                    if (calcMeasuresMap.get(defaultCaption) == null) {
                        calcMeasuresMap.put(meas);
                    }
                }
                this.generateLocalizedCalculatedMeasures(rolapLevel, measure, modelCube.getMeasureParent().getNames(), measure.getCaptions(), calcMeasuresMap);
                this.generateLocalizedCalculatedMeasures(rolapLevel, measure, modelCube.getMeasureParent().getNames(), measure.getNames(), calcMeasuresMap);
            }
            LightweightOrderedMap<ROLAPCalculatedMeasure> lightweightMap = new LightweightOrderedMap<ROLAPCalculatedMeasure>();
            lightweightMap.putAll(calcMeasuresMap.getList());
            this.calculatedMeasuresMap = lightweightMap;
            return this.calculatedMeasuresMap;
        }
        return null;
    }

    private void generateLocalizedCalculatedMeasures(ROLAPLevel rolapLevel, ROLAPMetaMeasure measure, ILocalizedString measureParentName, ILocalizedString localizedMemNameString, IOrderedMap<ROLAPCalculatedMeasure> calcMeasuresMap) {
        if (localizedMemNameString != null) {
            String[] supportedLocales;
            for (String locale : supportedLocales = localizedMemNameString.getSupportedLocales()) {
                String localizedParentName;
                String localizedMemName = localizedMemNameString.toString(locale);
                ROLAPCalculatedMeasure meas = new ROLAPCalculatedMeasure(localizedMemName, (Level)rolapLevel, measure);
                if (measureParentName != null && (localizedParentName = measureParentName.toString(locale)) != null) {
                    String uniqueName = UniqueNameGenerator.createUniqueName(localizedParentName, localizedMemName);
                    meas.setUniqueName(uniqueName);
                }
                if (calcMeasuresMap.get(meas.getName()) != null) continue;
                calcMeasuresMap.put(meas);
            }
        }
    }

    protected IOrderedMap<IMember> fetchMeasures() throws MetadataException, ProviderException {
        LightweightOrderedMap<IMember> result = new LightweightOrderedMap<IMember>();
        HashSet<String> measNames = new HashSet<String>();
        boolean flAggregateEnable = false;
        if (this.isMeasuresDimension()) {
            IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("RO");
            flAggregateEnable = providerCapabilities.isSupported("enableFirstLastAggregateRulesMeasures");
            ROLAPLevel level = (ROLAPLevel)this.getLevel(0);
            ROLAPCube cube = (ROLAPCube)this.getCube();
            ROLAPMetaCube modelCube = cube.getModelCube();
            ROLAPMetaMeasure[] measures = modelCube.getMeasures();
            ArrayList<ROLAPMeasure> measList = new ArrayList<ROLAPMeasure>();
            boolean isNRTCube = modelCube.isNearRealTimeCube();
            for (int i = 0; i < measures.length; ++i) {
                ROLAPMetaMeasure measure = measures[i];
                String name = measure.getName();
                ROLAPMeasure meas = measure.isCalculated() ? new ROLAPCalculatedMeasure(name, (Level)level, measure) : new ROLAPMeasure(name, (Level)level, measure);
                if (measNames.contains(meas.getName())) {
                    this.ex = new XQERuntimeException(XQEMessageKeys.ROL_DuplicateMeasureNameException, ((Object)meas).toString());
                    continue;
                }
                if (!flAggregateEnable && meas.containsFirstLastAggregateRule()) continue;
                if (isNRTCube && AggregateTypeEnum.UNKNOWN.equals(meas.getRegularAggregate())) {
                    ROLAPLog.logError("ROLAPCubes.IncrementalUpdates", "Measure " + meas.getName() + " is skipped because the aggregation type " + meas.getRegularAggregate() + " is not suppored when the factTransactionIDQueryItem is specified (a near realtime cube).");
                    continue;
                }
                measList.add(meas);
                measNames.add(meas.getName());
            }
            if (measList.size() > 0) {
                result.putAll(measList);
            }
            level.setCardinality(measures.length);
        }
        return result;
    }

    public XQERuntimeException getInitMeasureError() {
        return this.ex;
    }

    @Override
    public long getROLAPCardinality() {
        long card = 0L;
        int numHiers = this.getHierarchyCount();
        for (int hierx = 0; hierx < numHiers; ++hierx) {
            card += ((ROLAPHierarchy)this.getHierarchy(hierx)).getROLAPCardinality();
        }
        return card;
    }

    @Override
    public IROLAPCube getROLAPCube() {
        return (IROLAPCube)((Object)this.getCube());
    }

    @Override
    public IROLAPHierarchy getDefaultROLAPHierarchy() {
        return (IROLAPHierarchy)this.getDefaultHierarchy();
    }

    @Override
    public IROLAPMember getDefaultROLAPMember() throws Exception {
        IROLAPHierarchy h = (IROLAPHierarchy)this.getDefaultHierarchy();
        return h.getDefaultROLAPMember();
    }

    @Override
    public IROLAPHierarchy[] getROLAPHierarchies() {
        int ct = this.getHierarchyCount();
        IROLAPHierarchy[] hiers = new IROLAPHierarchy[ct];
        for (int i = 0; i < ct; ++i) {
            Hierarchy h = (Hierarchy)this.getHierarchy(i);
            hiers[i] = (IROLAPHierarchy)((Object)h);
        }
        return hiers;
    }

    @Override
    public IROLAPLevel[] getROLAPLevels() {
        Hierarchy h = (Hierarchy)this.getDefaultHierarchy();
        Level[] levs = h.getLevels().toArray(new Level[0]);
        IROLAPLevel[] levelsOut = new IROLAPLevel[levs.length];
        for (int i = 0; i < levs.length; ++i) {
            Level level = levs[i];
            levelsOut[i] = (IROLAPLevel)((Object)level);
        }
        return levelsOut;
    }

    @Override
    public IROLAPMember[] getROLAPMembers() {
        IMember[] members = this.getMembers();
        IROLAPMember[] membersOut = new IROLAPMember[members.length];
        for (int i = 0; i < members.length; ++i) {
            membersOut[i] = (IROLAPMember)members[i];
        }
        return membersOut;
    }

    @Override
    public int getROLAPType() {
        if (this.isTimeDimension()) {
            return 1;
        }
        if (this.isMeasuresDimension()) {
            return 2;
        }
        return 0;
    }

    public ROLAPMetaAttribute[] getFactKeysforDimension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    public boolean isLocalizationMethodByRow() {
        String localizationMethod;
        ROLAPMetaDimension metaDim = this.getMetaDimension();
        boolean byRow = false;
        if (metaDim != null && (localizationMethod = metaDim.getLocalizationMethod()) != null && BYROW.equalsIgnoreCase(localizationMethod)) {
            byRow = true;
        }
        return byRow;
    }

    @Override
    public List<ROLAPCalculatedMember> getROLAPCalculatedMembers(boolean includeSessionScoped) {
        return null;
    }

    @Override
    public boolean getMembersRollup() {
        return this.getMembersRollup(this.getCube());
    }

    @Override
    public boolean getMembersRollup(ICube cube) {
        return this.getMembersRollup(cube, false);
    }

    @Override
    public boolean getMembersRollup(ICube cube, boolean allowSecurityOverride) {
        IROLAPSecurityManager sec = (IROLAPSecurityManager)((Cube)cube).getSecurityManager();
        List<IHierarchy> hierarchies = this.getHierarchies();
        for (IHierarchy hierarchy : hierarchies) {
            if (hierarchy.isParentChild() && hierarchy instanceof ROLAPHierarchy && ((ROLAPHierarchy)hierarchy).isDataMemberHidden()) {
                return false;
            }
            if (!hierarchy.isParentChild() && ((ROLAPHierarchy)hierarchy).isExtraneousMembersRemoved()) {
                return false;
            }
            if (allowSecurityOverride && ROLAPCubeManager.getInstance().getConfig().isSecuredHierarchyMemberRollupAllowed()) {
                return true;
            }
            if (sec == null || sec.getMembersRollup(hierarchy)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Map<IHierarchy, ILevel>> findConvergenceHierarchyGroups(IHierarchy[] hiers) {
        if (hiers.length < 2) {
            return null;
        }
        int[] levelCounts = new int[hiers.length];
        ROLAPLevel[] levels = new ROLAPLevel[hiers.length];
        ROLAPMetaLevel[] metaLevels = new ROLAPMetaLevel[hiers.length];
        int maxLevelCount = 0;
        for (int i = 0; i < hiers.length; ++i) {
            levelCounts[i] = hiers[i].getLevelCount();
            levels[i] = (ROLAPLevel)hiers[i].getLevel(levelCounts[i] - 1);
            metaLevels[i] = levels[i].getMetaLevel();
            if (levelCounts[i] <= maxLevelCount) continue;
            maxLevelCount = levelCounts[i];
        }
        ArrayList<Map<IHierarchy, ILevel>> retGroup = null;
        boolean[] skips = new boolean[hiers.length];
        for (int i = 0; i < hiers.length - 1; ++i) {
            if (skips[i]) continue;
            ROLAPMetaLevel convergenceLevel = null;
            ArrayList<IHierarchy> groupHiers = null;
            for (int j = i + 1; j < hiers.length; ++j) {
                if (skips[j] || metaLevels[i] != metaLevels[j]) continue;
                if (convergenceLevel == null) {
                    convergenceLevel = metaLevels[i];
                    groupHiers = new ArrayList<IHierarchy>();
                    skips[i] = true;
                    groupHiers.add(hiers[i]);
                    skips[j] = true;
                    groupHiers.add(hiers[j]);
                    continue;
                }
                skips[j] = true;
                groupHiers.add(hiers[j]);
            }
            if (convergenceLevel == null) continue;
            if (retGroup == null) {
                retGroup = new ArrayList<Map<IHierarchy, ILevel>>();
            }
            IHierarchy[] subHiers = groupHiers.toArray(new IHierarchy[0]);
            ArrayList<Map<IHierarchy, ILevel>> subGroup = this.findConvergenceHierarchiesAndLevels(subHiers);
            for (int k = subGroup.size(); k > 0; --k) {
                retGroup.add(subGroup.get(k - 1));
            }
        }
        return retGroup;
    }

    public ArrayList<Map<IHierarchy, ILevel>> findConvergenceHierarchiesAndLevels(IHierarchy[] hiers) {
        if (hiers.length < 2) {
            return null;
        }
        int[] levelCounts = new int[hiers.length];
        ROLAPLevel[] levels = new ROLAPLevel[hiers.length];
        ROLAPMetaLevel[] metaLevels = new ROLAPMetaLevel[hiers.length];
        int maxLevelCount = 0;
        for (int i = 0; i < hiers.length; ++i) {
            levelCounts[i] = hiers[i].getLevelCount();
            levels[i] = (ROLAPLevel)hiers[i].getLevel(levelCounts[i] - 1);
            metaLevels[i] = levels[i].getMetaLevel();
            if (levelCounts[i] <= maxLevelCount) continue;
            maxLevelCount = levelCounts[i];
        }
        ROLAPMetaLevel convergenceLevel = this.findCommonMetaLevel(metaLevels);
        if (convergenceLevel == null) {
            return null;
        }
        ArrayList<Map<IHierarchy, ILevel>> retArrayList = new ArrayList<Map<IHierarchy, ILevel>>();
        ROLAPLevel[] tempLevels = new ROLAPLevel[hiers.length];
        ROLAPMetaLevel[] tempMetaLevels = new ROLAPMetaLevel[hiers.length];
        for (int iLevel = 1; iLevel < maxLevelCount; ++iLevel) {
            int i;
            int i2;
            boolean useThisLevel = true;
            ROLAPMetaLevel saveMetaLevel = null;
            for (i2 = 0; i2 < hiers.length; ++i2) {
                if (metaLevels[i2] != convergenceLevel) continue;
                if (levelCounts[i2] > iLevel) {
                    tempLevels[i2] = (ROLAPLevel)hiers[i2].getLevel(levelCounts[i2] - 1 - iLevel);
                    tempMetaLevels[i2] = tempLevels[i2].getMetaLevel();
                    if (saveMetaLevel == null) {
                        saveMetaLevel = tempMetaLevels[i2];
                        continue;
                    }
                    if (saveMetaLevel == tempMetaLevels[i2]) continue;
                    useThisLevel = false;
                    continue;
                }
                tempLevels[i2] = null;
                tempMetaLevels[i2] = null;
                useThisLevel = false;
            }
            if (useThisLevel) {
                for (i2 = 0; i2 < hiers.length; ++i2) {
                    levels[i2] = tempLevels[i2];
                }
                continue;
            }
            HashMap<IHierarchy, ROLAPLevel> oneHierToConvLevelMap = new HashMap<IHierarchy, ROLAPLevel>();
            for (i = 0; i < hiers.length; ++i) {
                if (metaLevels[i] != convergenceLevel) continue;
                oneHierToConvLevelMap.put(hiers[i], levels[i]);
            }
            retArrayList.add(oneHierToConvLevelMap);
            for (i = 0; i < hiers.length; ++i) {
                levels[i] = tempLevels[i];
                metaLevels[i] = tempMetaLevels[i];
            }
            convergenceLevel = this.findCommonMetaLevel(metaLevels);
            if (convergenceLevel == null) break;
        }
        return retArrayList;
    }

    private ROLAPMetaLevel findCommonMetaLevel(ROLAPMetaLevel[] metaLevels) {
        for (int i = 0; i < metaLevels.length - 1; ++i) {
            if (metaLevels[i] == null) continue;
            for (int j = i + 1; j < metaLevels.length; ++j) {
                if (metaLevels[j] == null || metaLevels[i] != metaLevels[j]) continue;
                return metaLevels[i];
            }
        }
        return null;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        ILocalizedString captions = null;
        if (this.getMetaDimension() != null && (captions = this.getMetaDimension().getCaptions()) == null) {
            captions = this.getMetaDimension().getNames();
        }
        if (this.getType() == DimensionTypeEnum.MEASURE) {
            ROLAPCube cube = (ROLAPCube)this.getCube();
            ROLAPMetaCube modelCube = cube.getModelCube();
            captions = ROLAPCube.getModelCubeFacts(modelCube).getNames();
        }
        if (captions == null) {
            captions = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPCube().getDefaultLocale(), this.getCaption());
        }
        return captions;
    }

    @Override
    public ILocalizedString getLocalizedName() {
        ILocalizedString names = null;
        if (this.getMetaDimension() != null) {
            names = this.getMetaDimension().getNames();
        }
        if (names == null) {
            names = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPCube().getDefaultLocale(), this.getName());
        }
        return names;
    }

    @Override
    public ILocalizedString getLocalizedDescription() {
        ILocalizedString descriptions = null;
        if (this.getMetaDimension() != null) {
            descriptions = this.getMetaDimension().getDescriptions();
        }
        if (descriptions == null) {
            descriptions = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPCube().getDefaultLocale(), this.getDescription());
        }
        return descriptions;
    }

    @Override
    public String getCaption() {
        String runLocaleCaption = null;
        if (this.getMetaDimension() != null) {
            Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
            String locale = LocaleConverter.localeToStr(runLocale);
            runLocaleCaption = this.getMetaDimension().getCaption(locale);
            if (runLocaleCaption == null) {
                runLocaleCaption = this.getMetaDimension().getCaption(this.getMetaDimension().getDefaultLocale());
            }
        }
        if (runLocaleCaption == null) {
            runLocaleCaption = this.getName();
        }
        return runLocaleCaption;
    }

    @Override
    public IMember findDescendant(IMember parent, String memberNamePart, ILevel level, boolean caseSensitive) {
        IMember result = null;
        try {
            String hierName = level.getHierarchy().getName();
            IHierarchy hierarchy = this.getHierarchy(hierName);
            ILevel rightLevel = hierarchy.getLevel(level.getIndex());
            for (IMember member : rightLevel.getMembers()) {
                String parentName;
                String memberParentName;
                String memberName = member.getName();
                if (memberName == null || memberName.length() == 0) {
                    String memberUniqueName = member.getUniqueName();
                    memberName = memberUniqueName.substring(memberUniqueName.lastIndexOf(LEFT_BRACKET) + 1, memberUniqueName.length() - 1);
                }
                if (caseSensitive) {
                    if (!memberName.equals(memberNamePart) || member.getParent() == null || parent == null) continue;
                    memberParentName = member.getParent().getName();
                    parentName = parent.getName();
                    if (memberParentName.isEmpty() || parentName.isEmpty()) {
                        return member;
                    }
                    if (!member.getParent().getUniqueName().equals(parent.getUniqueName())) continue;
                    return member;
                }
                if (!memberName.equalsIgnoreCase(memberNamePart) || member.getParent() == null || parent == null) continue;
                memberParentName = member.getParent().getName();
                parentName = parent.getName();
                if (memberParentName.isEmpty() || parentName.isEmpty()) {
                    return member;
                }
                if (!member.getParent().getUniqueName().equals(parent.getUniqueName())) continue;
                return member;
            }
        }
        catch (MetadataException e) {
            mErrorLogger.log(e);
        }
        return result;
    }

    @Override
    public String createV5UniqueName(String cubeName, String locale) {
        return UniqueNameGenerator.createROLAPV5UniqueName(this.getCube(), locale, this);
    }

    @Override
    public ROLAPCacheEngine getMetadataStorage() {
        return (ROLAPCacheEngine)((Cube)((Object)this.getROLAPCube())).getMetadataStorage();
    }

    public String cacheString(String str) {
        String existingInstance = this.stringCache.putIfAbsent(str, str);
        if (existingInstance == null) {
            return str;
        }
        return existingInstance;
    }

    public void clearStringCache() {
        this.stringCache.clear();
    }
}

