/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.INameCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQueryResultIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.NameCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.NameCacheNameProvider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAbstractHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAllLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDataMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchyMemberLoader;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasureFolder;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ShareableROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.SharedDimNameCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCubeFacts;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCustomPTDRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCustomRollingTotalRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCustomSimpleRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaView;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewDefinitionsFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.V5ExpressionUtils;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParserException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ROLAPHierarchy
extends ROLAPAbstractHierarchy
implements NameCacheNameProvider {
    public static final String ALL = "(All)";
    private static final String LEFT_BRACKET = "[";
    private static final String UNDERSCORE = "_";
    protected ROLAPMetaHierarchy metaHierarchy;
    private List<ROLAPCalculatedMeasure> hierarchyCalculatedMeasures = new ArrayList<ROLAPCalculatedMeasure>();
    private boolean twoPartUniqueName = true;
    private static final String RIGHT_BRACKET = "]";
    ROLAPMetaLevel recursiveMemberMetaLevel = null;
    ROLAPMetaLevel recursiveParentMetaLevel = null;
    private XQERuntimeException ex = null;
    private String rolapUniqueName = null;
    private boolean bExtraneousMembersRemoved = false;
    private IMember mCurrentPeriodMember = null;
    private boolean isCurrentPeriodMemberSet = false;
    private final INameCache v5UniqueNameCache;
    private Map<ICacheKey, ROLAPMember.LevelKeys> cacheKeyToLevelKeyMap;
    private LoadStatusEnum loadStatus = LoadStatusEnum.notYetStarted;

    public ROLAPHierarchy(String cubeName, String name, Dimension d, ROLAPMetaHierarchy hierarchy, boolean useTwoPartUniqueName) {
        super(name, d);
        this.twoPartUniqueName = useTwoPartUniqueName;
        this.rolapUniqueName = this.calculateUniqueName();
        this.v5UniqueNameCache = this.createNameCache();
        if (hierarchy != null) {
            this.metaHierarchy = hierarchy;
            this.initialiseHierarchies(cubeName);
            this.description = hierarchy.getName();
        } else if (d.getType() == DimensionTypeEnum.INTERNAL) {
            String allLevelName = "VL";
            String allMemberName = "VirtualMember";
            ILocalizedString allMemberCaptions = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPDimension().getROLAPCube().getDefaultLocale(), allMemberName);
            new ROLAPAllLevel(cubeName, allLevelName, this, allMemberName, allMemberCaptions, true);
            ROLAPHierarchyMemberLoader.logNumberOfMembersLoadedMsg(this, 1, true);
        } else {
            new ROLAPLevel("Values", this, true);
        }
    }

    private INameCache createNameCache() {
        if (this.getDimension().isShareable()) {
            return new SharedDimNameCache(this);
        }
        return new NameCache(this);
    }

    @Override
    public MetadataConnection getConnection() {
        return this.getDimension().getConnection();
    }

    public boolean isExtraneousMembersRemoved() {
        return this.bExtraneousMembersRemoved;
    }

    public void setExtraneousMembersRemoved() {
        this.bExtraneousMembersRemoved = true;
    }

    protected void initialiseHierarchies(String cubeName) {
        if (this.metaHierarchy != null) {
            ROLAPMetaLevel[] levels = this.metaHierarchy.getLevels();
            int levelCount = levels.length;
            if (this.metaHierarchy.hasAllLevel()) {
                String allLevelName = this.getAllLevelName(this.metaHierarchy);
                String allMemberName = this.metaHierarchy.getAllMemberName();
                ILocalizedString allMemberCaptions = this.metaHierarchy.getAllMemberCaptions();
                new ROLAPAllLevel(cubeName, allLevelName, this, allMemberName, allMemberCaptions, levelCount == 0);
            }
            if (this.isRecursive()) {
                if (levelCount != 2) {
                    throw new XQERuntimeException(XQEMessageKeys.ROL_ParentChildHierarchyIncorrectLevels, (Object)this.getName(), (Object)this.getDimension().getName(), (Object)cubeName);
                }
                this.recursiveMemberMetaLevel = levels[1];
                this.recursiveParentMetaLevel = levels[0];
            } else {
                for (int i = 0; i < levelCount; ++i) {
                    ROLAPMetaLevel level = levels[i];
                    String name = this.getLevelName(level, this.metaHierarchy);
                    if (this.getLevel(name) == null) {
                        new ROLAPLevel(name, this, level, cubeName, i == levelCount - 1);
                        continue;
                    }
                    this.ex = new XQERuntimeException(XQEMessageKeys.ROL_DuplicateLevelNameException, name);
                }
            }
            if (!this.isRecursive()) {
                this.setupMUNs();
            }
        }
    }

    @Override
    public boolean isParentChild() {
        return this.isRecursive();
    }

    public void setupMUNs() {
        ROLAPMetaLevel[] metaLevels = this.metaHierarchy.getLevels();
        List<ILevel> rolapLevels = this.getLevels();
        HashSet<ROLAPMetaAttribute> ancestorLevelKeys = new HashSet<ROLAPMetaAttribute>();
        int levelIdx = 0;
        if (this.metaHierarchy.hasAllLevel()) {
            ++levelIdx;
        }
        for (ROLAPMetaLevel metaLevel : metaLevels) {
            List<ROLAPMetaAttribute> attributes = metaLevel.getLevelKeys();
            boolean[] bKeys = new boolean[attributes.size()];
            boolean hasUsableKey = false;
            for (int i = 0; i < attributes.size(); ++i) {
                bKeys[i] = !ancestorLevelKeys.contains(attributes.get(i));
                hasUsableKey = hasUsableKey || bKeys[i];
            }
            if (!hasUsableKey) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_HierarchyContainsInvertedLevel, this.metaHierarchy.getName(), metaLevel.getName());
            }
            ((ROLAPLevel)rolapLevels.get(levelIdx)).setMUNKeys(bKeys);
            ancestorLevelKeys.addAll(attributes);
            ++levelIdx;
        }
    }

    public XQERuntimeException getInitLevelError() {
        return this.ex;
    }

    @Override
    public IOrderedMap<IMember> fetchFirstLevelMembers() throws MetadataException, ProviderException {
        return ((ROLAPLevel)this.getLevel(0)).fetchROLAPLevelMembers();
    }

    @Override
    public String getV5UniqueName() {
        return this.getV5UniqueName(null);
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        return this.v5UniqueNameCache.getV5UniqueName(cubeName, ROLAPUtilities.getExpressionLocale(this));
    }

    @Override
    public String getName(String locale) {
        String localizedName = null;
        ROLAPMetaHierarchy theMetaHierarchy = this.getMetaHierarchy();
        if (theMetaHierarchy != null) {
            localizedName = theMetaHierarchy.getName(locale);
        }
        if (localizedName == null) {
            localizedName = this.getName();
        }
        return localizedName;
    }

    @Override
    public String getUniqueName() {
        if (this.rolapUniqueName == null) {
            return this.calculateUniqueName();
        }
        return this.rolapUniqueName;
    }

    private String calculateUniqueName() {
        StringBuilder sb = new StringBuilder(LEFT_BRACKET);
        if (this.twoPartUniqueName) {
            ROLAPDimension d = (ROLAPDimension)this.getDimension();
            sb.append(d.getName());
            sb.append("].[");
            sb.append(this.getName());
            sb.append(RIGHT_BRACKET);
            return sb.toString();
        }
        sb.append(this.getName());
        sb.append(RIGHT_BRACKET);
        return sb.toString();
    }

    private String getAllLevelName(ROLAPMetaHierarchy hierarchy) {
        String allLevelName = null;
        if (hierarchy.hasAllLevel()) {
            String allMemberName;
            String defaultLocale = hierarchy.getDefaultLocale();
            allLevelName = hierarchy.getAllLevelName(defaultLocale);
            if (allLevelName == null) {
                allLevelName = ALL;
            }
            if (allLevelName.equals(allMemberName = hierarchy.getAllMemberName()) || hierarchy.getLevel(allLevelName) != null) {
                allLevelName = UNDERSCORE + allLevelName;
            }
        }
        return allLevelName;
    }

    private String getLevelName(ROLAPMetaLevel level, ROLAPMetaHierarchy hierarchy) {
        String allMemberName;
        String name = null;
        name = level.getName();
        if (hierarchy.hasAllLevel() && name.equals(allMemberName = hierarchy.getAllMemberName())) {
            name = UNDERSCORE + name;
        }
        return name;
    }

    @Override
    public boolean isRagged() {
        return false;
    }

    @Override
    public boolean isUnbalanced() {
        return this.isRecursive();
    }

    @Override
    public boolean isRecursive() {
        if (this.metaHierarchy == null) {
            return false;
        }
        return this.metaHierarchy.isRecursive();
    }

    public boolean isDataMemberHidden() {
        return this.metaHierarchy.isDataMemberHidden();
    }

    public boolean isRemoveExtraneousPaddingMembers() {
        return this.metaHierarchy.isRemoveExtraneousPaddingMembers();
    }

    @Override
    public boolean isMeasure() {
        return this.getDimension().isMeasuresDimension();
    }

    public ROLAPMetaLevel getRecursiveMemberMetaLevel() {
        if (this.getDimension().isShareable()) {
            String cubeName = this.getDimension().getCube().getName();
            return ((ShareableROLAPDimension)this.getDimension()).getMetaHierarchy(cubeName, this.getName()).getLevels()[1];
        }
        return this.recursiveMemberMetaLevel;
    }

    public ROLAPMetaLevel getRecursiveParentMetaLevel() {
        if (this.getDimension().isShareable()) {
            String cubeName = this.getDimension().getCube().getName();
            return ((ShareableROLAPDimension)this.getDimension()).getMetaHierarchy(cubeName, this.getName()).getLevels()[0];
        }
        return this.recursiveParentMetaLevel;
    }

    @Override
    public IROLAPMember getROLAPAllMember() {
        Level l = (Level)this.getLevel(0);
        if (!l.isAllLevel()) {
            return null;
        }
        IMember allMember = l.getMember(0);
        ROLAPDimension dimension = (ROLAPDimension)this.getDimension();
        ROLAPCube cube = (ROLAPCube)dimension.getCube();
        SecurityManagerInterface securityManager = cube.getSecurityManager(cube.getProvider());
        if (securityManager != null) {
            IMember[] members = new IMember[]{allMember};
            if ((members = securityManager.applySecurity(members, l.getHierarchy())).length == 0) {
                allMember = null;
            }
        }
        return (IROLAPMember)allMember;
    }

    public void addROLAPCalculatedMeasures(ROLAPCalculatedMeasure calculatedMeasure) {
        this.hierarchyCalculatedMeasures.add(calculatedMeasure);
    }

    @Override
    public List<ROLAPCalculatedMeasure> getROLAPCalculatedMeasures() {
        return this.hierarchyCalculatedMeasures;
    }

    @Override
    public long getROLAPCardinality() {
        long cardinality = 0L;
        int numLevels = this.getLevelCount();
        for (int levelx = 0; levelx < numLevels; ++levelx) {
            cardinality += (long)((ROLAPLevel)this.getLevel(levelx)).getROLAPCardinality();
        }
        return cardinality;
    }

    @Override
    public IROLAPMember getDefaultROLAPMember() {
        IMember defaultMember = this.getDefaultMemberWithSecurity();
        return (IROLAPMember)defaultMember;
    }

    @Override
    public int getROLAPDeploymentType() {
        if (this.isRecursive()) {
            return 32;
        }
        return 16;
    }

    @Override
    public int getDimNumber() {
        return this.getDimension().getIndex();
    }

    @Override
    public IROLAPDimension getROLAPDimension() {
        return (IROLAPDimension)this.getDimension();
    }

    @Override
    public int getROLAPDimensionType() {
        return this.getROLAPDimension().getROLAPType();
    }

    @Override
    public IROLAPLevel getROLAPLevel(int levelNo) {
        return (IROLAPLevel)this.getLevel(levelNo);
    }

    public ROLAPLevel getROLAPLevel(ICacheKey levelCacheKey) {
        Level[] levs = this.getLevels().toArray(new Level[0]);
        for (int j = 0; j < levs.length; ++j) {
            Level lev = levs[j];
            if (!(lev instanceof ROLAPLevel) || !((ROLAPLevel)lev).getCacheKey().equals(levelCacheKey)) continue;
            return (ROLAPLevel)lev;
        }
        return null;
    }

    @Override
    public IROLAPLevel[] getROLAPLevels() {
        Level[] levels = this.getLevels().toArray(new Level[0]);
        IROLAPLevel[] result = new IROLAPLevel[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            result[i] = (IROLAPLevel)((Object)levels[i]);
        }
        return result;
    }

    private void getROLAPRootMembersRecursive(IMemberCubics parent, List<IMember> runningList, boolean applySecurity, SecurityManagerInterface securityManager) throws Exception {
        List<IMember> children = parent.getChildren(true);
        for (IMemberCubics iMemberCubics : children) {
            if (iMemberCubics.isFillerMember() || this.isRestricted(iMemberCubics, applySecurity, securityManager)) {
                this.getROLAPRootMembersRecursive(iMemberCubics, runningList, applySecurity, securityManager);
                continue;
            }
            runningList.add(iMemberCubics);
        }
        List<ROLAPCalculatedMember> calcChildren = ((IROLAPMember)parent).getROLAPCalculatedMembers(true);
        for (ROLAPCalculatedMember child : calcChildren) {
            if (this.isRestricted(child, applySecurity, securityManager)) continue;
            runningList.add(child);
        }
    }

    private boolean isRestricted(IMemberCubics member, boolean applySecurity, SecurityManagerInterface securityManager) {
        if (applySecurity && securityManager != null) {
            IMember[] members = new IMember[]{member};
            IHierarchy hier = null;
            if (member != null) {
                hier = member.getHierarchy();
            }
            return (members = securityManager.applySecurity(members, hier)).length == 0;
        }
        return false;
    }

    public boolean hasSecurityLookupViews() {
        ROLAPCube cube = (ROLAPCube)this.getDimension().getCube();
        Map<String, ROLAPMetaView> securityViews = SecViewDefinitionsFactory.getFromLoadedCubeModel(cube);
        if (securityViews != null) {
            for (ROLAPMetaView secView : securityViews.values()) {
                if (!secView.containsSecurityLookupRules(this.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IROLAPMember[] getROLAPRootMembers(boolean applySecurity) throws Exception {
        ROLAPDimension dimension = (ROLAPDimension)this.getDimension();
        ROLAPCube cube = (ROLAPCube)dimension.getCube();
        SecurityManagerInterface securityManager = cube.getSecurityManager(cube.getProvider());
        ILevel rootLevel = this.getLevel(0);
        ArrayList<IMember> runningList = new ArrayList<IMember>();
        List<IMember> rootLevelMembers = ((Level)rootLevel).getMembers(true, false);
        for (IMemberCubics iMemberCubics : rootLevelMembers) {
            if (iMemberCubics.isFillerMember() || this.isRestricted(iMemberCubics, applySecurity, securityManager)) {
                this.getROLAPRootMembersRecursive(iMemberCubics, runningList, applySecurity, securityManager);
                continue;
            }
            runningList.add(iMemberCubics);
        }
        List<ROLAPCalculatedMember> rootLevelCalcMembers = ((ROLAPLevel)rootLevel).getROLAPCalculatedMembers(true);
        for (ROLAPCalculatedMember mem : rootLevelCalcMembers) {
            if (this.isRestricted(mem, applySecurity, securityManager)) continue;
            runningList.add(mem);
        }
        return runningList.toArray(new IROLAPMember[runningList.size()]);
    }

    @Override
    public ROLAPMetaHierarchy getMetaHierarchy() {
        String cubeName;
        if (this.getDimension().isShareable() && (cubeName = this.getDimension().getCube().getName()) != null) {
            return ((ShareableROLAPDimension)this.getDimension()).getMetaHierarchy(cubeName, this.getName());
        }
        return this.metaHierarchy;
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public boolean isTwoPartUniqueName() {
        return this.twoPartUniqueName;
    }

    public boolean isRollup() {
        return this.getDimension().getMembersRollup();
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        ILocalizedString captions = null;
        ROLAPMetaHierarchy theMetaHierarchy = this.getMetaHierarchy();
        if (theMetaHierarchy != null && this.isTwoPartUniqueName() && (captions = theMetaHierarchy.getCaptions()) == null) {
            captions = theMetaHierarchy.getNames();
        }
        if (captions == null) {
            captions = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPDimension().getROLAPCube().getDefaultLocale(), this.getCaption());
        }
        return captions;
    }

    @Override
    public ILocalizedString getLocalizedName() {
        ILocalizedString names = null;
        ROLAPMetaHierarchy theMetaHierarchy = this.getMetaHierarchy();
        if (theMetaHierarchy != null) {
            names = theMetaHierarchy.getNames();
        }
        if (names == null) {
            names = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPDimension().getROLAPCube().getDefaultLocale(), this.getName());
        }
        return names;
    }

    @Override
    public ILocalizedString getLocalizedDescription() {
        ILocalizedString descriptions = null;
        ROLAPMetaHierarchy theMetaHierarchy = this.getMetaHierarchy();
        if (theMetaHierarchy != null) {
            descriptions = theMetaHierarchy.getDescriptions();
        }
        if (descriptions == null) {
            descriptions = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPDimension().getROLAPCube().getDefaultLocale(), this.getDescription());
        }
        return descriptions;
    }

    @Override
    public String getCaption() {
        Locale runLocale;
        String locale;
        String runLocaleCaption = null;
        ROLAPMetaHierarchy theMetaHierarchy = this.getMetaHierarchy();
        if (theMetaHierarchy != null && this.isTwoPartUniqueName() && (runLocaleCaption = theMetaHierarchy.getCaption(locale = LocaleConverter.localeToStr(runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale()))) == null) {
            runLocaleCaption = theMetaHierarchy.getCaption(theMetaHierarchy.getDefaultLocale());
        }
        if (runLocaleCaption == null) {
            runLocaleCaption = this.getName();
        }
        return runLocaleCaption;
    }

    @Override
    public IMember getOriginalCalculatedMeasure(String originalV5Name) {
        List<ROLAPCalculatedMeasure> calcMeasures = this.getROLAPCalculatedMeasures();
        for (ROLAPCalculatedMeasure rolapMeasure : calcMeasures) {
            if (!rolapMeasure.getV5UniqueName().equals(originalV5Name)) continue;
            return rolapMeasure;
        }
        return null;
    }

    @Override
    public CalculatedMember getOriginalCalculatedMember(IROLAPCube cube, String originalV5Name) {
        List<ROLAPCalculatedMember> hierCalculatedMembers = this.getROLAPCalculatedMembers(cube.getName());
        for (ROLAPCalculatedMember rolapMember : hierCalculatedMembers) {
            if (!rolapMember.getV5UniqueName(cube.getName()).equals(originalV5Name)) continue;
            return rolapMember;
        }
        return null;
    }

    @Override
    public IROLAPHierarchy.FillerCaptionType getFillerCaptionType() {
        if (this.getDimension().isShareable()) {
            return this.metaHierarchy.getCaptionType();
        }
        return this.getMetaHierarchy().getCaptionType();
    }

    @Override
    protected boolean isRelativeTimeEnabled() {
        return this.getDimension().isTimeDimension() && this.metaHierarchy.hasRelativeTimeMembers();
    }

    @Override
    public boolean shouldShowRelativeTimePriorPeriodMembers() {
        return this.metaHierarchy.shouldShowRelativeTimePriorPeriodMembers();
    }

    @Override
    public boolean shouldShowRelativeTimeNextPeriodMembers() {
        return this.metaHierarchy.shouldShowRelativeTimeNextPeriodMembers();
    }

    @Override
    public boolean shouldShowRelativeTimeSubtreeMembers() {
        return this.metaHierarchy.shouldShowRelativeTimeSubtreeMembers();
    }

    @Override
    public IMember getCurrentPeriodMember() {
        if (!this.isCurrentPeriodMemberSet) {
            this.isCurrentPeriodMemberSet = true;
            if (this.metaHierarchy.hasRelativeTimeMembers()) {
                this.setCurrentPeriodMember();
            }
        }
        return this.mCurrentPeriodMember;
    }

    private void setCurrentPeriodMember() {
        ROLAPCube roBaseCube = (ROLAPCube)this.getDimension().getCube();
        ROLAPMemberQuery query = new ROLAPMemberQuery(roBaseCube.getSchema(), roBaseCube);
        if (query instanceof ROLAPMemberQuery) {
            query.setHierarchy(this);
        }
        ArrayList<ILevel> exprLevels = new ArrayList<ILevel>();
        ArrayList<String[]> dataItems = new ArrayList<String[]>();
        List<ILevel> levels = this.getLevels();
        for (ILevel level : levels) {
            String expr;
            if (level instanceof ROLAPAllLevel || (expr = ((ROLAPLevel)level).getCurrentPeriodExpression()) == null || expr.equals("")) continue;
            ROLAPMetaAttribute attrib = ((ROLAPLevel)level).getMetaLevel().getBusinessKey();
            dataItems.add(new String[]{attrib.getParentQualifiedQueryName(), expr, "ascending"});
            exprLevels.add(level);
            String msg = "Relative time current period expression for level [" + level.getName() + "]: " + expr + ".";
            ROLAPLog.log("ROLAPCubes.Loader", msg);
        }
        if (dataItems.isEmpty()) {
            List<IMember> members;
            int memberCount;
            ILevel level = this.getLevel(0);
            if (level != null && ((Level)level).isAllLevel()) {
                level = level.getNextLevel();
            }
            if (level != null && (memberCount = (members = level.getMembers()).size()) > 0) {
                this.mCurrentPeriodMember = members.get(memberCount - 1);
            }
            return;
        }
        query.setDataItemInfo(dataItems);
        IMember member = null;
        try {
            IROLAPQueryResultIterator resultIterator = query.execute();
            IMember parent = null;
            block3: while (resultIterator.hasNext()) {
                IValue[] values = resultIterator.next().getColumns();
                if (values.length <= 0) continue;
                for (int j = 0; j < values.length; ++j) {
                    IValue v = values[j];
                    if (v.isNull()) continue;
                    String m = v.toString();
                    ILevel level = (ILevel)exprLevels.get(j);
                    member = parent == null ? ((ROLAPLevel)level).getMember(m) : this.findDescendant(parent, m, (Level)level, true);
                    if (member == null) {
                        String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_RelativeTimeCurrentPeriodMemberNotFound, XQEMessages.getCurrProductLocale(), m);
                        ROLAPLog.logError("ROLAPCubes.Loader", "Current period expression failed: " + errorMessage);
                        continue block3;
                    }
                    parent = member;
                    String msg = "Relative time current period member " + member.getUniqueName() + " found.";
                    ROLAPLog.log("ROLAPCubes.Loader", msg);
                }
            }
            resultIterator.close();
        }
        catch (RuntimeException e) {
            ROLAPLog.logError("ROLAPCubes.Loader", "Current period expression failed to execute. ", e);
        }
        this.mCurrentPeriodMember = member;
    }

    @Override
    protected IMember createCalculatedMember(IROLAPCube cube, String name, IMember parentMember, int relaTimeMemberType, IMember relaTimeRefMember, String expression, ROLAPMetaObject metaMember, Set<String> existingCalcMembers) {
        ROLAPMetaCalculatedMember metaCalcMemb = null;
        String fullParentName = null;
        if (relaTimeMemberType != 0) {
            if (parentMember != null) {
                fullParentName = parentMember.getUniqueName();
            }
            if (expression == null) {
                expression = ((IROLAPMember)relaTimeRefMember).getV5UniqueName(cube.getName());
            }
        } else {
            metaCalcMemb = (ROLAPMetaCalculatedMember)metaMember;
            fullParentName = metaCalcMemb.getParentUniqueName();
            expression = metaCalcMemb.getV5Expression();
        }
        if (relaTimeMemberType == 0) {
            try {
                V5ExpressionUtils.checkV5ExpressionSyntax(expression);
            }
            catch (Exception e) {
                String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidCalculatedMemberDefinition, XQEMessages.getCurrProductLocale(), name, this.getUniqueName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, e);
                cube.addInvalidCalculatedMember(this, name);
                return null;
            }
        }
        ROLAPCalculatedMember calcMem = null;
        ROLAPCube rolapCube = null;
        try {
            rolapCube = (ROLAPCube)cube;
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_UnexpectedException, (Throwable)e, e.toString());
        }
        String[] identifiers = null;
        ILevel calcLevel = null;
        IMember calcParent = null;
        String parentName = fullParentName;
        IROLAPMember allMember = this.getROLAPAllMember();
        if (fullParentName == null && allMember == null) {
            calcLevel = this.getLevel(0);
        } else {
            if (fullParentName == null && allMember != null) {
                ROLAPHierarchyMemberLoader.logInvalidCalculatedMemberError(rolapCube, (IROLAPHierarchy)this, name, fullParentName, XQEMessageKeys.ROL_InvalidRootCalculatedMember);
                return null;
            }
            int cubeLastIdx = fullParentName.indexOf(".[");
            if (cubeLastIdx == -1) {
                ROLAPHierarchyMemberLoader.logInvalidCalculatedMemberError(rolapCube, (IROLAPHierarchy)this, name, fullParentName, XQEMessageKeys.ROL_CalculatedMemberParentInvalidCubeNamePart);
                return null;
            }
            if (fullParentName.substring(1, cubeLastIdx - 1).equals(rolapCube.getName())) {
                parentName = fullParentName.substring(cubeLastIdx + 1);
            }
            UniqueNameParser unp = new UniqueNameParser();
            try {
                identifiers = unp.parse(parentName);
            }
            catch (UniqueNameParserException e1) {
                String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidCalculatedMemberDefinition, XQEMessages.getCurrProductLocale(), name, this.getUniqueName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, new XQERuntimeException(XQEMessageKeys.ROL_CalculatedMemberParentInvalidIdentifier, (Throwable)e1, fullParentName));
                cube.addInvalidCalculatedMember(this, name);
                return null;
            }
            if (identifiers.length < 2) {
                ROLAPHierarchyMemberLoader.logInvalidCalculatedMemberError(rolapCube, (IROLAPHierarchy)this, name, fullParentName, XQEMessageKeys.ROL_CalculatedMemberParentInvalidIdentifier);
                return null;
            }
            try {
                if (relaTimeMemberType == 0) {
                    try {
                        calcParent = this.findMember(parentName);
                    }
                    catch (Exception e) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_UnexpectedException, (Throwable)e, e.toString());
                    }
                    if (calcParent == null) {
                        ROLAPHierarchyMemberLoader.logInvalidCalculatedMemberError(rolapCube, (IROLAPHierarchy)this, name, fullParentName, XQEMessageKeys.ROL_CalculatedMemberParentNotExist);
                        return null;
                    }
                    if (calcParent instanceof ROLAPDataMember) {
                        ROLAPHierarchyMemberLoader.logInvalidCalculatedMemberError(rolapCube, (IROLAPHierarchy)this, name, fullParentName, XQEMessageKeys.ROL_DataMemberCannotBeCalculatedMemberParent);
                        return null;
                    }
                } else {
                    calcParent = parentMember;
                }
                if ((calcLevel = calcParent.getLevel().getNextLevel()) == null) {
                    ROLAPHierarchyMemberLoader.logInvalidCalculatedMemberError(rolapCube, (IROLAPHierarchy)this, name, calcParent.getUniqueName(), XQEMessageKeys.ROL_CalculatedMemberParentInvalidLevel);
                    return null;
                }
            }
            catch (MetadataException e) {
                String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidCalculatedMemberDefinition, XQEMessages.getCurrProductLocale(), name, this.getUniqueName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, e);
                cube.addInvalidCalculatedMember(this, name);
                return null;
            }
        }
        try {
            calcMem = relaTimeMemberType != 0 ? new ROLAPRelativeTimeMember(name, calcLevel, expression, identifiers, relaTimeMemberType, relaTimeRefMember, metaMember) : new ROLAPCalculatedMember(name, calcLevel, (Object)expression, identifiers, metaCalcMemb);
            if (calcParent != null) {
                calcMem.setParentMember(calcParent);
                calcMem.setParentLevelNumber(calcParent.getLevel().getIndex());
                StringBuilder givenName = new StringBuilder(parentName);
                givenName.append(".[").append(name).append(RIGHT_BRACKET);
                calcMem.setProperty("DefinitionUniqueName", givenName.toString());
                calcMem.setUniqueName(calcParent.getUniqueName() + ".[" + name + RIGHT_BRACKET);
            } else {
                calcMem.setUniqueName(this.getUniqueName() + ".[" + name + RIGHT_BRACKET);
            }
            int solveOrder = -1;
            if (metaCalcMemb != null) {
                ROLAPMetaCube metaCube = null;
                ROLAPMetaCube[] metaCubes = metaCalcMemb.getMdSchema().getCubes();
                String cubeName = rolapCube.getName();
                if (metaCubes.length == 1) {
                    metaCube = metaCubes[0];
                } else {
                    for (ROLAPMetaCube c : metaCubes) {
                        if (!cubeName.equals(c.getName())) continue;
                        metaCube = c;
                    }
                }
                if (metaCube.isCubingServicesCompatible()) {
                    solveOrder = metaCalcMemb.getSolveOrder();
                }
            }
            calcMem.setSolveOrder(solveOrder);
            calcMem.setType(MemberTypeEnum.GLOBAL_CALCULATION);
            String v5Name = UniqueNameGenerator.createMemberV5UniqueName(cube.getName(), calcLevel, calcMem.getUniqueName());
            calcMem.setV5UniqueName(v5Name);
            if (existingCalcMembers == null || existingCalcMembers.add(calcMem.getUniqueName())) {
                try {
                    calcMem.setMemberId(rolapCube.getNextSessionCalculatedMemberID());
                }
                catch (MetadataException me) {
                    String errorMessage = "Unable to create calculated member " + name + " defined in hierarchy " + this.getName() + " because the maximum number of calculated members for cube " + rolapCube.getName() + " has been reached. Check if relative time has been enabled for one or more hierarchies in this cube since relative time members are considered calculated members.";
                    ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, errorMessage);
                    throw new RuntimeException(errorMessage, me);
                }
            } else {
                String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_DuplicateCalculatedMemberName, XQEMessages.getCurrProductLocale(), calcMem.getUniqueName());
                ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, errorMessage);
                return null;
            }
            rolapCube.getMemberCacheInContext().addCalculatedMember(calcMem);
            this.addROLAPCalculatedMembers(rolapCube, calcMem);
        }
        catch (MetadataException e) {
            throw new RuntimeException("Error creating " + name + " Calculated Member.", e);
        }
        return calcMem;
    }

    @Override
    public String createV5UniqueName(String cubeName, String locale) {
        return UniqueNameGenerator.createROLAPV5UniqueName(cubeName, locale, this);
    }

    public void loadMeasureFolders() {
        if (this.getDimension().isMeasuresDimension()) {
            ROLAPCube rolapCube = (ROLAPCube)this.getDimension().getCube();
            ROLAPMetaCube modelCube = rolapCube.getModelCube();
            ROLAPMetaCubeFacts facts = (ROLAPMetaCubeFacts)modelCube.getFirstChildByType(ROLAPMetaCubeFacts.class);
            List<ROLAPMetaObject> metaMeasureItems = facts.getMeasureItems();
            ROLAPMeasureFolder rootMeasureFolder = new ROLAPMeasureFolder(rolapCube, metaMeasureItems);
            rolapCube.setRootMeasureFolder(rootMeasureFolder);
        }
    }

    @Override
    public ArrayList<ROLAPMetaObject> getCustomRelativeTimeMembers() {
        ArrayList<ROLAPMetaObject> retArrayList = new ArrayList<ROLAPMetaObject>();
        int ct = this.metaHierarchy.getChildCount();
        for (int i = 0; i < ct; ++i) {
            ROLAPMetaObject obj = this.metaHierarchy.getChild(i);
            if (!(obj instanceof ROLAPMetaCustomSimpleRelativeTimeMember) && !(obj instanceof ROLAPMetaCustomPTDRelativeTimeMember) && !(obj instanceof ROLAPMetaCustomRollingTotalRelativeTimeMember)) continue;
            retArrayList.add(obj);
        }
        return retArrayList;
    }

    public void setCacheKeyToLevelKeyMap(Map<ICacheKey, ROLAPMember.LevelKeys> map) {
        this.cacheKeyToLevelKeyMap = map;
    }

    public ROLAPMember.LevelKeys getLevelKeys(ICacheKey cacheKey) {
        if (this.cacheKeyToLevelKeyMap != null) {
            return this.cacheKeyToLevelKeyMap.get(cacheKey);
        }
        return null;
    }

    public void setLoadStatus(LoadStatusEnum status) {
        this.loadStatus = status;
    }

    public LoadStatusEnum getLoadStatus() {
        return this.loadStatus;
    }

    public static enum LoadStatusEnum {
        notYetStarted,
        started,
        finished_success,
        finished_failure;

    }
}

