/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheEngine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPMemberCache;
import com.cognos.xqe.util.ILocalizedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ROLAPHierarchyBalancer {
    private final Map<ICacheKey, ICacheKey[]> mPaddingMembersMap = new LinkedHashMap<ICacheKey, ICacheKey[]>();
    private final List<ICacheKey> parentWithPaddedChildrenList = new ArrayList<ICacheKey>();
    private final ROLAPHierarchy mHierarchy;
    private final ROLAPBaseCube mCube;

    public ROLAPHierarchyBalancer(ROLAPHierarchy hierarchy, ROLAPBaseCube cube) {
        this.mHierarchy = hierarchy;
        this.mCube = cube;
    }

    public void collectHierarchyPaddingMembers(ICacheKey memberKey, Map<String, Object> properties, ROLAPLevel level, ICacheKey[] path, int levelIdx) {
        Object cachedObject = properties.get("NAME");
        String name = null;
        if (cachedObject != null) {
            name = cachedObject.toString();
        }
        if (name != null && name.compareTo("") != 0) {
            return;
        }
        if (level.getIndex() == 0 && this.isCubingServicesCompatible()) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_RootPaddingMemberNotSupported, (Object)this.mCube.getName(), (Object)this.mHierarchy.getDimension().getName(), (Object)this.mHierarchy.getName());
        }
        properties.put("PADDING_MEMBER", "1");
        this.adjustPaddingMemberProperties(properties, level, memberKey);
        this.mPaddingMembersMap.put(memberKey, path);
        ICacheKey parentCacheKey = path[levelIdx];
        this.parentWithPaddedChildrenList.add(parentCacheKey);
    }

    public boolean needsPaddingMember(ROLAPMember.LevelKeys thisRowKeys, ICacheKey parentKey) {
        if (thisRowKeys != null) {
            IValue[] keyValues;
            boolean allNull = true;
            for (IValue keyValue : keyValues = thisRowKeys.getKeyValues()) {
                allNull = allNull && keyValue.isNull();
            }
            if (parentKey != null) {
                return allNull && !this.parentWithPaddedChildrenList.contains(parentKey);
            }
        }
        return false;
    }

    public void adjustPaddingMemberCaption() {
        if (this.mPaddingMembersMap.size() == 0) {
            return;
        }
        IROLAPDimension dimension = this.mHierarchy.getROLAPDimension();
        try {
            ROLAPCacheEngine metadataStorage = dimension.getMetadataStorage();
            for (ICacheKey memberKey : this.mPaddingMembersMap.keySet()) {
                String caption;
                if (this.mHierarchy.getFillerCaptionType() == IROLAPHierarchy.FillerCaptionType.BLANK_CAPTION) {
                    caption = " ";
                } else {
                    caption = this.getParentCaption(dimension, memberKey);
                    if (caption == null) {
                        caption = this.getParentName(dimension, memberKey);
                    }
                }
                metadataStorage.setMemberPropValueInCache(memberKey, "CAPTION", caption);
                metadataStorage.setMemberPropValueInCache(memberKey, "NAME", "");
            }
        }
        catch (CacheException cacheException) {
            ROLAPMemberCache.throwCacheGetException(cacheException, this.mCube.getName(), dimension.getName());
        }
        this.mPaddingMembersMap.clear();
    }

    private void adjustPaddingMemberProperties(Map<String, Object> properties, ROLAPLevel level, ICacheKey memberKey) {
        Iterator<IProperty> prop;
        boolean memberPropertiesNotNull = false;
        Map<String, Object> removedProperties = null;
        if (properties.get("BUSINESS_KEY") != null) {
            memberPropertiesNotNull = true;
            prop = properties.remove("BUSINESS_KEY");
            removedProperties = this.addRemovedProperty(removedProperties, "BUSINESS_KEY", prop);
        }
        if (properties.get("DESCRIPTION") != null) {
            memberPropertiesNotNull = true;
            prop = properties.remove("DESCRIPTION");
            removedProperties = this.addRemovedProperty(removedProperties, "DESCRIPTION", prop);
        }
        for (IProperty property : level.getMemberProperties(this.mCube.getName())) {
            if (properties.get(property.getName()) == null) continue;
            memberPropertiesNotNull = true;
            Object prop2 = properties.remove(property.getName());
            removedProperties = this.addRemovedProperty(removedProperties, property.getName(), prop2);
        }
        if (memberPropertiesNotNull && ROLAPLog.isOn("ROLAPCubes.Loader")) {
            String msg = "Hierarchy: [" + level.getHierarchy().getName() + "] Level: [" + level.getName() + "] at key [" + memberKey + "] contains filler member with the following property values removed: " + removedProperties;
            ROLAPLog.log("ROLAPCubes.Loader", msg);
        }
    }

    private Map<String, Object> addRemovedProperty(Map<String, Object> removedProperties, String key, Object prop) {
        if (removedProperties == null) {
            removedProperties = new HashMap<String, Object>();
        }
        removedProperties.put(key, prop);
        return removedProperties;
    }

    private String getParentCaption(IROLAPDimension dimension, ICacheKey memberKey) {
        if (memberKey == null) {
            return null;
        }
        String caption = null;
        try {
            ROLAPCacheEngine metadataStorage = dimension.getMetadataStorage();
            ICacheKey parentKey = (ICacheKey)metadataStorage.getMemberPropValueFromCache(memberKey, "PARENT_MEMBER_CACHE_KEY");
            if (parentKey == null) {
                return null;
            }
            Object obj = metadataStorage.getMemberPropValueFromCache(parentKey, "CAPTION");
            if (obj instanceof ILocalizedString) {
                caption = ((ILocalizedString)obj).toString(this.mCube.getDefaultLocale());
            } else if (obj != null) {
                caption = obj.toString();
            }
        }
        catch (CacheException cacheException) {
            ROLAPMemberCache.throwCacheGetException(cacheException, this.mCube.getName(), dimension.getName());
        }
        return caption;
    }

    private String getParentName(IROLAPDimension dimension, ICacheKey memberKey) {
        if (memberKey == null) {
            return null;
        }
        String name = null;
        try {
            ROLAPCacheEngine metadataStorage = dimension.getMetadataStorage();
            ICacheKey parentKey = (ICacheKey)metadataStorage.getMemberPropValueFromCache(memberKey, "PARENT_MEMBER_CACHE_KEY");
            if (parentKey == null) {
                return null;
            }
            Object cachedObj = metadataStorage.getMemberPropValueFromCache(parentKey, "NAME");
            if (cachedObj != null) {
                name = cachedObj.toString();
            }
        }
        catch (CacheException cacheException) {
            ROLAPMemberCache.throwCacheGetException(cacheException, this.mCube.getName(), dimension.getName());
        }
        return name;
    }

    public void removeExtraneousPaddingMembers(Map<ICacheKey, List<ICacheKey>> memberChildMap, Map<ICacheKey, List<ICacheKey>> levelChildMap, ROLAPCacheEngine storage) {
        if (!this.mHierarchy.isRemoveExtraneousPaddingMembers() || this.mPaddingMembersMap.size() == 0) {
            return;
        }
        HashMap<ICacheKey, ICacheKey> extraneousPathMembers = new HashMap<ICacheKey, ICacheKey>();
        HashMap<ICacheKey, ICacheKey[]> leafPaddingMemberMap = new HashMap<ICacheKey, ICacheKey[]>();
        this.collectLeafPaddingMembers(leafPaddingMemberMap);
        this.collectExtraneousPathMembers(extraneousPathMembers, leafPaddingMemberMap, memberChildMap);
        if (extraneousPathMembers.size() > 0) {
            this.removeCacheMembers(extraneousPathMembers.keySet(), storage);
            this.removeFromMemberChildMap(memberChildMap, extraneousPathMembers);
            this.removeFromLevelChildMap(levelChildMap, extraneousPathMembers.keySet());
            this.removePaddingMembers(this.mPaddingMembersMap, extraneousPathMembers);
            this.mHierarchy.setExtraneousMembersRemoved();
        }
    }

    private void collectLeafPaddingMembers(Map<ICacheKey, ICacheKey[]> leafPaddingMemberMap) {
        for (Map.Entry<ICacheKey, ICacheKey[]> entry : this.mPaddingMembersMap.entrySet()) {
            ICacheKey[] path = entry.getValue();
            ICacheKey paddingMember = entry.getKey();
            int indexOfLeafLevel = path.length - 1;
            if (path[indexOfLeafLevel] == null || paddingMember != path[indexOfLeafLevel]) continue;
            leafPaddingMemberMap.put(paddingMember, path);
        }
    }

    private void removePaddingMembers(Map<ICacheKey, ICacheKey[]> paddingMembersMap, Map<ICacheKey, ICacheKey> extraneousPathMembers) {
        for (ICacheKey key : extraneousPathMembers.keySet()) {
            paddingMembersMap.remove(key);
        }
    }

    private void collectExtraneousPathMembers(Map<ICacheKey, ICacheKey> extraneousPathMembers, Map<ICacheKey, ICacheKey[]> leafPaddingMembers, Map<ICacheKey, List<ICacheKey>> memberChildMap) {
        HashMap<ICacheKey, ICacheKey> extraneousMembers = new HashMap<ICacheKey, ICacheKey>();
        ArrayList<ICacheKey> nonExtraneousPaddingMembers = new ArrayList<ICacheKey>();
        for (Map.Entry<ICacheKey, ICacheKey[]> entry : leafPaddingMembers.entrySet()) {
            ICacheKey[] path = entry.getValue();
            ICacheKey nonPaddingMemberParent = null;
            int i = path.length - 1;
            while (path.length >= 0) {
                ICacheKey parent = null;
                if (i > 0) {
                    parent = path[i - 1];
                }
                if (!this.mPaddingMembersMap.containsKey(path[i])) {
                    nonPaddingMemberParent = path[i];
                    break;
                }
                extraneousMembers.put(path[i], parent);
                --i;
            }
            if (nonPaddingMemberParent != null) {
                this.verifyExtraneousMembersInPath(nonPaddingMemberParent, path, false, nonExtraneousPaddingMembers, memberChildMap);
                if (nonExtraneousPaddingMembers.size() > 0) {
                    for (ICacheKey key : nonExtraneousPaddingMembers) {
                        extraneousMembers.remove(key);
                    }
                }
                extraneousPathMembers.putAll(extraneousMembers);
            }
            extraneousMembers.clear();
            nonExtraneousPaddingMembers.clear();
        }
    }

    private void verifyExtraneousMembersInPath(ICacheKey parent, ICacheKey[] path, boolean bExtraneous, List<ICacheKey> nonExtraneousPaddingMembers, Map<ICacheKey, List<ICacheKey>> memberChildMap) {
        List<ICacheKey> children = memberChildMap.get(parent);
        ICacheKey parentInPath = null;
        ICacheKey nextChildInPath = null;
        for (int i = 0; i < path.length; ++i) {
            if (parentInPath == null) {
                if (path[i] != parent) continue;
                parentInPath = path[i];
                continue;
            }
            nextChildInPath = path[i];
            break;
        }
        if (this.mPaddingMembersMap.containsKey(parent)) {
            if (children != null && children.size() != 0) {
                if (children.size() == 1 && !bExtraneous) {
                    nonExtraneousPaddingMembers.add(parent);
                    bExtraneous = false;
                } else if (children.size() > 1) {
                    nonExtraneousPaddingMembers.add(parent);
                    bExtraneous = true;
                }
            } else if (!bExtraneous) {
                nonExtraneousPaddingMembers.add(parent);
            }
        } else {
            nonExtraneousPaddingMembers.add(parent);
            if (children != null && children.size() != 0) {
                if (children.size() == 1) {
                    bExtraneous = false;
                } else if (children.size() > 1) {
                    bExtraneous = true;
                }
            } else {
                bExtraneous = false;
            }
        }
        if (nextChildInPath != null) {
            this.verifyExtraneousMembersInPath(nextChildInPath, path, bExtraneous, nonExtraneousPaddingMembers, memberChildMap);
        }
    }

    private void removeCacheMembers(Set<ICacheKey> members, ROLAPCacheEngine metadataStorage) {
        try {
            metadataStorage.bulkRemoveMembers(members);
        }
        catch (CacheException e) {
            Dimension d = (Dimension)this.mHierarchy.getDimension();
            ROLAPCacheBase.throwCacheRemoveException(e, this.mCube.getName(), d.getName());
        }
    }

    private void removeFromMemberChildMap(Map<ICacheKey, List<ICacheKey>> childMemberMap, Map<ICacheKey, ICacheKey> members) {
        for (Map.Entry<ICacheKey, ICacheKey> entry : members.entrySet()) {
            List<ICacheKey> children;
            ICacheKey child = entry.getKey();
            ICacheKey parent = entry.getValue();
            if (child == null || parent == null || (children = childMemberMap.get(parent)) == null || !children.contains(child)) continue;
            children.remove(child);
        }
        for (ICacheKey extraneousMemberKey : members.keySet()) {
            childMemberMap.remove(extraneousMemberKey);
        }
    }

    private void removeFromLevelChildMap(Map<ICacheKey, List<ICacheKey>> levelMemberMap, Set<ICacheKey> members) {
        for (ICacheKey extraneousMemberKey : members) {
            if (extraneousMemberKey == null) continue;
            for (List<ICacheKey> levelMembers : levelMemberMap.values()) {
                if (levelMembers != null && levelMembers.contains(extraneousMemberKey)) break;
            }
        }
    }

    private boolean isCubingServicesCompatible() {
        return this.mCube.isCubingServicesCompatible();
    }
}

