/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.AllocationRule;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.metadata.IAggregateMeasure;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.NameCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.NameCacheNameProvider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAggregationRule;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class ROLAPMeasure
extends ROLAPMember
implements IROLAPMeasure,
IAggregateMeasure,
NameCacheNameProvider {
    ROLAPMetaMeasure rolapMeasure;
    protected AggregateTypeEnum aggregationType = AggregateTypeEnum.UNKNOWN;
    protected ArrayList<IAggregateRule> aggregationRules;
    private final NameCache v5UniqueNameCache = new NameCache(this);

    @Override
    public String getAggregateRule() {
        if (this.rolapMeasure instanceof ROLAPMetaCalculatedMeasure) {
            return ((ROLAPMetaCalculatedMeasure)this.rolapMeasure).getAggregation();
        }
        return null;
    }

    public ROLAPMeasure(String name, Level level, ROLAPMetaMeasure measure) {
        super(name, level, null);
        this.rolapMeasure = measure;
        this.setROLAPAggregationRules();
    }

    @Override
    public MetadataConnection getConnection() {
        return this.getLevel().getDimension().getCube().getConnection();
    }

    @Override
    public OrderedMap<IMember> fetchChildMembers() throws MetadataException, ProviderException {
        return null;
    }

    @Override
    public int getROLAPType() {
        return 3;
    }

    @Override
    public boolean isMeasure() {
        return true;
    }

    @Override
    public boolean isSemiAggregate() {
        return this.getAggregateRules().length > 0;
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        return this.aggregationType;
    }

    @Override
    protected void setDefaultProperties() {
        super.setDefaultProperties();
        this.setProperty("display format", "Standard");
        this.setProperty("AggregationType", this.aggregationType.toMDDSType());
    }

    protected void setROLAPAggregationRules() {
        ROLAPMetaMeasure measure;
        IMetadata metadata;
        MetadataConnection mdConnection = this.getConnection();
        this.aggregationRules = new ArrayList();
        if (mdConnection != null && (metadata = mdConnection.bindMetadataReference((measure = this.getROLAPMetaMeasure()).getQueryItem())) != null) {
            if (metadata.getObjectType() == MetadataType.CALCULATION) {
                ICalculation calculation = (ICalculation)metadata;
                this.aggregationType = AggregateTypeEnum.valueOfModelString(calculation.getRegularAggregate());
            } else if (metadata.getObjectType() == MetadataType.QUERY_ITEM) {
                IQueryItem queryItem = (IQueryItem)metadata;
                this.aggregationType = AggregateTypeEnum.valueOfModelString(queryItem.getRegularAggregate());
            }
            ROLAPMetaAggregation[] aggrRules = this.rolapMeasure.getAggregations();
            if (aggrRules.length > 0) {
                for (ROLAPMetaAggregation aggregation : aggrRules) {
                    AggregateTypeEnum aggType = AggregateTypeEnum.valueOfModelString(aggregation.getAggrFunction());
                    ROLAPMetaDimension[] rolapDims = aggregation.getDimensions();
                    if (rolapDims == null || rolapDims.length <= 0) continue;
                    String[] dimNames = new String[rolapDims.length];
                    int dimNdx = 0;
                    for (ROLAPMetaDimension dimRef : rolapDims) {
                        dimNames[dimNdx++] = dimRef.getName();
                    }
                    this.aggregationRules.add(new ROLAPAggregationRule(aggType, dimNames));
                }
            }
        }
        this.setProperty("AggregationType", this.aggregationType.toMDDSType());
    }

    public String getQueryItemExpression() {
        return this.getROLAPMetaMeasure().getQueryItem();
    }

    public String getRelationalQueryItemExpression() {
        IQueryItem queryItem = this.getRelationalQueryItem();
        if (null != queryItem) {
            String expression = queryItem.getExpression();
            if (null != expression) {
                return expression;
            }
            return (String)queryItem.getProperty("ID");
        }
        return null;
    }

    public IQueryItem getRelationalQueryItem() {
        ROLAPMetaMeasure measure;
        IMetadata metadata;
        MetadataConnection mdConnection = this.getConnection();
        if (mdConnection != null && (metadata = mdConnection.bindMetadataReference((measure = this.getROLAPMetaMeasure()).getQueryItem())) != null && metadata.getObjectType() == MetadataType.QUERY_ITEM) {
            IQueryItem queryItem = (IQueryItem)metadata;
            queryItem.getQuerySubject();
            return queryItem;
        }
        return null;
    }

    public ROLAPMetaMeasure getROLAPMetaMeasure() {
        return this.rolapMeasure;
    }

    @Override
    public String getDescription() {
        return super.getDescriptionValue().toString();
    }

    public String getModelAggregateType() {
        return this.aggregationType.getModelName();
    }

    @Override
    public IAggregateRule[] getAggregateRules() {
        return this.aggregationRules.toArray(new IAggregateRule[this.aggregationRules.size()]);
    }

    @Override
    public String getV5UniqueName() {
        return this.v5UniqueNameCache.getV5UniqueName(ROLAPUtilities.getExpressionLocale(this));
    }

    public String getName(String locale) {
        String localizedName = null;
        if (this.getROLAPMetaMeasure() != null) {
            localizedName = this.getROLAPMetaMeasure().getName(locale);
        }
        if (localizedName == null) {
            localizedName = this.getName();
        }
        return localizedName;
    }

    @Override
    public String getV5UniqueCaption() {
        String part1 = UniqueNameGenerator.createMemberV5ModelPart(this.getHierarchy());
        String part2 = UniqueNameGenerator.createUniqueName(this.getDefaultCaption());
        return UniqueNameGenerator.join(part1, part2);
    }

    @Override
    public IScopeRelationship getScopeRelationship(IMetadata dimension) {
        return null;
    }

    @Override
    public String getQueryItemExpression(PlanningEnvironment planEnv) {
        return this.getQueryItemExpression();
    }

    @Override
    public String getV5AggregateAttribute() {
        return this.aggregationType.toV5Type();
    }

    @Override
    public String getV5AggregateForModelAggregate() {
        return this.aggregationType.toV5Type();
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public String getUnits() {
        return null;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        ILocalizedString captions = null;
        if (this.getROLAPMetaMeasure() != null) {
            captions = this.getROLAPMetaMeasure().getNames();
        }
        if (captions == null) {
            captions = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPCube().getDefaultLocale(), this.getName());
        }
        return captions;
    }

    @Override
    public ILocalizedString getLocalizedName() {
        ILocalizedString names = null;
        if (this.getROLAPMetaMeasure() != null) {
            names = this.getROLAPMetaMeasure().getNames();
        }
        if (names == null) {
            names = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPCube().getDefaultLocale(), this.getName());
        }
        return names;
    }

    @Override
    public ILocalizedString getLocalizedDescription() {
        ILocalizedString descriptions = null;
        if (this.getROLAPMetaMeasure() != null) {
            descriptions = this.getROLAPMetaMeasure().getDescriptions();
        }
        if (descriptions == null) {
            descriptions = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPCube().getDefaultLocale(), this.getName());
        }
        return descriptions;
    }

    @Override
    public String getCaption() {
        String runLocaleCaption = null;
        if (this.getROLAPMetaMeasure() != null) {
            Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
            String locale = LocaleConverter.localeToStr(runLocale);
            runLocaleCaption = this.getROLAPMetaMeasure().getName(locale);
            if (runLocaleCaption == null) {
                runLocaleCaption = this.getROLAPMetaMeasure().getName(this.getROLAPMetaMeasure().getDefaultLocale());
            }
        }
        if (runLocaleCaption == null) {
            runLocaleCaption = this.getName();
        }
        return runLocaleCaption;
    }

    public String getDefaultCaption() {
        String defaultCaption = null;
        if (this.getROLAPMetaMeasure() != null) {
            defaultCaption = this.getROLAPMetaMeasure().getCaption(this.getROLAPMetaMeasure().getDefaultLocale());
        }
        if (defaultCaption == null) {
            defaultCaption = this.getName();
        }
        return defaultCaption;
    }

    @Override
    public FormatId getFormatId() {
        if (this.getROLAPMetaMeasure() != null) {
            return this.getROLAPMetaMeasure().getFormatId();
        }
        return null;
    }

    @Override
    public boolean isVisible() {
        return this.getROLAPMetaMeasure().isVisible();
    }

    @Override
    public boolean isHidden() {
        return !this.isVisible();
    }

    public boolean containsFirstLastAggregateRule() {
        for (IAggregateRule rule : this.getAggregateRules()) {
            if (rule.getAggregate() != AggregateTypeEnum.FIRST && rule.getAggregate() != AggregateTypeEnum.LAST && rule.getAggregate() != AggregateTypeEnum.CURRENTPERIOD) continue;
            return true;
        }
        return false;
    }

    public boolean containsNonFirstLastAggregateRule() {
        for (IAggregateRule rule : this.getAggregateRules()) {
            if (rule.getAggregate() == AggregateTypeEnum.FIRST || rule.getAggregate() == AggregateTypeEnum.LAST || rule.getAggregate() == AggregateTypeEnum.CURRENTPERIOD) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCustomMeasures(Collection<IMember> measures) {
        boolean containsOneCustomMeasure = false;
        if (measures.size() == 1) {
            for (IMember measure : measures) {
                AggregateTypeEnum aggrType = ((ROLAPMeasure)measure).getRegularAggregate();
                containsOneCustomMeasure = aggrType == AggregateTypeEnum.UNKNOWN;
            }
        }
        return containsOneCustomMeasure;
    }

    public static boolean matchesMeasure(IROLAPMeasure measure, List<String> identifersInCalcExpressionList) {
        for (String identifier : identifersInCalcExpressionList) {
            if (!measure.getV5UniqueCaption().equals(identifier) && !measure.getV5UniqueName().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String createV5UniqueName(String cubeName, String locale) {
        String name = this.getName(locale);
        String part1 = UniqueNameGenerator.createMemberV5ModelPart(this.getHierarchy());
        String part2 = UniqueNameGenerator.createUniqueName(name);
        return UniqueNameGenerator.join(part1, part2);
    }

    @Override
    public IQuerySubject getQuerySubject() {
        return null;
    }

    @Override
    public String getExpression() {
        return null;
    }

    @Override
    public IScopeRelationship[] getScopeRelationships() {
        return new IScopeRelationship[0];
    }

    @Override
    public AllocationRule getAllocationRule() {
        return null;
    }

    @Override
    public boolean isMFWMeasure() {
        return false;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public Integer getSolveOrder() {
        return null;
    }
}

