/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.data.providers.relational.jdbc.util.DirectAccessJDBCValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPCommonMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDataMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberOperations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

public class ROLAPMember
extends Member
implements IROLAPMember,
IROLAPCommonMember {
    private static final String OPEN_BRACE = "[";
    private static final String CLOSE_BRACE = "]";
    public static final String MEMBER_CAPTION = "CAPTION";
    public static final String MEMBER_DESCRIPTION = "DESCRIPTION";
    public static final String MEMBER_KEY = "MEMBER_KEY";
    public static final String PADDING_MEMBER = "PADDING_MEMBER";
    public static final String SECURITY_PADDING_MEMBER = "SECURITY_PADDING_MEMBER";
    private static AtomicInteger maxMemberID = new AtomicInteger(0);
    private LevelKeys levelKeys;
    private ROLAPDataMember dm = null;
    private IROLAPMember parent = null;
    private boolean isPaddingMember = false;
    private boolean isSecPaddingMember = false;

    public ROLAPMember(String name, Level level, LevelKeys lKeys) {
        super(name, level);
        this.caption = name;
        this.setMemberId(maxMemberID.getAndIncrement());
        this.levelKeys = lKeys;
        this.setInitialised();
    }

    @Override
    public MetadataConnection getConnection() {
        return this.getLevel().getDimension().getCube().getConnection();
    }

    @Override
    public Object getBusinessKey() {
        return this.name;
    }

    protected void setParentMember(Member p) {
        super.setParentMember(p);
    }

    @Override
    public IMember getDataMember() {
        if (this.dm == null) {
            return super.getDataMember();
        }
        return this.dm;
    }

    public void setDataMember(ROLAPDataMember dataMember) {
        this.dm = dataMember;
    }

    public OrderedMap fetchChildMembers() throws MetadataException, ProviderException {
        throw new UnsupportedOperationException("ROLAPMember.fetchChildMembers not supported");
    }

    @Override
    public LevelKeys getLevelKeys() {
        return this.levelKeys;
    }

    @Override
    public int getROLAPChildrenCount() {
        ArrayList<IMember> relationList = new ArrayList<IMember>();
        try {
            this.getRelationsOf(1, true, relationList);
        }
        catch (Exception ex) {
            relationList.clear();
        }
        return relationList.size();
    }

    @Override
    public String getDefaultLocale() {
        return this.getROLAPDimension().getROLAPCube().getDefaultLocale();
    }

    @Override
    public ROLAPDimension getROLAPDimension() {
        return (ROLAPDimension)this.getLevel().getDimension();
    }

    @Override
    public ROLAPHierarchy getROLAPHierarchy() {
        return (ROLAPHierarchy)this.getLevel().getHierarchy();
    }

    @Override
    public int getROLAPOrdinal() {
        int index = this.getIndex();
        return index;
    }

    @Override
    public IROLAPMember getROLAPParent() {
        if (this.parent != null) {
            return this.parent;
        }
        ArrayList<IMember> relationList = new ArrayList<IMember>();
        ROLAPMember member = this;
        try {
            ROLAPMemberOperations.getRelationsOf(member, 4, true, relationList);
        }
        catch (Exception ex) {
            relationList.clear();
        }
        if (relationList.isEmpty()) {
            return null;
        }
        this.parent = (IROLAPMember)relationList.get(0);
        return this.parent;
    }

    @Override
    public int getROLAPParentCount() {
        if (this.getROLAPParent() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public Object getProperty(String propertyName) {
        Object value = super.getProperty(propertyName);
        if (null == value && propertyName.startsWith(OPEN_BRACE) && propertyName.endsWith(CLOSE_BRACE)) {
            try {
                propertyName = UniqueNameParser.parseLastIdentifier(propertyName);
            }
            catch (UniqueNameParserException uniqueNameParserException) {
                // empty catch block
            }
            if (null != propertyName) {
                value = super.getProperty(propertyName);
            }
        }
        return value;
    }

    @Override
    public void getRelationsOf(int treeOp, boolean includeCalcMembers, ArrayList<IMember> relationList) throws Exception {
        ROLAPMemberOperations.getRelationsOf(this, treeOp, includeCalcMembers, relationList);
    }

    @Override
    public int getROLAPType() {
        if (this.isCalculatedMember()) {
            return 4;
        }
        if (this.isMeasure()) {
            return 3;
        }
        if (this.getROLAPLevel().isAllLevel()) {
            return 2;
        }
        return 1;
    }

    @Override
    public List<ROLAPCalculatedMember> getROLAPCalculatedMembers(boolean includeCalcMembers) {
        return CollectionCast.uncheckedCast(((ROLAPCube)this.getLevel().getDimension().getCube()).getCalculations(this));
    }

    @Override
    public Pair[] getSourceMembers() {
        Pair[] result = new Pair[]{new Pair(this, XQEIntegerPool.getInteger(0))};
        return result;
    }

    public ROLAPCube getROLAPCube() {
        return (ROLAPCube)this.getLevel().getDimension().getCube();
    }

    @Override
    public IROLAPLevel getROLAPLevel() {
        return (IROLAPLevel)this.getLevel();
    }

    @Override
    public String getV5UniqueName() {
        return this.getV5UniqueName(null);
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        this.v5UniqueName = UniqueNameGenerator.createMemberV5UniqueName(cubeName, this.getLevel(), this.getUniqueName());
        return this.v5UniqueName;
    }

    @Override
    public boolean isPaddingMember() {
        return this.isPaddingMember;
    }

    public void setIsPaddingMember(boolean isPadding) {
        this.isPaddingMember = isPadding;
    }

    @Override
    public boolean isSecurityPaddingMember() {
        return this.isSecPaddingMember;
    }

    @Override
    public void setSecurityPaddingMember(boolean paddingMember) {
        this.isSecPaddingMember = paddingMember;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        return LocalizedString.emptyString();
    }

    @Override
    public ILocalizedString getLocalizedName() {
        return LocalizedString.emptyString();
    }

    @Override
    public ILocalizedString getLocalizedDescription() {
        return LocalizedString.emptyString();
    }

    @Override
    public List<IMember> getAllChildren(String cubeName) throws MetadataException, ProviderException {
        throw new UnsupportedOperationException("ROLAPmember.getAllChildren not supported");
    }

    public static class LevelKeys
    implements Serializable {
        private static final long serialVersionUID = 2066564625300467903L;
        private static final String NULL_STRING = "null";
        public static final String KEY_SEPARATOR = "?";
        public static final String ESCAPED_KEY_SEPARATOR = "??";
        protected IValue[] mKeyValues;
        private int hashCode;

        public LevelKeys(IValue[] keyValues) {
            this.mKeyValues = keyValues;
        }

        public LevelKeys(IValue[] keyValues, ROLAPLevel level) {
            for (IValue val : keyValues) {
                level.cacheObjectString(val);
            }
            this.mKeyValues = keyValues;
        }

        public LevelKeys(int numValues) {
            this.mKeyValues = new IValue[numValues];
        }

        public IValue[] getKeyValues() {
            return this.mKeyValues;
        }

        public void setKeyValue(IValue keyValue, int idx) {
            this.mKeyValues[idx] = keyValue;
            this.hashCode = 0;
        }

        public void setKeyValues(IValue[] keyValues) {
            this.mKeyValues = keyValues;
            this.hashCode = 0;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof LevelKeys)) {
                return false;
            }
            if (this.mKeyValues[0] instanceof DirectAccessJDBCValue) {
                return Arrays.equals(this.mKeyValues, ((LevelKeys)that).mKeyValues);
            }
            return Arrays.equals(((LevelKeys)that).mKeyValues, this.mKeyValues);
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            int retVal = 0;
            if (this.mKeyValues != null) {
                for (int i = 0; i < this.mKeyValues.length; ++i) {
                    if (this.mKeyValues[i] == null) continue;
                    retVal += this.mKeyValues[i].hashCode();
                }
            }
            this.hashCode = retVal;
            return retVal;
        }

        public String toString() {
            String strValue = "<Member Keys: ";
            for (int i = 0; i < this.mKeyValues.length; ++i) {
                if (i > 0) {
                    strValue = strValue + ",";
                }
                strValue = this.mKeyValues[i] == null ? strValue + NULL_STRING : strValue + this.mKeyValues[i].toString();
            }
            strValue = strValue + ">";
            return strValue;
        }

        public String[] getStringValues() {
            String[] stringVals = new String[this.mKeyValues.length];
            for (int i = 0; i < this.mKeyValues.length; ++i) {
                stringVals[i] = this.mKeyValues[i] != null ? this.mKeyValues[i].toString() : NULL_STRING;
            }
            return stringVals;
        }

        public String getMUNKeyIdentifier(boolean[] bMUNKeys) {
            if (bMUNKeys == null) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            boolean foundIdentifier = false;
            for (int i = 0; i < bMUNKeys.length; ++i) {
                String idValue = "";
                if (!bMUNKeys[i]) continue;
                if (this.mKeyValues[i] != null && !this.mKeyValues[i].isNull()) {
                    idValue = this.mKeyValues[i].toString();
                }
                idValue = StringUtils.replace((String)idValue, (String)KEY_SEPARATOR, (String)ESCAPED_KEY_SEPARATOR);
                if (foundIdentifier) {
                    result.append(KEY_SEPARATOR);
                } else {
                    foundIdentifier = true;
                }
                result.append(idValue);
            }
            return result.toString();
        }
    }
}

