/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPNamedSet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaNamedSet;
import com.cognos.xqe.transformation.olap.XQEOlapPlanningException;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.List;
import java.util.Locale;

public class ROLAPNamedSet
extends Metadata
implements IROLAPNamedSet {
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private final ICube parentCube;
    private final ROLAPMetaNamedSet metaNamedSet;
    private final String expression;
    private IMember firstMember = null;

    public ROLAPNamedSet(ICube cube, ROLAPMetaNamedSet metaNS) {
        this.parentCube = cube;
        this.metaNamedSet = metaNS;
        this.expression = this.metaNamedSet.getExpression();
        this.setName(this.metaNamedSet.getName());
        this.setUniqueName(LEFT_BRACKET + this.getName() + RIGHT_BRACKET);
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        ILocalizedString captions = this.metaNamedSet.getCaptions();
        if (captions == null) {
            captions = this.metaNamedSet.getNames();
        }
        if (captions == null) {
            captions = AbstractSingleLocaleString.getSingleLocaleString(((ROLAPCube)this.getCube()).getDefaultLocale(), this.getCaption());
        }
        return captions;
    }

    @Override
    public String getCaption() {
        Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
        String locale = LocaleConverter.localeToStr(runLocale);
        String theCaption = this.metaNamedSet.getCaption(locale);
        if (theCaption == null) {
            theCaption = this.metaNamedSet.getCaption(this.metaNamedSet.getDefaultLocale());
        }
        if (theCaption != null) {
            return theCaption;
        }
        if (this.caption != null) {
            return this.caption;
        }
        return this.getName();
    }

    @Override
    public String getV5UniqueName() {
        Locale expressionLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getExpressionLocale();
        String locale = LocaleConverter.localeToStr(expressionLocale);
        String caption = null;
        caption = this.metaNamedSet.getCaption(locale);
        if (caption == null) {
            caption = this.getCaption();
        }
        String part1 = UniqueNameGenerator.createUniqueName(this.getCube().getName());
        String part2 = UniqueNameGenerator.createUniqueName(caption);
        return UniqueNameGenerator.join(part1, part2);
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public IMember getFirstMember() {
        return this.firstMember;
    }

    @Override
    public void setFirstMember(IMember member) {
        this.firstMember = member;
    }

    @Override
    public String getDisplayPath() {
        return this.metaNamedSet.getDisplayPath();
    }

    @Override
    public ILocalizedString getLocalizedDisplayPath() {
        return this.metaNamedSet.getLocalizedDisplayPath();
    }

    @Override
    public ICube getCube() {
        return this.parentCube;
    }

    @Override
    public IDimension getDimension() {
        return null;
    }

    @Override
    public IHierarchy getHierarchy() {
        return null;
    }

    @Override
    public List<ILevel> getLevels() {
        return null;
    }

    @Override
    public IXQEQueryNode getSet(PlanningEnvironment environment, MetadataConnection mdConnection, MDXQuery mdxQuery) throws XQEOlapPlanningException {
        return null;
    }
}

