/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessageKeys_not_retranslatable;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.metadata.Property;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPProperty;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAllLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.List;
import java.util.Locale;

public class ROLAPProperty
extends Property
implements IROLAPProperty {
    public static final String MEMBER_KEY_PROPERTY_NAME = "MEMBER_KEY";
    public static final String SPACE = " ";
    private final ROLAPMetaAttribute metaAttribute;

    private String constructPropertyCaption(String locale, String propertyName) {
        if (propertyName == null || locale == null) {
            return super.getCaption();
        }
        StringBuilder newCaption = new StringBuilder();
        Locale localeObject = LocaleConverter.strToLocale(locale);
        if (this.getUniqueName().equals(MEMBER_KEY_PROPERTY_NAME)) {
            newCaption.append(propertyName);
            newCaption.append(SPACE + XQEMessages.getMessage(XQEMessageKeys_not_retranslatable.LOC_KEY_SUFFIX, localeObject));
        } else {
            newCaption.append(propertyName);
        }
        return newCaption.toString();
    }

    public ROLAPProperty(String name, ROLAPMetaAttribute theMetaAttribute) {
        super(name);
        this.metaAttribute = theMetaAttribute;
    }

    public final ROLAPMetaAttribute getMetaAttribute() {
        if (this.getLevel().getDimension().isShareable()) {
            ROLAPHierarchy rolapHierarchy = (ROLAPHierarchy)this.getROLAPHierarchy();
            if (rolapHierarchy.isRecursive()) {
                List<ROLAPMetaAttribute> relatedAttributes = rolapHierarchy.getRecursiveParentMetaLevel().getRelatedAttributes();
                ROLAPMetaAttribute foundAttribute = this.findMetaAttribute(relatedAttributes);
                if (foundAttribute != null) {
                    return foundAttribute;
                }
                relatedAttributes = rolapHierarchy.getRecursiveMemberMetaLevel().getRelatedAttributes();
                foundAttribute = this.findMetaAttribute(relatedAttributes);
                if (foundAttribute != null) {
                    return foundAttribute;
                }
            } else {
                List<ROLAPMetaAttribute> relatedAttributes = this.getROLAPLevel().getMetaLevel().getRelatedAttributes();
                ROLAPMetaAttribute foundAttribute = this.findMetaAttribute(relatedAttributes);
                if (foundAttribute != null) {
                    return foundAttribute;
                }
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot find meta attribute for property: " + this.getName() + " for cube: " + this.getLevel().getDimension().getCube().getName());
        }
        return this.metaAttribute;
    }

    protected ROLAPMetaAttribute findMetaAttribute(List<ROLAPMetaAttribute> relatedAttributes) {
        if (relatedAttributes != null && relatedAttributes.size() > 0) {
            for (int ix = 0; ix < relatedAttributes.size(); ++ix) {
                ROLAPMetaAttribute relatedAttrib = relatedAttributes.get(ix);
                String propName = relatedAttrib.getName();
                if (!propName.equals(this.getName())) continue;
                return relatedAttrib;
            }
        }
        return null;
    }

    @Override
    public IDataType getDataType() {
        if (null != this.metaAttribute) {
            return this.metaAttribute.getDataType();
        }
        return StringType.DEFAULTSTRINGTYPE;
    }

    @Override
    public IROLAPHierarchy getROLAPHierarchy() {
        return (IROLAPHierarchy)this.getHierarchy();
    }

    @Override
    public IROLAPLevel getROLAPLevel() {
        return (IROLAPLevel)this.getLevel();
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = UniqueNameGenerator.createUniqueName(this.getName());
            if (this.hierarchy != null && this.hierarchy.isParentChild()) {
                this.uniqueName = UniqueNameGenerator.join(this.hierarchy.getUniqueName(), this.uniqueName);
            } else if (this.level != null) {
                this.uniqueName = UniqueNameGenerator.join(this.level.getUniqueName(), this.uniqueName);
            }
        }
        return this.uniqueName;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        ILocalizedString propertyCaption = null;
        ILocalizedString revisedCaption = null;
        if (!this.getLevel().getHierarchy().isParentChild() && this.getLevel().isRootLevel() && this.getLevel() instanceof ROLAPAllLevel) {
            ROLAPAllLevel allLevel = (ROLAPAllLevel)this.getLevel();
            propertyCaption = allLevel.getLocalizedCaption();
        } else if (this.getUniqueName().equals(MEMBER_KEY_PROPERTY_NAME)) {
            propertyCaption = this.getHierarchy().isParentChild() ? ((IROLAPHierarchy)this.getHierarchy()).getLocalizedCaption() : ((IROLAPLevel)this.getLevel()).getLocalizedCaption();
        } else if (this.getMetaAttribute() != null) {
            propertyCaption = this.getMetaAttribute().getNames();
        }
        if (propertyCaption != null) {
            String defaultLocale = propertyCaption.getDefaultLocale();
            String defaultCaption = this.constructPropertyCaption(defaultLocale, propertyCaption.toString());
            revisedCaption = new LocalizedString(defaultLocale, defaultCaption);
            for (String locale : propertyCaption.getSupportedLocales()) {
                String localeCaption = propertyCaption.toString(locale);
                revisedCaption.put(locale, this.constructPropertyCaption(locale, localeCaption));
            }
        }
        if (revisedCaption == null) {
            revisedCaption = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPLevel().getROLAPDimension().getROLAPCube().getDefaultLocale(), super.getCaption());
        }
        return revisedCaption;
    }
}

