/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.SQLQueryMetrics;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.parameters.RequestParameters;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPCommonMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQueryResultIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCompoundKeyMapping;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryResultIteratorFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.RolapQueryHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateDimensionRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateHierarchyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateLevelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateMeasureRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMdSchema;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaQueryItem;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.RolapV5Builder;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IncrementManager;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderAggregateCombination;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQuery;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryResult;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import com.cognos.xqe.util.primitive.IteratorInt;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.StringWriter;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ROLAPQuery
extends V5ProviderQuery
implements IROLAPQuery {
    private static XQELogger sLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPQuery", LogLevel.TRACE);
    private static XQELogger aggrLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPQuery.AggregateStrategy", LogLevel.TRACE);
    public static final String XQEQUERYNODE_BOOL_PROP_FALSE = "false";
    public static final String XQEQUERYNODE_BOOL_PROP_TRUE = "true";
    private String name = null;
    private boolean isLowestLevels = false;
    private final ListMultimap<IROLAPQuery.QueryTarget, ROLAPMetaAttribute> levelKeySelections;
    protected HashMap<ROLAPMetaAttribute, Collection<IValue>> levelKeyFilters;
    protected Map<ROLAPMetaAttribute, String> aggrCubeLevelKeyToQueryItem;
    private final List<ROLAPMetaObject> sortAttributes;
    protected ArrayList<ROLAPMeasure> measureSelections;
    private final ROLAPMetaMdSchema metaMdSchema;
    private ArrayList<String[]> dataItemsInfo;
    private ArrayList<String[]> aggTableDataItemsInfo;
    private Map<String, String> dataItemNameToAggregateType;
    private boolean usingExternalAggregateTable = false;
    private boolean aggregateFactUnionQuery = false;
    private IMember[] outputTuple = null;
    private final ROLAPBaseCube cube;
    protected ArrayList<ROLAPCompoundKeyMapping> compoundKeyMappings = null;
    protected final ArrayList<ROLAPCompoundKeyMapping> pchCompoundKeyMappings = new ArrayList();
    private final String id;
    private AggregateAnalysisInfo aggregateInfo = null;
    public static final int IN_EXPR_SET_SIZE = 250;
    public static final String BEGIN_IN_EXPR = " in (";
    public static final String END_OR_EXPR = ") or ";
    public static final String IS_NULL_EXPR = " is NULL";
    public static final String OR_EXPR = " or ";
    public static final String AND_EXPR = " and ";
    public static final String BETWEEN_EXPR = " between ";
    public static final String PARAMETER_MARKER = "?";
    public static final String PARAMETER_NAME_PMIN = "pMin";
    public static final String PARAMETER_NAME_PMAX = "pMax";
    public static final String PARAMETER_NAME_PREFIX = "p";
    private static final int MIN_BETWEEN_ELEMENTS = 1000;
    protected HashMap<String, ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>>> extraFilterList = null;
    protected HashMapIntObject<ArrayList<ROLAPCompoundKeyMapping>> extraAggregationFilters = null;
    protected HashMapIntObject<ArrayList<ROLAPCompoundKeyMapping>> aggregationCombinationFilters = null;
    private final List<String> valueFilterExpressions = new ArrayList<String>();
    private final List<IROLAPCommonMember> mExcludedMembers;
    private V5ProviderAggregateCombination flAggregateMemberFilter = null;
    private List<List<IMember>> flAggregateMemberPerHierarchy = null;
    private WorkloadLogger workloadLogger = null;
    private final SQLQueryMetrics queryMetrics = new SQLQueryMetrics();
    private HashSet<ILevel> aggregateLevels = new HashSet();
    protected List<String> dimFactJoinFilters = null;
    private Integer xmdxNodeId = 0;
    private boolean computeAggregationOnly;
    private boolean returnContextTuple;
    private final boolean useFactTableOnly;
    private final boolean includeIncrementalPredicate;
    private HashSet<ROLAPMetaAttribute> levelKeyFiltersToBeParameterized = null;
    private Parameters filterParameters = null;

    public void setExtraAggregateFilters(HashMapIntObject<ArrayList<ROLAPCompoundKeyMapping>> extraAggregateFilters) {
        this.extraAggregationFilters = extraAggregateFilters;
    }

    public void setAggregateCombinationFilters(HashMapIntObject<ArrayList<ROLAPCompoundKeyMapping>> aggregateCombinationFilters) {
        this.aggregationCombinationFilters = aggregateCombinationFilters;
    }

    public HashMapIntObject<ArrayList<ROLAPCompoundKeyMapping>> getAggregateCombinationFilters() {
        return this.aggregationCombinationFilters;
    }

    public void setAggregateLevels(HashSet<ILevel> levels) {
        this.aggregateLevels = levels;
    }

    public ROLAPBaseCube getQueryCube() {
        return this.cube;
    }

    protected void addLevelKeyFilterToBeParameterized(ROLAPMetaAttribute levelKey) {
        if (this.levelKeyFiltersToBeParameterized == null) {
            this.levelKeyFiltersToBeParameterized = new HashSet();
        }
        this.levelKeyFiltersToBeParameterized.add(levelKey);
    }

    private boolean shouldUseParameters(ROLAPMetaAttribute levelKey) {
        if (this.levelKeyFiltersToBeParameterized != null) {
            return this.levelKeyFiltersToBeParameterized.contains(levelKey);
        }
        return false;
    }

    private String getNameToUseInV5(String queryName) {
        if (this.levelKeyFiltersToBeParameterized != null) {
            return "QueryP";
        }
        return queryName;
    }

    public ROLAPQuery(String queryName, ROLAPMetaMdSchema schema, ROLAPBaseCube aCube, boolean computeAggOnly, boolean factTableOnly, boolean includeIncrementalFilter) {
        this.name = queryName;
        this.metaMdSchema = schema;
        this.cube = aCube;
        this.computeAggregationOnly = computeAggOnly;
        this.useFactTableOnly = factTableOnly;
        this.includeIncrementalPredicate = includeIncrementalFilter && this.cube.getIncrementManagerInContext().isIncrementalUpdatesEnabled();
        this.levelKeySelections = ArrayListMultimap.create();
        this.levelKeyFilters = new LinkedHashMap<ROLAPMetaAttribute, Collection<IValue>>();
        this.extraFilterList = new HashMap();
        this.sortAttributes = new ArrayList<ROLAPMetaObject>();
        this.measureSelections = new ArrayList();
        this.dimFactJoinFilters = new ArrayList<String>();
        this.mExcludedMembers = new ArrayList<IROLAPCommonMember>();
        this.id = new UID().toString();
        if (this.cube.getWorkloadLogger().isLoggingQueries()) {
            this.workloadLogger = this.cube.getWorkloadLogger();
        }
    }

    public ROLAPQuery(String queryName, ROLAPMetaMdSchema schema, ROLAPBaseCube aCube, boolean computeAggOnly) {
        this(queryName, schema, aCube, computeAggOnly, false, true);
    }

    public boolean isComputeAggregationOnly() {
        return this.computeAggregationOnly;
    }

    public void setComputeAggregationOnly(boolean value) {
        this.computeAggregationOnly = value;
    }

    public void setReturnContextTuple(boolean value) {
        this.returnContextTuple = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    @Override
    public List<ROLAPMetaAttribute> getAttributeSelections(IROLAPQuery.QueryTarget target) {
        List combinedAttributesForTarget = this.levelKeySelections.get((Object)IROLAPQuery.QueryTarget.COMMON);
        if (target != IROLAPQuery.QueryTarget.COMMON) {
            combinedAttributesForTarget.addAll(this.levelKeySelections.get((Object)target));
        }
        return combinedAttributesForTarget;
    }

    @Override
    public int addAttributeAvoidingDuplicates(ROLAPMetaAttribute metaAttribute, IROLAPQuery.QueryTarget target) {
        return metaAttribute.addAttributeAvoidingDuplicates(this, target);
    }

    @Override
    public void addSortAttribute(ROLAPMetaObject metaObject) {
        if (!this.sortAttributes.contains(metaObject)) {
            this.sortAttributes.add(metaObject);
        }
    }

    public void addMeasure(ROLAPMeasure measure) {
        this.measureSelections.add(measure);
    }

    public ArrayList<ROLAPMeasure> getMeasureSelection() {
        return this.measureSelections;
    }

    @Override
    public int getMeasuresOffset() {
        return this.getAttributeCount();
    }

    public void setDataItemInfo(ArrayList<String[]> dataitems, boolean forAggregateTable) {
        if (forAggregateTable) {
            this.aggTableDataItemsInfo = dataitems;
        } else {
            this.dataItemsInfo = dataitems;
        }
    }

    public ArrayList<String[]> getDataItemInfo(boolean forAggregateTable) {
        if (forAggregateTable) {
            return this.aggTableDataItemsInfo;
        }
        return this.dataItemsInfo;
    }

    @Override
    public IROLAPQueryResultIterator execute() {
        return this.execute(null).getProviderQueryResultIter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V5ProviderQueryResult execute(ExecutionEnvironment execEnv) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCDataQuery", ZipiContext.getQRDName());
        try {
            V5ProviderQueryResult v5ProviderQueryResult = this.tryToExecute(execEnv);
            return v5ProviderQueryResult;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V5ProviderQueryResult tryToExecute(ExecutionEnvironment execEnv) {
        ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPQuery.Performance", "Started data query.");
        try {
            QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
            envHelper.setInternalUse(false);
            envHelper.setUpEnvironment(false);
            ExecutionEnvironment newExecEnv = envHelper.getExecutionEnvironment();
            RequestEnvironment newReqEnv = envHelper.getRequestEnvironment();
            MultiRequestContext context = newExecEnv.getMultiRequestContext();
            RequestParameters origParams = context.getRequestParameters();
            context.clearRequestParameters();
            try {
                long executionStartTime = 0L;
                if (this.workloadLogger != null) {
                    executionStartTime = System.currentTimeMillis();
                }
                this.setupRequestEnvironment(newReqEnv);
                RolapV5Builder.setupConnectionElement(newExecEnv);
                PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(newReqEnv);
                planEnv.setMetdataConnection(this.getMetadataConnection());
                V5QuerySet querySet = this.createV5QuerySet(planEnv);
                this.logAggregateInfo(((RequestEnvironment)planEnv.getRequestEnvironment()).getReportName());
                if (querySet != null) {
                    Parameters parameters;
                    boolean hasUnresolvedParameters;
                    if (this.workloadLogger != null) {
                        this.logWorkloadInfo(newReqEnv);
                    }
                    PlannedV5QuerySet plannedQuerySet = this.planQuerySet(planEnv, querySet);
                    RSAPIDataset dataset = RolapQueryHelper.getDataset(this.getNameToUseInV5(this.name), plannedQuerySet);
                    V5ProviderQueryResult queryResult = null;
                    if (dataset != null) {
                        queryResult = new V5ProviderQueryResult(ROLAPQueryResultIteratorFactory.getIterator(dataset, newExecEnv));
                    }
                    boolean bl = hasUnresolvedParameters = (parameters = newReqEnv.getRequestParameters()).getUnresolvedParameters().size() > 0;
                    if (!(hasUnresolvedParameters || parameters.containsParameterWithNullOrNilValue() || parameters.hasOptionalParameter())) {
                        QueryEngine.getInstance().getCacheManager().storePlanTree(plannedQuerySet, newReqEnv, planEnv.getMetadataConnection());
                    }
                    if (this.workloadLogger != null) {
                        long executionTime = System.currentTimeMillis() - executionStartTime;
                        this.workloadLogger.logQueryExecutionTime(newReqEnv, this.id, executionTime);
                    }
                    if (null != dataset) {
                        V5ProviderQueryResult v5ProviderQueryResult = queryResult;
                        return v5ProviderQueryResult;
                    }
                }
            }
            finally {
                envHelper.tearDownEnvironment();
                context.setRequestParameters(origParams);
            }
        }
        finally {
            ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", "Finished data query.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlannedV5QuerySet planQuerySet(PlanningEnvironment planEnv, V5QuerySet querySet) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCPlanningQuerySet", ZipiContext.getQRDName());
        try {
            PlannedV5QuerySet plannedV5QuerySet = this.tryToPlanQuerySet(planEnv, querySet);
            return plannedV5QuerySet;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlannedV5QuerySet tryToPlanQuerySet(PlanningEnvironment planEnv, V5QuerySet querySet) {
        PlannedV5QuerySet plannedQuerySet;
        ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPQuery.Performance", "Started planning querySet.");
        try {
            plannedQuerySet = QueryPlanner.getInstance().planQueryAllowPlanReuse(querySet, planEnv);
        }
        finally {
            ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", "Finished planning querySet.");
        }
        return plannedQuerySet;
    }

    private void logAggregateInfo(String reportName) {
        if (this.aggregateInfo != null) {
            if (this.aggregateInfo.selectedAggregate != null) {
                this.cube.getMetrics().recordAggrTableAccess(1L, 1L);
            } else {
                this.cube.getMetrics().recordAggrTableAccess(0L, 1L);
            }
            if (aggrLogger.isOn()) {
                this.aggregateInfo.setV5ReportName(reportName);
                aggrLogger.log(this.aggregateInfo.getAggregateAnalysisAsXML());
            }
        }
    }

    private void logWorkloadInfo(RequestEnvironment newReqEnv) {
        HashMap<ROLAPLevel, HashSet<IROLAPCommonMember>> levelMemberMap = new HashMap<ROLAPLevel, HashSet<IROLAPCommonMember>>();
        if (this.compoundKeyMappings != null) {
            for (ROLAPCompoundKeyMapping keyMapping : this.compoundKeyMappings) {
                levelMemberMap.put(keyMapping.getLevel(), new HashSet(0));
            }
        }
        if (this.computeAggregationOnly) {
            ArrayList<ROLAPLevel> levels = new ArrayList<ROLAPLevel>();
            ROLAPLevel[] levelsArray = null;
            levelsArray = this.getLevels(this.extraAggregationFilters);
            if (levelsArray != null) {
                levels.addAll(Arrays.asList(levelsArray));
            }
            if ((levelsArray = this.getLevels(this.aggregationCombinationFilters)) != null) {
                levels.addAll(Arrays.asList(levelsArray));
            }
            for (ROLAPLevel level : levels) {
                if (levelMemberMap.containsKey(level)) continue;
                levelMemberMap.put(level, new HashSet(0));
            }
        }
        if (this.usingExternalAggregateTable) {
            String aggregateName = null;
            if (null != this.aggregateInfo && this.aggregateInfo.selectedAggregate != null) {
                aggregateName = this.aggregateInfo.selectedAggregate.getName();
            }
            this.workloadLogger.logQueryAgainstDatabaseAggregateTable(newReqEnv, aggregateName, this.id, this.measureSelections, levelMemberMap);
        } else {
            this.workloadLogger.logQueryAgainstDatabase(newReqEnv, this.id, this.measureSelections, levelMemberMap);
        }
    }

    @Override
    public V5QuerySet createV5QuerySet(PlanningEnvironment planEnv) {
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        XQETrace trace = planEnv.getTrace();
        boolean loggingOn = (trace.getTraceLevel() & 0x100) != 0;
        trace.removeTraceLevel(256);
        MetricsService.startCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        V5QuerySet v5QuerySet = null;
        this.generateDataItems();
        if (this.getDataItemInfo(this.usingExternalAggregateTable) != null) {
            v5QuerySet = this.aggregateFactUnionQuery ? this.buildV5QuerySetAggrNrt(planEnv) : this.buildV5QuerySet(planEnv);
            if (sLogger.isOn()) {
                String msg = String.format("Built V5QuerySet for query %s: \n%s", this.name, v5QuerySet.dumpToString());
                sLogger.log(msg);
            }
            if (this.filterParameters != null) {
                ((RequestEnvironment)planEnv.getRequestEnvironment()).setRequestParameters(this.filterParameters);
            }
            planEnv.setRoot(v5QuerySet);
        }
        MetricsService.endCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        if (loggingOn) {
            trace.addTraceLevel(256);
        }
        planEnv.resetTreeHasBeenModified();
        return v5QuerySet;
    }

    public V5QuerySet buildV5QuerySetAggrNrt(PlanningEnvironment planEnv) {
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO)) {
            ROLAPLog.log("ROLAPQuery.Performance", "Executing aggregate query \"" + this.name + "\" as a union of fact and aggregate table queries.");
        }
        String modelPath = this.metaMdSchema.getCommonCubeModel().getModelPath();
        V5QuerySet v5QuerySet = RolapV5Builder.addNewV5QuerySetToPlanner(planEnv, modelPath, nodeFactory);
        String v5QueryName = this.getNameToUseInV5(this.name) + "_agg";
        V5Query query1 = this.buildBasicQueryNode(planEnv, nodeFactory, v5QuerySet, v5QueryName, null, IROLAPQuery.QueryTarget.AGG_TABLE, false);
        Map<ROLAPMetaAttribute, String> tmpAggrMap = this.aggrCubeLevelKeyToQueryItem;
        this.aggrCubeLevelKeyToQueryItem = null;
        v5QueryName = this.getNameToUseInV5(this.name) + "_fact";
        V5Query query2 = this.buildBasicQueryNode(planEnv, nodeFactory, v5QuerySet, v5QueryName, null, IROLAPQuery.QueryTarget.FACT_TABLE, false);
        String expression = this.cube.getIncrementManagerInContext().getFactQueryFilterExpression(true);
        RolapV5Builder.addDetailFilterForStringExpression(nodeFactory, query2, expression);
        IXQEQueryNode[] queries = new IXQEQueryNode[]{query1, query2};
        String unionQueryName = RolapV5Builder.getUnionQueryName(queries);
        IXQEQueryNode groupBody = RolapV5Builder.addGroupBodyNode(nodeFactory, unionQueryName);
        List<IXQEQueryNode> dataItemsToProject = query2.getDescendantsOfTypeOrdered(101003, false);
        V5Query unionQuery = (V5Query)RolapV5Builder.addUnionQueryNode(nodeFactory, v5QuerySet, true, dataItemsToProject, this.dataItemNameToAggregateType, groupBody, queries);
        if (this.xmdxNodeId > 0 && this.isTraceEnabled(planEnv)) {
            unionQuery.setPropertyValue("xmdxNodeId", this.xmdxNodeId);
        }
        IXQEQueryNode selection = unionQuery.getFirstDescendantOfTypeOrdered(101009, false);
        this.addPostAggregationFiltersToV5Query(planEnv, nodeFactory, unionQuery, selection, groupBody);
        RolapV5Builder.buildAndInsertQRD(nodeFactory, v5QuerySet, unionQueryName, groupBody);
        this.aggrCubeLevelKeyToQueryItem = tmpAggrMap;
        return v5QuerySet;
    }

    @Override
    public V5QuerySet buildV5QuerySet(PlanningEnvironment planEnv) {
        String expression;
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        String modelPath = this.metaMdSchema.getCommonCubeModel().getModelPath();
        V5QuerySet v5QuerySet = RolapV5Builder.addNewV5QuerySetToPlanner(planEnv, modelPath, nodeFactory);
        String v5QueryName = this.getNameToUseInV5(this.name);
        IXQEQueryNode groupBody = RolapV5Builder.addGroupBodyNode(nodeFactory, v5QueryName);
        IROLAPQuery.QueryTarget target = IROLAPQuery.QueryTarget.FACT_TABLE;
        if (this.usingExternalAggregateTable) {
            target = IROLAPQuery.QueryTarget.AGG_TABLE;
        }
        V5Query query = this.buildBasicQueryNode(planEnv, nodeFactory, v5QuerySet, v5QueryName, groupBody, target, true);
        if (!this.usingExternalAggregateTable && this.includeIncrementalPredicate && this.cube.getIncrementManagerInContext() != null && (expression = this.cube.getIncrementManagerInContext().getFactQueryFilterExpression(false)) != null) {
            RolapV5Builder.addDetailFilterForStringExpression(nodeFactory, query, expression);
        }
        RolapV5Builder.buildAndInsertQRD(nodeFactory, v5QuerySet, v5QueryName, groupBody);
        return v5QuerySet;
    }

    public V5Query buildBasicQueryNode(PlanningEnvironment planEnv, XQENodeFactory nodeFactory, V5QuerySet v5QuerySet, String v5QueryName, IXQEQueryNode groupBody, IROLAPQuery.QueryTarget target, boolean includePostAggregationFilters) {
        V5Query query = RolapV5Builder.addQueryNode(nodeFactory, v5QuerySet, v5QueryName);
        IXQEQueryNode selection = RolapV5Builder.addSelectionNode(nodeFactory, query, true);
        RolapV5Builder.addRelationalSourceNode(nodeFactory, query);
        if (this.xmdxNodeId > 0 && this.isTraceEnabled(planEnv)) {
            query.setPropertyValue("xmdxNodeId", this.xmdxNodeId);
        }
        boolean aggTable = target == IROLAPQuery.QueryTarget.AGG_TABLE;
        this.addDataItemsToV5Query(planEnv, nodeFactory, selection, groupBody, this.getDataItemInfo(aggTable), target);
        this.addPreAggregationFiltersToV5Query(nodeFactory, query, selection, groupBody, target);
        if (includePostAggregationFilters) {
            this.addPostAggregationFiltersToV5Query(planEnv, nodeFactory, query, selection, groupBody);
        }
        return query;
    }

    private void addDataItemsToV5Query(PlanningEnvironment planEnv, XQENodeFactory nodeFactory, IXQEQueryNode selection, IXQEQueryNode groupBody, ArrayList<String[]> dataItems, IROLAPQuery.QueryTarget target) {
        int measuresOffset = this.getMeasuresOffset();
        for (int i = 0; i < dataItems.size(); ++i) {
            ROLAPMeasure measure;
            String[] info = dataItems.get(i);
            IXQEQueryNode dataItem = nodeFactory.createNode(101003);
            dataItem.setPropertyValue("name", info[0]);
            if (info.length > 2) {
                dataItem.setPropertyValue("aggregate", info[2]);
            }
            selection.addChild(dataItem);
            boolean isSemiAggregateMeasure = false;
            if (i >= measuresOffset && this.measureSelections.size() > 0 && !this.usingExternalAggregateTable && (isSemiAggregateMeasure = (measure = this.measureSelections.get(i - measuresOffset)).isSemiAggregate())) {
                V5ValueSummaryFunction aggrExpression = AggregationUtils.buildAggregateExpression(planEnv, selection, dataItem, this.getAttributeSelections(target), measure);
                dataItem.addChild(aggrExpression);
            }
            if (!isSemiAggregateMeasure) {
                IXQEQueryNode expression = nodeFactory.createNode(101004);
                expression.setPropertyValue("expression", info[1]);
                dataItem.addChild(expression);
            }
            if (this.computeAggregationOnly && i < measuresOffset && !this.returnContextTuple || groupBody == null) continue;
            IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", info[0]);
            groupBody.addChild(dataItemRef);
        }
    }

    private void addPreAggregationFiltersToV5Query(XQENodeFactory nodeFactory, V5Query query, IXQEQueryNode selection, IXQEQueryNode groupBody, IROLAPQuery.QueryTarget target) {
        for (Map.Entry<ROLAPMetaAttribute, Collection<IValue>> entry : this.levelKeyFilters.entrySet()) {
            ROLAPMetaAttribute rOLAPMetaAttribute = entry.getKey();
            Collection<IValue> collection = entry.getValue();
            RolapV5Builder.addDetailFilterForStringExpression(nodeFactory, query, this.getFilterString(rOLAPMetaAttribute, collection, true));
        }
        ArrayListMultimap combinedPchFilters = ArrayListMultimap.create();
        for (ROLAPCompoundKeyMapping rOLAPCompoundKeyMapping : this.pchCompoundKeyMappings) {
            Map<ROLAPMetaAttribute, Collection<IValue>> map = rOLAPCompoundKeyMapping.getPchLevelKeyFilters(target);
            for (Map.Entry<ROLAPMetaAttribute, Collection<IValue>> filter : map.entrySet()) {
                combinedPchFilters.putAll((Object)filter.getKey(), (Iterable)filter.getValue());
            }
        }
        boolean bl = this.compoundKeyMappings != null && this.compoundKeyMappings.size() > 1 && (this.levelKeySelections == null || this.levelKeySelections.size() == 0);
        for (Map.Entry entry : combinedPchFilters.asMap().entrySet()) {
            ROLAPMetaAttribute levelKey = (ROLAPMetaAttribute)entry.getKey();
            Collection levelKeyValues = (Collection)entry.getValue();
            this.addLevelKeyFilterToBeParameterized(levelKey);
            RolapV5Builder.addDetailFilterForStringExpression(nodeFactory, query, this.getFilterString(levelKey, levelKeyValues, bl));
        }
        this.addMultilevelPredicateFilters(nodeFactory, query);
        this.generateFLFilters(query, nodeFactory);
        this.addMemberExclusionDetailFilters(nodeFactory, query);
        if (this.computeAggregationOnly) {
            if (this.extraAggregationFilters != null) {
                IteratorInt iteratorInt = this.extraAggregationFilters.keySetIterator();
                while (iteratorInt.hasNext()) {
                    int n = iteratorInt.next();
                    ArrayList<ROLAPCompoundKeyMapping> aggCKMs = this.extraAggregationFilters.get(n);
                    if (!this.usingExternalAggregateTable) {
                        for (ROLAPCompoundKeyMapping aggCKM : aggCKMs) {
                            Iterator<IROLAPCommonMember> it;
                            ROLAPLevel level = aggCKM.getLevel();
                            if (level == null || !level.hasRecursiveHierarchy() || !(it = aggCKM.getRequestedMembers().iterator()).hasNext()) continue;
                            HashSet<IMember> mbrSet = new HashSet<IMember>(((IMemberCubics)((Object)it.next())).getDescendants());
                            for (IROLAPCommonMember iROLAPCommonMember : mbrSet) {
                                aggCKM.addMemberSelection((IMember)((Object)iROLAPCommonMember));
                            }
                        }
                    }
                    if (this.tupleFiltersExpressions != null) continue;
                    this.addAggregateDetailFilters(nodeFactory, query, aggCKMs);
                    if (!this.returnContextTuple) continue;
                    this.addAggregateCombinationSelections(nodeFactory, selection, null, aggCKMs);
                }
            }
            if (this.aggregationCombinationFilters != null) {
                IteratorInt iteratorInt = this.aggregationCombinationFilters.keySetIterator();
                while (iteratorInt.hasNext()) {
                    int n = iteratorInt.next();
                    ArrayList<ROLAPCompoundKeyMapping> aggMembers = this.aggregationCombinationFilters.get(n);
                    if (this.tupleFiltersExpressions == null) {
                        this.addAggregateDetailFilters(nodeFactory, query, aggMembers);
                    }
                    this.addAggregateCombinationSelections(nodeFactory, selection, groupBody, aggMembers);
                }
            }
            if (this.tupleFiltersExpressions != null) {
                this.generateTupleBasedFilters(query, nodeFactory);
            }
        }
        if (!this.usingExternalAggregateTable) {
            for (String string : this.dimFactJoinFilters) {
                query.addChild(this.getDetailFilterForExpression(nodeFactory, string));
            }
        }
    }

    private void addPostAggregationFiltersToV5Query(PlanningEnvironment planEnv, XQENodeFactory nodeFactory, V5Query query, IXQEQueryNode selection, IXQEQueryNode groupBody) {
        if (this.isPushdownQuery()) {
            this.mPushdownManager.generatePushdownV5Expression(CollectionCast.upcast(this.measureSelections, IMember.class), planEnv, query, selection, groupBody);
        }
        for (String expression : this.valueFilterExpressions) {
            RolapV5Builder.addDetailFilterForStringExpression(nodeFactory, query, expression);
        }
    }

    private void addMultilevelPredicateFilters(XQENodeFactory nodeFactory, V5Query query) {
        for (String dim : this.extraFilterList.keySet()) {
            ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>> predicatelist = this.extraFilterList.get(dim);
            V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
            detailFilter.setPostAutoAggregation(false);
            query.addChild(detailFilter);
            ArrayList<IXQEQueryNode> oredExpressions = new ArrayList<IXQEQueryNode>();
            for (int i = 0; i < predicatelist.size(); ++i) {
                Map<ROLAPMetaAttribute, HashSet<IValue>> predicateMap = predicatelist.get(i);
                ArrayList<IXQEQueryNode> andedExpressions = new ArrayList<IXQEQueryNode>();
                for (ROLAPMetaAttribute levelKey : predicateMap.keySet()) {
                    Collection levelKeyValues = predicateMap.get(levelKey);
                    IXQEQueryNode filterExpression = nodeFactory.createNode(101013);
                    filterExpression.setPropertyValue("expression", this.getFilterString(levelKey, levelKeyValues, true));
                    andedExpressions.add(filterExpression);
                }
                IXQEQueryNode filterExpression = this.getAndExpression(nodeFactory, andedExpressions);
                oredExpressions.add(filterExpression);
            }
            IXQEQueryNode filterExpression = this.getOrExpression(nodeFactory, oredExpressions);
            detailFilter.addChild(filterExpression);
        }
    }

    private void addMemberExclusionDetailFilters(XQENodeFactory nodeFactory, IXQEQueryNode query) {
        if (!this.mExcludedMembers.isEmpty()) {
            ArrayList<ROLAPCompoundKeyMapping> memberMaps = new ArrayList<ROLAPCompoundKeyMapping>(this.mExcludedMembers.size());
            for (IROLAPCommonMember mem : this.mExcludedMembers) {
                ROLAPCompoundKeyMapping map = new ROLAPCompoundKeyMapping(true);
                map.addMemberSelection((IMember)((Object)mem));
                memberMaps.add(map);
            }
            IXQEQueryNode expr = this.createNonOverfetchingLevelKeyExpression(nodeFactory, memberMaps);
            expr = this.getNotExpression(nodeFactory, expr);
            V5DetailFilter dtf = this.createDetailFilter(nodeFactory, expr);
            query.addChild(dtf);
        }
    }

    private void addAggregateCombinationSelections(XQENodeFactory nodeFactory, IXQEQueryNode selection, IXQEQueryNode groupBody, ArrayList<ROLAPCompoundKeyMapping> aggMembers) {
        for (int i = 0; i < aggMembers.get((int)0).mProjectedColumns.size(); ++i) {
            ROLAPMetaAttribute levelKey = aggMembers.get((int)0).mProjectedColumns.get(i);
            String levelKeyName = levelKey.getName();
            IXQEQueryNode dataItem = nodeFactory.createNode(101003);
            dataItem.setPropertyValue("name", levelKeyName);
            String column = null;
            if (this.aggrCubeLevelKeyToQueryItem != null) {
                column = this.aggrCubeLevelKeyToQueryItem.get(levelKey);
            }
            if (column == null) {
                column = levelKey.getQueryItem();
            }
            IXQEQueryNode expression = nodeFactory.createNode(101004);
            expression.setPropertyValue("expression", column);
            dataItem.addChild(expression);
            selection.addChild(dataItem);
            if (groupBody == null) continue;
            IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", levelKeyName);
            groupBody.addChild(dataItemRef);
        }
    }

    private void addAggregateDetailFilters(XQENodeFactory nodeFactory, IXQEQueryNode query, ArrayList<ROLAPCompoundKeyMapping> aggCKMs) {
        IXQEQueryNode orExpression = this.createNonOverfetchingLevelKeyExpression(nodeFactory, aggCKMs);
        V5DetailFilter detailFilter = this.createDetailFilter(nodeFactory, orExpression);
        query.addChild(detailFilter);
    }

    private IXQEQueryNode createNonOverfetchingLevelKeyExpression(XQENodeFactory nodeFactory, ArrayList<ROLAPCompoundKeyMapping> memberCKMs) {
        ArrayList<IXQEQueryNode> andExpressions = new ArrayList<IXQEQueryNode>();
        ROLAPLevel level = null;
        List<ROLAPMetaAttribute> projectedColumns = null;
        ArrayList<ROLAPCompoundKeyMapping> nextMemberCKMs = memberCKMs;
        while (!nextMemberCKMs.isEmpty()) {
            memberCKMs = nextMemberCKMs;
            level = memberCKMs.get(0).getLevel();
            projectedColumns = memberCKMs.get((int)0).mProjectedColumns;
            nextMemberCKMs = new ArrayList();
            HashSet[] keyValues = (HashSet[])ArrayCast.uncheckedCast(new HashSet[projectedColumns.size()]);
            for (int i = 0; i < keyValues.length; ++i) {
                keyValues[i] = new HashSet();
            }
            for (ROLAPCompoundKeyMapping aggCKM : memberCKMs) {
                if (aggCKM.getLevel() != level) {
                    nextMemberCKMs.add(aggCKM);
                    continue;
                }
                for (IROLAPCommonMember member : aggCKM.getRequestedMembers()) {
                    int i;
                    IValue[] levelKeys = member.getLevelKeys().getKeyValues();
                    if (!this.addLevelKeysToAndExpression(keyValues, levelKeys)) {
                        andExpressions.add(this.getAndExpression(nodeFactory, projectedColumns, keyValues));
                        for (i = 0; i < keyValues.length; ++i) {
                            keyValues[i] = new HashSet();
                        }
                    }
                    for (i = 0; i < levelKeys.length; ++i) {
                        keyValues[i].add(levelKeys[i]);
                    }
                }
            }
            andExpressions.add(this.getAndExpression(nodeFactory, projectedColumns, keyValues));
        }
        IXQEQueryNode orExpression = this.getOrExpression(nodeFactory, andExpressions);
        return orExpression;
    }

    private boolean addLevelKeysToAndExpression(HashSet<IValue>[] keyValues, IValue[] levelKeys) {
        int count = 0;
        for (int i = 0; i < levelKeys.length; ++i) {
            boolean contained = keyValues[i].contains(levelKeys[i]);
            if (keyValues[i].size() > 1) {
                ++count;
            } else if (keyValues[i].size() == 1 && !contained) {
                ++count;
            }
            if (count <= 1) continue;
            return false;
        }
        return true;
    }

    private void generateDataItems() {
        ArrayList<String[]> aggrDataItems;
        if (this.getDataItemInfo(this.usingExternalAggregateTable) != null) {
            return;
        }
        if (!this.cube.getConfigIsDisableExternalAggregates() && (aggrDataItems = this.resolveAggregates()) != null) {
            this.setDataItemInfo(aggrDataItems, true);
            this.usingExternalAggregateTable = true;
            if (!this.aggregateFactUnionQuery) {
                return;
            }
        }
        if (this.flAggregateMemberPerHierarchy == null && this.flAggregateMemberFilter != null) {
            this.flAggregateMemberPerHierarchy = this.flAggregateMemberFilter.getPerHierarchyMemberList(null);
        }
        ArrayList<String[]> dataItems = new ArrayList<String[]>();
        this.dataItemNameToAggregateType = new HashMap<String, String>(this.measureSelections.size());
        if (!this.usingExternalAggregateTable) {
            IROLAPQuery.QueryTarget target = IROLAPQuery.QueryTarget.COMMON;
            for (ROLAPCompoundKeyMapping mapping : this.pchCompoundKeyMappings) {
                mapping.addPchProjectionGroupingAttributes(this, target);
            }
        }
        for (ROLAPMetaAttribute attrib : this.getAttributeSelections(IROLAPQuery.QueryTarget.FACT_TABLE)) {
            String queryItem = attrib.getQueryItem();
            String qualName = ROLAPQuery.createUniqueDataItemName(dataItems, attrib);
            dataItems.add(new String[]{qualName, queryItem});
        }
        int numMeasures = this.measureSelections.size();
        Iterator<ROLAPMeasure> measureIt = this.measureSelections.iterator();
        while (measureIt.hasNext()) {
            ROLAPMeasure measure = measureIt.next();
            ROLAPMetaMeasure metaMeasure = measure.getROLAPMetaMeasure();
            String queryItem = metaMeasure.getQueryItem();
            String dataItemName = metaMeasure.getName();
            AggregateTypeEnum aggrType = measure.getRegularAggregate();
            String aggTypeStr = aggrType.toV5Type();
            if (aggrType == AggregateTypeEnum.UNKNOWN) {
                if (this.isLowestLevels) {
                    aggTypeStr = AggregateTypeEnum.MIN.toV5Type();
                    dataItems.add(new String[]{dataItemName, queryItem, aggTypeStr});
                } else {
                    if (sLogger.isOn(LogLevel.INFO)) {
                        sLogger.log(LogLevel.INFO, String.format("Removing custom aggregate measure, %s, because it was not found in an aggregate cube and is not at fact table granularity.", measure));
                    }
                    --numMeasures;
                    measureIt.remove();
                }
            } else {
                dataItems.add(new String[]{dataItemName, queryItem});
            }
            this.dataItemNameToAggregateType.put(dataItemName, aggTypeStr);
        }
        if (numMeasures > 0) {
            this.setDataItemInfo(dataItems, false);
        }
    }

    public static String createUniqueDataItemName(List<String[]> previousDataItemNames, ROLAPMetaAttribute attrib) {
        String baseQualName = attrib.getParentQualifiedQueryName();
        int count = 0;
        String qualName = baseQualName;
        while (ROLAPQuery.doesNameExist(qualName, previousDataItemNames)) {
            qualName = baseQualName + "_" + String.valueOf(++count);
        }
        return qualName;
    }

    private static boolean doesNameExist(String name, List<String[]> previousDataItemNames) {
        for (String[] currentName : previousDataItemNames) {
            if (!name.equals(currentName[0])) continue;
            return true;
        }
        return false;
    }

    private ArrayList<String[]> resolveAggregates() {
        ArrayList<String[]> aggDataItems = null;
        ArrayList<ROLAPMetaAggregateCube> candidateList = new ArrayList<ROLAPMetaAggregateCube>();
        ROLAPMetaCube metaCube = this.cube.getModelCube();
        ROLAPMetaAggregateCube[] aggrCubes = metaCube.getAggregateCubes();
        if (aggrCubes == null || aggrCubes.length == 0) {
            if (aggrLogger.isOn()) {
                aggrLogger.log(String.format("Aggregate cubes are not present for this cube.", new Object[0]));
            }
            return null;
        }
        this.aggregateInfo = new AggregateAnalysisInfo();
        if (!this.isQueryAllowedToLeverageAggregateCubes(this.measureSelections)) {
            return null;
        }
        for (ROLAPMetaAggregateCube aggrCube : aggrCubes) {
            if (!this.doesAggregateSatisfyQuery(aggrCube, this.measureSelections.toArray(new ROLAPMeasure[0]), true)) continue;
            candidateList.add(aggrCube);
        }
        if (candidateList.size() > 0) {
            ROLAPMetaAggregateCube aggrCube = this.decideBetterAggregate(candidateList);
            aggDataItems = this.translateQueryToUseAggregate(aggrCube);
        }
        return aggDataItems;
    }

    private ROLAPMetaAggregateCube decideBetterAggregate(ArrayList<ROLAPMetaAggregateCube> candidateList) {
        ROLAPMetaAggregateCube betterAggr = null;
        if (candidateList.size() == 1) {
            betterAggr = candidateList.get(0);
            this.aggregateInfo.setSelectedAggregate(betterAggr, "Only matching aggregate cube found.");
            return betterAggr;
        }
        double minLowestLevelsCardinality = 0.0;
        double currentLowestLevelsCardinality = 0.0;
        boolean uniqueCardinailty = true;
        boolean sameCardinalityOrdinalTie = false;
        for (int idx = 0; idx < candidateList.size(); ++idx) {
            ROLAPMetaAggregateCube aggrCube = candidateList.get(idx);
            currentLowestLevelsCardinality = aggrCube.getLowestLevelsCardinality(this.cube);
            if (idx == 0 || currentLowestLevelsCardinality < minLowestLevelsCardinality) {
                betterAggr = aggrCube;
                minLowestLevelsCardinality = currentLowestLevelsCardinality;
                uniqueCardinailty = true;
                sameCardinalityOrdinalTie = false;
                continue;
            }
            if (minLowestLevelsCardinality != currentLowestLevelsCardinality) continue;
            uniqueCardinailty = false;
            if (aggrCube.getOrdinal() < betterAggr.getOrdinal()) {
                betterAggr = aggrCube;
                sameCardinalityOrdinalTie = false;
                continue;
            }
            sameCardinalityOrdinalTie = true;
        }
        if (uniqueCardinailty) {
            this.aggregateInfo.setSelectedAggregate(betterAggr, "Aggregate with minimum lowest levels cardinality.");
        } else if (sameCardinalityOrdinalTie) {
            this.aggregateInfo.setSelectedAggregate(betterAggr, "First aggregate with minimum lowest levels cardinality and lowest ordinal.");
        } else {
            this.aggregateInfo.setSelectedAggregate(betterAggr, "Aggregate with minimum lowest levels cardinality and lowest ordinal.");
        }
        return betterAggr;
    }

    private boolean isQueryAllowedToLeverageAggregateCubes(List<ROLAPMeasure> measureList) {
        if (this.useFactTableOnly) {
            return false;
        }
        if (!this.computeAggregationOnly) {
            return true;
        }
        for (ROLAPMeasure measure : measureList) {
            if (!measure.isSemiAggregate() || !measure.containsNonFirstLastAggregateRule()) continue;
            this.aggregateInfo.setReasonForNoneConsidered("Cannot route semi-aggregate measures to aggreate cubes for external aggregations pushed to the datasource");
            return false;
        }
        return true;
    }

    protected boolean doesAggregateSatisfyQuery(ROLAPMetaAggregateCube aggregateCube, ROLAPMeasure[] measureList, boolean checkSliceCoverage) {
        if (this.aggregateInfo == null) {
            this.aggregateInfo = new AggregateAnalysisInfo();
        }
        return ROLAPQuery.doesAggregateSatisfyQuery(aggregateCube, measureList, checkSliceCoverage, this.compoundKeyMappings, this.cube, this);
    }

    protected static boolean doesAggregateSatisfyQuery(ROLAPMetaAggregateCube aggregateCube, ROLAPMeasure[] measureList, boolean checkSliceCoverage, ArrayList<ROLAPCompoundKeyMapping> compoundKeyMappings, ROLAPBaseCube cube, ROLAPQuery query) {
        AggregateAnalysisInfo aggregateInfo = null;
        boolean computeAggregationOnly = false;
        if (query != null) {
            computeAggregationOnly = query.computeAggregationOnly;
            aggregateInfo = query.aggregateInfo;
        }
        boolean allAdditiveMeasures = true;
        boolean requiresMeasureRewrite = false;
        for (ROLAPMeasure measure : measureList) {
            boolean measureMatches = false;
            ROLAPMetaAggregateMeasureRef aggrMeasureRef = aggregateCube.getAggregateMeasure(measure);
            if (aggrMeasureRef != null) {
                AggregateTypeEnum rolapAggrType = measure.getRegularAggregate();
                switch (rolapAggrType) {
                    case COUNT: 
                    case SUM: 
                    case MIN: 
                    case MAX: {
                        break;
                    }
                    case AVG: 
                    case VAR: 
                    case STDDEV: 
                    case UNKNOWN: {
                        allAdditiveMeasures = false;
                        break;
                    }
                    case CALCULATED: {
                        if (!aggrMeasureRef.getAggregateContent().equalsIgnoreCase("no")) break;
                        allAdditiveMeasures = false;
                        break;
                    }
                    default: {
                        allAdditiveMeasures = false;
                    }
                }
                if (measure.isSemiAggregate()) {
                    if (measureList.length == 1) {
                        if (measure.containsNonFirstLastAggregateRule()) {
                            allAdditiveMeasures = false;
                        }
                    } else {
                        allAdditiveMeasures = false;
                    }
                }
                measureMatches = true;
            }
            if (measureMatches) continue;
            if (measure.getRegularAggregate() == AggregateTypeEnum.AVG && ROLAPQuery.getSpecifiedAggregateMeasure(aggregateCube, measure, AggregateTypeEnum.SUM, cube) != null && ROLAPQuery.getSpecifiedAggregateMeasure(aggregateCube, measure, AggregateTypeEnum.COUNT, cube) != null) {
                allAdditiveMeasures = true;
                requiresMeasureRewrite = true;
                continue;
            }
            ROLAPQuery.addRejectedAggregates(aggregateInfo, aggregateCube, ReasonForRejection.MEASURE_MISMATCH, measure.getName());
            return false;
        }
        boolean potentialAggFactUnionQuery = IncrementManager.queryWillIncludeTidRange(cube);
        if (potentialAggFactUnionQuery && (!allAdditiveMeasures || requiresMeasureRewrite)) {
            ROLAPQuery.addRejectedAggregates(aggregateInfo, aggregateCube, ReasonForRejection.CANT_ROLLUP_WITH_NON_ADDITIVE_MEASURE, null);
            return false;
        }
        if (compoundKeyMappings == null && !computeAggregationOnly) {
            if (allAdditiveMeasures) {
                if (checkSliceCoverage) {
                    if (ROLAPQuery.doesAggregateSatisfyAllLevelsNotSeenInQuery(aggregateCube, allAdditiveMeasures, aggregateInfo, new HashSet<ROLAPMetaAggregateHierarchyRef>())) {
                        ROLAPQuery.addQualifiedAggregates(aggregateInfo, aggregateCube);
                        return true;
                    }
                    return false;
                }
                ROLAPQuery.addQualifiedAggregates(aggregateInfo, aggregateCube);
                return true;
            }
            if (aggregateCube.getAggregateDimensionRefs().length == 0) {
                ROLAPQuery.addQualifiedAggregates(aggregateInfo, aggregateCube);
                return true;
            }
            ROLAPQuery.addRejectedAggregates(aggregateInfo, aggregateCube, ReasonForRejection.CANT_ROLLUP_WITH_NON_ADDITIVE_MEASURE, null);
            return false;
        }
        if (compoundKeyMappings != null && !ROLAPQuery.doesAggregateSatisfyAllLevels(aggregateCube, checkSliceCoverage, allAdditiveMeasures, compoundKeyMappings, aggregateInfo)) {
            return false;
        }
        if (computeAggregationOnly) {
            ArrayList<ROLAPCompoundKeyMapping> mappings = new ArrayList<ROLAPCompoundKeyMapping>();
            if (query != null && query.extraAggregationFilters != null) {
                IteratorInt hierIt = query.extraAggregationFilters.keySetIterator();
                while (hierIt.hasNext()) {
                    int hierNdx = hierIt.next();
                    ArrayList<ROLAPCompoundKeyMapping> aggMembers = query.extraAggregationFilters.get(hierNdx);
                    if (!checkSliceCoverage) {
                        mappings.add(aggMembers.get(0));
                        continue;
                    }
                    mappings.addAll(aggMembers);
                }
            }
            if (query != null && query.aggregationCombinationFilters != null) {
                IteratorInt hierIt = query.aggregationCombinationFilters.keySetIterator();
                while (hierIt.hasNext()) {
                    int hierNdx = hierIt.next();
                    ArrayList<ROLAPCompoundKeyMapping> aggMembers = query.aggregationCombinationFilters.get(hierNdx);
                    if (!checkSliceCoverage) {
                        mappings.add(aggMembers.get(0));
                        continue;
                    }
                    mappings.addAll(aggMembers);
                }
            }
            if (!mappings.isEmpty() && !ROLAPQuery.doesAggregateSatisfyAllLevels(aggregateCube, checkSliceCoverage, allAdditiveMeasures, mappings, aggregateInfo)) {
                return false;
            }
        }
        ROLAPQuery.addQualifiedAggregates(aggregateInfo, aggregateCube);
        return true;
    }

    private static boolean doesAggregateSatisfyAllLevels(ROLAPMetaAggregateCube aggregateCube, boolean checkSliceCoverage, boolean allAdditiveMeasure, ArrayList<ROLAPCompoundKeyMapping> mappings, AggregateAnalysisInfo aggregateInfo) {
        HashSet<ROLAPMetaAggregateHierarchyRef> aggrHierarchySeenInQuery = new HashSet<ROLAPMetaAggregateHierarchyRef>();
        for (ROLAPCompoundKeyMapping mapping : mappings) {
            ROLAPLevel level = mapping.getLevel();
            boolean levelMatches = false;
            ROLAPMetaAggregateLevelRef aggrLevelRef = aggregateCube.getAggregateLevel(level);
            if (aggrLevelRef != null) {
                if (!allAdditiveMeasure && !aggregateCube.isLowestAggregateLevel(level)) {
                    ROLAPQuery.addRejectedAggregates(aggregateInfo, aggregateCube, ReasonForRejection.CANT_ROLLUP_WITH_NON_ADDITIVE_MEASURE, null);
                    return false;
                }
                levelMatches = true;
            }
            if (!levelMatches) {
                ROLAPQuery.addRejectedAggregates(aggregateInfo, aggregateCube, ReasonForRejection.LEVEL_MISMATCH, level.getUniqueName());
                return false;
            }
            ROLAPMetaAggregateHierarchyRef aggrHierarchy = (ROLAPMetaAggregateHierarchyRef)aggrLevelRef.getParent();
            if (checkSliceCoverage && aggrHierarchy.getAggregateSlice() != null) {
                IHierarchy hierarchy = level.getHierarchy();
                ILevel sliceLevel = aggrHierarchy.getAggregateSliceLevel(hierarchy);
                if (sliceLevel == null) {
                    ROLAPQuery.addRejectedAggregates(aggregateInfo, aggregateCube, ReasonForRejection.AGGREGATE_SLICE_MISMATCH, level.getUniqueName());
                    return false;
                }
                if (sliceLevel.getIndex() == level.getIndex()) {
                    for (IROLAPCommonMember member : mapping.getRequestedMembers()) {
                        if (aggrHierarchy.getAggregateSlice().containsMember((IMember)((Object)member))) continue;
                        ROLAPQuery.addRejectedAggregates(aggregateInfo, aggregateCube, ReasonForRejection.AGGREGATE_SLICE_MISMATCH, ((IMember)((Object)member)).getUniqueName());
                        return false;
                    }
                } else if (sliceLevel.getIndex() > level.getIndex()) {
                    for (IROLAPCommonMember member : mapping.getRequestedMembers()) {
                        ArrayList<IMember> descendants = ((ROLAPMemberProxy)member).getDescendants(sliceLevel);
                        for (IMember descendantMember : descendants) {
                            if (aggrHierarchy.getAggregateSlice().containsMember(descendantMember)) continue;
                            ROLAPQuery.addRejectedAggregates(aggregateInfo, aggregateCube, ReasonForRejection.AGGREGATE_SLICE_MISMATCH, descendantMember.getUniqueName());
                            return false;
                        }
                    }
                } else {
                    for (IROLAPCommonMember member : mapping.getRequestedMembers()) {
                        IMember parent;
                        for (parent = ((IMember)((Object)member)).getParent(); parent != null && !parent.getLevel().equals(sliceLevel); parent = parent.getParent()) {
                        }
                        if (aggrHierarchy.getAggregateSlice().containsMember(parent)) continue;
                        ROLAPQuery.addRejectedAggregates(aggregateInfo, aggregateCube, ReasonForRejection.AGGREGATE_SLICE_MISMATCH, parent.getUniqueName());
                        return false;
                    }
                }
            }
            if (!checkSliceCoverage) continue;
            aggrHierarchySeenInQuery.add(aggrHierarchy);
        }
        return !checkSliceCoverage || ROLAPQuery.doesAggregateSatisfyAllLevelsNotSeenInQuery(aggregateCube, allAdditiveMeasure, aggregateInfo, aggrHierarchySeenInQuery);
    }

    private static boolean doesAggregateSatisfyAllLevelsNotSeenInQuery(ROLAPMetaAggregateCube aggregateCube, boolean allAdditiveMeasures, AggregateAnalysisInfo aggregateInfo, HashSet<ROLAPMetaAggregateHierarchyRef> aggrHierarchySeenInQuery) {
        for (ROLAPMetaAggregateDimensionRef dimRef : aggregateCube.getAggregateDimensionRefs()) {
            for (ROLAPMetaAggregateHierarchyRef aggrHierarchy : dimRef.getAggregateHierarchyRefs()) {
                if (aggrHierarchySeenInQuery.contains(aggrHierarchy)) continue;
                if (!allAdditiveMeasures) {
                    ROLAPQuery.addRejectedAggregates(aggregateInfo, aggregateCube, ReasonForRejection.CANT_ROLLUP_WITH_NON_ADDITIVE_MEASURE, null);
                    return false;
                }
                if (aggrHierarchy.getAggregateSlice() == null) continue;
                ROLAPQuery.addRejectedAggregates(aggregateInfo, aggregateCube, ReasonForRejection.AGGREGATE_SLICE_MISMATCH, aggrHierarchy.getName());
                return false;
            }
        }
        return true;
    }

    private static void addQualifiedAggregates(AggregateAnalysisInfo aggregateInfo, ROLAPMetaAggregateCube aggrCube) {
        if (aggregateInfo != null) {
            aggregateInfo.addQualifiedAggregates(aggrCube);
        }
    }

    private static void addRejectedAggregates(AggregateAnalysisInfo aggregateInfo, ROLAPMetaAggregateCube aggrCube, ReasonForRejection reason, String objectName) {
        if (aggregateInfo != null) {
            aggregateInfo.addRejectedAggregates(aggrCube, reason, objectName);
        }
    }

    private ArrayList<String[]> translateQueryToUseAggregate(ROLAPMetaAggregateCube aggregateCube) {
        ROLAPLevel level;
        ArrayList<String[]> aggDataItems = new ArrayList<String[]>();
        this.aggregateFactUnionQuery = this.includeIncrementalPredicate && IncrementManager.queryWillIncludeTidRange(this.cube);
        this.aggrCubeLevelKeyToQueryItem = new HashMap<ROLAPMetaAttribute, String>();
        if (this.flAggregateMemberFilter != null) {
            this.flAggregateMemberPerHierarchy = this.flAggregateMemberFilter.getPerHierarchyMemberList(aggregateCube);
            for (List list : this.flAggregateMemberPerHierarchy) {
                ROLAPLevel level2 = (ROLAPLevel)((IMember)list.get(0)).getLevel();
                this.translateLevelToUseAggregate(aggregateCube, level2, null);
            }
        }
        if (this.compoundKeyMappings != null) {
            for (ROLAPCompoundKeyMapping rOLAPCompoundKeyMapping : this.compoundKeyMappings) {
                ROLAPMetaAggregateLevelRef aggrLevelRef;
                ROLAPLevel level2 = rOLAPCompoundKeyMapping.getLevel();
                if (level2.getHierarchy().isParentChild() || (aggrLevelRef = aggregateCube.getAggregateLevel(level2)) == null) continue;
                this.translateLevelKeysToUseAggregate(level2, aggrLevelRef, aggDataItems);
                this.translateParentLevelToUseAggregate(aggregateCube, level2);
            }
        }
        if (this.pchCompoundKeyMappings != null) {
            IROLAPQuery.QueryTarget columnProjectionTarget = IROLAPQuery.QueryTarget.COMMON;
            for (ROLAPCompoundKeyMapping mapping : this.pchCompoundKeyMappings) {
                level = mapping.getLevel();
                ROLAPMetaAggregateLevelRef aggrLevelRef = aggregateCube.getAggregateLevel(level);
                if (aggrLevelRef == null) continue;
                ArrayList<String[]> aggDataItemsToAppend = null;
                if (mapping.shouldProjectPchColumn(columnProjectionTarget)) {
                    aggDataItemsToAppend = aggDataItems;
                }
                this.translateLevelKeysToUseAggregate(level, aggrLevelRef, aggDataItemsToAppend);
                this.translateParentLevelToUseAggregate(aggregateCube, level);
                mapping.addPchProjectionGroupingAttributes(this, columnProjectionTarget);
            }
        }
        if (this.computeAggregationOnly) {
            ArrayList<ROLAPCompoundKeyMapping> aggMembers;
            IteratorInt hierIt;
            if (this.extraAggregationFilters != null) {
                hierIt = this.extraAggregationFilters.keySetIterator();
                while (hierIt.hasNext()) {
                    int n = hierIt.next();
                    aggMembers = this.extraAggregationFilters.get(n);
                    level = aggMembers.get(0).getLevel();
                    this.translateLevelToUseAggregate(aggregateCube, level, null);
                }
            }
            if (this.aggregationCombinationFilters != null) {
                hierIt = this.aggregationCombinationFilters.keySetIterator();
                while (hierIt.hasNext()) {
                    int n = hierIt.next();
                    aggMembers = this.aggregationCombinationFilters.get(n);
                    level = aggMembers.get(0).getLevel();
                    this.translateLevelToUseAggregate(aggregateCube, level, aggDataItems);
                }
            }
        }
        for (ROLAPMeasure rOLAPMeasure : this.measureSelections) {
            ROLAPMetaAggregateMeasureRef aggrMeasureRef = aggregateCube.getAggregateMeasure(rOLAPMeasure);
            if (aggrMeasureRef != null) {
                AggregateTypeEnum rolapAggrType = rOLAPMeasure.getRegularAggregate();
                switch (rolapAggrType) {
                    case COUNT: {
                        aggDataItems.add(new String[]{aggrMeasureRef.getName(), aggrMeasureRef.getQueryItem(), "total"});
                        break;
                    }
                    case SUM: 
                    case MIN: 
                    case MAX: {
                        aggDataItems.add(new String[]{aggrMeasureRef.getName(), aggrMeasureRef.getQueryItem()});
                        break;
                    }
                    case CALCULATED: {
                        if (aggrMeasureRef.getAggregateContent().equalsIgnoreCase("yes")) {
                            aggDataItems.add(new String[]{aggrMeasureRef.getName(), aggrMeasureRef.getQueryItem()});
                            break;
                        }
                        aggDataItems.add(new String[]{aggrMeasureRef.getName(), aggrMeasureRef.getQueryItem(), "minimum"});
                        break;
                    }
                    default: {
                        aggDataItems.add(new String[]{aggrMeasureRef.getName(), aggrMeasureRef.getQueryItem(), "minimum"});
                        break;
                    }
                }
                continue;
            }
            if (rOLAPMeasure.getRegularAggregate() != AggregateTypeEnum.AVG) continue;
            ROLAPMetaAggregateMeasureRef aggrSum = this.getSpecifiedAggregateMeasure(aggregateCube, rOLAPMeasure, AggregateTypeEnum.SUM);
            ROLAPMetaAggregateMeasureRef aggrCount = this.getSpecifiedAggregateMeasure(aggregateCube, rOLAPMeasure, AggregateTypeEnum.COUNT);
            aggDataItems.add(new String[]{rOLAPMeasure.getName(), aggrSum.getQueryItem() + "/" + "total" + "(" + aggrCount.getQueryItem() + ")", "calculated"});
        }
        return aggDataItems;
    }

    private void translateLevelKeysToUseAggregate(ROLAPLevel level, ROLAPMetaAggregateLevelRef aggrLevelRef, ArrayList<String[]> aggDataItems) {
        int idx = 0;
        List<ROLAPMetaAttribute> attributes = level.getMetaLevel().getLevelKeys();
        for (ROLAPMetaQueryItem queryItem : aggrLevelRef.getQueryItems()) {
            if (aggDataItems != null) {
                String qualName = ROLAPQuery.createUniqueDataItemName(aggDataItems, attributes.get(idx));
                aggDataItems.add(new String[]{qualName, queryItem.getRefObject()});
            }
            this.aggrCubeLevelKeyToQueryItem.put(attributes.get(idx), queryItem.getRefObject());
            ++idx;
        }
    }

    private void translateParentLevelToUseAggregate(ROLAPMetaAggregateCube aggregateCube, ROLAPLevel level) {
        ROLAPLevel currentLevel = level;
        while (currentLevel.getPreviousLevel() != null) {
            ROLAPMetaAggregateLevelRef currentAggrLevelRef;
            ROLAPMetaLevel metaLevel = (currentLevel = (ROLAPLevel)currentLevel.getPreviousLevel()).getMetaLevel();
            if (metaLevel == null || (currentAggrLevelRef = aggregateCube.getAggregateLevel(currentLevel)) == null) continue;
            int idx = 0;
            List<ROLAPMetaAttribute> attributes = metaLevel.getLevelKeys();
            for (ROLAPMetaQueryItem queryItem : currentAggrLevelRef.getQueryItems()) {
                this.aggrCubeLevelKeyToQueryItem.put(attributes.get(idx), queryItem.getRefObject());
                ++idx;
            }
        }
    }

    private void translateLevelToUseAggregate(ROLAPMetaAggregateCube aggregateCube, ROLAPLevel level, ArrayList<String[]> aggDataItems) {
        ROLAPMetaAggregateLevelRef aggrLevelRef = aggregateCube.getAggregateLevel(level);
        if (aggrLevelRef != null) {
            this.translateLevelKeysToUseAggregate(level, aggrLevelRef, aggDataItems);
            this.translateParentLevelToUseAggregate(aggregateCube, level);
        }
    }

    public static ROLAPMetaAggregateMeasureRef getSpecifiedAggregateMeasure(ROLAPMetaAggregateCube aggregateCube, ROLAPMeasure inputMeasure, AggregateTypeEnum aggrType, ROLAPBaseCube cube) {
        String inputQIExpr = inputMeasure.getRelationalQueryItemExpression();
        for (ROLAPMetaAggregateMeasureRef aggrMeasureRef : aggregateCube.getAggregateMeasureRefs()) {
            String queryItemExpr;
            ROLAPMeasure measure = (ROLAPMeasure)cube.getMeasure(aggrMeasureRef.getName());
            if (measure.getRegularAggregate() != aggrType || (queryItemExpr = measure.getRelationalQueryItemExpression()) == null || !queryItemExpr.equals(inputQIExpr)) continue;
            return aggrMeasureRef;
        }
        return null;
    }

    private ROLAPMetaAggregateMeasureRef getSpecifiedAggregateMeasure(ROLAPMetaAggregateCube aggregateCube, ROLAPMeasure inputMeasure, AggregateTypeEnum aggrType) {
        return ROLAPQuery.getSpecifiedAggregateMeasure(aggregateCube, inputMeasure, aggrType, this.cube);
    }

    public void addFilter(ROLAPMetaAttribute filterAttrib, Collection<IValue> selections) {
        this.levelKeyFilters.put(filterAttrib, selections);
    }

    public void addFilter(ROLAPMetaAttribute filterAttrib, Collection<IValue> selections, boolean useParameters) {
        this.levelKeyFilters.put(filterAttrib, selections);
        if (useParameters) {
            this.addLevelKeyFilterToBeParameterized(filterAttrib);
        }
    }

    public void addValueFilterExpression(String expression) {
        this.valueFilterExpressions.add(expression);
    }

    public void addJoinFilter(String filterExpression) {
        this.dimFactJoinFilters.add(filterExpression);
    }

    public int getColumnCount() {
        return this.getAttributeCount() + this.measureSelections.size();
    }

    public int getAttributeCount() {
        return this.levelKeySelections.get((Object)IROLAPQuery.QueryTarget.COMMON).size();
    }

    @Override
    public void addAttribute(ROLAPMetaAttribute attrib, IROLAPQuery.QueryTarget target) {
        this.levelKeySelections.put((Object)target, (Object)attrib);
    }

    public void addExtraFilterList(String dim, ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>> predicatelist) {
        this.extraFilterList.put(dim, predicatelist);
    }

    private void setupRequestEnvironment(RequestEnvironment reqEnv) {
        RolapV5Builder.setRequestEnvironmentCubeInfo(reqEnv, this.cube);
        reqEnv.setSubRequestID(this.id);
    }

    private String getFilterString(ROLAPMetaAttribute levelKey, Collection<IValue> levelKeyvalues, boolean allowBetweenClause) {
        boolean useQuotes = true;
        for (IValue value : levelKeyvalues) {
            if (value == null) continue;
            IDataType dt = value.getDataType();
            useQuotes = dt.isTextType() || dt.isDate();
            break;
        }
        Parameters parameters = null;
        if (this.shouldUseParameters(levelKey)) {
            if (this.filterParameters == null) {
                this.filterParameters = new Parameters();
            }
            parameters = this.filterParameters;
            useQuotes = false;
        }
        if (levelKeyvalues.size() > 1000 && allowBetweenClause) {
            return this.createBetweenExpressionForMembers(levelKey, levelKeyvalues, useQuotes, parameters);
        }
        return ROLAPQuery.createINExpressionForMembers(levelKey, levelKeyvalues, useQuotes, this.aggrCubeLevelKeyToQueryItem, parameters);
    }

    private String createBetweenExpressionForMembers(ROLAPMetaAttribute levelKey, Collection<IValue> levelKeyValues, boolean useQuotes, Parameters parameters) {
        StringBuilder exprBuilder = new StringBuilder();
        String column = null;
        if (this.aggrCubeLevelKeyToQueryItem != null) {
            column = this.aggrCubeLevelKeyToQueryItem.get(levelKey);
        }
        if (column == null) {
            column = levelKey.getQueryItem();
        }
        boolean useParameters = parameters != null;
        exprBuilder.append('(');
        boolean appendIsNull = false;
        IValue minValue = null;
        IValue maxValue = null;
        for (IValue testValue : levelKeyValues) {
            if (testValue == null || testValue.isNull()) {
                appendIsNull = true;
                continue;
            }
            if (minValue == null) {
                minValue = testValue;
                maxValue = testValue;
                continue;
            }
            if (testValue.compareTo(maxValue) > 0) {
                maxValue = testValue;
            }
            if (testValue.compareTo(minValue) >= 0) continue;
            minValue = testValue;
        }
        if (minValue != null) {
            exprBuilder.append(column);
            exprBuilder.append(BETWEEN_EXPR);
            if (useQuotes) {
                exprBuilder.append('\'').append(minValue.toString()).append('\'');
            } else if (useParameters) {
                this.addParameterToExpression(exprBuilder, parameters, PARAMETER_NAME_PMIN, minValue.toString());
            } else {
                exprBuilder.append(minValue.toString());
            }
            exprBuilder.append(AND_EXPR);
            if (useQuotes) {
                exprBuilder.append('\'').append(maxValue.toString()).append('\'');
            } else if (useParameters) {
                this.addParameterToExpression(exprBuilder, parameters, PARAMETER_NAME_PMAX, maxValue.toString());
            } else {
                exprBuilder.append(maxValue.toString());
            }
        }
        if (appendIsNull) {
            if (minValue != null) {
                exprBuilder.append(OR_EXPR);
            }
            exprBuilder.append(column).append(IS_NULL_EXPR);
        }
        exprBuilder.append(')');
        return exprBuilder.toString();
    }

    private void addParameterToExpression(StringBuilder exprBuilder, Parameters parameters, String parameterName, String value) {
        Parameter parameter = new Parameter(parameterName);
        parameter.getParameterValueItems().clear();
        parameter.getParameterValueItems().setAssociatedParameter(parameter);
        exprBuilder.append(PARAMETER_MARKER);
        exprBuilder.append(parameterName);
        exprBuilder.append(PARAMETER_MARKER);
        parameter.addValue(value);
        parameters.addParameter(parameterName, parameter);
    }

    public static String createINExpressionForMembers(ROLAPMetaAttribute levelKey, Collection<IValue> levelKeyValues, boolean useQuotes, Map<ROLAPMetaAttribute, String> aggrCubeQueryItems) {
        return ROLAPQuery.createINExpressionForMembers(levelKey, levelKeyValues, useQuotes, aggrCubeQueryItems, null);
    }

    public static String createINExpressionForMembers(ROLAPMetaAttribute levelKey, Collection<IValue> levelKeyValues, boolean useQuotes, Map<ROLAPMetaAttribute, String> aggrCubeQueryItems, Parameters parameters) {
        boolean useParameters;
        StringBuilder tempExprBuilder = new StringBuilder();
        StringBuilder finalExprBuilder = new StringBuilder();
        int countOrs = 0;
        boolean appendIsNull = false;
        int inCntr = 0;
        boolean addNewParameterToQuery = useParameters = parameters != null;
        String column = null;
        if (aggrCubeQueryItems != null) {
            column = aggrCubeQueryItems.get(levelKey);
        }
        if (column == null) {
            column = levelKey.getQueryItem();
        }
        finalExprBuilder.append('(');
        tempExprBuilder.append(column);
        if (useQuotes) {
            tempExprBuilder.append(BEGIN_IN_EXPR).append('\'');
        } else {
            tempExprBuilder.append(BEGIN_IN_EXPR);
        }
        Parameter parameter = new Parameter();
        String parameterName = "";
        for (IValue value : levelKeyValues) {
            if (value == null || value.isNull()) {
                appendIsNull = true;
                continue;
            }
            if (inCntr > 0 && inCntr % 250 == 0) {
                if (useQuotes) {
                    tempExprBuilder.append('\'').append(END_OR_EXPR);
                    tempExprBuilder.append(column);
                    tempExprBuilder.append(BEGIN_IN_EXPR).append('\'');
                } else {
                    tempExprBuilder.append(END_OR_EXPR);
                    tempExprBuilder.append(column);
                    tempExprBuilder.append(BEGIN_IN_EXPR);
                    if (useParameters) {
                        parameters.addParameter(parameterName, parameter);
                        addNewParameterToQuery = true;
                    }
                }
                ++countOrs;
            } else if (inCntr > 0 && !useParameters) {
                if (useQuotes) {
                    tempExprBuilder.append("';'");
                } else {
                    tempExprBuilder.append(";");
                }
            }
            ++inCntr;
            if (useParameters) {
                if (addNewParameterToQuery) {
                    StringBuilder nameBuilder = new StringBuilder();
                    nameBuilder.append(PARAMETER_NAME_PREFIX);
                    nameBuilder.append(String.valueOf(parameters.size() + 1));
                    parameterName = nameBuilder.toString();
                    parameter = new Parameter(parameterName);
                    parameter.getParameterValueItems().clear();
                    parameter.getParameterValueItems().setAssociatedParameter(parameter);
                    int estMaxCapacity = levelKeyValues.size();
                    if (estMaxCapacity > 250) {
                        estMaxCapacity = 250;
                    }
                    parameter.getParameterValueItems().ensureCapacity(estMaxCapacity);
                    tempExprBuilder.append(PARAMETER_MARKER);
                    tempExprBuilder.append(parameterName);
                    tempExprBuilder.append(PARAMETER_MARKER);
                    addNewParameterToQuery = false;
                }
                if (parameter == null) continue;
                parameter.addValue(value.toString());
                continue;
            }
            tempExprBuilder.append(ROLAPQuery.escapeSQLString(value.toString()));
        }
        if (inCntr != 0) {
            if (useQuotes) {
                tempExprBuilder.append('\'').append(')');
            } else {
                tempExprBuilder.append(')');
                if (useParameters) {
                    parameters.addParameter(parameterName, parameter);
                }
            }
            finalExprBuilder.append((CharSequence)tempExprBuilder);
        }
        if (appendIsNull) {
            if (inCntr != 0) {
                finalExprBuilder.append(OR_EXPR);
            }
            finalExprBuilder.append(column).append(IS_NULL_EXPR);
        }
        finalExprBuilder.append(')');
        return finalExprBuilder.toString();
    }

    public static String escapeSQLString(String s) {
        StringBuilder str = new StringBuilder();
        int len = 0;
        if (s != null) {
            len = s.length();
        }
        block3: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\'': {
                    str.append("''");
                    continue block3;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    private boolean useQuotesForExpression(HashSet<IValue> keyValues) {
        boolean useQuotes = true;
        for (IValue value : keyValues) {
            if (value == null) continue;
            IDataType dt = value.getDataType();
            useQuotes = dt.isTextType() || dt.isDate();
            break;
        }
        return useQuotes;
    }

    private IXQEQueryNode getNotExpression(XQENodeFactory nodeFactory, IXQEQueryNode childExpression) {
        V5LogicalExpression notExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
        notExpr.setSubType(2);
        notExpr.addChild(childExpression);
        return notExpr;
    }

    private IXQEQueryNode getOrExpression(XQENodeFactory nodeFactory, List<IXQEQueryNode> childExpressions) {
        if (childExpressions.size() == 1) {
            return childExpressions.get(0);
        }
        V5LogicalExpression orExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
        orExpr.setSubType(1);
        V5LogicalExpression rootOrExpr = orExpr;
        for (int i = 0; i < childExpressions.size(); ++i) {
            orExpr.addChild(childExpressions.get(i));
            if (i >= childExpressions.size() - 2) {
                orExpr.addChild(childExpressions.get(i + 1));
                break;
            }
            V5LogicalExpression rightChild = (V5LogicalExpression)nodeFactory.createNode(201003);
            rightChild.setSubType(1);
            orExpr.addChild(rightChild);
            orExpr = rightChild;
        }
        return rootOrExpr;
    }

    private IXQEQueryNode getAndExpression(XQENodeFactory nodeFactory, List<IXQEQueryNode> childExpressions) {
        if (childExpressions.size() == 1) {
            return childExpressions.get(0);
        }
        V5LogicalExpression andExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
        andExpr.setSubType(0);
        V5LogicalExpression rootAndExpr = andExpr;
        for (int i = 0; i < childExpressions.size(); ++i) {
            andExpr.addChild(childExpressions.get(i));
            if (i >= childExpressions.size() - 2) {
                andExpr.addChild(childExpressions.get(i + 1));
                break;
            }
            V5LogicalExpression rightChild = (V5LogicalExpression)nodeFactory.createNode(201003);
            rightChild.setSubType(0);
            andExpr.addChild(rightChild);
            andExpr = rightChild;
        }
        return rootAndExpr;
    }

    private IXQEQueryNode getAndExpression(XQENodeFactory nodeFactory, List<ROLAPMetaAttribute> projectedColumns, HashSet<IValue>[] keyValues) {
        ArrayList<IXQEQueryNode> childExpressions = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < keyValues.length; ++i) {
            boolean useQuotes = this.useQuotesForExpression(keyValues[i]);
            IXQEQueryNode filterExpression = this.getFilterExpression(nodeFactory, ROLAPQuery.createINExpressionForMembers(projectedColumns.get(i), keyValues[i], useQuotes, this.aggrCubeLevelKeyToQueryItem));
            childExpressions.add(filterExpression);
        }
        return this.getAndExpression(nodeFactory, childExpressions);
    }

    private IXQEQueryNode getFilterExpression(XQENodeFactory nodeFactory, String filterExpression) {
        IXQEQueryNode filterExpressionNode = nodeFactory.createNode(101013);
        filterExpressionNode.setPropertyValue("expression", filterExpression);
        return filterExpressionNode;
    }

    private V5DetailFilter getDetailFilterForExpression(XQENodeFactory nodeFactory, String filterExpression) {
        IXQEQueryNode filterExpressionNode = this.getFilterExpression(nodeFactory, filterExpression);
        V5DetailFilter detailFilter = this.createDetailFilter(nodeFactory, filterExpressionNode);
        return detailFilter;
    }

    private V5DetailFilter createDetailFilter(XQENodeFactory nodeFactory, IXQEQueryNode filterExpressionNode) {
        V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
        detailFilter.setPostAutoAggregation(false);
        detailFilter.addChild(filterExpressionNode);
        return detailFilter;
    }

    public void setXmdxNodeId(Integer xmdxTupleNodeId) {
        if (xmdxTupleNodeId != -1) {
            this.xmdxNodeId = xmdxTupleNodeId;
        }
    }

    @Override
    public MetadataConnection getMetadataConnection() {
        return this.cube.getConnection();
    }

    @Override
    public void setPushdownManager(PushdownManager pushdownManager) {
        super.setPushdownManager(pushdownManager);
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        String reportName = ((RequestEnvironment)execEnv.getRequestEnvironment()).getReportName();
        if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.TRACE)) {
            String function = this.mPushdownManager.getTopPushdownFunctionName();
            ROLAPLog.log("ROLAPQuery.Performance", "Executing query \"" + reportName + ":" + this.getName() + "\" as pushdown of " + function);
        }
    }

    private ROLAPLevel[] getLevels(ArrayList<ROLAPCompoundKeyMapping> mappings) {
        ROLAPLevel[] levels = null;
        if (mappings == null) {
            return null;
        }
        int index = 0;
        levels = new ROLAPLevel[mappings.size()];
        for (ROLAPCompoundKeyMapping mapping : mappings) {
            levels[index++] = mapping.getLevel();
        }
        return levels;
    }

    private ROLAPLevel[] getLevels(HashMapIntObject<ArrayList<ROLAPCompoundKeyMapping>> filters) {
        ROLAPLevel[] levels = null;
        if (filters != null) {
            int index = 0;
            levels = new ROLAPLevel[filters.size()];
            IteratorInt hierIt = filters.keySetIterator();
            while (hierIt.hasNext()) {
                int hierNdx = hierIt.next();
                ArrayList<ROLAPCompoundKeyMapping> aggMembers = filters.get(hierNdx);
                levels[index++] = aggMembers.get(0).getLevel();
            }
        }
        return levels;
    }

    @Override
    public void setMeasuresOffset(int theMeasuresOffset) {
    }

    public void addExclusionFilter(IROLAPCommonMember mem) {
        this.mExcludedMembers.add(mem);
    }

    protected void generateTupleBasedFilters(IXQEQueryNode query, XQENodeFactory nodeFactory) {
        ArrayList<IXQEQueryNode> tupleFilterExprs = new ArrayList<IXQEQueryNode>();
        for (Set set : this.tupleFiltersExpressions) {
            for (ITuple tuple : set.getTupleList()) {
                IXQEQueryNode filterExprPerTuple = this.getFilterExpressionPerTuple(nodeFactory, tuple);
                tupleFilterExprs.add(filterExprPerTuple);
            }
        }
        if (tupleFilterExprs.isEmpty()) {
            return;
        }
        IXQEQueryNode filterExpr = this.getOrExpression(nodeFactory, tupleFilterExprs);
        V5DetailFilter rootFilter = (V5DetailFilter)nodeFactory.createNode(101008);
        rootFilter.addChild(filterExpr);
        query.addChild(rootFilter);
    }

    private IXQEQueryNode getFilterExpressionPerTuple(XQENodeFactory nodeFactory, ITuple tuple) {
        ArrayList<IXQEQueryNode> andExpressions = new ArrayList<IXQEQueryNode>();
        for (IMember mem : tuple.getMembers()) {
            IROLAPCommonMember member = (IROLAPCommonMember)((Object)mem);
            ROLAPLevel aLevel = (ROLAPLevel)mem.getLevel();
            ROLAPMetaLevel metaLevel = aLevel.getMetaLevel();
            if (metaLevel == null) continue;
            IValue[] levelKeys = member.getLevelKeys().getKeyValues();
            HashSet[] keyValues = (HashSet[])ArrayCast.uncheckedCast(new HashSet[levelKeys.length]);
            for (int i = 0; i < levelKeys.length; ++i) {
                keyValues[i] = new HashSet();
                keyValues[i].add(levelKeys[i]);
            }
            andExpressions.add(this.getAndExpression(nodeFactory, metaLevel.getLevelKeys(), keyValues));
        }
        return this.getAndExpression(nodeFactory, andExpressions);
    }

    public void setFLAggregateMemberFilter(V5ProviderAggregateCombination memberFilter) {
        this.flAggregateMemberFilter = memberFilter;
    }

    private void generateFLFilters(IXQEQueryNode query, XQENodeFactory nodeFactory) {
        if (this.flAggregateMemberPerHierarchy == null) {
            return;
        }
        ArrayList<IXQEQueryNode> andExpressions = new ArrayList<IXQEQueryNode>();
        for (List<IMember> membersOfHierarchy : this.flAggregateMemberPerHierarchy) {
            ArrayList<IXQEQueryNode> oredExpressions = new ArrayList<IXQEQueryNode>();
            HashSet[] keyValues = null;
            List<ROLAPMetaAttribute> keys = null;
            for (IMember aMember : membersOfHierarchy) {
                IValue[] levelKeys;
                IROLAPCommonMember member = (IROLAPCommonMember)((Object)aMember);
                if (keys == null) {
                    ROLAPMetaLevel roLevel = ((ROLAPLevel)aMember.getLevel()).getMetaLevel();
                    keys = roLevel.getLevelKeys();
                    keyValues = (HashSet[])ArrayCast.uncheckedCast(new HashSet[keys.size()]);
                    for (int i = 0; i < keyValues.length; ++i) {
                        keyValues[i] = new HashSet();
                    }
                }
                if (member.getLevelKeys() == null) continue;
                boolean bIsPadding = false;
                for (IValue aKeyValue : levelKeys = member.getLevelKeys().getKeyValues()) {
                    if (!aKeyValue.isNull()) continue;
                    bIsPadding = true;
                    break;
                }
                if (bIsPadding) {
                    HashSet[] paddingKeyValues = (HashSet[])ArrayCast.uncheckedCast(new HashSet[keys.size()]);
                    for (int i = 0; i < levelKeys.length; ++i) {
                        paddingKeyValues[i] = new HashSet();
                        paddingKeyValues[i].add(levelKeys[i]);
                    }
                    oredExpressions.add(this.getAndExpression(nodeFactory, keys, paddingKeyValues));
                    continue;
                }
                for (int i = 0; i < levelKeys.length; ++i) {
                    keyValues[i].add(levelKeys[i]);
                }
            }
            if (membersOfHierarchy.size() != oredExpressions.size()) {
                oredExpressions.add(this.getAndExpression(nodeFactory, keys, keyValues));
            }
            andExpressions.add(this.getOrExpression(nodeFactory, oredExpressions));
        }
        if (andExpressions.isEmpty()) {
            return;
        }
        IXQEQueryNode filterExpr = this.getAndExpression(nodeFactory, andExpressions);
        V5DetailFilter rootFilter = (V5DetailFilter)nodeFactory.createNode(101008);
        rootFilter.addChild(filterExpr);
        query.addChild(rootFilter);
    }

    public void setIsAtLowestLevels(boolean queryAtLowestLevels) {
        this.isLowestLevels = queryAtLowestLevels;
    }

    protected boolean usingExternalAggregateTable() {
        return this.usingExternalAggregateTable;
    }

    public IMember[] getOutputTuple() {
        return this.outputTuple;
    }

    public void setOutputTuple(IMember[] tuple) {
        this.outputTuple = tuple;
    }

    public void setWorkloadLogger(WorkloadLogger theWorkloadLogger) {
        this.workloadLogger = theWorkloadLogger;
    }

    public SQLQueryMetrics getQueryMetrics() {
        return this.queryMetrics;
    }

    private class AggregateAnalysisInfo {
        private String v5ReportName = "";
        private final ArrayList<ROLAPMetaAggregateCube> qualifiedAggregates = new ArrayList();
        private final ArrayList<RejectedElement> rejectedAggregates = new ArrayList();
        private ROLAPMetaAggregateCube selectedAggregate = null;
        private String reasonForChoosing = "";
        private String reasonNoneConsidered = null;
        private final XQETrace trace = new XQETrace();
        private static final String NAME = "name";
        private static final String LEVEL = "level";
        private static final String DIMENSION = "dimension";
        private static final String HIERARCHY = "hierarchy";
        private static final String MEASURE = "measure";
        private static final String MEMBER = "member";
        private static final String AGGREGATE_CUBE = "aggregateCube";
        private static final String ORDINAL = "ordinal";
        private static final String LOWEST_LEVEL_CARDINALITY = "lowestLevelsCardinality";
        private static final String VALUE = "value";
        private static final String REASON = "reason";
        private StringWriter aggregateBuffer = null;
        private long sqlQueryExecTime = -1L;

        private AggregateAnalysisInfo() {
        }

        public void collectStartSQLQueryExecTime() {
            this.sqlQueryExecTime = System.currentTimeMillis();
        }

        public void collectSQLQueryExecTime() {
            this.sqlQueryExecTime -= System.currentTimeMillis();
        }

        protected void setV5ReportName(String report) {
            this.v5ReportName = report;
        }

        protected void addQualifiedAggregates(ROLAPMetaAggregateCube aggrCube) {
            this.qualifiedAggregates.add(aggrCube);
        }

        protected void addRejectedAggregates(ROLAPMetaAggregateCube aggrCube, ReasonForRejection reason, String objectName) {
            this.rejectedAggregates.add(new RejectedElement(aggrCube, reason, objectName));
        }

        protected void setSelectedAggregate(ROLAPMetaAggregateCube aggrCube, String reason) {
            this.selectedAggregate = aggrCube;
            this.reasonForChoosing = reason;
        }

        protected void setReasonForNoneConsidered(String noneConsidered) {
            this.reasonNoneConsidered = noneConsidered;
        }

        protected String getAggregateAnalysisAsXML() {
            this.startTraceForAggregateAnalysis();
            this.printOriginalQuery();
            this.trace.beginElement("aggregatesConsidered", -1);
            if (this.reasonNoneConsidered != null) {
                this.trace.attribute(VALUE, this.reasonNoneConsidered);
            }
            for (ROLAPMetaAggregateCube aggregateCube : this.qualifiedAggregates) {
                this.printQualifiedAggregateCube(aggregateCube);
            }
            this.trace.endElement();
            if (this.selectedAggregate != null) {
                this.printSelectedAggregate();
            }
            this.trace.beginElement("aggregatesNotMatching", -1);
            for (RejectedElement rejected : this.rejectedAggregates) {
                this.printRejectedAggregateCube(rejected);
            }
            this.trace.endElement();
            return this.endTraceForAggregateAnalysis();
        }

        private void startTraceForAggregateAnalysis() {
            this.aggregateBuffer = new StringWriter();
            this.trace.addStream(this.aggregateBuffer);
            this.trace.beginElement("aggregateAnalysis", -1);
            this.trace.beginElement("v5Report", -1);
            this.trace.attribute(NAME, this.v5ReportName);
            this.trace.endElement();
        }

        private String endTraceForAggregateAnalysis() {
            if (this.trace == null) {
                return "";
            }
            this.trace.endElement();
            return this.aggregateBuffer.toString();
        }

        private void printOriginalQuery() {
            if (this.trace == null) {
                return;
            }
            this.trace.beginElement("originalQuery", -1);
            this.trace.beginElement("measures", -1);
            for (ROLAPMeasure measure : ROLAPQuery.this.measureSelections) {
                this.trace.beginElement(MEASURE, -1);
                this.trace.attribute(NAME, measure.getName());
                this.trace.endElement();
            }
            this.trace.endElement();
            if (ROLAPQuery.this.compoundKeyMappings != null || ROLAPQuery.this.extraAggregationFilters != null || ROLAPQuery.this.aggregationCombinationFilters != null) {
                this.trace.beginElement("levels", -1);
                this.printLevels(ROLAPQuery.this.getLevels(ROLAPQuery.this.compoundKeyMappings));
                if (ROLAPQuery.this.computeAggregationOnly) {
                    this.printLevels(ROLAPQuery.this.getLevels(ROLAPQuery.this.extraAggregationFilters));
                    this.printLevels(ROLAPQuery.this.getLevels(ROLAPQuery.this.aggregationCombinationFilters));
                }
                this.trace.endElement();
            }
            this.trace.endElement();
        }

        private void printLevels(ROLAPLevel[] levels) {
            if (this.trace == null) {
                return;
            }
            if (levels == null) {
                return;
            }
            for (ROLAPLevel level : levels) {
                this.printLevel(level);
            }
        }

        private void printLevel(ROLAPLevel level) {
            if (this.trace == null) {
                return;
            }
            IHierarchy hierarchy = level.getHierarchy();
            IDimension dim = level.getDimension();
            this.trace.beginElement(LEVEL, -1);
            this.trace.attribute(NAME, level.getName());
            this.trace.attribute(DIMENSION, dim.getName());
            this.trace.attribute(HIERARCHY, hierarchy.getName());
            this.trace.endElement();
        }

        private void printQualifiedAggregateCube(ROLAPMetaAggregateCube aggregateCube) {
            if (this.trace == null) {
                return;
            }
            this.trace.beginElement(AGGREGATE_CUBE, -1);
            this.trace.attribute(NAME, aggregateCube.getName());
            this.trace.attribute(ORDINAL, aggregateCube.getOrdinal());
            this.trace.attribute(LOWEST_LEVEL_CARDINALITY, aggregateCube.getLowestLevelsCardinality(ROLAPQuery.this.cube));
            this.trace.endElement();
        }

        private void printRejectedAggregateCube(RejectedElement aggregateElement) {
            if (this.trace == null) {
                return;
            }
            this.trace.beginElement(AGGREGATE_CUBE, -1);
            this.trace.attribute(NAME, aggregateElement.getAggregateCube().getName());
            this.trace.beginElement(ORDINAL, -1);
            this.trace.attribute(VALUE, aggregateElement.getAggregateCube().getOrdinal());
            this.trace.endElement();
            this.trace.beginElement(REASON, -1);
            switch (aggregateElement.getReason()) {
                case LEVEL_MISMATCH: {
                    this.trace.attribute(VALUE, "levelNotMatching");
                    this.trace.beginElement(LEVEL, -1);
                    this.trace.attribute(NAME, aggregateElement.getLevelOrMeasureOrMemberName());
                    this.trace.endElement();
                    break;
                }
                case MEASURE_MISMATCH: {
                    this.trace.attribute(VALUE, "measureNotMatching");
                    this.trace.beginElement(MEASURE, -1);
                    this.trace.attribute(NAME, aggregateElement.getLevelOrMeasureOrMemberName());
                    this.trace.endElement();
                    break;
                }
                case CANT_ROLLUP_WITH_NON_ADDITIVE_MEASURE: {
                    this.trace.attribute(VALUE, "cantRollupWithNonAdditiveMeasure");
                    break;
                }
                case AGGREGATE_SLICE_MISMATCH: {
                    this.trace.attribute(VALUE, "aggregateSliceNotMatchingMember");
                    this.trace.beginElement(MEMBER, -1);
                    this.trace.attribute(NAME, aggregateElement.getLevelOrMeasureOrMemberName());
                    this.trace.endElement();
                    break;
                }
            }
            this.trace.endElement();
            this.trace.endElement();
        }

        private void printSelectedAggregate() {
            if (this.trace == null) {
                return;
            }
            this.trace.beginElement("aggregateSelected", -1);
            this.trace.beginElement(AGGREGATE_CUBE, -1);
            this.trace.attribute(NAME, this.selectedAggregate.getName());
            this.trace.attribute("reasonForChoosing", this.reasonForChoosing);
            this.trace.attribute("SQLExecTimeInMS", this.sqlQueryExecTime);
            this.trace.endElement();
            this.trace.endElement();
        }

        private class RejectedElement {
            private final ROLAPMetaAggregateCube aggrCube;
            private final ReasonForRejection reason;
            private final String levelOrMeasureOrMemberName;

            RejectedElement(ROLAPMetaAggregateCube aggregateCube, ReasonForRejection type, String objectName) {
                this.aggrCube = aggregateCube;
                this.reason = type;
                this.levelOrMeasureOrMemberName = objectName;
            }

            public ROLAPMetaAggregateCube getAggregateCube() {
                return this.aggrCube;
            }

            public ReasonForRejection getReason() {
                return this.reason;
            }

            public String getLevelOrMeasureOrMemberName() {
                return this.levelOrMeasureOrMemberName;
            }
        }
    }

    private static enum ReasonForRejection {
        MEASURE_MISMATCH,
        LEVEL_MISMATCH,
        CANT_ROLLUP_WITH_NON_ADDITIVE_MEASURE,
        AGGREGATE_SLICE_MISMATCH;

    }
}

