/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPProperty;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.DefaultENUSLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.HashMapIntInt;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import java.util.HashMap;
import java.util.Map;

public class ROLAPQueryAttributesToColumnsHandler {
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_CAPTION = "caption";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    public static final String ATTRIBUTE_BUSINESS_KEY = "business_key";
    public static final String ATTRIBUTE_LEVEL_KEY = "level_key";
    public static final String ATTRIBUTE_PROPERTY = "property";
    public static final String ATTRIBUTE_LOCALE_QUERY_ITEM = "localeQueryItem";
    public static final int NOT_MAPPED_COLUMN = -1;
    private static final String BYCOLUMN = "byColumn";
    private static final String BYROW = "byRow";
    private final HashMapIntInt mLevelNameColIdx = new HashMapIntInt();
    private final HashMapIntInt mLevelCaptionColIdx = new HashMapIntInt();
    private final HashMapIntInt mLevelDescColIdx = new HashMapIntInt();
    private final HashMapIntInt mLevelBusinessKeyColIdx = new HashMapIntInt();
    private final HashMapIntObject<ArrayListInt> mLevelKeyColIdx = new HashMapIntObject();
    private final HashMapIntObject<ArrayListInt> mPropertyColIdx = new HashMapIntObject();
    private final HashMapIntInt mLevelLocaleQueryItemColIdx = new HashMapIntInt();
    private String defaultLocale = null;
    private final IROLAPQuery.QueryTarget target = IROLAPQuery.QueryTarget.COMMON;

    public ROLAPQueryAttributesToColumnsHandler(String locale) {
        this.defaultLocale = locale;
    }

    public void addAttributeColumn(String type, int levelIndex, int attributeColumn) {
        if (ATTRIBUTE_NAME.equalsIgnoreCase(type)) {
            this.mLevelNameColIdx.put(levelIndex, attributeColumn);
        } else if (ATTRIBUTE_CAPTION.equalsIgnoreCase(type)) {
            this.mLevelCaptionColIdx.put(levelIndex, attributeColumn);
        } else if (ATTRIBUTE_DESCRIPTION.equalsIgnoreCase(type)) {
            this.mLevelDescColIdx.put(levelIndex, attributeColumn);
        } else if (ATTRIBUTE_BUSINESS_KEY.equalsIgnoreCase(type)) {
            this.mLevelBusinessKeyColIdx.put(levelIndex, attributeColumn);
        } else if (ATTRIBUTE_LEVEL_KEY.equalsIgnoreCase(type)) {
            if (this.mLevelKeyColIdx.containsKey(levelIndex)) {
                this.mLevelKeyColIdx.get(levelIndex).add(attributeColumn);
            } else {
                ArrayListInt properties = new ArrayListInt();
                properties.add(attributeColumn);
                this.mLevelKeyColIdx.put(levelIndex, properties);
            }
        } else if (ATTRIBUTE_PROPERTY.equalsIgnoreCase(type)) {
            if (this.mPropertyColIdx.containsKey(levelIndex)) {
                this.mPropertyColIdx.get(levelIndex).add(attributeColumn);
            } else {
                ArrayListInt properties = new ArrayListInt();
                properties.add(attributeColumn);
                this.mPropertyColIdx.put(levelIndex, properties);
            }
        } else if (ATTRIBUTE_LOCALE_QUERY_ITEM.equals(type)) {
            this.mLevelLocaleQueryItemColIdx.put(levelIndex, attributeColumn);
        }
    }

    public void addNameColumn(IROLAPQuery query, ROLAPMetaAttribute name, int levelIndex) {
        int column = query.addAttributeAvoidingDuplicates(name, this.target);
        this.addAttributeColumn(ATTRIBUTE_NAME, levelIndex, column);
    }

    public void addLocaleLookupColumn(IROLAPQuery query, ROLAPMetaAttribute name, int levelIndex) {
        int column = query.addAttributeAvoidingDuplicates(name, this.target);
        this.addAttributeColumn(ATTRIBUTE_LOCALE_QUERY_ITEM, levelIndex, column);
    }

    public void addCaptionColumn(IROLAPQuery query, ROLAPMetaAttribute name, int levelIndex) {
        int column = query.addAttributeAvoidingDuplicates(name, this.target);
        this.addAttributeColumn(ATTRIBUTE_CAPTION, levelIndex, column);
    }

    public void addDescriptionColumn(IROLAPQuery query, ROLAPMetaAttribute name, int levelIndex) {
        int column = query.addAttributeAvoidingDuplicates(name, this.target);
        this.addAttributeColumn(ATTRIBUTE_DESCRIPTION, levelIndex, column);
    }

    public void addBusinessKeyColumn(IROLAPQuery query, ROLAPMetaAttribute name, int levelIndex) {
        int column = query.addAttributeAvoidingDuplicates(name, this.target);
        this.addAttributeColumn(ATTRIBUTE_BUSINESS_KEY, levelIndex, column);
    }

    public void addLevelKeyColumn(IROLAPQuery query, ROLAPMetaAttribute name, int levelIndex) {
        int column = query.addAttributeAvoidingDuplicates(name, this.target);
        this.addAttributeColumn(ATTRIBUTE_LEVEL_KEY, levelIndex, column);
    }

    public void addPropertyColumn(IROLAPQuery query, ROLAPMetaAttribute name, int levelIndex) {
        int column = query.addAttributeAvoidingDuplicates(name, this.target);
        this.addAttributeColumn(ATTRIBUTE_PROPERTY, levelIndex, column);
    }

    public int getAttributeColumn(String type, int levelIndex, int propertyIndex) {
        int column = -1;
        if (ATTRIBUTE_LEVEL_KEY.equalsIgnoreCase(type)) {
            if (this.mLevelKeyColIdx.containsKey(levelIndex)) {
                column = this.mLevelKeyColIdx.get(levelIndex).get(propertyIndex);
            }
        } else if (ATTRIBUTE_PROPERTY.equalsIgnoreCase(type) && this.mPropertyColIdx.containsKey(levelIndex)) {
            column = this.mPropertyColIdx.get(levelIndex).get(propertyIndex);
        }
        return column;
    }

    public int getAttributeColumn(String type, int levelIndex) {
        int column = -1;
        if (ATTRIBUTE_NAME.equalsIgnoreCase(type)) {
            column = this.mLevelNameColIdx.get(levelIndex);
        } else if (ATTRIBUTE_CAPTION.equalsIgnoreCase(type)) {
            column = this.mLevelCaptionColIdx.get(levelIndex);
        } else if (ATTRIBUTE_DESCRIPTION.equalsIgnoreCase(type)) {
            column = this.mLevelDescColIdx.get(levelIndex);
        } else if (ATTRIBUTE_BUSINESS_KEY.equalsIgnoreCase(type)) {
            column = this.mLevelBusinessKeyColIdx.get(levelIndex);
        } else if (ATTRIBUTE_LOCALE_QUERY_ITEM.equalsIgnoreCase(type)) {
            column = this.mLevelLocaleQueryItemColIdx.get(levelIndex);
        }
        return column;
    }

    public int[] getAttributeColumns(String type, int levelIndex) {
        int[] column = null;
        if (ATTRIBUTE_LEVEL_KEY.equalsIgnoreCase(type)) {
            if (this.mLevelKeyColIdx.containsKey(levelIndex)) {
                column = this.mLevelKeyColIdx.get(levelIndex).toArray();
            }
        } else if (ATTRIBUTE_PROPERTY.equalsIgnoreCase(type) && this.mPropertyColIdx.containsKey(levelIndex)) {
            column = this.mPropertyColIdx.get(levelIndex).toArray();
        }
        return column;
    }

    public IValue getNameValue(int levelIndex, IValue[] row) {
        IValue value = null;
        int column = this.getAttributeColumn(ATTRIBUTE_NAME, levelIndex);
        if (column >= 0) {
            value = row[column];
        }
        return value;
    }

    public IValue getLocaleQueryItemValue(int levelIndex, IValue[] row) {
        IValue value = null;
        int column = this.getAttributeColumn(ATTRIBUTE_LOCALE_QUERY_ITEM, levelIndex);
        if (column >= 0) {
            value = row[column];
        }
        return value;
    }

    public Object getPropertyValue(ROLAPProperty property, int levelIndex, int propIndex, IValue[] row) {
        Object propertyValue = null;
        Object objValue = null;
        IValue value = null;
        int column = this.getAttributeColumn(ATTRIBUTE_PROPERTY, levelIndex, propIndex);
        if (column == -1) {
            return objValue;
        }
        ROLAPMetaAttribute attribute = property.getMetaAttribute();
        if (attribute != null) {
            String localizeMethod = null;
            if (attribute.getParent() instanceof ROLAPMetaDimension) {
                localizeMethod = ((ROLAPMetaDimension)attribute.getParent()).getLocalizationMethod();
                int lookupColumn = this.getAttributeColumn(ATTRIBUTE_LOCALE_QUERY_ITEM, levelIndex);
                propertyValue = BYROW.equalsIgnoreCase(localizeMethod) && lookupColumn != -1 ? this.getValueByRow(column, lookupColumn, row) : this.getValuebyColumn(attribute, column, row);
            }
        }
        if (propertyValue == null) {
            value = row[column];
            if (value != null && !value.isNull()) {
                objValue = value.getDataType().isTextType() ? value.toString() : value;
            }
        } else {
            objValue = propertyValue instanceof DefaultENUSLocaleString ? propertyValue.toString() : propertyValue;
        }
        return objValue;
    }

    public Object getCaptionValue(ROLAPMetaLevel metaLevel, int levelIndex, IValue[] row) {
        String objValue = null;
        Object caption = null;
        IValue value = null;
        int column = this.getAttributeColumn(ATTRIBUTE_CAPTION, levelIndex);
        if (column == -1) {
            return objValue;
        }
        ROLAPMetaAttribute attribute = metaLevel.getCaption();
        if (attribute != null) {
            String localizeMethod = null;
            if (attribute.getParent() instanceof ROLAPMetaDimension) {
                localizeMethod = ((ROLAPMetaDimension)attribute.getParent()).getLocalizationMethod();
                int lookupColumn = this.getAttributeColumn(ATTRIBUTE_LOCALE_QUERY_ITEM, levelIndex);
                caption = BYROW.equalsIgnoreCase(localizeMethod) && lookupColumn != -1 ? this.getValueByRow(column, lookupColumn, row) : this.getValuebyColumn(attribute, column, row);
            }
        }
        if (caption == null) {
            value = row[column];
            if (value != null && !value.isNull()) {
                objValue = value.toString();
            }
        } else {
            objValue = caption;
        }
        return objValue;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    private ILocalizedString getValuebyColumn(ROLAPMetaAttribute attribute, int column, IValue[] row) {
        ILocalizedString localizedValue = null;
        IValue value = null;
        if (attribute != null && attribute.getQueryItemCount() > 0) {
            int colIndex = column;
            HashMap<String, IValue> localeValues = new HashMap<String, IValue>();
            for (String string : attribute.getLocales()) {
                value = row[colIndex];
                if (value != null && !value.isNull() && value.getDataType().isTextType()) {
                    localeValues.put(string, value);
                }
                ++colIndex;
            }
            if (localeValues.containsKey(this.getDefaultLocale())) {
                IValue defaultValue = (IValue)localeValues.get(this.getDefaultLocale());
                localizedValue = attribute.generateLocalizedString(localeValues.size(), this.getDefaultLocale(), defaultValue.toString());
                localeValues.remove(this.getDefaultLocale());
            }
            for (Map.Entry entry : localeValues.entrySet()) {
                if (localizedValue == null) {
                    localizedValue = attribute.generateLocalizedString(localeValues.size(), (String)entry.getKey(), ((IValue)entry.getValue()).toString());
                    continue;
                }
                localizedValue.put((String)entry.getKey(), ((IValue)entry.getValue()).toString());
            }
        }
        return localizedValue;
    }

    private ILocalizedString getValueByRow(int column, int lookupColumn, IValue[] row) {
        ILocalizedString localizedValue = null;
        IValue value = null;
        IValue localeValue = null;
        String locale = null;
        if (lookupColumn != -1 && (localeValue = row[lookupColumn]) != null && !localeValue.isNull() && localeValue.getDataType().isTextType()) {
            locale = localeValue.toString().toLowerCase();
        }
        if (locale == null) {
            locale = this.getDefaultLocale();
        }
        if (column != -1) {
            value = row[column];
        }
        if (value != null && !value.isNull() && value.getDataType().isTextType()) {
            localizedValue = AbstractSingleLocaleString.getSingleLocaleString(locale, value.toString());
        }
        return localizedValue;
    }
}

