/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metrics.IteratorProfilingManager;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQueryResultIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.xqejapi.IRSAPIHasColumns;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.concurrent.atomic.AtomicBoolean;

public class ROLAPQueryResultIterator
implements IROLAPQueryResultIterator {
    private final ExecutionEnvironment execEnv;
    private final RSAPIDataset rsapiDataset;
    private RSAPIEdgeIterator it = null;
    private RSAPIPartialDataset partialDataset = null;
    FormatId[] formatIds = null;
    protected final AtomicBoolean released = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROLAPQueryResultIterator(RSAPIDataset dataset, ExecutionEnvironment env) {
        this.rsapiDataset = dataset;
        this.execEnv = env;
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCGettingQueryResult", ZipiContext.getQRDName());
        try {
            this.initializeIterator(dataset, env);
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    private void initializeIterator(RSAPIDataset dataset, ExecutionEnvironment env) {
        ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPQuery.Performance", "Started getting query result iterator (fetch first rows from DB).");
        XQETrace trace = this.execEnv.getTrace();
        if (trace == null) {
            trace = new XQETrace();
            QueryEngineLoggingUtils.addExecutionTraceLevels(trace, this.execEnv.getRequestEnvironment());
            this.execEnv.setTrace(trace);
        }
        IteratorProfilingManager.getInstance().registerProfiler(trace);
        RSAPIEdgeRowset rowset = null;
        try {
            this.partialDataset = QueryEngine.getInstance().getPartialDataset(this.rsapiDataset, new int[]{0}, new int[]{0}, true, false, env);
            rowset = this.partialDataset.getMasterDataset().getEdge(0).getRowsets()[0];
            this.it = this.partialDataset.edgeIterator(0);
            RSAPIColumn[] columns = rowset.getColumns();
            FormatService formatService = FormatService.getInstance();
            this.formatIds = new FormatId[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                String format = columns[i].getFormat();
                this.formatIds[i] = format != null && format.length() > 0 ? formatService.registerV5Format(format, null) : (columns[i].getDatatype().isNumeric() ? FormatId.DEFAULT_NUMBER_FORMAT_FID : FormatId.INVALID_FORMAT_FID);
            }
        }
        catch (RuntimeException ex) {
            this.close();
            throw ex;
        }
        catch (Throwable ex) {
            this.close();
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
        }
        finally {
            ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", "Finished getting query result iterator (fetch first rows from DB).");
        }
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public IRSAPIHasColumns next() {
        return this.it.next();
    }

    @Override
    public FormatId[] getColumnFormat() {
        return this.formatIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.it != null) {
                this.it.release();
                this.it = null;
            }
        }
        finally {
            try {
                if (this.partialDataset != null) {
                    IteratorProfilingManager profilingMgr = IteratorProfilingManager.getInstance();
                    profilingMgr.logProfiling(this.partialDataset.getMasterDataset(), (IExecutionEnvironment)this.execEnv);
                    profilingMgr.unregisterProfiler();
                    this.partialDataset.release();
                    this.partialDataset = null;
                }
            }
            finally {
                this.rsapiDataset.releaseResultset(this.execEnv);
            }
        }
    }

    public ExecutionEnvironment getExecEnv() {
        return this.execEnv;
    }

    public RSAPIPartialDataset getPartialDataset() {
        return this.partialDataset;
    }

    @Override
    public RSAPIDataset getRSAPIDataset() {
        return this.rsapiDataset;
    }
}

